# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['paddle']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.23.0,<3.0.0']

setup_kwargs = {
    'name': 'paddle-python',
    'version': '0.1.0',
    'description': 'Python wrapper around the Paddle.com API',
    'long_description': '# Paddle Python\n\nA python (3.5+) wrapper around the [Paddle.com](https://paddle.com/) [API](https://developer.paddle.com/api-reference/intro)\n\n_Note: This is a work in progress, not all of the Paddle endpoints have been implemented yet_\n\n## Quick start\n\n### Installation\n\n```\npip install paddle-python\n```\n\n\n### Usage\n\nTo use the Paddle API you will need a Paddle Vendor ID and API key which can be found on [Paddle\'s SDK page](https://vendors.paddle.com/sdk)\n\n```python\nfrom paddle import Paddle\n\n\npaddle = Paddle(vendor_id=12345, api_key=\'myapikey\')\npaddle.list_products()\n```\n\nIf `vendor_id` and `api_key` are not passed through when initalising Paddle will fall back and try and use environmental variables called `PADDLE_VENDOR_ID` and `PADDLE_API_KEY`\n```bash\nexport PADDLE_VENDOR_ID=12345\nexport PADDLE_API_KEY="myfakeapikey"\n```\n\n```python\nfrom paddle import Paddle\n\n\npaddle = Paddle()\npaddle.list_products()\n```\n\n\n## Working endpoints\n\n\n* [Get Order Details](https://developer.paddle.com/api-reference/checkout-api/order-information/getorder)\n* [Get User History](https://checkout.paddle.com/api/2.0/user/history)\n* [Get Prices](https://developer.paddle.com/api-reference/checkout-api/prices/getprices)\n* [List Coupons](https://developer.paddle.com/api-reference/product-api/coupons/listcoupons)\n* [Create Coupon](https://developer.paddle.com/api-reference/product-api/coupons/createcoupon)\n* [Delete Coupon](https://developer.paddle.com/api-reference/product-api/coupons/deletecoupon)\n* [Update Coupon](https://developer.paddle.com/api-reference/product-api/coupons/updatecoupon)\n* [List Products](https://developer.paddle.com/api-reference/product-api/products/getproducts)\n* [List Plans](https://developer.paddle.com/api-reference/subscription-api/plans/listplans)\n* [Get Webhook History](https://developer.paddle.com/api-reference/alert-api/webhooks/webhooks)\n\n```python\npaddle.get_order_details(checkout_id=checkout_id)\npaddle.get_user_history(email=email)\npaddle.get_prices(product_ids=[product_id])\npaddle.list_coupons(product_id=product_id)\npaddle.create_coupon(\n    coupon_type=coupon_type,\n    discount_type=discount_type,\n    discount_amount=discount_amount,\n    allowed_uses=allowed_uses,\n    recurring=recurring,\n    currency=currency,\n    product_ids=product_ids,\n    coupon_code=coupon_code,\n    description=description,\n    expires=expires,\n    minimum_threshold=minimum_threshold,\n    group=group,\n)\npaddle.delete_coupon(coupon_code=new_coupon_code, product_id=product_id)\npaddle.update_coupon(\n    coupon_code=coupon_code,\n    new_coupon_code=new_coupon_code,\n    new_group=\'paddle-python-test\',\n    product_ids=[product_id],\n    expires=expires,\n    allowed_uses=allowed_uses,\n    currency=currency,\n    minimum_threshold=9998,\n    discount_amount=discount_amount,\n    recurring=True\n)\npaddle.list_products()\npaddle.list_plans()\npaddle.get_webhook_history()\n```\n\n\n## Failing Endpoints\n\nThe below endpoints have been implimented but are not working correctly according to the tests. They have been commented out in `paddle/paddle.py` and the tests will skip is the methods do not exist\n\n* [Generate License](https://developer.paddle.com/api-reference/product-api/licenses/createlicense) - `Paddle error 108 - Unable to find requested product`\n* [Create pay link](https://developer.paddle.com/api-reference/product-api/pay-links/createpaylink) -  `Paddle error 108 - Unable to find requested product`\n\n\n## ToDo\n* Fix generate license and create pay link endpoints\n* Paddle API endpoints\n    * [List Transactions](https://developer.paddle.com/api-reference/product-api/transactions/listtransactions)\n    * [Refund Payment](https://developer.paddle.com/api-reference/product-api/payments/refundpayment)\n    * [Create Plan](https://developer.paddle.com/api-reference/subscription-api/plans/createplan)\n    * [List Users](https://developer.paddle.com/api-reference/subscription-api/subscription-users/listusers)\n    * [Cancel Subscription](https://developer.paddle.com/api-reference/subscription-api/subscription-users/canceluser)\n    * [Update Subscription](https://developer.paddle.com/api-reference/subscription-api/subscription-users/updateuser)\n    * [Preview Subscription Update](https://developer.paddle.com/api-reference/subscription-api/subscription-users/previewupdate)\n    * [Add Modifier](https://developer.paddle.com/api-reference/subscription-api/modifiers/createmodifier)\n    * [Delete Modifier](https://developer.paddle.com/api-reference/subscription-api/modifiers/deletemodifier)\n    * [List Modifiers](https://developer.paddle.com/api-reference/subscription-api/modifiers/listmodifiers)\n    * [List Payments](https://developer.paddle.com/api-reference/subscription-api/payments/listpayments)\n    * [Reschedule Payment](https://developer.paddle.com/api-reference/subscription-api/payments/updatepayment)\n    * [Create One-off Charge](https://developer.paddle.com/api-reference/subscription-api/one-off-charges/createcharge)\n* Get test coverage to 100%\n* tox\n* Do we want to have a set of tests which use mocks?\n    * Could use pytest-recording (vcrpy) to update Mock data\n    * Github actions to recreate mocks nightly?\n    * How to deal with different vendor_ids etc?\n    * Mock requests to check params, json, urls etc?\n    * How to deal with the manual cleanup\n* Pull request template\n* Travis?\n    * Test results in pull request\n    * Coverage info in pull request\n* Dependabot\n* Remove double call for exception error message checking. How to get the exception str from `pytest.raises()`\n',
    'author': 'Matt Pye',
    'author_email': 'pyematt@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pyepye/paddle-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
