# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['paddle']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.23.0,<3.0.0']

setup_kwargs = {
    'name': 'paddle-python',
    'version': '0.4.3',
    'description': 'Python wrapper around the Paddle.com API',
    'long_description': '# Paddle Python\n\nA python (3.5+) wrapper around the [Paddle.com](https://paddle.com/) [API](https://developer.paddle.com/api-reference/intro)\n\n_Note: This is a work in progress, not all of the Paddle endpoints have been implemented yet_\n\n## Quick start\n\n### Installation\n\n```bash\npip install paddle-python\n```\n\n\n### Usage\n\nTo use the Paddle API you will need a Paddle Vendor ID and API key which can be found on [Paddle\'s SDK page](https://vendors.paddle.com/sdk)\n\n```python\nfrom paddle import Paddle\n\n\npaddle = Paddle(vendor_id=12345, api_key=\'myapikey\')\npaddle.list_products()\n```\n\nIf `vendor_id` and `api_key` are not passed through when initalising Paddle will fall back and try and use environmental variables called `PADDLE_VENDOR_ID` and `PADDLE_API_KEY`\n```bash\nexport PADDLE_VENDOR_ID=12345\nexport PADDLE_API_KEY="myapikey"\n```\n\n```python\nfrom paddle import Paddle\n\n\npaddle = Paddle()\npaddle.list_products()\n```\n\n\n## Documentation\n\nComing soon. Please see `Working endpoints` below for basic usage.\n\n\n## Contributing\n\nAll contributions are welcome and appreciated. Please see [CONTRIBUTING.md](https://github.com/pyepye/paddle-python/blob/master/CONTRIBUTING.md) for more details including details on how to run tests etc.\n\n\n## Working endpoints\n* [Get Order Details](https://developer.paddle.com/api-reference/checkout-api/order-information/getorder)\n* [Get User History](https://checkout.paddle.com/api/2.0/user/history)\n* [Get Prices](https://developer.paddle.com/api-reference/checkout-api/prices/getprices)\n* [List Coupons](https://developer.paddle.com/api-reference/product-api/coupons/listcoupons)\n* [Create Coupon](https://developer.paddle.com/api-reference/product-api/coupons/createcoupon)\n* [Delete Coupon](https://developer.paddle.com/api-reference/product-api/coupons/deletecoupon)\n* [Update Coupon](https://developer.paddle.com/api-reference/product-api/coupons/updatecoupon)\n* [List Products](https://developer.paddle.com/api-reference/product-api/products/getproducts)\n* [List Transactions](https://developer.paddle.com/api-reference/product-api/transactions/listtransactions)\n* [Refund Payment](https://developer.paddle.com/api-reference/product-api/payments/refundpayment)\n* [List Plans](https://developer.paddle.com/api-reference/subscription-api/plans/listplans)\n* [Create Plan](https://developer.paddle.com/api-reference/subscription-api/plans/createplan)\n* [List Subscription Users](https://developer.paddle.com/api-reference/subscription-api/subscription-users/listusers)\n* [Update Subscription](https://developer.paddle.com/api-reference/subscription-api/subscription-users/canceluser)\n* [Get Webhook History](https://developer.paddle.com/api-reference/alert-api/webhooks/webhooks)\n\n```python\npaddle.get_order_details(checkout_id=checkout_id)\npaddle.get_user_history(email=email)\npaddle.get_prices(product_ids=[product_id])\npaddle.list_coupons(product_id=product_id)\npaddle.create_coupon(\n    coupon_type=\'product\',\n    discount_type=\'percentage\',\n    discount_amount=50,\n    allowed_uses=1,\n    recurring=False,\n    currency=\'USD\',\n    product_ids=product_ids,\n    coupon_code=\'50%OFF\',\n    description=\'50% off coupon over $10\',\n    expires=expires,\n    minimum_threshold=10,\n    group=\'paddle-python\',\n)\npaddle.delete_coupon(coupon_code=new_coupon_code, product_id=product_id)\npaddle.update_coupon(\n    coupon_code=coupon_code,\n    new_coupon_code=\'40%OFF\',\n    new_group=\'paddle-python-test\',\n    product_ids=[product_id],\n    expires=expires,\n    allowed_uses=1,\n    currency=\'USD\',\n    minimum_threshold=10,\n    discount_amount=40,\n    recurring=True\n)\npaddle.list_products()\npaddle.list_transactions(entity=\'subscription\', entity_id=subscription_id)\npaddle.refund_payment(order_id=order_id, amount=amount, reason=reason)\npaddle.list_plans()\npaddle.create_plan(\n    plan_name=\'plan_name\',\n    plan_trial_days=14,\n    plan_length=1,\n    plan_type=\'month\',\n    main_currency_code=\'USD\',\n    initial_price_usd=50,\n    recurring_price_usd=50,\n)\npaddle.list_subscription_users()\npaddle.cancel_subscription(subscription_id=1234)\npaddle.get_webhook_history()\n```\n\n\n## Failing Endpoints\n\nThe below endpoints have been implimented but are not working correctly according to the tests. They have been commented out in `paddle/paddle.py` and the tests will skip is the methods do not exist\n\n* [Generate License](https://developer.paddle.com/api-reference/product-api/licenses/createlicense) - `Paddle error 108 - Unable to find requested product`\n* [Create pay link](https://developer.paddle.com/api-reference/product-api/pay-links/createpaylink) -  `Paddle error 108 - Unable to find requested product`\n\n\n## ToDo\n* Fix generate license and create pay link endpoints\n* Paddle API endpoints\n    * [Update Subscription](https://developer.paddle.com/api-reference/subscription-api/subscription-users/updateuser)\n    * [Preview Subscription Update](https://developer.paddle.com/api-reference/subscription-api/subscription-users/previewupdate)\n    * [Add Modifier](https://developer.paddle.com/api-reference/subscription-api/modifiers/createmodifier)\n    * [Delete Modifier](https://developer.paddle.com/api-reference/subscription-api/modifiers/deletemodifier)\n    * [List Modifiers](https://developer.paddle.com/api-reference/subscription-api/modifiers/listmodifiers)\n    * [List Payments](https://developer.paddle.com/api-reference/subscription-api/payments/listpayments)\n    * [Reschedule Payment](https://developer.paddle.com/api-reference/subscription-api/payments/updatepayment)\n    * [Create One-off Charge](https://developer.paddle.com/api-reference/subscription-api/one-off-charges/createcharge)\n* Get test coverage to 100%\n* Docs (auto docs?)\n* Use `pytest-mock` `Spy` to check params, json, urls etc for test requests\n    * Needed to any tests which skip due to missing data\n* How to deal with the manual cleanup?\n* Pull request template\n* TravisCI?\n* Dependabot\n* Remove double call for exception error message checking - How to get the exception str from `pytest.raises()`? pytest-mock `Spy`?\n',
    'author': 'Matt Pye',
    'author_email': 'pyematt@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pyepye/paddle-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
