# coding: utf-8

"""
    Patch API V1

    The core API used to integrate with Patch's service  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: engineering@usepatch.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from patch_api.configuration import Configuration


class CreateAirShippingEstimateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "destination_airport": "str",
        "origin_airport": "str",
        "aircraft_code": "str",
        "aircraft_type": "str",
        "freight_mass_g": "int",
        "emissions_scope": "str",
        "project_id": "str",
        "create_order": "bool",
    }

    attribute_map = {
        "destination_airport": "destination_airport",
        "origin_airport": "origin_airport",
        "aircraft_code": "aircraft_code",
        "aircraft_type": "aircraft_type",
        "freight_mass_g": "freight_mass_g",
        "emissions_scope": "emissions_scope",
        "project_id": "project_id",
        "create_order": "create_order",
    }

    def __init__(
        self,
        destination_airport=None,
        origin_airport=None,
        aircraft_code=None,
        aircraft_type="unknown",
        freight_mass_g=None,
        emissions_scope="ttw",
        project_id=None,
        create_order=False,
        local_vars_configuration=None,
    ):  # noqa: E501
        """CreateAirShippingEstimateRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._destination_airport = None
        self._origin_airport = None
        self._aircraft_code = None
        self._aircraft_type = None
        self._freight_mass_g = None
        self._emissions_scope = None
        self._project_id = None
        self._create_order = None
        self.discriminator = None

        self.destination_airport = destination_airport
        self.origin_airport = origin_airport
        self.aircraft_code = aircraft_code
        self.aircraft_type = aircraft_type
        if freight_mass_g is not None:
            self.freight_mass_g = freight_mass_g
        self.emissions_scope = emissions_scope
        self.project_id = project_id
        self.create_order = create_order

    @property
    def destination_airport(self):
        """Gets the destination_airport of this CreateAirShippingEstimateRequest.  # noqa: E501


        :return: The destination_airport of this CreateAirShippingEstimateRequest.  # noqa: E501
        :rtype: str
        """
        return self._destination_airport

    @destination_airport.setter
    def destination_airport(self, destination_airport):
        """Sets the destination_airport of this CreateAirShippingEstimateRequest.


        :param destination_airport: The destination_airport of this CreateAirShippingEstimateRequest.  # noqa: E501
        :type: str
        """

        self._destination_airport = destination_airport

    @property
    def origin_airport(self):
        """Gets the origin_airport of this CreateAirShippingEstimateRequest.  # noqa: E501


        :return: The origin_airport of this CreateAirShippingEstimateRequest.  # noqa: E501
        :rtype: str
        """
        return self._origin_airport

    @origin_airport.setter
    def origin_airport(self, origin_airport):
        """Sets the origin_airport of this CreateAirShippingEstimateRequest.


        :param origin_airport: The origin_airport of this CreateAirShippingEstimateRequest.  # noqa: E501
        :type: str
        """

        self._origin_airport = origin_airport

    @property
    def aircraft_code(self):
        """Gets the aircraft_code of this CreateAirShippingEstimateRequest.  # noqa: E501


        :return: The aircraft_code of this CreateAirShippingEstimateRequest.  # noqa: E501
        :rtype: str
        """
        return self._aircraft_code

    @aircraft_code.setter
    def aircraft_code(self, aircraft_code):
        """Sets the aircraft_code of this CreateAirShippingEstimateRequest.


        :param aircraft_code: The aircraft_code of this CreateAirShippingEstimateRequest.  # noqa: E501
        :type: str
        """

        self._aircraft_code = aircraft_code

    @property
    def aircraft_type(self):
        """Gets the aircraft_type of this CreateAirShippingEstimateRequest.  # noqa: E501


        :return: The aircraft_type of this CreateAirShippingEstimateRequest.  # noqa: E501
        :rtype: str
        """
        return self._aircraft_type

    @aircraft_type.setter
    def aircraft_type(self, aircraft_type):
        """Sets the aircraft_type of this CreateAirShippingEstimateRequest.


        :param aircraft_type: The aircraft_type of this CreateAirShippingEstimateRequest.  # noqa: E501
        :type: str
        """
        allowed_values = [None, "passenger", "cargo", "unknown"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and aircraft_type not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `aircraft_type` ({0}), must be one of {1}".format(  # noqa: E501
                    aircraft_type, allowed_values
                )
            )

        self._aircraft_type = aircraft_type

    @property
    def freight_mass_g(self):
        """Gets the freight_mass_g of this CreateAirShippingEstimateRequest.  # noqa: E501


        :return: The freight_mass_g of this CreateAirShippingEstimateRequest.  # noqa: E501
        :rtype: int
        """
        return self._freight_mass_g

    @freight_mass_g.setter
    def freight_mass_g(self, freight_mass_g):
        """Sets the freight_mass_g of this CreateAirShippingEstimateRequest.


        :param freight_mass_g: The freight_mass_g of this CreateAirShippingEstimateRequest.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and freight_mass_g is not None
            and freight_mass_g > 2000000000
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `freight_mass_g`, must be a value less than or equal to `2000000000`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and freight_mass_g is not None
            and freight_mass_g < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `freight_mass_g`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._freight_mass_g = freight_mass_g

    @property
    def emissions_scope(self):
        """Gets the emissions_scope of this CreateAirShippingEstimateRequest.  # noqa: E501


        :return: The emissions_scope of this CreateAirShippingEstimateRequest.  # noqa: E501
        :rtype: str
        """
        return self._emissions_scope

    @emissions_scope.setter
    def emissions_scope(self, emissions_scope):
        """Sets the emissions_scope of this CreateAirShippingEstimateRequest.


        :param emissions_scope: The emissions_scope of this CreateAirShippingEstimateRequest.  # noqa: E501
        :type: str
        """
        allowed_values = [None, "wtt", "ttw", "wtw"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and emissions_scope not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `emissions_scope` ({0}), must be one of {1}".format(  # noqa: E501
                    emissions_scope, allowed_values
                )
            )

        self._emissions_scope = emissions_scope

    @property
    def project_id(self):
        """Gets the project_id of this CreateAirShippingEstimateRequest.  # noqa: E501


        :return: The project_id of this CreateAirShippingEstimateRequest.  # noqa: E501
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this CreateAirShippingEstimateRequest.


        :param project_id: The project_id of this CreateAirShippingEstimateRequest.  # noqa: E501
        :type: str
        """

        self._project_id = project_id

    @property
    def create_order(self):
        """Gets the create_order of this CreateAirShippingEstimateRequest.  # noqa: E501


        :return: The create_order of this CreateAirShippingEstimateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._create_order

    @create_order.setter
    def create_order(self, create_order):
        """Sets the create_order of this CreateAirShippingEstimateRequest.


        :param create_order: The create_order of this CreateAirShippingEstimateRequest.  # noqa: E501
        :type: bool
        """

        self._create_order = create_order

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateAirShippingEstimateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateAirShippingEstimateRequest):
            return True

        return self.to_dict() != other.to_dict()
