# coding: utf-8

"""
    Patch API V1

    The core API used to integrate with Patch's service  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: developers@usepatch.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from patch_api.configuration import Configuration


class Fulfillment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'amount': 'int',
        'state': 'str',
        'reject_reason': 'str',
        'proof_data': 'object',
        'fulfillment_documents': 'list[FulfillmentDocument]',
        'project': 'Project'
    }

    attribute_map = {
        'id': 'id',
        'amount': 'amount',
        'state': 'state',
        'reject_reason': 'reject_reason',
        'proof_data': 'proof_data',
        'fulfillment_documents': 'fulfillment_documents',
        'project': 'project'
    }

    def __init__(self, id=None, amount=None, state=None, reject_reason=None, proof_data=None, fulfillment_documents=None, project=None, local_vars_configuration=None):  # noqa: E501
        """Fulfillment - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._amount = None
        self._state = None
        self._reject_reason = None
        self._proof_data = None
        self._fulfillment_documents = None
        self._project = None
        self.discriminator = None

        self.id = id
        self.amount = amount
        self.state = state
        self.reject_reason = reject_reason
        self.proof_data = proof_data
        self.fulfillment_documents = fulfillment_documents
        self.project = project

    @property
    def id(self):
        """Gets the id of this Fulfillment.  # noqa: E501

        The id of the record  # noqa: E501

        :return: The id of this Fulfillment.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Fulfillment.

        The id of the record  # noqa: E501

        :param id: The id of this Fulfillment.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def amount(self):
        """Gets the amount of this Fulfillment.  # noqa: E501

        The amount of allocatables in grams/Wh to fulfill.  # noqa: E501

        :return: The amount of this Fulfillment.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Fulfillment.

        The amount of allocatables in grams/Wh to fulfill.  # noqa: E501

        :param amount: The amount of this Fulfillment.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def state(self):
        """Gets the state of this Fulfillment.  # noqa: E501

        The current state of the fulfillment.  # noqa: E501

        :return: The state of this Fulfillment.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Fulfillment.

        The current state of the fulfillment.  # noqa: E501

        :param state: The state of this Fulfillment.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501
        allowed_values = ["accepted", "rejected", "require_review"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def reject_reason(self):
        """Gets the reject_reason of this Fulfillment.  # noqa: E501

        The reason this fulfillment was rejected.  # noqa: E501

        :return: The reject_reason of this Fulfillment.  # noqa: E501
        :rtype: str
        """
        return self._reject_reason

    @reject_reason.setter
    def reject_reason(self, reject_reason):
        """Sets the reject_reason of this Fulfillment.

        The reason this fulfillment was rejected.  # noqa: E501

        :param reject_reason: The reject_reason of this Fulfillment.  # noqa: E501
        :type: str
        """

        self._reject_reason = reject_reason

    @property
    def proof_data(self):
        """Gets the proof_data of this Fulfillment.  # noqa: E501

        An optional JSON object containing metadata for this order.  # noqa: E501

        :return: The proof_data of this Fulfillment.  # noqa: E501
        :rtype: object
        """
        return self._proof_data

    @proof_data.setter
    def proof_data(self, proof_data):
        """Sets the proof_data of this Fulfillment.

        An optional JSON object containing metadata for this order.  # noqa: E501

        :param proof_data: The proof_data of this Fulfillment.  # noqa: E501
        :type: object
        """

        self._proof_data = proof_data

    @property
    def fulfillment_documents(self):
        """Gets the fulfillment_documents of this Fulfillment.  # noqa: E501

        An array of URLs for fulfillment documents for the fulfillment.  # noqa: E501

        :return: The fulfillment_documents of this Fulfillment.  # noqa: E501
        :rtype: list[FulfillmentDocument]
        """
        return self._fulfillment_documents

    @fulfillment_documents.setter
    def fulfillment_documents(self, fulfillment_documents):
        """Sets the fulfillment_documents of this Fulfillment.

        An array of URLs for fulfillment documents for the fulfillment.  # noqa: E501

        :param fulfillment_documents: The fulfillment_documents of this Fulfillment.  # noqa: E501
        :type: list[FulfillmentDocument]
        """

        self._fulfillment_documents = fulfillment_documents

    @property
    def project(self):
        """Gets the project of this Fulfillment.  # noqa: E501

        An object returning the Project record this Fulfillment is associated with.  # noqa: E501

        :return: The project of this Fulfillment.  # noqa: E501
        :rtype: Project
        """
        return self._project

    @project.setter
    def project(self, project):
        """Sets the project of this Fulfillment.

        An object returning the Project record this Fulfillment is associated with.  # noqa: E501

        :param project: The project of this Fulfillment.  # noqa: E501
        :type: Project
        """
        if self.local_vars_configuration.client_side_validation and project is None:  # noqa: E501
            raise ValueError("Invalid value for `project`, must not be `None`")  # noqa: E501

        self._project = project

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Fulfillment):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Fulfillment):
            return True

        return self.to_dict() != other.to_dict()
