# coding: utf-8

"""
    Patch API V1

    The core API used to integrate with Patch's service  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: developers@usepatch.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from patch_api.configuration import Configuration


class Payout(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'payout_cents_usd': 'str',
        'state': 'str',
        'external_system': 'str',
        'external_system_id': 'str',
        'organization': 'Organization'
    }

    attribute_map = {
        'id': 'id',
        'payout_cents_usd': 'payout_cents_usd',
        'state': 'state',
        'external_system': 'external_system',
        'external_system_id': 'external_system_id',
        'organization': 'organization'
    }

    def __init__(self, id=None, payout_cents_usd=None, state=None, external_system=None, external_system_id=None, organization=None, local_vars_configuration=None):  # noqa: E501
        """Payout - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._payout_cents_usd = None
        self._state = None
        self._external_system = None
        self._external_system_id = None
        self._organization = None
        self.discriminator = None

        self.id = id
        self.payout_cents_usd = payout_cents_usd
        self.state = state
        self.external_system = external_system
        self.external_system_id = external_system_id
        self.organization = organization

    @property
    def id(self):
        """Gets the id of this Payout.  # noqa: E501

        The id of the record  # noqa: E501

        :return: The id of this Payout.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Payout.

        The id of the record  # noqa: E501

        :param id: The id of this Payout.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def payout_cents_usd(self):
        """Gets the payout_cents_usd of this Payout.  # noqa: E501

        The payout amount in cents of USD  # noqa: E501

        :return: The payout_cents_usd of this Payout.  # noqa: E501
        :rtype: str
        """
        return self._payout_cents_usd

    @payout_cents_usd.setter
    def payout_cents_usd(self, payout_cents_usd):
        """Sets the payout_cents_usd of this Payout.

        The payout amount in cents of USD  # noqa: E501

        :param payout_cents_usd: The payout_cents_usd of this Payout.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and payout_cents_usd is None:  # noqa: E501
            raise ValueError("Invalid value for `payout_cents_usd`, must not be `None`")  # noqa: E501

        self._payout_cents_usd = payout_cents_usd

    @property
    def state(self):
        """Gets the state of this Payout.  # noqa: E501

        The current state of the payout.  # noqa: E501

        :return: The state of this Payout.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Payout.

        The current state of the payout.  # noqa: E501

        :param state: The state of this Payout.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501
        allowed_values = ["accepted", "complete", "require_review"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def external_system(self):
        """Gets the external_system of this Payout.  # noqa: E501

        The system of the record for the payout (e.g. \"stripe\").  # noqa: E501

        :return: The external_system of this Payout.  # noqa: E501
        :rtype: str
        """
        return self._external_system

    @external_system.setter
    def external_system(self, external_system):
        """Sets the external_system of this Payout.

        The system of the record for the payout (e.g. \"stripe\").  # noqa: E501

        :param external_system: The external_system of this Payout.  # noqa: E501
        :type: str
        """

        self._external_system = external_system

    @property
    def external_system_id(self):
        """Gets the external_system_id of this Payout.  # noqa: E501

        The id of the payout in the system of record.  # noqa: E501

        :return: The external_system_id of this Payout.  # noqa: E501
        :rtype: str
        """
        return self._external_system_id

    @external_system_id.setter
    def external_system_id(self, external_system_id):
        """Sets the external_system_id of this Payout.

        The id of the payout in the system of record.  # noqa: E501

        :param external_system_id: The external_system_id of this Payout.  # noqa: E501
        :type: str
        """

        self._external_system_id = external_system_id

    @property
    def organization(self):
        """Gets the organization of this Payout.  # noqa: E501

        An object returning the Organization record this Payout is associated with.  # noqa: E501

        :return: The organization of this Payout.  # noqa: E501
        :rtype: Organization
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this Payout.

        An object returning the Organization record this Payout is associated with.  # noqa: E501

        :param organization: The organization of this Payout.  # noqa: E501
        :type: Organization
        """
        if self.local_vars_configuration.client_side_validation and organization is None:  # noqa: E501
            raise ValueError("Invalid value for `organization`, must not be `None`")  # noqa: E501

        self._organization = organization

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Payout):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Payout):
            return True

        return self.to_dict() != other.to_dict()
