# coding: utf-8

"""
Patch API V1

The core API used to integrate with Patch's service  # noqa: E501

The version of the OpenAPI document: v1
Contact: developers@usepatch.com
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import os

from patch_api.api_client import ApiClient


class TestEstimatesApi(unittest.TestCase):
    """EstimatesApi unit test stubs"""

    def setUp(self):
        api_client = ApiClient(api_key=os.environ.get("SANDBOX_API_KEY"))
        self.api = api_client.estimates  # noqa: E501

    def tearDown(self):
        self.api = None

    def test_create_and_retrieve_mass_estimate(self):
        """Test case for create_mass_estimate

        Create an estimate based on mass of CO2  # noqa: E501
        """
        mass_g = 100
        project_id = "pro_test_2b67b11a030b66e0a6dd61a56b49079a"
        estimate = self.api.create_mass_estimate(
            mass_g=mass_g, project_id=project_id, create_order=True
        )
        self.assertTrue(estimate)
        self.assertEqual(estimate.data.order.amount, mass_g)

        retrieved_estimate = self.api.retrieve_estimate(id=estimate.data.id)
        self.assertTrue(retrieved_estimate)

    def test_create_and_retrieve_flight_estimate(self):
        """Test case for create_flight_estimate

        Create an estimate based on the distance in meters flown by an airplane # noqa: E501
        """
        distance_m = 1000000
        estimate = self.api.create_flight_estimate(
            distance_m=distance_m, create_order=True
        )
        self.assertEqual(estimate.data.type, "flight")
        self.assertGreater(estimate.data.order.amount, 50000)
        self.assertGreater(estimate.data.mass_g, 50000)

        retrieved_estimate = self.api.retrieve_estimate(id=estimate.data.id)
        self.assertTrue(retrieved_estimate)

    def test_create_and_retrieve_flight_estimate_with_airports(self):
        """Test case for create_flight_estimate

        Create an estimate based on the distance in meters flown by an airplane # noqa: E501
        """
        estimate_short = self.api.create_flight_estimate(
            origin_airport="SFO", destination_airport="LAX"
        )
        estimate_long = self.api.create_flight_estimate(
            origin_airport="SFO", destination_airport="JFK"
        )
        self.assertGreater(estimate_long.data.mass_g, estimate_short.data.mass_g)

    def test_create_bitcoin_estimate_no_params(self):
        """Test case for create_bitcoin_estimate

        Create an estimate based on a transaction amount  # noqa: E501
        """

        estimate = self.api.create_bitcoin_estimate()
        self.assertEqual(estimate.data.type, "bitcoin")
        self.assertGreater(
            estimate.data.mass_g, 200
        )  # not setting an exact value since this is changing daily

    def test_create_bitcoin_estimate_transaction_value(self):
        """Test case for create_bitcoin_estimate

        Create an estimate based on a transaction amount  # noqa: E501
        """
        transaction_value_btc_sats = 100000

        estimate = self.api.create_bitcoin_estimate(
            transaction_value_btc_sats=transaction_value_btc_sats
        )
        self.assertEqual(estimate.data.type, "bitcoin")
        self.assertGreater(
            estimate.data.mass_g, 200
        )  # not setting an exact value since this is changing daily

    def test_create_hotel_estimate(self):
        """Test case for create_hotel_estimate

        Create an estimate based on a country code  # noqa: E501
        """

        estimate = self.api.create_hotel_estimate(country_code="US")
        self.assertEqual(estimate.data.type, "hotel")
        self.assertGreater(
            estimate.data.mass_g, 15_000
        )  # not setting an exact value since this is changing daily

    def test_create_air_shipping_estimate_airport_iatas(self):
        """Test case for create_air_shipping_estimate

        Create an estimate based on airport iata values  # noqa: E501
        """
        estimate = self.api.create_air_shipping_estimate(
            destination_airport="JFK", freight_mass_g=19_158, origin_airport="ATL"
        )
        self.assertEqual(estimate.data.order, None)
        self.assertEqual(estimate.data.type, "shipping_air")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_air_shipping_estimate_create_order(self):
        """Test case for create_air_shipping_estimate

        Create an estimate and an order  # noqa: E501
        """
        estimate = self.api.create_air_shipping_estimate(
            create_order=True,
            destination_airport="JFK",
            freight_mass_g=18_092,
            origin_airport="ATL",
        )
        self.assertGreater(estimate.data.order.amount, 2_000)
        self.assertEqual(estimate.data.type, "shipping_air")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_rail_shipping_estimate_addresses(self):
        """Test case for create_rail_shipping_estimate

        Create an estimate based on locode values  # noqa: E501
        """
        estimate = self.api.create_rail_shipping_estimate(
            destination_country_code="US",
            destination_postal_code="90210",
            freight_mass_g=18092,
            origin_country_code="US",
            origin_postal_code="97209",
        )
        self.assertEqual(estimate.data.order, None)
        self.assertEqual(estimate.data.type, "shipping_rail")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_rail_shipping_estimate_locodes(self):
        """Test case for create_rail_shipping_estimate

        Create an estimate based on locode values  # noqa: E501
        """
        estimate = self.api.create_rail_shipping_estimate(
            destination_locode="USSD2", freight_mass_g=18092, origin_locode="USSEA"
        )
        self.assertEqual(estimate.data.order, None)
        self.assertEqual(estimate.data.type, "shipping_rail")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_rail_shipping_estimate_create_order(self):
        """Test case for create_rail_shipping_estimate

        Create an estimate and an order  # noqa: E501
        """
        estimate = self.api.create_rail_shipping_estimate(
            create_order=True,
            destination_locode="USSD2",
            freight_mass_g=19_217,
            origin_locode="USSEA",
        )
        self.assertGreater(estimate.data.order.amount, 0)
        self.assertEqual(estimate.data.type, "shipping_rail")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_road_shipping_estimate_addresses(self):
        """Test case for create_road_shipping_estimate

        Create an estimate based on locode values  # noqa: E501
        """
        estimate = self.api.create_road_shipping_estimate(
            destination_country_code="US",
            destination_postal_code="90210",
            freight_mass_g=19_166,
            origin_country_code="US",
            origin_postal_code="97209",
        )
        self.assertEqual(estimate.data.order, None)
        self.assertEqual(estimate.data.type, "shipping_road")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_road_shipping_estimate_locodes(self):
        """Test case for create_road_shipping_estimate

        Create an estimate based on locode values  # noqa: E501
        """
        estimate = self.api.create_road_shipping_estimate(
            destination_locode="USSD2", freight_mass_g=16_907, origin_locode="USSEA"
        )
        self.assertEqual(estimate.data.order, None)
        self.assertEqual(estimate.data.type, "shipping_road")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_road_shipping_estimate_create_order(self):
        """Test case for create_road_shipping_estimate

        Create an estimate and an order  # noqa: E501
        """
        estimate = self.api.create_road_shipping_estimate(
            create_order=True,
            destination_locode="USSD2",
            freight_mass_g=21_933,
            origin_locode="USSEA",
        )
        self.assertGreater(estimate.data.order.amount, 0)
        self.assertEqual(estimate.data.type, "shipping_road")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_sea_shipping_estimate_addresses(self):
        """Test case for create_sea_shipping_estimate

        Create an estimate based on address values  # noqa: E501
        """
        estimate = self.api.create_sea_shipping_estimate(
            destination_country_code="US",
            destination_postal_code="90210",
            freight_mass_g=26_906,
            origin_country_code="US",
            origin_postal_code="97209",
        )
        self.assertEqual(estimate.data.order, None)
        self.assertEqual(estimate.data.type, "shipping_sea")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_sea_shipping_estimate_locodes(self):
        """Test case for create_sea_shipping_estimate

        Create an estimate based on locode values  # noqa: E501
        """
        estimate = self.api.create_sea_shipping_estimate(
            destination_locode="USSD2", freight_mass_g=17_311, origin_locode="USSEA"
        )
        self.assertEqual(estimate.data.order, None)
        self.assertEqual(estimate.data.type, "shipping_sea")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized

    def test_create_sea_shipping_estimate_create_order(self):
        """Test case for create_sea_shipping_estimate

        Create an estimate and an order  # noqa: E501
        """
        estimate = self.api.create_sea_shipping_estimate(
            create_order=True,
            destination_locode="USSD2",
            freight_mass_g=22_210,
            origin_locode="USSEA",
        )
        self.assertGreater(estimate.data.order.amount, 0)
        self.assertEqual(estimate.data.type, "shipping_sea")
        self.assertGreater(
            estimate.data.mass_g, 0
        )  # not setting an exact value since the mock values returned are randomized


if __name__ == "__main__":
    unittest.main()
