"""Collection of patch-based denoising methods."""
from patch_denoise.denoise import (
    mp_pca,
    hybrid_pca,
    optimal_thresholding,
    adaptive_thresholding,
    raw_svt,
    nordic,
)

from patch_denoise.space_time.lowrank import (
    AdaptiveDenoiser,
    HybridPCADenoiser,
    MPPCADenoiser,
    NordicDenoiser,
    OptimalSVDDenoiser,
    RawSVDDenoiser,
)

__all__ = [
    "AdaptiveDenoiser",
    "HybridPCADenoiser",
    "MPPCADenoiser",
    "NordicDenoiser",
    "OptimalSVDDenoiser",
    "RawSVDDenoiser",
    "mp_pca",
    "hybrid_pca",
    "optimal_thresholding",
    "adaptive_thresholding",
    "raw_svt",
    "nordic",
]

try:
    # -- Distribution mode --
    # import from _version.py generated by setuptools_scm during release
    from ._version import version as __version__
except ImportError:
    # -- Source mode --
    # use setuptools_scm to get the current version from src using git
    from setuptools_scm import get_version as _gv
    from os import path as _path

    __version__ = _gv(_path.join(_path.dirname(__file__), _path.pardir))
