# GenerateREADME

The GenerateREADME patchflow aims to automatically generate documentation for a folder in your repository in form of a README.md file. 

## How to run?
 
You can run it as follows:

`patchwork GenerateREADME folder_path=/path/to/your/folder`

by default you will need to provide the `openai_api_key` and the `github_api_key` you can pass them as arguments: 

`patchwork GenerateREADME openai_api_key=<Your_API_KEY> github_api_key=<Your_GH_Token> folder_path=/path/to/your/folder`

## What it does?

The GenerateREADME patchflow will first convert the folder into a markdown file using an open-source tool [code2prompt](https://github.com/raphaelmansuy/code2prompt). It will then use the file to create a prompt to be sent to `gpt-3.5-turbo` to generate a README.md file. You can check the default [prompt template](./generate_readme_prompt.json). The generated README.md file is then committed to the repository under a new branch and finally a pull request is created for the user to review and merge the changes. 

## Configuration

The following are the default configurations that can be modified by the user to adapt the GenerateREADME patchflow to their needs. All the options can be set both via CLI arguments and and the yaml config file.

### Model

You can choose any LLM API as long as it has an OpenAI API compatible chat completions endpoint. Just update the default values of the following options:

```yaml
- model: gpt-3.5-turbo
- client_base_url: https://api.openai.com/v1
```

E.g. to use Meta's CodeLlama model from HuggingFace you can set:

```yaml
client_base_url: https://api-inference.huggingface.co/models/codellama/CodeLlama-70b-Instruct-hf/v1
model: codellama/CodeLlama-70b-Instruct-hf
model_temperature: 0.2
model_top_p: 0.95
model_max_tokens: 2000
```
and pass your HuggingFace token in the `openai_api_key` option.

You can also use llama.cpp to run inference on CPU locally. Just install the [llama-cpp-python](https://github.com/abetlen/llama-cpp-python) package and run their OpenAI compatible web server as described [here](https://github.com/abetlen/llama-cpp-python) with the command:

`python3 -m llama_cpp.server --hf_model_repo_id TheBloke/deepseek-coder-6.7B-instruct-GGUF --model 'deepseek-coder-6.7b-instruct.Q4_K_M.gguf' --chat_format chatml`

Once the local server is running you can set:

```yaml
client_base_url: http://localhost:8000/v1
model: TheBloke/deepseek-coder-6.7B-instruct-GGUF
model_temperature: 0.2
model_top_p: 0.95
model_max_tokens: 1000
```
and use the local model for inference.

### Filter
You can restrict the kind of files to use for generating the documentation using the `filter` option.
```yaml
filter: '*.py'
```

### Suppress comments
If you do not want the comments in the file to be included set the `suppress_comments` option.
```yaml
suppress_comments: false
```

### README file name
You can change the default README file name from README.md to something you want by using the `markdown_file_name` option.
```yaml
markdown_file_name: Diagram.md
```

### Manage PRs
In addition, there are options to let you manage the PRs as you like, by setting a `branch_prefix`,  or disabling the creation of new branches with `disable_branch` (commits will be made on the current branch). You can also disable PR creation with `disable_pr` or force push commits to existing PR with `force_pr_creation`.

```yaml
branch_prefix: Generated-README
disable_branch: false
disable_pr: false
force_pr_creation: false
```

### Prompt template

You can update the default [prompt template](./generate_readme_prompt.json). Note the use of variable `{{fullContent}}`. It is generated by the steps within the GenerateREADME patchflow and replaced by the actual value during the execution. The expected output response is complete content of the README.md file with the documentation.

## Examples

Here are some example PRs generated with the GenerateREADME patchflow:

- https://github.com/patched-codes/patchwork/pull/53
- https://github.com/patched-codes/patchwork/pull/52
