import { Construct } from 'constructs';
import { aws_lambda, aws_events } from 'aws-cdk-lib';
/**
 * Defines a cron expression.
 */
export interface CronOptionsWithSeconds extends aws_events.CronOptions {
    /**
     * The second to run the Lambda at.
     *
     * @default - At the first second of every minute
     */
    readonly second?: string;
}
/**
 * Defines the schedule for a time trigger.
 */
export interface TimeTriggerSchedule {
    /**
     * Set this to define the schedule using a cron expression.
     *
     * As of now, this is the only supported option
     */
    readonly cron: CronOptionsWithSeconds;
}
export interface TimeTriggerProps {
    /**
     * Defines the schedule for a time trigger.
     */
    readonly schedule: TimeTriggerSchedule;
}
export declare class TimeTrigger extends Construct implements aws_lambda.IEventSource {
    private id;
    private props;
    constructor(scope: Construct, id: string, props: TimeTriggerProps);
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     */
    bind(target: aws_lambda.IFunction): void;
}
