---
name: Bug Report / Feature Request
about: Create a report to help us improve the pCloud SDK
title: '[BUG/FEATURE] Brief description'
labels: ''
assignees: ''
---

## Issue Type
- [ ] Bug Report
- [ ] Feature Request
- [ ] Documentation Issue
- [ ] Question

## Description
A clear and concise description of what the issue is or what feature you'd like to see.

## Environment (for bug reports)
- **pCloud SDK Version:** [e.g., 2.0.0]
- **Python Version:** [e.g., 3.11.0]
- **Operating System:** [e.g., Ubuntu 22.04, Windows 11, macOS 13]
- **Installation Method:** [e.g., pip, conda, from source]

## Steps to Reproduce (for bug reports)
1. Go to '...'
2. Run command '...'
3. See error

## Expected Behavior
A clear and concise description of what you expected to happen.

## Actual Behavior
A clear and concise description of what actually happened.

## Code Sample
If applicable, add a minimal code sample that reproduces the issue:

```python
from pcloud_sdk import PCloudSDK

sdk = PCloudSDK()
# Your code here
```

## Error Messages/Logs
If applicable, add any error messages or log output:

```
Paste error messages here
```

## Screenshots
If applicable, add screenshots to help explain your problem.

## Proposed Solution (for feature requests)
If you have ideas for how to implement the feature, please describe them here.

## Additional Context
Add any other context about the problem here.

## Checklist
- [ ] I have searched for existing issues before creating this one
- [ ] I have provided all necessary information
- [ ] I have tested with the latest version of the SDK
- [ ] I have included a minimal code sample (if applicable)