## Description
Please provide a brief description of the changes in this pull request.

## Type of Change
- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation update
- [ ] Performance improvement
- [ ] Code refactoring
- [ ] Test improvement

## Related Issue(s)
- Closes #(issue number)
- Related to #(issue number)

## Changes Made
- [ ] Added/Modified functionality in module: `pcloud_sdk/...`
- [ ] Updated documentation
- [ ] Added/Updated tests
- [ ] Updated examples
- [ ] Updated changelog

## Testing
- [ ] All existing tests pass
- [ ] New tests added for new functionality
- [ ] Manual testing completed
- [ ] Integration tests pass (if applicable)

### Test Commands Run
```bash
# List the commands you used to test your changes
python tools/test_runner.py
python tools/lint.py
```

## Code Quality Checklist
- [ ] Code follows the project's style guidelines (black, isort, flake8)
- [ ] Self-review of the code completed
- [ ] Code is documented (docstrings, comments where necessary)
- [ ] No debugging statements left in code
- [ ] Type hints added where appropriate

## Backwards Compatibility
- [ ] This change is backwards compatible
- [ ] This change breaks backwards compatibility (please describe impact)

## Performance Impact
- [ ] No performance impact
- [ ] Performance improvement (please describe)
- [ ] Performance regression (please justify and describe mitigation)

## Documentation
- [ ] Documentation updated in `docs/` directory
- [ ] README.md updated (if needed)
- [ ] Examples updated/added (if needed)
- [ ] Changelog updated

## Additional Notes
Please add any additional information, context, or screenshots that would help reviewers understand your changes.

## Checklist for Maintainers
- [ ] Code review completed
- [ ] All CI checks pass
- [ ] Documentation review completed
- [ ] Version bump needed (if applicable)
- [ ] Ready to merge