"""
pCloud SDK for Python v1.0
Modern Python SDK for pCloud API with automatic token management and progress tracking
"""

from .app import App
from .config import Config

# Main SDK class
from .core import PCloudSDK
from .exceptions import PCloudException
from .file_operations import File
from .folder_operations import Folder
from .progress_utils import (
    DetailedProgress,
    MinimalProgress,
    SilentProgress,
    SimpleProgressBar,
    create_detailed_progress,
    create_minimal_progress,
    create_progress_bar,
    create_silent_progress,
)
from .request import HttpClient, Request
from .response import Response
from .user_operations import User

# Prefer version generated by setuptools_scm at build time
try:  # pragma: no cover - exists in sdists/wheels
    from ._version import version as __version__  # type: ignore
except Exception:  # pragma: no cover - fallback for editable/dev environments
    try:
        from importlib.metadata import version as _pkg_version  # type: ignore
    except Exception:  # pragma: no cover
        try:
            from importlib_metadata import version as _pkg_version  # type: ignore
        except Exception:  # pragma: no cover
            _pkg_version = None  # type: ignore

    try:
        __version__ = _pkg_version("pcloud-sdk-python") if _pkg_version else "0.0.0"
    except Exception:  # pragma: no cover
        __version__ = "0.0.0"
__author__ = "Converted from pCloud PHP SDK"
__license__ = "MIT"

__all__ = [
    # Main SDK
    "PCloudSDK",
    # Core classes
    "App",
    "Request",
    "Response",
    "HttpClient",
    "Config",
    "PCloudException",
    # Operation classes
    "File",
    "Folder",
    "User",
    # Progress utilities
    "create_progress_bar",
    "create_detailed_progress",
    "create_minimal_progress",
    "create_silent_progress",
    "SimpleProgressBar",
    "DetailedProgress",
    "MinimalProgress",
    "SilentProgress",
]
