Pandas-sql-loader
===================================
Модуль, реализующий функцию sql_load для оптимизации потрбеления 
памяти метода pandas.read_sql(). Проставляет минимально возможный
для каждого столбца тип данных. 
(float64 -> float16, int64 -> uint8 и т.д)

Интерфейс метода полностью совместим с pandas.read_sql(), 
однако присутствуют дополнительные опциональные параметры.
   

sql_load interface
===================================

sql_load(sql,
         con,
         index_col=None,
         coerce_float=True,
         params=None,
         parse_dates=None,
         columns=None,
         chunksize=None,
         need_downcast=False,
         column_types=None,
         iterator=True)
         
Все стандартные параметры есть в документации, опишу только новые:

need_downcast: bool, default False
===================================

Флаг, устанавливающий нужна ли оптимизация памяти или нет.

column_types: list, default None
===================================
Список numpy типов, к которым нужно привести столбцы.  
Если в столбце есть значение, превыщающее заданный тип, то тип будет проигнорирован.
Если длина списка меньше, чем кол-во столбцов, то список будет автоматически
расширен типами uint8.
Если не задан, то каждый столбец попытается привести к uint8.

iterator: bool, default True
===================================
Флаг, устанавливающий должен ли вернуться итератор или уже собранный из 
чанков DataFrame при установленном chunksize.


Рекомендация
===================================
Для датасетов, размер которых в полтора раза меньше чем доступная память и более, 
настоятельно рекомендуется использовать загрузку чанками, тк прежде чем сдаункастить 
типы, в память будет загружен DataFrame средствами самого пандас (т.е. с жирными типами)


Пример
===================================
Чтобы получить готовый оптимизированный DataFrame, но загруженный чанками:

df = sql_load(query, con, chunksize=10000, need_downcast=True, iterator=False)

