# upper case to text table
UPPER_TO_TEXT = bytearray([65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 32, 0, 0, 0])

# lower case to text table
LOWER_TO_TEXT = bytearray([97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122,  32, 0, 0, 0])

# table for text mixed sub-mode
MIXED_TO_TEXT = bytearray([48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 38, 13, 9, 44, 58, 35, 45, 46, 36, 47, 43, 37, 42, 61, 94, 0, 32, 0, 0, 0])

# punctuaion to text table
PUNCT_TO_TEXT = bytearray([59, 60, 62, 64, 91, 92, 93, 95, 96, 126, 33, 13, 9, 44, 58, 10, 45, 46, 36, 47, 34, 124, 42, 40, 41, 63, 123, 125, 39, 0])

# Symbol to cluster and codeword translation table.
# Each entry is made of:
#   18 bits symbol (bit 29 to bit 12)
#   2 bits cluster (bit 11 to bit 10) 
#   10 bits codeword (bit 9 to bit 0) 
SYMBOL_TABLE = list([ \
    0x0000c802, 0x00015805, 0x0001e808, 0x00024009, 0x0002780a, 0x0002d00b, 0x0004c80c, 0x0005580f, \
	0x0005b012, 0x0005e812, 0x00064014, 0x00067815, 0x00092015, 0x00095818, 0x0009b018, 0x0009e81b, \
	0x000a401b, 0x000a781d, 0x000db01d, 0x000e142c, 0x000e401f, 0x000ea42f, 0x000f3432, 0x000fc434, \
	0x00121436, 0x00124021, 0x0012a439, 0x0013343b, 0x0013c43d, 0x0016a43e, 0x00173440, 0x0017c441, \
    0x00243830, 0x0024c833, 0x00255836, 0x0025b02b, 0x0025e838, 0x0026402e, 0x0026783a, 0x0026d030, \
    0x0028c83c, 0x00292034, 0x0029583f, 0x0029b037, 0x0029e842, 0x002a403a, 0x002a7843, 0x002d203c, \
    0x002d5846, 0x002db03f, 0x002de848, 0x002e4041, 0x00318466, 0x0031b043, 0x00321469, 0x00324045, \
    0x0032a46c, 0x0032d046, 0x0033346e, 0x0033c470, 0x00361471, 0x0036a473, 0x00373475, 0x0037c476, \
    0x003aa477, 0x003b3478, 0x00483856, 0x0048c859, 0x0049204d, 0x0049585b, 0x0049b050, 0x0049e85d, \
    0x004a4052, 0x004a785e, 0x004ad053, 0x004c9054, 0x004cc860, 0x004d2057, 0x004d5863, 0x004db05a, \
    0x004de864, 0x004e405c, 0x004ed05d, 0x0051205e, 0x00515866, 0x0051b060, 0x00524062, 0x00558494, \
    0x0055b063, 0x00561497, 0x0056a499, 0x0057349b, 0x0057c49c, 0x005a149d, 0x005aa49f, 0x005b34a0, \
    0x005ea4a1, 0x006c386e, 0x006c9067, 0x006cc870, 0x006d206a, 0x006d5872, 0x006db06d, 0x006de873, \
    0x006e406f, 0x00709071, 0x0070c875, 0x00712074, 0x00715876, 0x0071b076, 0x00724078, 0x0072d079, \
    0x0076407b, 0x007984b4, 0x007a14b6, 0x007aa4b8, 0x007b34b9, 0x007e14ba, 0x007ea4bb, 0x0090007c, \
    0x0090387a, 0x0090907f, 0x0090c87c, 0x00912082, 0x0091587d, 0x0091b084, 0x00924086, 0x00949087, \
    0x0094c87e, 0x00952088, 0x0095b089, 0x009d84c8, 0x009e14ca, 0x009ea4cb, 0x00b4008a, 0x00b4387f, \
    0x00b4c880, 0x00b6408e, 0x0120550b, 0x0120b8aa, 0x0120e50e, 0x012148ad, 0x01217511, 0x0121d8b0, \
    0x012268b2, 0x0122f8b4, 0x0124b8b8, 0x012548bb, 0x0125a0c8, 0x0125d8be, 0x012630cc, 0x012668c0, \
    0x0126c0ce, 0x0126f8c2, 0x012910d2, 0x012948c8, 0x0129a0d6, 0x0129d8cb, 0x012a30d9, 0x012a68cd, \
    0x012ac0db, 0x012da0de, 0x012dd8d2, 0x012e30e1, 0x012ec0e3, 0x01320541, 0x013230e5, 0x01329544, \
    0x0132c0e7, 0x01332547, 0x0133b549, 0x0136954d, 0x0137254f, 0x0137b551, 0x014428de, 0x01445555, \
    0x0144b8e1, 0x0144e558, 0x014548e4, 0x0145755a, 0x0145d8e6, 0x014668e8, 0x0146f8e9, 0x0148b8ec, \
    0x014910fb, 0x014948ef, 0x0149a0ff, 0x0149d8f1, 0x014a3102, 0x014a68f3, 0x014d1109, 0x014d48f7, \
    0x014da10c, 0x014dd8f9, 0x014e310f, 0x0151a114, 0x01523116, 0x0152c118, 0x0156057c, 0x01563119, \
    0x0156957f, 0x01572581, 0x0157b583, 0x015a9585, 0x015b2587, 0x01682901, 0x0168558a, 0x0168b904, \
    0x0168e58c, 0x01694906, 0x0169d908, 0x016a6909, 0x016c8129, 0x016cb90c, 0x016d112d, 0x016d490e, \
    0x016da130, 0x016dd910, 0x016e3133, 0x016ec135, 0x01711138, 0x01714912, 0x0171a13b, 0x0172313d, \
    0x0172c13f, 0x0175a140, 0x01763141, 0x017a05a5, 0x017a95a7, 0x017b25a9, 0x017e95ab, 0x018c2913, \
    0x018c55ad, 0x018cb915, 0x018d4917, 0x018dd918, 0x0190814e, 0x0190b91a, 0x01911151, 0x0191491c, \
    0x0191a154, 0x01923156, 0x01951159, 0x0195a15a, 0x0196315b, 0x019e05bc, 0x019e95be, 0x01b0291d, \
    0x01b0b91f, 0x01b14920, 0x01b4b922, 0x01b51161, 0x01b5a162, 0x01b63163, 0x01d42923, 0x01d4b924, \
    0x02404625, 0x0240a963, 0x0240d628, 0x02413966, 0x0241662b, 0x0241c969, 0x0241f62c, 0x0242596b, \
    0x0242e96d, 0x0244a971, 0x0244d632, 0x02453974, 0x02456636, 0x0245c977, 0x02465979, 0x0246e97b, \
    0x024901d4, 0x02493980, 0x024991d8, 0x0249c983, 0x024a21dc, 0x024a5985, 0x024ab1df, 0x024d91e6, \
    0x024dc988, 0x024e21e9, 0x025221f0, 0x0256865a, 0x0257165d, 0x0257a65f, 0x02641989, 0x02644663, \
    0x0264a98c, 0x0264d666, 0x0265398f, 0x02656667, 0x0265c991, 0x02665993, 0x0266e994, 0x0268a997, \
    0x0268d66c, 0x0269399a, 0x0269c99c, 0x026a599e, 0x026d020f, 0x026d39a2, 0x026d9213, 0x026dc9a4, \
    0x026e2216, 0x0271921e, 0x02722221, 0x02762224, 0x027a8683, 0x027b1685, 0x028819a5, 0x02884687, \
    0x0288a9a8, 0x0288d688, 0x028939aa, 0x0289c9ac, 0x028a59ad, 0x028ca9b0, 0x028d39b2, 0x028dc9b4, \
    0x0291023a, 0x029139b7, 0x0291923d, 0x02922240, 0x0292b242, 0x02959244, 0x02962245, 0x029e8696, \
    0x02ac19b8, 0x02ac4697, 0x02aca9ba, 0x02ad39bc, 0x02adc9bd, 0x02b0a9bf, 0x02b139c1, 0x02b5024d, \
    0x02d019c2, 0x02d0a9c4, 0x02d139c5, 0x02d4a9c7, 0x02f419c8, 0x02f4a9c9, 0x036036fa, 0x03609a07, \
    0x0360c6fc, 0x03612a0a, 0x036156fe, 0x0361ba0d, 0x0361e6ff, 0x03624a0f, 0x0362da11, 0x03649a15, \
    0x0364c703, 0x03652a18, 0x03655705, 0x0365ba1b, 0x03664a1d, 0x0366da1f, 0x03692a24, 0x0369ba27, \
    0x036a4a29, 0x036d82e7, 0x036dba2d, 0x036e12eb, 0x036ea2ee, 0x037212f4, 0x0372a2f6, 0x03840a2e, \
    0x03843718, 0x03849a31, 0x0384c71a, 0x03852a34, 0x0385571b, 0x0385ba36, 0x03864a38, 0x0386da39, \
    0x03889a3c, 0x0388c71d, 0x03892a3f, 0x0389ba41, 0x038a4a43, 0x038d2a47, 0x038dba49, 0x03918313, \
    0x03921316, 0x0392a318, 0x0396131a, 0x03a80a4a, 0x03a8371e, 0x03a89a4d, 0x03a8c71f, 0x03a92a4f, \
    0x03a9ba51, 0x03aa4a52, 0x03ac9a55, 0x03ad2a57, 0x03adba59, 0x03b12a5c, 0x03b58323, 0x03b61324, \
    0x03cc0a5d, 0x03cc3720, 0x03cc9a5f, 0x03cd2a61, 0x03cdba62, 0x03d09a64, 0x03d12a66, 0x03f00a67, \
    0x03f09a69, 0x03f12a6a, 0x03f49a6c, 0x0480275b, 0x0480b75d, 0x0481475f, 0x0481d760, 0x04848ab7, \
    0x0484b762, 0x04851aba, 0x04854764, 0x0485aabd, 0x04863abf, 0x0486cac1, 0x04891ac6, 0x0489aac9, \
    0x048a3acb, 0x048daacf, 0x04a42765, 0x04a4b767, 0x04a54768, 0x04a88ad8, 0x04a8b76a, 0x04a91adb, \
    0x04a9aadd, 0x04aa3adf, 0x04ad1ae3, 0x04adaae5, 0x04c8276b, 0x04c8b76c, 0x04cc8aec, 0x04cd1aee, \
    0x04cdaaf0, 0x04d11af3, 0x04ec276d, 0x04f08af7, 0x04f11af9, 0x05a01784, 0x05a0a786, 0x05a13788, \
    0x05a1c789, 0x05a4a78b, 0x05a5378d, 0x05a90b44, 0x05a99b47, 0x05aa2b49, 0x05ad9b4d, 0x05c4178e, \
    0x05c4a790, 0x05c53791, 0x05c8a793, 0x05cd0b57, 0x05cd9b59, 0x05e81794, 0x05e8a795, 0x05f10b5f, \
    0x08004800, 0x0800d803, 0x08013006, 0x08016806, 0x0801c008, 0x0801f809, 0x0802500a, 0x0804a00c, \
    0x0804d80d, 0x0805300f, 0x08056810, 0x0805c013, 0x0805f813, 0x08093016, 0x0809941e, 0x0809c019, \
    0x080a2421, 0x080a501c, 0x080ab424, 0x080b4426, 0x080bd428, 0x080d9429, 0x080dc01e, 0x080e242d, \
    0x080e5020, 0x080eb430, 0x080f4433, 0x080fd435, 0x08122437, 0x0812b43a, 0x0813443c, 0x0816882b, \
    0x0816b43f, 0x0817182d, 0x0817a82f, 0x08244831, 0x0824a026, 0x0824d834, 0x08253029, 0x08256837, \
    0x0825c02c, 0x0825f839, 0x0826502f, 0x0828a031, 0x0828d83d, 0x08293035, 0x08296840, 0x0829c038, \
    0x082a503b, 0x082d045a, 0x082d303d, 0x082d945d, 0x082dc040, 0x082e2460, 0x082e5042, 0x082eb462, \
    0x082f4464, 0x082fd465, 0x08319467, 0x0831c044, 0x0832246a, 0x0832b46d, 0x0833446f, 0x08362472, \
    0x0836b474, 0x083a8852, 0x083b1854, 0x083ba855, 0x08481047, 0x08484857, 0x0848a04a, 0x0848d85a, \
    0x0849304e, 0x0849685c, 0x0849c051, 0x084ca055, 0x084cd861, 0x084d3058, 0x084dc05b, 0x0851048b, \
    0x0851305f, 0x0851948e, 0x0851c061, 0x08522490, 0x0852b492, 0x08534493, 0x08559495, 0x08562498, \
    0x0856b49a, 0x085a249e, 0x085e886c, 0x085f186d, 0x086c1064, 0x086c486f, 0x086ca068, 0x086cd871, \
    0x086d306b, 0x086dc06e, 0x086e5070, 0x0870a072, 0x08713075, 0x0871c077, 0x087504ae, 0x0875307a, \
    0x087594b0, 0x087624b2, 0x0876b4b3, 0x087994b5, 0x087a24b7, 0x0890107d, 0x0890487b, 0x0890a080, \
    0x08913083, 0x0891c085, 0x089904c4, 0x089994c6, 0x089a24c7, 0x089d94c9, 0x08b4a08c, 0x08b5308d, \
    0x08bd04d0, 0x08bd94d1, 0x09003881, 0x0900c884, 0x09015887, 0x0901b098, 0x0901e889, 0x0902409a, \
    0x0902788b, 0x0904c88d, 0x0905209e, 0x09055890, 0x0905b0a1, 0x0905e893, 0x090640a3, 0x09067894, \
    0x0906d0a4, 0x090920a5, 0x09095897, 0x0909b0a8, 0x0909e899, 0x090a40aa, 0x090ad0ab, 0x090d84f6, \
    0x090db0ac, 0x090e14f9, 0x090e40ae, 0x090ea4fc, 0x090f34fe, 0x090fc500, 0x09121501, 0x091240af, \
    0x0912a503, 0x09133505, 0x0913c506, 0x0916a507, 0x09173508, 0x092038a7, 0x0920c8ab, 0x092120b6, \
    0x092158ae, 0x0921b0b9, 0x0921e8b1, 0x092240bc, 0x092278b3, 0x092438b5, 0x092490c1, 0x0924c8b9, \
    0x092520c5, 0x092558bc, 0x0925b0c9, 0x0925e8bf, 0x092640cd, 0x092678c1, 0x092890cf, 0x0928c8c4, \
    0x092920d3, 0x092958c9, 0x0929b0d7, 0x0929e8cc, 0x092a40da, 0x092d20dc, 0x092d58cf, 0x092d8533, \
    0x092db0df, 0x092e1536, 0x092e40e2, 0x092ea539, 0x092f353b, 0x092fc53d, 0x0931853e, 0x0931b0e4, \
    0x09321542, 0x093240e6, 0x0932a545, 0x09333548, 0x0933c54a, 0x0936154b, 0x0936a54e, 0x09373550, \
    0x093aa552, 0x094438df, 0x094490eb, 0x0944c8e2, 0x094520ee, 0x094558e5, 0x0945b0f1, 0x0945e8e7, \
    0x094640f3, 0x0946d0f4, 0x094838ea, 0x094890f8, 0x0948c8ed, 0x094920fc, 0x094958f0, 0x0949b100, \
    0x0949e8f2, 0x094a4103, 0x094ad105, 0x094c9106, 0x094cc8f5, 0x094d210a, 0x094d58f8, 0x094db10d, \
    0x094e4110, 0x094ed111, 0x09512112, 0x09518572, 0x0951b115, 0x09521575, 0x09524117, 0x0952a577, \
    0x09533579, 0x0955857a, 0x0956157d, 0x0956a580, 0x09573582, 0x095a1584, 0x095aa586, 0x0968011a, \
    0x09683902, 0x0968911d, 0x0968c905, 0x09692120, 0x09695907, 0x0969b122, 0x096a4124, 0x096ad125, \
    0x096c0126, 0x096c390a, 0x096c912a, 0x096cc90d, 0x096d212e, 0x096d590f, 0x096db131, 0x096e4134, \
    0x09709136, 0x0970c911, 0x09712139, 0x0971b13c, 0x0972413e, 0x0975859e, 0x097615a0, 0x0976a5a2, \
    0x097985a3, 0x097a15a6, 0x097aa5a8, 0x097e15aa, 0x098c0142, 0x098c3914, 0x098c9145, 0x098cc916, \
    0x098d2147, 0x098db149, 0x098e414a, 0x0990014b, 0x09903919, 0x0990914f, 0x0990c91b, 0x09912152, \
    0x0991b155, 0x09924157, 0x09949158, 0x099985b8, 0x099a15ba, 0x099d85bb, 0x099e15bd, 0x09b0391e, \
    0x09b1b15e, 0x09b43921, 0x09b49160, 0x09bd85c5, 0x0a20293d, 0x0a2055f1, 0x0a20b940, 0x0a20e5f4, \
    0x0a214943, 0x0a2175f6, 0x0a21d945, 0x0a226947, 0x0a22f948, 0x0a24b94b, 0x0a251194, 0x0a25494e, \
    0x0a25a198, 0x0a25d950, 0x0a26319b, 0x0a266952, 0x0a26c19d, 0x0a2911a1, 0x0a294956, 0x0a29a1a4, \
    0x0a29d958, 0x0a2a31a7, 0x0a2ac1a9, 0x0a2da1ac, 0x0a2e31ae, 0x0a320618, 0x0a3231b1, 0x0a32961b, \
    0x0a33261d, 0x0a33b61f, 0x0a369621, 0x0a372623, 0x0a402960, 0x0a405626, 0x0a40b964, 0x0a40e629, \
    0x0a414967, 0x0a41d96a, 0x0a42696c, 0x0a44296e, 0x0a44562f, 0x0a4481c0, 0x0a44b972, 0x0a44e633, \
    0x0a4511c4, 0x0a454975, 0x0a45a1c7, 0x0a45d978, 0x0a4631ca, 0x0a46697a, 0x0a4881d0, 0x0a48b97e, \
    0x0a4911d5, 0x0a494981, 0x0a49a1d9, 0x0a49d984, 0x0a4a31dd, 0x0a4d11e3, 0x0a4d4987, 0x0a4da1e7, \
    0x0a4e31ea, 0x0a4ec1ec, 0x0a51a1ee, 0x0a520650, 0x0a5231f1, 0x0a529653, 0x0a532655, 0x0a560658, \
    0x0a56965b, 0x0a57265e, 0x0a5a9661, 0x0a64298a, 0x0a645664, 0x0a64b98d, 0x0a654990, 0x0a65d992, \
    0x0a682995, 0x0a685669, 0x0a6881fe, 0x0a68b998, 0x0a691201, 0x0a69499b, 0x0a69a204, 0x0a69d99d, \
    0x0a6a3206, 0x0a6ac208, 0x0a6c820c, 0x0a6cb9a0, 0x0a6d1210, 0x0a6d49a3, 0x0a6da214, 0x0a6e3217, \
    0x0a6ec219, 0x0a71121c, 0x0a71a21f, 0x0a723222, 0x0a76067d, 0x0a76967f, 0x0a7a0681, 0x0a7a9684, \
    0x0a8829a6, 0x0a88b9a9, 0x0a8949ab, 0x0a8c29ae, 0x0a8c822d, 0x0a8cb9b1, 0x0a8d1230, 0x0a8d49b3, \
    0x0a8da232, 0x0a8e3234, 0x0a908237, 0x0a90b9b6, 0x0a91123b, 0x0a91a23e, 0x0a923241, 0x0a951243, \
    0x0a9a0693, 0x0a9e0695, 0x0aac29b9, 0x0aacb9bb, 0x0ab029be, 0x0ab0b9c0, 0x0ab4824c, 0x0ab5a24f, \
    0x0ad029c3, 0x0ad429c6, 0x0b4019e8, 0x0b4046d7, 0x0b40a9eb, 0x0b40d6da, 0x0b4139ee, 0x0b4166db, \
    0x0b41c9f0, 0x0b4259f2, 0x0b42e9f3, 0x0b44a9f6, 0x0b44d6e0, 0x0b4539f9, 0x0b45c9fb, 0x0b4659fd, \
    0x0b4902aa, 0x0b493a01, 0x0b4992ae, 0x0b49ca03, 0x0b4a22b1, 0x0b4d92b9, 0x0b4e22bc, 0x0b5222c0, \
    0x0b5686f7, 0x0b5716f9, 0x0b601a04, 0x0b6046fb, 0x0b60aa08, 0x0b60d6fd, 0x0b613a0b, 0x0b61ca0e, \
    0x0b625a10, 0x0b641a12, 0x0b644701, 0x0b64aa16, 0x0b64d704, 0x0b653a19, 0x0b65ca1c, 0x0b665a1e, \
    0x0b68aa22, 0x0b6902d6, 0x0b693a25, 0x0b6992d9, 0x0b69ca28, 0x0b6a22dc, 0x0b6ab2de, 0x0b6d02e4, \
    0x0b6d3a2c, 0x0b6d92e8, 0x0b6e22ec, 0x0b7192f2, 0x0b7222f5, 0x0b768714, 0x0b7a8717, 0x0b841a2f, \
    0x0b844719, 0x0b84aa32, 0x0b853a35, 0x0b85ca37, 0x0b881a3a, 0x0b88471c, 0x0b88aa3d, 0x0b893a40, \
    0x0b89ca42, 0x0b8caa45, 0x0b8d0306, 0x0b8d3a48, 0x0b8d9309, 0x0b8e230b, 0x0b910310, 0x0b919314, \
    0x0b922317, 0x0ba81a4b, 0x0ba8aa4e, 0x0ba93a50, 0x0bac1a53, 0x0bacaa56, 0x0bad3a58, 0x0bb0aa5b, \
    0x0bb1031f, 0x0bb19320, 0x0bb50322, 0x0bcc1a5e, 0x0bccaa60, 0x0bd01a63, 0x0bd0aa65, 0x0bf01a68, \
    0x0bf41a6b, 0x0c600a8f, 0x0c603755, 0x0c609a92, 0x0c60c757, 0x0c612a95, 0x0c615758, 0x0c61ba97, \
    0x0c624a99, 0x0c62da9a, 0x0c649a9d, 0x0c64c75a, 0x0c652aa0, 0x0c65baa2, 0x0c664aa4, 0x0c692aa8, \
    0x0c69baaa, 0x0c6d8386, 0x0c6e1389, 0x0c72138e, 0x0c800aab, 0x0c80375c, 0x0c809aae, 0x0c80c75e, \
    0x0c812ab0, 0x0c81bab2, 0x0c824ab3, 0x0c840ab4, 0x0c843761, 0x0c849ab8, 0x0c84c763, 0x0c852abb, \
    0x0c85babe, 0x0c864ac0, 0x0c889ac4, 0x0c892ac7, 0x0c89baca, 0x0c8d2ace, 0x0c8d83a0, 0x0ca40ad0, \
    0x0ca43766, 0x0ca49ad2, 0x0ca52ad4, 0x0ca5bad5, 0x0ca80ad6, 0x0ca83769, 0x0ca89ad9, 0x0ca92adc, \
    0x0ca9bade, 0x0cac9ae1, 0x0cad2ae4, 0x0cc80ae6, 0x0cc89ae8, 0x0cc92ae9, 0x0ccc0aea, 0x0ccc9aed, \
    0x0ccd2aef, 0x0cd09af2, 0x0cec0af4, 0x0cec9af5, 0x0cf00af6, 0x0cf09af8, 0x0d80277e, 0x0d80b780, \
    0x0d814781, 0x0d848b27, 0x0d84b783, 0x0d851b2a, 0x0d85ab2c, 0x0d863b2e, 0x0d891b32, 0x0d89ab34, \
    0x0da02785, 0x0da0b787, 0x0da4278a, 0x0da48b3b, 0x0da4b78c, 0x0da51b3d, 0x0da5ab3f, 0x0da88b42, \
    0x0da91b45, 0x0da9ab48, 0x0dad1b4c, 0x0dc4278f, 0x0dc82792, 0x0dc88b51, 0x0dc91b53, 0x0dcc8b55, \
    0x0dcd1b58, 0x0dec8b5c, 0x0df08b5e, 0x0ea01799, 0x0ea0a79b, 0x0ea1379c, 0x0ea4a79e, 0x0ea90b89, \
    0x0ea99b8b, 0x0ec4179f, 0x0ec4a7a0, 0x0ecd0b91, 0x10002000, 0x10005801, 0x1000b003, 0x1000e804, \
    0x10014007, 0x10017807, 0x1004b00d, 0x10051410, 0x10054010, 0x1005a413, 0x10063416, 0x1006c418, \
    0x1007541a, 0x1009141b, 0x10094017, 0x1009a41f, 0x1009d01a, 0x100a3422, 0x100ac425, 0x100b5427, \
    0x100da42a, 0x100e342e, 0x100ec431, 0x10120825, 0x10123438, 0x10129827, 0x10132829, 0x1013b82a, \
    0x1016982c, 0x1017282e, 0x10242023, 0x10245832, 0x1024b027, 0x1024e835, 0x1025402a, 0x1025d02d, \
    0x1028844e, 0x1028b032, 0x10291451, 0x10294036, 0x1029a454, 0x1029d039, 0x102a3456, 0x102ac458, \
    0x102b5459, 0x102d145b, 0x102d403e, 0x102da45e, 0x102e3461, 0x102ec463, 0x1031a468, 0x1032346b, \
    0x1036084e, 0x10369850, 0x10372851, 0x103a9853, 0x10482048, 0x10485858, 0x1048b04b, 0x1049404f, \
    0x104c8482, 0x104cb056, 0x104d1485, 0x104d4059, 0x104da487, 0x104e3489, 0x104ec48a, 0x1051148c, \
    0x1051a48f, 0x10523491, 0x1055a496, 0x105a086a, 0x105a986b, 0x106c2065, 0x106cb069, 0x106d406c, \
    0x107084a8, 0x1070b073, 0x107114aa, 0x1071a4ac, 0x107234ad, 0x107514af, 0x1075a4b1, 0x107e0879, \
    0x1090207e, 0x1090b081, 0x109484c0, 0x109514c2, 0x1095a4c3, 0x109914c5, 0x10b4208b, 0x10b884ce, \
    0x10b914cf, 0x11004882, 0x1100a092, 0x1100d885, 0x11013095, 0x11016888, 0x1101c099, 0x1101f88a, \
    0x1104a09b, 0x1104d88e, 0x1105309f, 0x11056891, 0x1105c0a2, 0x110904ea, 0x110930a6, 0x110994ed, \
    0x1109c0a9, 0x110a24f0, 0x110ab4f2, 0x110b44f4, 0x110bd4f5, 0x110d94f7, 0x110dc0ad, 0x110e24fa, \
    0x110eb4fd, 0x110f44ff, 0x11122502, 0x1112b504, 0x111688a3, 0x111718a5, 0x1117a8a6, 0x112010b0, \
    0x112048a8, 0x1120a0b3, 0x1120d8ac, 0x112130b7, 0x112168af, 0x1121c0ba, 0x112250bd, 0x112410be, \
    0x112448b6, 0x1124a0c2, 0x1124d8ba, 0x112530c6, 0x112568bd, 0x1125c0ca, 0x1128a0d0, 0x1128d8c5, \
    0x11290525, 0x112930d4, 0x11299528, 0x1129c0d8, 0x112a252b, 0x112ab52d, 0x112b452f, 0x112d0530, \
    0x112d30dd, 0x112d9534, 0x112dc0e0, 0x112e2537, 0x112eb53a, 0x112f453c, 0x1131953f, 0x11322543, \
    0x1132b546, 0x1136254c, 0x113688d9, 0x113718db, 0x113a88dc, 0x113b18dd, 0x114410e8, 0x114448e0, \
    0x1144a0ec, 0x1144d8e3, 0x114530ef, 0x1145c0f2, 0x114810f5, 0x114848eb, 0x1148a0f9, 0x1148d8ee, \
    0x114930fd, 0x1149c101, 0x114a5104, 0x114ca107, 0x114d0568, 0x114d310b, 0x114d956b, 0x114dc10e, \
    0x114e256d, 0x114eb56f, 0x11510570, 0x11513113, 0x11519573, 0x11522576, 0x1152b578, 0x1155957b, \
    0x1156257e, 0x115a88ff, 0x115e8900, 0x1168111b, 0x11684903, 0x1168a11e, 0x11693121, 0x1169c123, \
    0x116c1127, 0x116c490b, 0x116ca12b, 0x116d312f, 0x116dc132, 0x1170a137, 0x11710597, 0x1171313a, \
    0x11719599, 0x1172259b, 0x1175059c, 0x1175959f, 0x117625a1, 0x117995a4, 0x118c1143, 0x118ca146, \
    0x118d3148, 0x1190114c, 0x1190a150, 0x11913153, 0x119505b4, 0x119595b6, 0x119905b7, 0x119995b9, \
    0x11b0115c, 0x11b0a15d, 0x11b4115f, 0x11b905c3, 0x11bd05c4, 0x12003925, 0x1200c928, 0x12012169, \
    0x1201592a, 0x1201b16c, 0x1201e92c, 0x1202416e, 0x1202792d, 0x1202d16f, 0x12049170, 0x1204c92f, \
    0x12052173, 0x12055932, 0x1205b176, 0x1205e933, 0x12064178, 0x1206d179, 0x1209217a, 0x12095935, \
    0x1209b17c, 0x120a417e, 0x120d85e1, 0x120db17f, 0x120e15e4, 0x120e4180, 0x120ea5e6, 0x120f35e8, \
    0x120fc5e9, 0x121215ea, 0x1212a5ec, 0x121335ed, 0x1216a5ee, 0x1220393e, 0x12209184, 0x1220c941, \
    0x12212187, 0x12215944, 0x1221b18a, 0x1221e946, 0x1222418c, 0x12243949, 0x12249191, 0x1224c94c, \
    0x12252195, 0x1225594f, 0x1225b199, 0x1225e951, 0x1226419c, 0x1228919e, 0x1228c954, 0x122921a2, \
    0x12295957, 0x1229b1a5, 0x122a41a8, 0x122d21aa, 0x122d860e, 0x122db1ad, 0x122e1611, 0x122e41af, \
    0x122ea613, 0x122f3615, 0x12318616, 0x1231b1b0, 0x12321619, 0x1232a61c, 0x1233361e, 0x12361620, \
    0x1236a622, 0x124001b2, 0x12403961, 0x124091b5, 0x1240c965, 0x124121b8, 0x12415968, 0x1241b1ba, \
    0x124241bc, 0x124401bd, 0x1244396f, 0x124491c1, 0x1244c973, 0x124521c5, 0x12455976, 0x1245b1c8, \
    0x124641cb, 0x1246d1cc, 0x124801cd, 0x1248397c, 0x124891d1, 0x1248c97f, 0x124921d6, 0x12495982, \
    0x1249b1da, 0x124a41de, 0x124ad1e0, 0x124c91e1, 0x124cc986, 0x124d21e4, 0x124d8646, 0x124db1e8, \
    0x124e1649, 0x124e41eb, 0x124ea64b, 0x125121ed, 0x1251864e, 0x1251b1ef, 0x12521651, 0x1252a654, \
    0x12558656, 0x12561659, 0x1256a65c, 0x125a1660, 0x126401f2, 0x1264398b, 0x126491f5, 0x1264c98e, \
    0x126521f7, 0x1265b1f9, 0x126641fa, 0x126801fb, 0x12683996, 0x126891ff, 0x1268c999, 0x12692202, \
    0x1269b205, 0x126a4207, 0x126c0209, 0x126c399f, 0x126c920d, 0x126cc9a1, 0x126d2211, 0x126db215, \
    0x126e4218, 0x1270921a, 0x1271221d, 0x12718677, 0x1271b220, 0x12721679, 0x12752223, 0x1275867b, \
    0x1276167e, 0x12798680, 0x127a1682, 0x12880225, 0x128839a7, 0x12889227, 0x12892229, 0x1289b22a, \
    0x128c022b, 0x128c39af, 0x128c922e, 0x128d2231, 0x128db233, 0x12900235, 0x129039b5, 0x12909238, \
    0x1291223c, 0x1291b23f, 0x12958690, 0x12998692, 0x129d8694, 0x12ad2247, 0x12b09249, 0x12b1224a, \
    0x12b4024b, 0x12b5224e, 0x132029d6, 0x132056b4, 0x1320b9d9, 0x1320e6b6, 0x132149db, 0x1321d9dd, \
    0x132269de, 0x13248275, 0x1324b9e1, 0x13251279, 0x132549e3, 0x1325a27c, 0x1325d9e5, 0x1326327f, \
    0x13291284, 0x132949e7, 0x1329a287, 0x132a3289, 0x132da28c, 0x132e328e, 0x133206cf, 0x133296d1, \
    0x133326d3, 0x133696d5, 0x134029e9, 0x134056d8, 0x1340b9ec, 0x134149ef, 0x1341d9f1, 0x134429f4, \
    0x134456dd, 0x1344829a, 0x1344b9f7, 0x1345129d, 0x134549fa, 0x1345a2a0, 0x1345d9fc, 0x134632a2, \
    0x1346c2a4, 0x134882a7, 0x1348b9ff, 0x134912ab, 0x13494a02, 0x1349a2af, 0x134a32b2, 0x134ac2b4, \
    0x134d12b7, 0x134da2ba, 0x134e32bd, 0x1351a2bf, 0x135206f1, 0x135296f3, 0x135606f5, 0x135696f8, \
    0x13602a05, 0x1360ba09, 0x13614a0c, 0x13642a13, 0x136482c9, 0x1364ba17, 0x136512cc, 0x13654a1a, \
    0x1365a2ce, 0x136632d0, 0x13682a20, 0x136882d3, 0x1368ba23, 0x136912d7, 0x13694a26, 0x1369a2da, \
    0x136a32dd, 0x136c82e1, 0x136cba2b, 0x136d12e5, 0x136da2e9, 0x136e32ed, 0x137112f0, 0x1371a2f3, \
    0x13720710, 0x13760713, 0x137a0716, 0x13842a30, 0x1384ba33, 0x13882a3b, 0x138882fd, 0x1388ba3e, \
    0x138912ff, 0x1389a301, 0x138c2a44, 0x138c8304, 0x138cba46, 0x138d1307, 0x138da30a, 0x1390830e, \
    0x13911311, 0x1391a315, 0x13951319, 0x13a82a4c, 0x13ac2a54, 0x13ac831c, 0x13ad131d, 0x13b02a5a, \
    0x13b0831e, 0x13b48321, 0x14401a7c, 0x14404745, 0x1440aa7f, 0x1440d746, 0x14413a81, 0x1441ca83, \
    0x14425a84, 0x1444aa87, 0x14453a89, 0x1445ca8b, 0x1449035e, 0x14493a8e, 0x14499361, 0x144a2364, \
    0x144d9369, 0x144e236b, 0x14568754, 0x14601a90, 0x14604756, 0x1460aa93, 0x14613a96, 0x1461ca98, \
    0x14641a9b, 0x14644759, 0x1464aa9e, 0x14653aa1, 0x1465caa3, 0x1468aaa6, 0x14690379, 0x14693aa9, \
    0x1469937c, 0x146a237e, 0x146d0383, 0x146d9387, 0x146e238a, 0x1471938d, 0x14801aac, 0x1480aaaf, \
    0x14813ab1, 0x14841ab5, 0x1484aab9, 0x14853abc, 0x14881ac2, 0x1488aac5, 0x14890398, 0x14893ac8, \
    0x1489939a, 0x148caacd, 0x148d039e, 0x14a41ad1, 0x14a4aad3, 0x14a81ad7, 0x14a8aada, 0x14ac1ae0, \
    0x14acaae2, 0x14c81ae7, 0x14cc1aeb, 0x14d01af1, 0x15600b0c, 0x1560377c, 0x15609b0f, 0x1560c77d, \
    0x15612b11, 0x1561bb13, 0x15624b14, 0x15649b17, 0x15652b19, 0x1565bb1b, 0x15692b1e, 0x15800b1f, \
    0x1580377f, 0x15809b21, 0x15812b23, 0x1581bb24, 0x15840b25, 0x15843782, 0x15849b28, 0x15852b2b, \
    0x1585bb2d, 0x15889b30, 0x15892b33, 0x15a00b35, 0x15a09b37, 0x15a12b38, 0x15a40b39, 0x15a49b3c, \
    0x15a52b3e, 0x15a80b40, 0x15a89b43, 0x15a92b46, 0x15ac9b4b, 0x15c40b4e, 0x15c49b4f, 0x15c80b50, \
    0x15c89b52, 0x15cc0b54, 0x15cc9b56, 0x15e80b5a, 0x15ec0b5b, 0x15f00b5d, 0x16802797, 0x1680b798, \
    0x16848b78, 0x16851b7a, 0x1685ab7c, 0x16891b7f, 0x16a0279a, 0x16a4279d, 0x16a48b83, 0x16a51b85, \
    0x16a88b87, 0x16a91b8a, 0x16c88b8e, 0x16cc8b90, 0x18003001, 0x18009402, 0x1800c004, 0x18012405, \
    0x1801b408, 0x1802440a, 0x1802d40c, 0x1804940d, 0x1804c00e, 0x18052411, 0x18055011, 0x1805b414, \
    0x18064417, 0x1806d419, 0x1809241c, 0x1809b420, 0x180a4423, 0x180d881f, 0x180db42b, 0x180e1821, \
    0x180ea823, 0x180f3824, 0x18121826, 0x1812a828, 0x18240442, 0x18243024, 0x18249445, 0x1824c028, \
    0x18252448, 0x1825b44a, 0x1826444c, 0x1826d44d, 0x1828944f, 0x1828c033, 0x18292452, 0x1829b455, \
    0x182a4457, 0x182d245c, 0x182db45f, 0x1831884a, 0x1832184c, 0x1832a84d, 0x1836184f, 0x18480479, \
    0x18483049, 0x1848947c, 0x1848c04c, 0x1849247e, 0x1849b480, 0x184a4481, 0x184c9483, 0x184d2486, \
    0x184db488, 0x1851248d, 0x18558868, 0x18561869, 0x186c04a2, 0x186c3066, 0x186c94a4, 0x186d24a6, \
    0x186db4a7, 0x187094a9, 0x187124ab, 0x18798878, 0x189004bc, 0x189094be, 0x189124bf, 0x189494c1, \
    0x18b404cc, 0x18b494cd, 0x1900208f, 0x19005883, 0x1900b093, 0x1900e886, 0x19014096, 0x190484de, \
    0x1904b09c, 0x190514e1, 0x190540a0, 0x1905a4e4, 0x190634e6, 0x1906c4e8, 0x190754e9, 0x190914eb, \
    0x190940a7, 0x1909a4ee, 0x190a34f1, 0x190ac4f3, 0x190da4f8, 0x190e34fb, 0x1912089f, 0x191298a1, \
    0x191328a2, 0x191698a4, 0x192020b1, 0x192058a9, 0x1920b0b4, 0x192140b8, 0x1921d0bb, 0x192420bf, \
    0x192458b7, 0x19248517, 0x1924b0c3, 0x1925151a, 0x192540c7, 0x1925a51d, 0x1925d0cb, 0x1926351f, \
    0x1926c521, 0x19288522, 0x1928b0d1, 0x19291526, 0x192940d5, 0x1929a529, 0x192a352c, 0x192ac52e, \
    0x192d1531, 0x192da535, 0x192e3538, 0x1931a540, 0x193208d5, 0x193298d7, 0x193608d8, 0x193698da, \
    0x194420e9, 0x1944b0ed, 0x194540f0, 0x194820f6, 0x1948855e, 0x1948b0fa, 0x19491561, 0x194940fe, \
    0x1949a563, 0x194a3565, 0x194c8566, 0x194cb108, 0x194d1569, 0x194da56c, 0x194e356e, 0x19511571, \
    0x1951a574, 0x195608fd, 0x195a08fe, 0x1968211c, 0x1968b11f, 0x196c2128, 0x196c8590, 0x196cb12c, \
    0x196d1592, 0x196da594, 0x19708595, 0x19711598, 0x1971a59a, 0x1975159d, 0x198c2144, 0x1990214d, \
    0x199085b0, 0x199115b2, 0x199485b3, 0x199515b5, 0x19b485c1, 0x19b885c2, 0x1a001164, 0x1a004926, \
    0x1a00a167, 0x1a00d929, 0x1a01316a, 0x1a01692b, 0x1a01c16d, 0x1a04a171, 0x1a04d930, 0x1a053174, \
    0x1a05c177, 0x1a0905d8, 0x1a09317b, 0x1a0995db, 0x1a09c17d, 0x1a0a25dd, 0x1a0ab5df, 0x1a0b45e0, \
    0x1a0d95e2, 0x1a0e25e5, 0x1a0eb5e7, 0x1a1225eb, 0x1a16893b, 0x1a17193c, 0x1a201181, 0x1a20493f, \
    0x1a20a185, 0x1a20d942, 0x1a213188, 0x1a21c18b, 0x1a22518d, 0x1a24118e, 0x1a24494a, 0x1a24a192, \
    0x1a24d94d, 0x1a253196, 0x1a25c19a, 0x1a28a19f, 0x1a290604, 0x1a2931a3, 0x1a299607, 0x1a29c1a6, \
    0x1a2a2609, 0x1a2ab60b, 0x1a2d060c, 0x1a2d31ab, 0x1a2d960f, 0x1a2e2612, 0x1a2eb614, 0x1a319617, \
    0x1a32261a, 0x1a36895e, 0x1a3a895f, 0x1a4011b3, 0x1a404962, 0x1a40a1b6, 0x1a4131b9, 0x1a41c1bb, \
    0x1a4411be, 0x1a444970, 0x1a44a1c2, 0x1a4531c6, 0x1a45c1c9, 0x1a4811ce, 0x1a48497d, 0x1a48a1d2, \
    0x1a49063c, 0x1a4931d7, 0x1a49963f, 0x1a49c1db, 0x1a4a2641, 0x1a4ca1e2, 0x1a4d0644, 0x1a4d31e5, \
    0x1a4d9647, 0x1a4e264a, 0x1a51064c, 0x1a51964f, 0x1a522652, 0x1a559657, 0x1a6411f3, 0x1a64a1f6, \
    0x1a6531f8, 0x1a6811fc, 0x1a68a200, 0x1a693203, 0x1a6c120a, 0x1a6ca20e, 0x1a6d0671, 0x1a6d3212, \
    0x1a6d9673, 0x1a70a21b, 0x1a710675, 0x1a719678, 0x1a75067a, 0x1a75967c, 0x1a881226, 0x1a88a228, \
    0x1a8c122c, 0x1a8ca22f, 0x1a901236, 0x1a90a239, 0x1a91068d, 0x1a95068f, 0x1a990691, 0x1aac1246, \
    0x1ab01248, 0x1b0039ca, 0x1b009251, 0x1b00c9cc, 0x1b012253, 0x1b0159ce, 0x1b01b256, 0x1b01e9cf, \
    0x1b024258, 0x1b04925a, 0x1b04c9d0, 0x1b05225d, 0x1b0559d1, 0x1b05b25f, 0x1b064261, 0x1b06d262, \
    0x1b092263, 0x1b09b265, 0x1b0a4266, 0x1b0d86aa, 0x1b0db267, 0x1b0e16ac, 0x1b0ea6ae, 0x1b0f36af, \
    0x1b1216b0, 0x1b12a6b1, 0x1b200268, 0x1b2039d7, 0x1b20926b, 0x1b20c9da, 0x1b21226d, 0x1b2159dc, \
    0x1b21b26f, 0x1b224271, 0x1b240272, 0x1b2439df, 0x1b249276, 0x1b24c9e2, 0x1b25227a, 0x1b2559e4, \
    0x1b25b27d, 0x1b264280, 0x1b26d281, 0x1b289282, 0x1b28c9e6, 0x1b292285, 0x1b29b288, 0x1b2a428a, \
    0x1b2d228b, 0x1b2d86c8, 0x1b2db28d, 0x1b2e16ca, 0x1b2ea6cc, 0x1b3186cd, 0x1b3216d0, 0x1b32a6d2, \
    0x1b3616d4, 0x1b40028f, 0x1b4039ea, 0x1b409292, 0x1b40c9ed, 0x1b412294, 0x1b41b296, 0x1b424297, \
    0x1b440298, 0x1b4439f5, 0x1b44929b, 0x1b44c9f8, 0x1b45229e, 0x1b45b2a1, 0x1b4642a3, 0x1b4802a5, \
    0x1b4839fe, 0x1b4892a8, 0x1b48ca00, 0x1b4922ac, 0x1b49b2b0, 0x1b4a42b3, 0x1b4c92b5, 0x1b4d22b8, \
    0x1b4d86eb, 0x1b4db2bb, 0x1b4e16ed, 0x1b5122be, 0x1b5186ef, 0x1b5216f2, 0x1b5586f4, 0x1b5616f6, \
    0x1b6002c1, 0x1b603a06, 0x1b6092c3, 0x1b6122c5, 0x1b61b2c6, 0x1b6402c7, 0x1b643a14, 0x1b6492ca, \
    0x1b6522cd, 0x1b65b2cf, 0x1b6802d1, 0x1b683a21, 0x1b6892d4, 0x1b6922d8, 0x1b69b2db, 0x1b6c02df, \
    0x1b6c3a2a, 0x1b6c92e2, 0x1b6d22e6, 0x1b6d870c, 0x1b6db2ea, 0x1b7092ef, 0x1b7122f1, 0x1b71870f, \
    0x1b758712, 0x1b798715, 0x1b8402f7, 0x1b8492f9, 0x1b8522fa, 0x1b8802fb, 0x1b8892fe, 0x1b892300, \
    0x1b8c0302, 0x1b8c9305, 0x1b8d2308, 0x1b90030c, 0x1b90930f, 0x1b912312, 0x1ba8931b, 0x1c202a72, \
    0x1c205732, 0x1c20ba74, 0x1c214a76, 0x1c21da77, 0x1c24833a, 0x1c24ba79, 0x1c25133d, 0x1c254a7b, \
    0x1c25a33f, 0x1c263341, 0x1c26c343, 0x1c291346, 0x1c29a348, 0x1c2a334a, 0x1c2da34c, 0x1c320741, \
    0x1c329743, 0x1c402a7d, 0x1c40ba80, 0x1c414a82, 0x1c442a85, 0x1c448352, 0x1c44ba88, 0x1c451355, \
    0x1c454a8a, 0x1c45a357, 0x1c463359, 0x1c48835b, 0x1c48ba8d, 0x1c49135f, 0x1c49a362, 0x1c4a3365, \
    0x1c4d1367, 0x1c4da36a, 0x1c520751, 0x1c560753, 0x1c602a91, 0x1c60ba94, 0x1c642a9c, 0x1c648370, \
    0x1c64ba9f, 0x1c651372, 0x1c65a374, 0x1c682aa5, 0x1c688377, 0x1c68baa7, 0x1c69137a, 0x1c69a37d, \
    0x1c6c8381, 0x1c6d1384, 0x1c6da388, 0x1c71138c, 0x1c802aad, 0x1c842ab6, 0x1c848392, 0x1c851394, \
    0x1c882ac3, 0x1c888396, 0x1c891399, 0x1c8c2acc, 0x1c8c839c, 0x1c8d139f, 0x1d401b02, 0x1d40477b, \
    0x1d40ab04, 0x1d413b06, 0x1d41cb07, 0x1d44ab09, 0x1d453b0b, 0x1d601b0d, 0x1d60ab10, 0x1d613b12, \
    0x1d641b15, 0x1d64ab18, 0x1d653b1a, 0x1d68ab1d, 0x1d801b20, 0x1d80ab22, 0x1d841b26, 0x1d84ab29, \
    0x1d881b2f, 0x1d88ab31, 0x1da01b36, 0x1da41b3a, 0x1da81b41, 0x1dac1b4a, 0x1e600b68, 0x1e603796, \
    0x1e609b6a, 0x1e612b6c, 0x1e61bb6d, 0x1e649b6f, 0x1e652b71, 0x1e800b72, 0x1e809b74, 0x1e812b75, \
    0x1e840b76, 0x1e849b79, 0x1e852b7b, 0x1e889b7e, 0x1ea00b80, 0x1ea09b81, 0x1ea40b82, 0x1ea49b84, \
    0x1ea80b86, 0x1ea89b88, 0x1ec40b8c, 0x1ec80b8d, 0x1ecc0b8f, 0x1f848b9d, 0x1f851b9f, 0x20001400, \
    0x20004002, 0x2000a403, 0x2000d005, 0x20013406, 0x2001c409, 0x2002540b, 0x2004a40e, 0x20053412, \
    0x2005c415, 0x20090816, 0x2009341d, 0x20099819, 0x200a281c, 0x200ab81e, 0x200d9820, 0x200e2822, \
    0x20168022, 0x20241443, 0x20244025, 0x2024a446, 0x20253449, 0x2025c44b, 0x2028a450, 0x20293453, \
    0x202d0844, 0x202d9847, 0x202e2849, 0x2031984b, 0x2048147a, 0x2048a47d, 0x2049347f, 0x204ca484, \
    0x20510865, 0x20519867, 0x206c14a3, 0x206ca4a5, 0x20750877, 0x209014bd, 0x210004d2, 0x21003090, \
    0x210094d5, 0x2100c094, 0x210124d8, 0x21015097, 0x2101b4da, 0x210244dc, 0x2102d4dd, 0x210494df, \
    0x2104c09d, 0x210524e2, 0x2105b4e5, 0x210644e7, 0x210924ec, 0x2109b4ef, 0x210d889b, 0x210e189d, \
    0x210ea89e, 0x211218a0, 0x21200509, 0x212030b2, 0x2120950c, 0x2120c0b5, 0x2121250f, 0x2121b512, \
    0x21224513, 0x21240514, 0x212430c0, 0x21249518, 0x2124c0c4, 0x2125251b, 0x2125b51e, 0x21264520, \
    0x21289523, 0x21292527, 0x2129b52a, 0x212d2532, 0x212d88d0, 0x212e18d3, 0x213188d4, 0x213218d6, \
    0x21440553, 0x214430ea, 0x21449556, 0x21452559, 0x2145b55b, 0x2148055c, 0x214830f7, 0x2148955f, \
    0x21492562, 0x2149b564, 0x214c9567, 0x214d256a, 0x215188fb, 0x215588fc, 0x21680588, 0x2168958b, \
    0x2169258d, 0x216c058e, 0x216c9591, 0x216d2593, 0x21709596, 0x218c05ac, 0x218c95ae, 0x219005af, \
    0x219095b1, 0x21b005bf, 0x21b405c0, 0x22002165, 0x22005927, 0x2200b168, 0x2201416b, 0x220485cf, \
    0x2204b172, 0x220515d2, 0x22054175, 0x2205a5d4, 0x220635d6, 0x2206c5d7, 0x220915d9, 0x2209a5dc, \
    0x220a35de, 0x220da5e3, 0x22120939, 0x2212993a, 0x22202182, 0x2220b186, 0x22214189, 0x2224218f, \
    0x222485fa, 0x2224b193, 0x222515fd, 0x22254197, 0x2225a5ff, 0x22263601, 0x22288602, 0x2228b1a0, \
    0x22291605, 0x2229a608, 0x222a360a, 0x222d160d, 0x222da610, 0x2232095c, 0x2236095d, 0x224021b4, \
    0x2240b1b7, 0x224421bf, 0x22448630, 0x2244b1c3, 0x22451634, 0x2245a637, 0x224821cf, 0x2248863a, \
    0x2248b1d3, 0x2249163d, 0x2249a640, 0x224c8642, 0x224d1645, 0x224da648, 0x2251164d, 0x226421f4, \
    0x226821fd, 0x2268866a, 0x2269166d, 0x226c220b, 0x226c866f, 0x226d1672, 0x22708674, 0x22711676, \
    0x228c868a, 0x2290868c, 0x2294868e, 0x23001250, 0x230049cb, 0x2300a252, 0x2300d9cd, 0x23013254, \
    0x2301c257, 0x23025259, 0x2304a25b, 0x2305325e, 0x2305c260, 0x230906a4, 0x23093264, 0x230996a6, \
    0x230a26a8, 0x230ab6a9, 0x230d96ab, 0x230e26ad, 0x231689d5, 0x23201269, 0x232049d8, 0x2320a26c, \
    0x2321326e, 0x2321c270, 0x23241273, 0x232449e0, 0x2324a277, 0x2325327b, 0x2325c27e, 0x2328a283, \
    0x232906c1, 0x23293286, 0x232996c3, 0x232a26c5, 0x232d06c6, 0x232d96c9, 0x232e26cb, 0x233196ce, \
    0x23401290, 0x2340a293, 0x23413295, 0x23441299, 0x2344a29c, 0x2345329f, 0x234812a6, 0x2348a2a9, \
    0x234906e5, 0x234932ad, 0x234996e7, 0x234ca2b6, 0x234d06e9, 0x234d96ec, 0x235106ee, 0x235196f0, \
    0x236012c2, 0x2360a2c4, 0x236412c8, 0x2364a2cb, 0x236812d2, 0x2368a2d5, 0x23690708, 0x236c12e0, \
    0x236ca2e3, 0x236d070b, 0x2371070e, 0x23750711, 0x238412f8, 0x238812fc, 0x238c1303, 0x2390130d, \
    0x24000325, 0x24003a6d, 0x24009326, 0x2400ca6f, 0x24012328, 0x24015a70, 0x2401b329, 0x2402432a, \
    0x2404932b, 0x2404ca71, 0x2405232c, 0x2405b32d, 0x2406432e, 0x2409232f, 0x2409b330, 0x240d872c, \
    0x240e172e, 0x240ea72f, 0x24121730, 0x24200331, 0x24203a73, 0x24209332, 0x2420ca75, 0x24212334, \
    0x2421b336, 0x24224337, 0x24240338, 0x24243a78, 0x2424933b, 0x2424ca7a, 0x2425233e, 0x2425b340, \
    0x24264342, 0x24289344, 0x24292347, 0x2429b349, 0x242d234b, 0x242d873d, 0x242e173f, 0x24318740, \
    0x24321742, 0x2440034d, 0x24403a7e, 0x2440934e, 0x2441234f, 0x2441b350, 0x24440351, 0x24443a86, \
    0x24449353, 0x24452356, 0x2445b358, 0x2448035a, 0x24483a8c, 0x2448935c, 0x24492360, 0x2449b363, \
    0x244c9366, 0x244d2368, 0x244d874e, 0x24518750, 0x24558752, 0x2460036c, 0x2460936d, 0x2461236e, \
    0x2464036f, 0x24649371, 0x24652373, 0x24680375, 0x24689378, 0x2469237b, 0x246c037f, 0x246c9382, \
    0x246d2385, 0x2470938b, 0x2480038f, 0x24809390, 0x24840391, 0x24849393, 0x24880395, 0x24889397, \
    0x248c039b, 0x248c939d, 0x25202afc, 0x2520bafe, 0x25214aff, 0x2524bb01, 0x2532077a, 0x25402b03, \
    0x2540bb05, 0x25442b08, 0x2544bb0a, 0x25602b0e, 0x25642b16, 0x25682b1c, 0x26401b62, 0x2640ab64, \
    0x26413b65, 0x2644ab67, 0x26601b69, 0x2660ab6b, 0x26641b6e, 0x2664ab70, 0x26801b73, 0x26841b77, \
    0x26881b7d, 0x27600b94, 0x27609b96, 0x27612b97, 0x27649b99, 0x27800b9a, 0x27809b9b, 0x27840b9c, \
    0x27849b9e, 0x27a00ba0, 0x28002401, 0x2800b404, 0x28014407, 0x2804880b, 0x2804b40f, 0x2805180e, \
    0x2805a811, 0x28063814, 0x28091817, 0x2809a81a, 0x28242444, 0x2824b447, 0x2828883b, 0x2829183e, \
    0x2829a841, 0x282d1845, 0x2848247b, 0x284c885f, 0x284d1862, 0x28708874, 0x290014d3, 0x29004091, \
    0x2900a4d6, 0x290134d9, 0x2901c4db, 0x2904a4e0, 0x290534e3, 0x29090895, 0x29099898, 0x290a289a, \
    0x290d989c, 0x2920150a, 0x2920a50d, 0x29213510, 0x29241515, 0x2924a519, 0x2925351c, 0x2928a524, \
    0x292908c6, 0x292998ca, 0x292d08ce, 0x292d98d1, 0x29441554, 0x2944a557, 0x2948155d, 0x2948a560, \
    0x294d08f6, 0x295108fa, 0x29681589, 0x296c158f, 0x2a0005c6, 0x2a003166, 0x2a0095c9, 0x2a0125cb, \
    0x2a01b5cd, 0x2a0245ce, 0x2a0495d0, 0x2a0525d3, 0x2a05b5d5, 0x2a0925da, 0x2a0d8937, 0x2a0e1938, \
    0x2a2005ef, 0x2a203183, 0x2a2095f2, 0x2a2125f5, 0x2a21b5f7, 0x2a2405f8, 0x2a243190, 0x2a2495fb, \
    0x2a2525fe, 0x2a25b600, 0x2a289603, 0x2a292606, 0x2a2d895a, 0x2a31895b, 0x2a400624, 0x2a409627, \
    0x2a41262a, 0x2a44062d, 0x2a449631, 0x2a452635, 0x2a480638, 0x2a48963b, 0x2a49263e, 0x2a4c9643, \
    0x2a640662, 0x2a649665, 0x2a680668, 0x2a68966b, 0x2a6c066e, 0x2a6c9670, 0x2a880686, 0x2a8c0689, \
    0x2a90068b, 0x2b014255, 0x2b04869e, 0x2b04b25c, 0x2b0516a0, 0x2b05a6a2, 0x2b0636a3, 0x2b0916a5, \
    0x2b09a6a7, 0x2b1209d4, 0x2b20226a, 0x2b242274, 0x2b2486ba, 0x2b24b278, 0x2b2516bc, 0x2b25a6be, \
    0x2b2886bf, 0x2b2916c2, 0x2b29a6c4, 0x2b2d16c7, 0x2b402291, 0x2b4486de, 0x2b4516e1, 0x2b4886e3, \
    0x2b4916e6, 0x2b4c86e8, 0x2b4d16ea, 0x2b648702, 0x2b688707, 0x2b6c870a, 0x2b70870d, 0x2c004a6e, \
    0x2c00a327, 0x2c090728, 0x2c09972a, 0x2c0a272b, 0x2c0d972d, 0x2c20a333, 0x2c213335, 0x2c241339, \
    0x2c24a33c, 0x2c28a345, 0x2c290739, 0x2c29973b, 0x2c2d073c, 0x2c2d973e, 0x2c44a354, 0x2c48a35d, \
    0x2c49074b, 0x2c4d074d, 0x2c51074f, 0x2c681376, 0x2c6c1380, 0x2d003afa, 0x2d00cafb, 0x2d0d8772, \
    0x2d0e1773, 0x2d203afd, 0x2d243b00, 0x2d2d8778, 0x2d318779, 0x2e202b60, 0x2e20bb61, 0x2e402b63, \
    0x2e442b66, 0x2f401b92, 0x2f40ab93, 0x2f601b95, 0x2f641b98, 0x310024d4, 0x3100b4d7, 0x3104888c, \
    0x3105188f, 0x3105a892, 0x31091896, 0x31242516, 0x312888c3, 0x312918c7, 0x314c88f4, 0x320015c7, \
    0x3200a5ca, 0x320135cc, 0x3204a5d1, 0x32090934, 0x32099936, 0x322015f0, 0x3220a5f3, 0x322415f9, \
    0x3224a5fc, 0x32290955, 0x322d0959, 0x3244162e, 0x32481639, 0x33000698, 0x3300969a, 0x3301269c, \
    0x3301b69d, 0x3304969f, 0x330526a1, 0x330d89d3, 0x332006b2, 0x332096b5, 0x332126b7, 0x332406b8, \
    0x332496bb, 0x332526bd, 0x332896c0, 0x334006d6, 0x334096d9, 0x334406dc, 0x334496df, 0x334806e2, \
    0x334896e4, 0x33640700, 0x33680706, 0x336c0709, 0x34048724, 0x34051726, 0x3405a727, 0x34091729, \
    0x34248735, 0x34251737, 0x34288738, 0x3429173a, 0x34448748, 0x3448874a, 0x344c874c, 0x35090770, \
    0x35099771, 0x35290776, 0x352d0777, 0x3a0025c8, 0x3a04892e, 0x3a051931, 0x3a288953, 0x3b001699, \
    0x3b00a69b, 0x3b0909d2, 0x3b2016b3, 0x3b2416b9, 0x3c000721, 0x3c009722, 0x3c012723, 0x3c049725, \
    0x3c200731, 0x3c209733, 0x3c240734, 0x3c249736, 0x3c400744, 0x3c440747, 0x3c480749, 0x3d04876e, \
    0x3d05176f, 0x3d248774, 0x3d288775, \
])
