"""
peakrdl-python is a tool to generate Python Register Access Layer (RAL) from SystemRDL
Copyright (C) 2021 - 2023

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

This module is intended to distributed as part of automatically generated code by the
peakrdl-python tool.  It provides a set of types used by the autogenerated code to callbacks
"""
from array import array as Array

from typing import Optional, Union, List
from typing import Protocol


class ReadCallback(Protocol):
    """
    Callback definition for a single register read operation
    """
    # pylint: disable=too-few-public-methods
    def __call__(self, addr: int, width: int, accesswidth: int) -> int:
        pass


class WriteCallback(Protocol):
    """
    Callback definition for a single register write operation
    """
    # pylint: disable=too-few-public-methods
    def __call__(self, addr: int, width: int, accesswidth: int, data: int) -> None:
        pass


class ReadBlockLegacyCallback(Protocol):
    """
    Callback definition for a block read operation
    """
    # pylint: disable=too-few-public-methods
    def __call__(self, addr: int, width: int, accesswidth: int, length: int) -> Array:
        pass

class ReadBlockCallback(Protocol):
    """
    Callback definition for a block read operation
    """
    # pylint: disable=too-few-public-methods
    def __call__(self, addr: int, width: int, accesswidth: int, length: int) -> List[int]:
        pass


class WriteBlockCallback(Protocol):
    """
    Callback definition for a block write operation
    """
    # pylint: disable=too-few-public-methods
    def __call__(self, addr: int, width: int, accesswidth: int, data: List[int]) -> None:
        pass


class WriteBlockLegacyCallback(Protocol):
    """
    Callback definition for a block write operation
    """
    # pylint: disable=too-few-public-methods
    def __call__(self, addr: int, width: int, accesswidth: int, data: Array) -> None:
        pass


class AsyncReadCallback(Protocol):
    """
    Callback definition for a single register async read operation
    """
    # pylint: disable=too-few-public-methods,unexpected-special-method-signature
    async def __call__(self, addr: int, width: int, accesswidth: int) -> int:
        pass


class AsyncWriteCallback(Protocol):
    """
    Callback definition for a single register async write operation
    """
    # pylint: disable=too-few-public-methods,unexpected-special-method-signature
    async def __call__(self, addr: int, width: int, accesswidth: int, data: int) -> None:
        pass


class AsyncReadBlockCallback(Protocol):
    """
    Callback definition for an async block read operation
    """
    # pylint: disable=too-few-public-methods,unexpected-special-method-signature
    async def __call__(self, addr: int, width: int, accesswidth: int, length: int) -> List[int]:
        pass

class AsyncReadBlockLegacyCallback(Protocol):
    """
    Callback definition for an async block read operation
    """
    # pylint: disable=too-few-public-methods,unexpected-special-method-signature
    async def __call__(self, addr: int, width: int, accesswidth: int, length: int) -> Array:
        pass


class AsyncWriteBlockCallback(Protocol):
    """
    Callback definition for an async block write operation
    """
    # pylint: disable=too-few-public-methods,unexpected-special-method-signature
    async def __call__(self, addr: int, width: int, accesswidth: int, data: List[int]) -> None:
        pass

class AsyncWriteBlockLegacyCallback(Protocol):
    """
    Callback definition for an async block write operation
    """
    # pylint: disable=too-few-public-methods,unexpected-special-method-signature
    async def __call__(self, addr: int, width: int, accesswidth: int, data: Array) -> None:
        pass


class _NormalCallbackSetBase:
    """
    Class to hold a set of callbacks, this reduces the number of callback that need to be passed
    around
    """

    __slots__ = ['__write_callback', '__read_callback']

    def __init__(self,
                 write_callback: Optional[WriteCallback] = None,
                 read_callback: Optional[ReadCallback] = None):

        self.__read_callback = read_callback
        self.__write_callback = write_callback

    @property
    def read_callback(self) -> Optional[ReadCallback]:
        """
        single read callback function

        Returns: call back function

        """
        return self.__read_callback

    @property
    def write_callback(self) -> Optional[WriteCallback]:
        """
        single write callback function

        Returns: call back function

        """
        return self.__write_callback


class NormalCallbackSet(_NormalCallbackSetBase):
    """
    Class to hold a set of callbacks, this reduces the number of callback that need to be passed
    around
    """

    __slots__ = ['__write_block_callback', '__read_block_callback']

    def __init__(self,
                 write_callback: Optional[WriteCallback] = None,
                 read_callback: Optional[ReadCallback] = None,
                 write_block_callback: Optional[WriteBlockCallback] = None,
                 read_block_callback: Optional[ReadBlockCallback] = None):

        super().__init__(read_callback=read_callback, write_callback=write_callback)

        self.__read_block_callback = read_block_callback
        self.__write_block_callback = write_block_callback

    @property
    def read_block_callback(self) -> Optional[ReadBlockCallback]:
        """
        block read callback function

        Returns: call back function

        """
        return self.__read_block_callback

    @property
    def write_block_callback(self) -> Optional[WriteBlockCallback]:
        """
        block read callback function

        Returns: call back function

        """
        return self.__write_block_callback


class NormalCallbackSetLegacy(_NormalCallbackSetBase):
    """
    Class to hold a set of callbacks, this reduces the number of callback that need to be passed
    around
    """

    __slots__ = ['__write_block_callback', '__read_block_callback']

    def __init__(self,
                 write_callback: Optional[WriteCallback] = None,
                 read_callback: Optional[ReadCallback] = None,
                 write_block_callback: Optional[WriteBlockLegacyCallback] = None,
                 read_block_callback: Optional[ReadBlockLegacyCallback] = None):

        super().__init__(read_callback=read_callback, write_callback=write_callback)

        self.__read_block_callback = read_block_callback
        self.__write_block_callback = write_block_callback

    @property
    def read_block_callback(self) -> Optional[ReadBlockLegacyCallback]:
        """
        block read callback function

        Returns: call back function

        """
        return self.__read_block_callback

    @property
    def write_block_callback(self) -> Optional[WriteBlockLegacyCallback]:
        """
        block read callback function

        Returns: call back function

        """
        return self.__write_block_callback

class _AsyncCallbackSetBase:
    """
    Class to hold a set of callbacks, this reduces the number of callback that need to be passed
    around
    """

    __slots__ = ['__write_callback', '__read_callback']

    def __init__(self,
                 write_callback: Optional[AsyncWriteCallback] = None,
                 read_callback: Optional[AsyncReadCallback] = None):

        self.__read_callback = read_callback
        self.__write_callback = write_callback

    @property
    def read_callback(self) -> Optional[AsyncReadCallback]:
        """
        single read callback function

        Returns: call back function

        """
        return self.__read_callback

    @property
    def write_callback(self) -> Optional[AsyncWriteCallback]:
        """
        single write callback function

        Returns: call back function

        """
        return self.__write_callback


class AsyncCallbackSet(_AsyncCallbackSetBase):
    """
    Class to hold a set of callbacks, this reduces the number of callback that need to be passed
    around
    """

    __slots__ = ['__write_block_callback', '__read_block_callback']

    def __init__(self,
                 write_callback: Optional[AsyncWriteCallback] = None,
                 read_callback: Optional[AsyncReadCallback] = None,
                 write_block_callback: Optional[AsyncWriteBlockCallback] = None,
                 read_block_callback: Optional[AsyncReadBlockCallback] = None):

        super().__init__(read_callback=read_callback, write_callback=write_callback)

        self.__read_block_callback = read_block_callback
        self.__write_block_callback = write_block_callback

    @property
    def read_block_callback(self) -> Optional[AsyncReadBlockCallback]:
        """
        block read callback function

        Returns: call back function

        """
        return self.__read_block_callback

    @property
    def write_block_callback(self) -> Optional[AsyncWriteBlockCallback]:
        """
        block read callback function

        Returns: call back function

        """
        return self.__write_block_callback


class AsyncCallbackSetLegacy(_AsyncCallbackSetBase):
    """
    Class to hold a set of callbacks, this reduces the number of callback that need to be passed
    around
    """

    __slots__ = ['__write_block_callback', '__read_block_callback']

    def __init__(self,
                 write_callback: Optional[AsyncWriteCallback] = None,
                 read_callback: Optional[AsyncReadCallback] = None,
                 write_block_callback: Optional[AsyncWriteBlockLegacyCallback] = None,
                 read_block_callback: Optional[AsyncReadBlockLegacyCallback] = None):
        super().__init__(read_callback=read_callback, write_callback=write_callback)

        self.__read_block_callback = read_block_callback
        self.__write_block_callback = write_block_callback

    @property
    def read_block_callback(self) -> Optional[AsyncReadBlockLegacyCallback]:
        """
        block read callback function

        Returns: call back function

        """
        return self.__read_block_callback

    @property
    def write_block_callback(self) -> Optional[AsyncWriteBlockLegacyCallback]:
        """
        block read callback function

        Returns: call back function

        """
        return self.__write_block_callback


CallbackSet = Union[AsyncCallbackSet, NormalCallbackSet]
CallbackSetLegacy = Union[AsyncCallbackSetLegacy, NormalCallbackSetLegacy]
