"""
peakrdl-python is a tool to generate Python Register Access Layer (RAL) from SystemRDL
Copyright (C) 2021 - 2023

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

This package is intended to distributed as part of automatically generated code by the PeakRDL
Python tool. It provides a set of classes used by the autogenerated code
"""

from .callbacks import ReadCallback
from .callbacks import ReadBlockCallback
from .callbacks import WriteCallback
from .callbacks import WriteBlockCallback
from .callbacks import NormalCallbackSet, NormalCallbackSetLegacy
from .callbacks import AsyncCallbackSet, AsyncCallbackSetLegacy
from .callbacks import CallbackSet

from .base import AddressMap
from .base import RegFile
from .base import AddressMapArray
from .base import RegFileArray

from .base import AsyncAddressMap
from .base import AsyncRegFile
from .base import AsyncAddressMapArray
from .base import AsyncRegFileArray

from .register_and_field import Reg
from .register_and_field import RegArray
from .register_and_field import RegisterWriteVerifyError

from .register_and_field import RegReadOnly
from .register_and_field import RegWriteOnly
from .register_and_field import RegReadWrite
from .register_and_field import WritableRegister
from .register_and_field import ReadableRegister

from .register_and_field import RegReadOnlyArray
from .register_and_field import RegWriteOnlyArray
from .register_and_field import RegReadWriteArray
from .register_and_field import ReadableRegisterArray
from .register_and_field import WriteableRegisterArray

from .async_register_and_field import AsyncReg
from .async_register_and_field import AsyncRegArray
from .async_register_and_field import RegAsyncReadOnly
from .async_register_and_field import RegAsyncWriteOnly
from .async_register_and_field import RegAsyncReadWrite
from .async_register_and_field import ReadableAsyncRegister
from .async_register_and_field import WritableAsyncRegister
from .async_register_and_field import RegAsyncReadOnlyArray
from .async_register_and_field import RegAsyncWriteOnlyArray
from .async_register_and_field import RegAsyncReadWriteArray
from .async_register_and_field import ReadableAsyncRegisterArray
from .async_register_and_field import WriteableAsyncRegisterArray

from .base_field import FieldSizeProps
from .base_field import FieldMiscProps
from .register_and_field import FieldReadOnly
from .register_and_field import FieldWriteOnly
from .register_and_field import FieldReadWrite
from .base_field import Field
from .register_and_field import FieldEnumReadOnly
from .register_and_field import FieldEnumWriteOnly
from .register_and_field import FieldEnumReadWrite
from .base_field import FieldEnum
from .field_encoding import SystemRDLEnum, SystemRDLEnumEntry
from .field_encoding import RegisterFieldJSONEncoder

from .async_register_and_field import FieldAsyncReadOnly
from .async_register_and_field import FieldAsyncWriteOnly
from .async_register_and_field import FieldAsyncReadWrite
from .async_register_and_field import FieldEnumAsyncReadOnly
from .async_register_and_field import FieldEnumAsyncWriteOnly
from .async_register_and_field import FieldEnumAsyncReadWrite

from .memory import MemoryReadOnly, MemoryReadOnlyLegacy
from .memory import MemoryWriteOnly, MemoryWriteOnlyLegacy
from .memory import MemoryReadWrite, MemoryReadWriteLegacy
from .memory import MemoryReadOnlyArray
from .memory import MemoryWriteOnlyArray
from .memory import MemoryReadWriteArray
from .async_memory import MemoryAsyncReadOnly, MemoryAsyncReadOnlyLegacy
from .async_memory import MemoryAsyncWriteOnly, MemoryAsyncWriteOnlyLegacy
from .async_memory import MemoryAsyncReadWrite, MemoryAsyncReadWriteLegacy
from .async_memory import MemoryAsyncReadOnlyArray
from .async_memory import MemoryAsyncWriteOnlyArray
from .async_memory import MemoryAsyncReadWriteArray
from .memory import ReadableMemory, ReadableMemoryLegacy
from .memory import WritableMemory, WritableMemoryLegacy
from .memory import Memory
from .async_memory import ReadableAsyncMemory, ReadableAsyncMemoryLegacy
from .async_memory import WritableAsyncMemory, WritableAsyncMemoryLegacy
from .async_memory import AsyncMemory
from .memory import MemoryArray
from .async_memory import AsyncMemoryArray

from .utility_functions import get_array_typecode
from .utility_functions import UnsupportedWidthError
from .base import Node
from .base import Base
from .base import UDPStruct
