"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSecretValue = void 0;
const util_arn_parser_1 = require("@aws-sdk/util-arn-parser");
const aws_sdk_1 = require("aws-sdk");
/**
 * Retrieves the Secret Value from SecretsManager by Arn. If field is given, extract json field value from secret string.
 */
const getSecretValue = async (secretId, field) => {
    const secretArn = (0, util_arn_parser_1.parse)(secretId);
    const secretsManager = new aws_sdk_1.SecretsManager({ region: secretArn.region });
    const getSecretValueResponse = await secretsManager.getSecretValue({ SecretId: secretId }).promise();
    const secretString = getSecretValueResponse.SecretString;
    if (!field) {
        return secretString;
    }
    return JSON.parse(secretString)[field];
};
exports.getSecretValue = getSecretValue;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0LXNlY3JldC12YWx1ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9jdXN0b20tcmVzb3VyY2UtcHJvdmlkZXIvZ2V0LXNlY3JldC12YWx1ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4REFBNkQ7QUFDN0QscUNBQXlDO0FBRXpDOztHQUVHO0FBQ0ksTUFBTSxjQUFjLEdBQUcsS0FBSyxFQUFFLFFBQWdCLEVBQUUsS0FBYyxFQUFtQixFQUFFO0lBQ3hGLE1BQU0sU0FBUyxHQUFHLElBQUEsdUJBQVEsRUFBQyxRQUFTLENBQUMsQ0FBQztJQUN0QyxNQUFNLGNBQWMsR0FBRyxJQUFJLHdCQUFjLENBQUMsRUFBRSxNQUFNLEVBQUUsU0FBUyxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7SUFDeEUsTUFBTSxzQkFBc0IsR0FBRyxNQUFNLGNBQWMsQ0FBQyxjQUFjLENBQUMsRUFBRSxRQUFRLEVBQUUsUUFBUyxFQUFFLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUN0RyxNQUFNLFlBQVksR0FBRyxzQkFBc0IsQ0FBQyxZQUFhLENBQUM7SUFFMUQsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ1gsT0FBTyxZQUFZLENBQUM7SUFDdEIsQ0FBQztJQUVELE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUN6QyxDQUFDLENBQUM7QUFYVyxRQUFBLGNBQWMsa0JBV3pCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgcGFyc2UgYXMgcGFyc2VBcm4gfSBmcm9tIFwiQGF3cy1zZGsvdXRpbC1hcm4tcGFyc2VyXCI7XG5pbXBvcnQgeyBTZWNyZXRzTWFuYWdlciB9IGZyb20gXCJhd3Mtc2RrXCI7XG5cbi8qKlxuICogUmV0cmlldmVzIHRoZSBTZWNyZXQgVmFsdWUgZnJvbSBTZWNyZXRzTWFuYWdlciBieSBBcm4uIElmIGZpZWxkIGlzIGdpdmVuLCBleHRyYWN0IGpzb24gZmllbGQgdmFsdWUgZnJvbSBzZWNyZXQgc3RyaW5nLlxuICovXG5leHBvcnQgY29uc3QgZ2V0U2VjcmV0VmFsdWUgPSBhc3luYyAoc2VjcmV0SWQ6IHN0cmluZywgZmllbGQ/OiBzdHJpbmcpOiBQcm9taXNlPHN0cmluZz4gPT4ge1xuICBjb25zdCBzZWNyZXRBcm4gPSBwYXJzZUFybihzZWNyZXRJZCEpO1xuICBjb25zdCBzZWNyZXRzTWFuYWdlciA9IG5ldyBTZWNyZXRzTWFuYWdlcih7IHJlZ2lvbjogc2VjcmV0QXJuLnJlZ2lvbiB9KTtcbiAgY29uc3QgZ2V0U2VjcmV0VmFsdWVSZXNwb25zZSA9IGF3YWl0IHNlY3JldHNNYW5hZ2VyLmdldFNlY3JldFZhbHVlKHsgU2VjcmV0SWQ6IHNlY3JldElkISB9KS5wcm9taXNlKCk7XG4gIGNvbnN0IHNlY3JldFN0cmluZyA9IGdldFNlY3JldFZhbHVlUmVzcG9uc2UuU2VjcmV0U3RyaW5nITtcblxuICBpZiAoIWZpZWxkKSB7XG4gICAgcmV0dXJuIHNlY3JldFN0cmluZztcbiAgfVxuXG4gIHJldHVybiBKU09OLnBhcnNlKHNlY3JldFN0cmluZylbZmllbGRdO1xufTtcbiJdfQ==