"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubCustomResourceProvider = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const handler_function_1 = require("./handler-function");
/**
 * @internal
 */
class GithubCustomResourceProvider extends constructs_1.Construct {
    /**
     * Retrieve GithubCustomResourceProvider as stack singleton resource.
     */
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = "cdk-github.GithubCustomResourceProvider";
        const existing = stack.node.tryFindChild(id);
        return existing || new GithubCustomResourceProvider(stack, id);
    }
    constructor(scope, id) {
        super(scope, id);
        const onEventHandler = new handler_function_1.HandlerFunction(this, "OnEventHandler", {
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        this.grantPrincipal = onEventHandler.grantPrincipal;
        const provider = new custom_resources.Provider(this, "Provider", {
            onEventHandler: onEventHandler,
        });
        this.serviceToken = provider.serviceToken;
    }
}
exports.GithubCustomResourceProvider = GithubCustomResourceProvider;
//# sourceMappingURL=data:application/json;base64,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