"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const secrets_manager = require("aws-cdk-lib/aws-secretsmanager");
const custom_resources = require("aws-cdk-lib/custom-resources");
const auth_1 = require("./auth");
const github_custom_resource_1 = require("./github-custom-resource");
// https://github.com/octokit/authentication-strategies.js/#the-authoptionsfactory-pattern
// export REPO=
// yarn bundle:custom-resource-provider/handler.lambda
// npx cdk deploy --app 'npx ts-node -P tsconfig.json --prefer-ts-exts ./src/integ.default.ts' --require-approval never --no-rollback
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, "GithubCustomResource");
const repo = process.env.REPO ?? "cdk-github";
const secret = secrets_manager.Secret.fromSecretNameV2(stack, "Auth", "cdk-github/test");
new github_custom_resource_1.GithubCustomResource(stack, "GithubRepo", {
    onCreate: {
        // https://octokit.github.io/rest.js/v19/#repos-create-in-org
        endpoint: "repos",
        method: "createInOrg",
        parameters: {
            org: "pepperize",
            name: repo,
        },
        outputPaths: ["id", "full_name"],
        physicalResourceId: custom_resources.PhysicalResourceId.fromResponse("full_name"),
        ignoreErrorCodesMatching: "name already exists on this account",
    },
    onUpdate: {
        // https://octokit.github.io/rest.js/v19#repos-get
        endpoint: "repos",
        method: "get",
        parameters: {
            owner: "pepperize",
            repo,
        },
        outputPaths: ["id", "full_name"],
        physicalResourceId: custom_resources.PhysicalResourceId.fromResponse("full_name"),
    },
    onDelete: {
        // https://octokit.github.io/rest.js/v19#repos-delete
        endpoint: "repos",
        method: "get", // method: "delete",
        parameters: {
            owner: "pepperize",
            repo,
        },
        outputPaths: [],
    },
    authOptions: auth_1.AuthOptions.appAuth(secret),
});
//# sourceMappingURL=data:application/json;base64,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