"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubCustomResourceProvider = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const handler_function_1 = require("./handler-function");
/**
 * @internal
 */
class GithubCustomResourceProvider extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        const onEventHandler = new handler_function_1.HandlerFunction(this, "OnEventHandler", {
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        this.grantPrincipal = onEventHandler.grantPrincipal;
        const provider = new custom_resources.Provider(this, "Provider", {
            onEventHandler: onEventHandler,
        });
        this.serviceToken = provider.serviceToken;
    }
    /**
     * Retrieve GithubCustomResourceProvider as stack singleton resource.
     */
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = "cdk-github.GithubCustomResourceProvider";
        const existing = stack.node.tryFindChild(id);
        return existing || new GithubCustomResourceProvider(stack, id);
    }
}
exports.GithubCustomResourceProvider = GithubCustomResourceProvider;
//# sourceMappingURL=data:application/json;base64,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