import { CustomResource, RemovalPolicy } from "aws-cdk-lib";
import { Construct } from "constructs";
import { GithubActionsSecret } from "./github-actions-secret";
import { GithubCustomResourceBase, GithubCustomResourceOptions } from "./github-custom-resource";
export declare enum Visibility {
    ALL = "all",
    PRIVATE = "private",
    SELECTED = "selected"
}
export interface GithubActionsSecretOrganizationProps extends GithubCustomResourceOptions {
    /**
     * The GitHub organization name. The name is not case-sensitive.
     */
    readonly organizationName: string;
    /**
     * The GitHub secret name.
     */
    readonly secretName: string;
    /**
     * The SSM Secret.
     */
    readonly source: GithubActionsSecret;
    /**
     * Which type of organization repositories have access to the organization secret.
     */
    readonly visibility?: Visibility;
    /**
     * Whether to DESTROY or RETAIN the secret on resource removal.
     * @default RETAIN
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * Manage an GitHib Actions organization secret.
 *
 * ```typescript
 * // The GitHub API authentication secret
 * const auth = secrets_manager.Secret.fromSecretNameV2(scope, "Auth", "cdk-github/github-token");
 *
 * // The AWS SecretsManager Secret to configure as GitHub Action secret.
 * const secret = secrets_manager.Secret.fromSecretNameV2(scope, "Secret", "any-secret/example");
 *
 * new GithubActionsSecretOrganization(scope, "GithubRepo", {
 *   organizationName: "pepperize",
 *   secretName: "example",
 *   source: GithubActionsSecret.fromSecretsManager(secret, "some-json-field"),
 *   visibility: Visibility.ALL,
 *   authOptions: AuthOptions.appAuth(auth),
 *   removalPolicy: RemovalPolicy.DESTROY,
 * });
 * ```
 */
export declare class GithubActionsSecretOrganization extends GithubCustomResourceBase {
    /**
     * @internal
     */
    readonly _resource: CustomResource;
    constructor(scope: Construct, id: string, props: GithubActionsSecretOrganizationProps);
}
