"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encrypt = void 0;
const sodium = require("libsodium-wrappers");
/**
 * https://docs.github.com/en/rest/actions/secrets#create-or-update-an-organization-secret
 * https://docs.github.com/en/rest/actions/secrets#create-or-update-a-repository-secret
 * https://docs.github.com/en/rest/actions/secrets#create-or-update-an-environment-secret
 *
 * @param secret 'plain-text-secret' - replace with the secret you want to encrypt
 * @param key 'base64-encoded-public-key' - replace with the Base64 encoded public key
 */
exports.encrypt = async (secret, key) => {
    // Check if libsodium is ready and then proceed.
    await sodium.ready;
    // Convert Secret & Base64 key to Uint8Array.
    const binkey = sodium.from_base64(key, sodium.base64_variants.ORIGINAL);
    const binsec = sodium.from_string(secret);
    // Encrypt the secret using LibSodium
    const encBytes = sodium.crypto_box_seal(binsec, binkey);
    // Convert encrypted Uint8Array to Base64
    return sodium.to_base64(encBytes, sodium.base64_variants.ORIGINAL);
};
//# sourceMappingURL=data:application/json;base64,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