"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSecretValue = void 0;
const util_arn_parser_1 = require("@aws-sdk/util-arn-parser");
const aws_sdk_1 = require("aws-sdk");
/**
 * Retrieves the Secret Value from SecretsManager by Arn. If field is given, extract json field value from secret string.
 */
exports.getSecretValue = async (secretId, field) => {
    const secretArn = util_arn_parser_1.parse(secretId);
    const secretsManager = new aws_sdk_1.SecretsManager({ region: secretArn.region });
    const getSecretValueResponse = await secretsManager.getSecretValue({ SecretId: secretId }).promise();
    const secretString = getSecretValueResponse.SecretString;
    if (!field) {
        return secretString;
    }
    return JSON.parse(secretString)[field];
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0LXNlY3JldC12YWx1ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9jdXN0b20tcmVzb3VyY2UtcHJvdmlkZXIvZ2V0LXNlY3JldC12YWx1ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4REFBNkQ7QUFDN0QscUNBQXlDO0FBRXpDOztHQUVHO0FBQ1UsUUFBQSxjQUFjLEdBQUcsS0FBSyxFQUFFLFFBQWdCLEVBQUUsS0FBYyxFQUFtQixFQUFFO0lBQ3hGLE1BQU0sU0FBUyxHQUFHLHVCQUFRLENBQUMsUUFBUyxDQUFDLENBQUM7SUFDdEMsTUFBTSxjQUFjLEdBQUcsSUFBSSx3QkFBYyxDQUFDLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO0lBQ3hFLE1BQU0sc0JBQXNCLEdBQUcsTUFBTSxjQUFjLENBQUMsY0FBYyxDQUFDLEVBQUUsUUFBUSxFQUFFLFFBQVMsRUFBRSxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7SUFDdEcsTUFBTSxZQUFZLEdBQUcsc0JBQXNCLENBQUMsWUFBYSxDQUFDO0lBRTFELElBQUksQ0FBQyxLQUFLLEVBQUU7UUFDVixPQUFPLFlBQVksQ0FBQztLQUNyQjtJQUVELE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUN6QyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBwYXJzZSBhcyBwYXJzZUFybiB9IGZyb20gXCJAYXdzLXNkay91dGlsLWFybi1wYXJzZXJcIjtcbmltcG9ydCB7IFNlY3JldHNNYW5hZ2VyIH0gZnJvbSBcImF3cy1zZGtcIjtcblxuLyoqXG4gKiBSZXRyaWV2ZXMgdGhlIFNlY3JldCBWYWx1ZSBmcm9tIFNlY3JldHNNYW5hZ2VyIGJ5IEFybi4gSWYgZmllbGQgaXMgZ2l2ZW4sIGV4dHJhY3QganNvbiBmaWVsZCB2YWx1ZSBmcm9tIHNlY3JldCBzdHJpbmcuXG4gKi9cbmV4cG9ydCBjb25zdCBnZXRTZWNyZXRWYWx1ZSA9IGFzeW5jIChzZWNyZXRJZDogc3RyaW5nLCBmaWVsZD86IHN0cmluZyk6IFByb21pc2U8c3RyaW5nPiA9PiB7XG4gIGNvbnN0IHNlY3JldEFybiA9IHBhcnNlQXJuKHNlY3JldElkISk7XG4gIGNvbnN0IHNlY3JldHNNYW5hZ2VyID0gbmV3IFNlY3JldHNNYW5hZ2VyKHsgcmVnaW9uOiBzZWNyZXRBcm4ucmVnaW9uIH0pO1xuICBjb25zdCBnZXRTZWNyZXRWYWx1ZVJlc3BvbnNlID0gYXdhaXQgc2VjcmV0c01hbmFnZXIuZ2V0U2VjcmV0VmFsdWUoeyBTZWNyZXRJZDogc2VjcmV0SWQhIH0pLnByb21pc2UoKTtcbiAgY29uc3Qgc2VjcmV0U3RyaW5nID0gZ2V0U2VjcmV0VmFsdWVSZXNwb25zZS5TZWNyZXRTdHJpbmchO1xuXG4gIGlmICghZmllbGQpIHtcbiAgICByZXR1cm4gc2VjcmV0U3RyaW5nO1xuICB9XG5cbiAgcmV0dXJuIEpTT04ucGFyc2Uoc2VjcmV0U3RyaW5nKVtmaWVsZF07XG59O1xuIl19