"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthOptions = exports.AuthenticationStrategy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * @internal
 */
var AuthenticationStrategy;
(function (AuthenticationStrategy) {
    /**
     * GitHub App or installation authentication
     *
     * @see https://github.com/octokit/auth-app.js/#readme
     */
    AuthenticationStrategy["AUTH_APP"] = "auth-app";
    /**
     * Personal Access Token authentication
     *
     * @see https://github.com/octokit/auth-token.js#readme
     */
    AuthenticationStrategy["AUTH_TOKEN"] = "auth-token";
    /**
     * unauthenticated
     *
     * @see https://github.com/octokit/auth-unauthenticated.js#readme
     */
    AuthenticationStrategy["UNAUTHENTICATED"] = "unauthenticated";
})(AuthenticationStrategy = exports.AuthenticationStrategy || (exports.AuthenticationStrategy = {}));
class AuthOptions {
    /**
     * GitHub App or installation authentication
     *
     * @see https://github.com/octokit/auth-app.js/#readme
     */
    static appAuth(secret) {
        return new (class AppAuthOptions extends AuthOptions {
            constructor() {
                super(...arguments);
                this._auth = {
                    strategy: AuthenticationStrategy.AUTH_APP,
                    secret: secret.secretArn,
                };
            }
            _grantRead(grantee) {
                secret.grantRead(grantee);
            }
        })();
    }
    /**
     * Personal Access Token authentication
     *
     * @see https://github.com/octokit/auth-token.js#readme
     */
    static tokenAuth(parameter) {
        return new (class TokenAuthOptions extends AuthOptions {
            constructor() {
                super(...arguments);
                this._auth = {
                    strategy: AuthenticationStrategy.AUTH_TOKEN,
                    secret: parameter.parameterArn,
                };
            }
            _grantRead(grantee) {
                parameter.grantRead(grantee);
            }
        })();
    }
    /**
     * unauthenticated
     *
     * @see https://github.com/octokit/auth-unauthenticated.js#readme
     */
    static unauthenticated() {
        return new (class TokenAuthOptions extends AuthOptions {
            constructor() {
                super(...arguments);
                this._auth = {
                    strategy: AuthenticationStrategy.UNAUTHENTICATED,
                };
            }
            _grantRead(grantee) {
                grantee;
            }
        })();
    }
}
exports.AuthOptions = AuthOptions;
_a = JSII_RTTI_SYMBOL_1;
AuthOptions[_a] = { fqn: "@pepperize/cdk-github.AuthOptions", version: "0.0.78" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0aC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hdXRoLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUE7O0dBRUc7QUFDSCxJQUFZLHNCQXFCWDtBQXJCRCxXQUFZLHNCQUFzQjtJQUNoQzs7OztPQUlHO0lBQ0gsK0NBQXFCLENBQUE7SUFFckI7Ozs7T0FJRztJQUNILG1EQUF5QixDQUFBO0lBRXpCOzs7O09BSUc7SUFDSCw2REFBbUMsQ0FBQTtBQUNyQyxDQUFDLEVBckJXLHNCQUFzQixHQUF0Qiw4QkFBc0IsS0FBdEIsOEJBQXNCLFFBcUJqQztBQWdDRCxNQUFzQixXQUFXO0lBQy9COzs7O09BSUc7SUFDSSxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQStCO1FBQ25ELE9BQU8sSUFBSSxDQUFDLE1BQU0sY0FBZSxTQUFRLFdBQVc7WUFBeEM7O2dCQUNELFVBQUssR0FBRztvQkFDZixRQUFRLEVBQUUsc0JBQXNCLENBQUMsUUFBUTtvQkFDekMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxTQUFTO2lCQUN6QixDQUFDO1lBS0osQ0FBQztZQUhDLFVBQVUsQ0FBQyxPQUF1QjtnQkFDaEMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUM1QixDQUFDO1NBQ0YsQ0FBQyxFQUFFLENBQUM7SUFDUCxDQUFDO0lBQ0Q7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxTQUFTLENBQUMsU0FBeUI7UUFDL0MsT0FBTyxJQUFJLENBQUMsTUFBTSxnQkFBaUIsU0FBUSxXQUFXO1lBQTFDOztnQkFDRCxVQUFLLEdBQUc7b0JBQ2YsUUFBUSxFQUFFLHNCQUFzQixDQUFDLFVBQVU7b0JBQzNDLE1BQU0sRUFBRSxTQUFTLENBQUMsWUFBWTtpQkFDL0IsQ0FBQztZQUtKLENBQUM7WUFIQyxVQUFVLENBQUMsT0FBdUI7Z0JBQ2hDLFNBQVMsQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLENBQUM7WUFDL0IsQ0FBQztTQUNGLENBQUMsRUFBRSxDQUFDO0lBQ1AsQ0FBQztJQUNEOzs7O09BSUc7SUFDSSxNQUFNLENBQUMsZUFBZTtRQUMzQixPQUFPLElBQUksQ0FBQyxNQUFNLGdCQUFpQixTQUFRLFdBQVc7WUFBMUM7O2dCQUNELFVBQUssR0FBRztvQkFDZixRQUFRLEVBQUUsc0JBQXNCLENBQUMsZUFBZTtpQkFDakQsQ0FBQztZQUtKLENBQUM7WUFIQyxVQUFVLENBQUMsT0FBdUI7Z0JBQ2hDLE9BQU8sQ0FBQztZQUNWLENBQUM7U0FDRixDQUFDLEVBQUUsQ0FBQztJQUNQLENBQUM7O0FBbERILGtDQTJEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWlhbVwiO1xuaW1wb3J0ICogYXMgc2VjcmV0c19tYW5hZ2VyIGZyb20gXCJhd3MtY2RrLWxpYi9hd3Mtc2VjcmV0c21hbmFnZXJcIjtcbmltcG9ydCAqIGFzIHNzbSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLXNzbVwiO1xuXG4vKipcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgZW51bSBBdXRoZW50aWNhdGlvblN0cmF0ZWd5IHtcbiAgLyoqXG4gICAqIEdpdEh1YiBBcHAgb3IgaW5zdGFsbGF0aW9uIGF1dGhlbnRpY2F0aW9uXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9naXRodWIuY29tL29jdG9raXQvYXV0aC1hcHAuanMvI3JlYWRtZVxuICAgKi9cbiAgQVVUSF9BUFAgPSBcImF1dGgtYXBwXCIsXG5cbiAgLyoqXG4gICAqIFBlcnNvbmFsIEFjY2VzcyBUb2tlbiBhdXRoZW50aWNhdGlvblxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9vY3Rva2l0L2F1dGgtdG9rZW4uanMjcmVhZG1lXG4gICAqL1xuICBBVVRIX1RPS0VOID0gXCJhdXRoLXRva2VuXCIsXG5cbiAgLyoqXG4gICAqIHVuYXV0aGVudGljYXRlZFxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9vY3Rva2l0L2F1dGgtdW5hdXRoZW50aWNhdGVkLmpzI3JlYWRtZVxuICAgKi9cbiAgVU5BVVRIRU5USUNBVEVEID0gXCJ1bmF1dGhlbnRpY2F0ZWRcIixcbn1cblxuLyoqXG4gKiBUaGUgYXV0aCBjb25maWd1cmF0aW9uIHBhc3NlZCB0byB0aGUgb25FdmVudEhhbmRsZXJcbiAqXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBdXRoIHtcbiAgLyoqXG4gICAqIFRoZSBhdXRoZW50aWNhdGlvbiBzdHJhdGVneSB0byB1c2VcbiAgICpcbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vb2N0b2tpdC9hdXRoZW50aWNhdGlvbi1zdHJhdGVnaWVzLmpzLyNhdXRoZW50aWNhdGlvbi1zdHJhdGVnaWVzanNcbiAgICovXG4gIHJlYWRvbmx5IHN0cmF0ZWd5OiBBdXRoZW50aWNhdGlvblN0cmF0ZWd5O1xuICAvKipcbiAgICogRWl0aGVyIGEgU2VjcmV0c01hbmFnZXIgU2VjcmV0IEFybiBvciBhbiBTU00gUGFyYW1ldGVyU3RvcmUgUGFyYW1ldGVyIEFyblxuICAgKi9cbiAgcmVhZG9ubHkgc2VjcmV0Pzogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIElBdXRoT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHJlYWRvbmx5IF9hdXRoOiBBdXRoO1xuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIF9ncmFudFJlYWQoZ3JhbnRlZTogaWFtLklHcmFudGFibGUpOiB2b2lkO1xufVxuXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQXV0aE9wdGlvbnMgaW1wbGVtZW50cyBJQXV0aE9wdGlvbnMge1xuICAvKipcbiAgICogR2l0SHViIEFwcCBvciBpbnN0YWxsYXRpb24gYXV0aGVudGljYXRpb25cbiAgICpcbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vb2N0b2tpdC9hdXRoLWFwcC5qcy8jcmVhZG1lXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGFwcEF1dGgoc2VjcmV0OiBzZWNyZXRzX21hbmFnZXIuSVNlY3JldCk6IEF1dGhPcHRpb25zIHtcbiAgICByZXR1cm4gbmV3IChjbGFzcyBBcHBBdXRoT3B0aW9ucyBleHRlbmRzIEF1dGhPcHRpb25zIHtcbiAgICAgIHJlYWRvbmx5IF9hdXRoID0ge1xuICAgICAgICBzdHJhdGVneTogQXV0aGVudGljYXRpb25TdHJhdGVneS5BVVRIX0FQUCxcbiAgICAgICAgc2VjcmV0OiBzZWNyZXQuc2VjcmV0QXJuLFxuICAgICAgfTtcblxuICAgICAgX2dyYW50UmVhZChncmFudGVlOiBpYW0uSUdyYW50YWJsZSkge1xuICAgICAgICBzZWNyZXQuZ3JhbnRSZWFkKGdyYW50ZWUpO1xuICAgICAgfVxuICAgIH0pKCk7XG4gIH1cbiAgLyoqXG4gICAqIFBlcnNvbmFsIEFjY2VzcyBUb2tlbiBhdXRoZW50aWNhdGlvblxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9vY3Rva2l0L2F1dGgtdG9rZW4uanMjcmVhZG1lXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHRva2VuQXV0aChwYXJhbWV0ZXI6IHNzbS5JUGFyYW1ldGVyKTogQXV0aE9wdGlvbnMge1xuICAgIHJldHVybiBuZXcgKGNsYXNzIFRva2VuQXV0aE9wdGlvbnMgZXh0ZW5kcyBBdXRoT3B0aW9ucyB7XG4gICAgICByZWFkb25seSBfYXV0aCA9IHtcbiAgICAgICAgc3RyYXRlZ3k6IEF1dGhlbnRpY2F0aW9uU3RyYXRlZ3kuQVVUSF9UT0tFTixcbiAgICAgICAgc2VjcmV0OiBwYXJhbWV0ZXIucGFyYW1ldGVyQXJuLFxuICAgICAgfTtcblxuICAgICAgX2dyYW50UmVhZChncmFudGVlOiBpYW0uSUdyYW50YWJsZSkge1xuICAgICAgICBwYXJhbWV0ZXIuZ3JhbnRSZWFkKGdyYW50ZWUpO1xuICAgICAgfVxuICAgIH0pKCk7XG4gIH1cbiAgLyoqXG4gICAqIHVuYXV0aGVudGljYXRlZFxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9vY3Rva2l0L2F1dGgtdW5hdXRoZW50aWNhdGVkLmpzI3JlYWRtZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyB1bmF1dGhlbnRpY2F0ZWQoKTogQXV0aE9wdGlvbnMge1xuICAgIHJldHVybiBuZXcgKGNsYXNzIFRva2VuQXV0aE9wdGlvbnMgZXh0ZW5kcyBBdXRoT3B0aW9ucyB7XG4gICAgICByZWFkb25seSBfYXV0aCA9IHtcbiAgICAgICAgc3RyYXRlZ3k6IEF1dGhlbnRpY2F0aW9uU3RyYXRlZ3kuVU5BVVRIRU5USUNBVEVELFxuICAgICAgfTtcblxuICAgICAgX2dyYW50UmVhZChncmFudGVlOiBpYW0uSUdyYW50YWJsZSkge1xuICAgICAgICBncmFudGVlO1xuICAgICAgfVxuICAgIH0pKCk7XG4gIH1cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgYWJzdHJhY3QgcmVhZG9ubHkgX2F1dGg6IEF1dGg7XG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIGFic3RyYWN0IF9ncmFudFJlYWQoZ3JhbnRlZTogaWFtLklHcmFudGFibGUpOiB2b2lkO1xufVxuIl19