import { CustomResource, RemovalPolicy } from "aws-cdk-lib";
import { Construct } from "constructs";
import { GithubActionsSecret } from "./github-actions-secret";
import { GithubCustomResourceBase, GithubCustomResourceOptions } from "./github-custom-resource";
export interface GithubActionsSecretRepositoryProps extends GithubCustomResourceOptions {
    /**
     The GitHub Repository owner. The name is not case-sensitive.
     */
    readonly owner: string;
    /**
     * The GitHub Repository name. The name is not case-sensitive.
     */
    readonly repositoryName: string;
    /**
     * The GitHub secret name.
     */
    readonly secretName: string;
    /**
     * The SSM Secret.
     */
    readonly source: GithubActionsSecret;
    /**
     * Whether to DESTROY or RETAIN the secret on resource removal.
     * @default RETAIN
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * Manage an GitHib Actions Repository secret.
 *
 * ```typescript
 * // The GitHub API authentication secret
 * const auth = secrets_manager.Secret.fromSecretNameV2(scope, "Auth", "cdk-github/github-token");
 *
 * // The AWS SecretsManager Secret to configure as GitHub Action secret.
 * const secret = secrets_manager.Secret.fromSecretNameV2(scope, "Secret", "any-secret/example");
 *
 * new GithubActionsSecretRepository(scope, "GithubRepo", {
 *   owner: "pepperize",
 *   repositoryName: "cdk-github",
 *   secretName: "example",
 *   source: GithubActionsSecret.fromSecretsManager(secret, "some-json-field"),
 *   authOptions: AuthOptions.appAuth(auth),
 *   removalPolicy: RemovalPolicy.DESTROY,
 * });
 * ```
 */
export declare class GithubActionsSecretRepository extends GithubCustomResourceBase {
    /**
     * @internal
     */
    readonly _resource: CustomResource;
    constructor(scope: Construct, id: string, props: GithubActionsSecretRepositoryProps);
}
