"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubActionsSecret = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
class GithubActionsSecret {
    static fromSecretsManager(secret, field) {
        return new GithubActionsSecret(secret, field);
    }
    constructor(secret, field) {
        this.creationStack = (0, aws_cdk_lib_1.captureStackTrace)();
        this.secret = secret;
        this.field = field;
    }
    resolve(_) {
        return { arn: this.secret.secretArn, field: this.field };
    }
    /**
     * @internal
     */
    _grantRead(grantee) {
        this.secret.grantRead(grantee);
    }
}
exports.GithubActionsSecret = GithubActionsSecret;
//# sourceMappingURL=data:application/json;base64,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