"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubCustomResource = exports.GithubCustomResourceBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const provider_1 = require("./custom-resource-provider/provider");
class GithubCustomResourceBase extends constructs_1.Construct {
    /**
     * The physical name of this custom resource.
     */
    get ref() {
        return this._resource.ref;
    }
    /**
     * Returns the value of an attribute of the custom resource of an arbitrary
     * type. Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getAttString` for string attributes.
     */
    getAtt(attributeName) {
        return this._resource.getAtt(attributeName);
    }
    /**
     * Returns the value of an attribute of the custom resource of type string.
     * Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt` encoded as a string.
     */
    getAttString(attributeName) {
        return this._resource.getAttString(attributeName);
    }
}
exports.GithubCustomResourceBase = GithubCustomResourceBase;
_a = JSII_RTTI_SYMBOL_1;
GithubCustomResourceBase[_a] = { fqn: "@pepperize/cdk-github.GithubCustomResourceBase", version: "0.0.970" };
/**
 * ```typescript
 * const auth = secrets_manager.Secret.fromSecretNameV2(scope, "Auth", "cdk-github/github-token");
 *
 * new GithubCustomResource(scope, "GithubRepo", {
 *   onCreate: {
 *     // https://octokit.github.io/rest.js/v19/#repos-create-in-org
 *     endpoint: "repos",
 *     method: "createInOrg",
 *     parameters: {
 *       org: "pepperize",
 *       name: "cdk-github",
 *     },
 *     outputPaths: ["id", "full_name"],
 *     physicalResourceId: custom_resources.PhysicalResourceId.fromResponse("full_name"),
 *     ignoreErrorCodesMatching: "name already exists on this account",
 *   },
 *   onUpdate: {
 *     // https://octokit.github.io/rest.js/v19#repos-get
 *     endpoint: "repos",
 *     method: "get",
 *     parameters: {
 *       owner: "pepperize",
 *       repo: "cdk-github",
 *     },
 *     outputPaths: ["id", "full_name"],
 *     physicalResourceId: custom_resources.PhysicalResourceId.fromResponse("full_name"),
 *   },
 *   onDelete: {
 *     // https://octokit.github.io/rest.js/v19#repos-delete
 *     endpoint: "repos",
 *     method: "delete",
 *     parameters: {
 *       owner: "pepperize",
 *       repo: "cdk-github",
 *     },
 *     outputPaths: [],
 *   },
 *   authOptions: AuthOptions.appAuth(auth),
 * });
 * ```
 */
class GithubCustomResource extends GithubCustomResourceBase {
    constructor(scope, id, props) {
        super(scope, id);
        const provider = provider_1.GithubCustomResourceProvider.getOrCreate(this);
        const authOptions = props.authOptions;
        authOptions._grantRead(provider);
        this._resource = new aws_cdk_lib_1.CustomResource(this, "Resource", {
            serviceToken: provider.serviceToken,
            resourceType: props.resourceType,
            properties: {
                Create: props.onCreate && aws_cdk_lib_1.Lazy.uncachedString({ produce: () => aws_cdk_lib_1.Stack.of(this).toJsonString(props.onCreate) }),
                Update: props.onUpdate && aws_cdk_lib_1.Lazy.uncachedString({ produce: () => aws_cdk_lib_1.Stack.of(this).toJsonString(props.onUpdate) }),
                Delete: props.onDelete && aws_cdk_lib_1.Lazy.uncachedString({ produce: () => aws_cdk_lib_1.Stack.of(this).toJsonString(props.onDelete) }),
                Auth: props.authOptions._auth,
            },
        });
    }
}
exports.GithubCustomResource = GithubCustomResource;
_b = JSII_RTTI_SYMBOL_1;
GithubCustomResource[_b] = { fqn: "@pepperize/cdk-github.GithubCustomResource", version: "0.0.970" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0aHViLWN1c3RvbS1yZXNvdXJjZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9naXRodWItY3VzdG9tLXJlc291cmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQXFFO0FBRXJFLDJDQUF1QztBQUV2QyxrRUFBbUY7QUFpRm5GLE1BQXNCLHdCQUF5QixTQUFRLHNCQUFTO0lBSzlEOztPQUVHO0lBQ0gsSUFBSSxHQUFHO1FBQ0wsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQztJQUM1QixDQUFDO0lBQ0Q7Ozs7Ozs7O09BUUc7SUFDSCxNQUFNLENBQUMsYUFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBQ0Q7Ozs7Ozs7T0FPRztJQUNILFlBQVksQ0FBQyxhQUFxQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ3BELENBQUM7O0FBakNILDREQWtDQzs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBeUNHO0FBQ0gsTUFBYSxvQkFBcUIsU0FBUSx3QkFBd0I7SUFLaEUsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFnQztRQUN4RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLHVDQUE0QixDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNoRSxNQUFNLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3RDLFdBQVcsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUM7UUFFakMsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLDRCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNwRCxZQUFZLEVBQUUsUUFBUSxDQUFDLFlBQVk7WUFDbkMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLFVBQVUsRUFBRTtnQkFDVixNQUFNLEVBQUUsS0FBSyxDQUFDLFFBQVEsSUFBSSxrQkFBSSxDQUFDLGNBQWMsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUM7Z0JBQzdHLE1BQU0sRUFBRSxLQUFLLENBQUMsUUFBUSxJQUFJLGtCQUFJLENBQUMsY0FBYyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLG1CQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQztnQkFDN0csTUFBTSxFQUFFLEtBQUssQ0FBQyxRQUFRLElBQUksa0JBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDO2dCQUM3RyxJQUFJLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxLQUFLO2FBQzlCO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF0Qkgsb0RBdUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ3VzdG9tUmVzb3VyY2UsIExhenksIFJlZmVyZW5jZSwgU3RhY2sgfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCAqIGFzIGN1c3RvbV9yZXNvdXJjZXMgZnJvbSBcImF3cy1jZGstbGliL2N1c3RvbS1yZXNvdXJjZXNcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBJQXV0aE9wdGlvbnMgfSBmcm9tIFwiLi9hdXRoXCI7XG5pbXBvcnQgeyBHaXRodWJDdXN0b21SZXNvdXJjZVByb3ZpZGVyIH0gZnJvbSBcIi4vY3VzdG9tLXJlc291cmNlLXByb3ZpZGVyL3Byb3ZpZGVyXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgR2l0aHViQXBpQ2FsbCB7XG4gIC8qKlxuICAgKiBUaGUgZW5kcG9pbnQgdG8gY2FsbC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vb2N0b2tpdC9yZXN0LmpzXG4gICAqL1xuICByZWFkb25seSBlbmRwb2ludDogc3RyaW5nO1xuICAvKipcbiAgICogVGhlIG1ldGhvZCB0byBjYWxsLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9vY3Rva2l0L3Jlc3QuanNcbiAgICovXG4gIHJlYWRvbmx5IG1ldGhvZDogc3RyaW5nO1xuICAvKipcbiAgICogVGhlIHBhcmFtZXRlcnMgZm9yIHRoZSBzZXJ2aWNlIGFjdGlvbi5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vb2N0b2tpdC9yZXN0LmpzXG4gICAqL1xuICByZWFkb25seSBwYXJhbWV0ZXJzPzogYW55O1xuICAvKipcbiAgICogVGhlIHBoeXNpY2FsIHJlc291cmNlIGlkIG9mIHRoZSBjdXN0b20gcmVzb3VyY2UgZm9yIHRoaXMgY2FsbC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jcnBnLXJlZi1yZXNwb25zZXMuaHRtbFxuICAgKlxuICAgKiBAZGVmYXVsdCB1bmRlZmluZWQgLSBmb3IgXCJDcmVhdGVcIiByZXF1ZXN0cywgZGVmYXVsdHMgdG8gdGhlIGV2ZW50J3MgUmVxdWVzdElkLCBmb3IgXCJVcGRhdGVcIiBhbmQgXCJEZWxldGVcIiwgZGVmYXVsdHMgdG8gdGhlIGN1cnJlbnQgYFBoeXNpY2FsUmVzb3VyY2VJZGAuXG4gICAqL1xuICByZWFkb25seSBwaHlzaWNhbFJlc291cmNlSWQ/OiBjdXN0b21fcmVzb3VyY2VzLlBoeXNpY2FsUmVzb3VyY2VJZDtcbiAgLyoqXG4gICAqIFRoZSByZWdleCBwYXR0ZXJuIHRvIHVzZSB0byBjYXRjaCBBUEkgZXJyb3JzLiBUaGUgYG1lc3NhZ2VgIHByb3BlcnR5IG9mIHRoZSBgUmVxdWVzdEVycm9yYCBvYmplY3Qgd2lsbCBiZSB0ZXN0ZWQgYWdhaW5zdCB0aGlzIHBhdHRlcm4uIElmIHRoZXJlIGlzIGEgbWF0Y2ggYW4gZXJyb3Igd2lsbCBub3QgYmUgdGhyb3duLlxuICAgKi9cbiAgcmVhZG9ubHkgaWdub3JlRXJyb3JDb2Rlc01hdGNoaW5nPzogc3RyaW5nO1xuICAvKipcbiAgICogRmlsdGVyIHRoZSBkYXRhIHJldHVybmVkIGJ5IHRoZSBjdXN0b20gcmVzb3VyY2UgdG8gc3BlY2lmaWMgcGF0aHMgaW4gdGhlIEFQSSByZXNwb25zZS5cbiAgICpcbiAgICogPGI+VGhlIHRvdGFsIHNpemUgb2YgdGhlIHJlc3BvbnNlIGJvZHkgY2FuJ3QgZXhjZWVkIDQwOTYgYnl0ZXMuPC9iPlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2NycGctcmVmLXJlc3BvbnNlcy5odG1sXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmdpdGh1Yi5jb20vZW4vcmVzdFxuICAgKlxuICAgKiBFeGFtcGxlIGZvciBvY3Rva2l0LnJlc3QucmVwb3MuY3JlYXRlSW5Pcmc6IFsnaWQnLCAnZnVsbF9uYW1lJywgJ293bmVyLmlkJ11cbiAgICpcbiAgICogQGRlZmF1bHQgdW5kZWZpbmVkIC0gaXQncyByZWNvbW1lbmRlZCB0byBkZWZpbmUgaXRcbiAgICovXG4gIHJlYWRvbmx5IG91dHB1dFBhdGhzPzogc3RyaW5nW107XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgR2l0aHViQ3VzdG9tUmVzb3VyY2VPcHRpb25zIHtcbiAgLyoqXG4gICAqIEN1cnJlbnRseSwgc3VwcG9ydHMgb25seSBHaXRIdWIgQXBwLlxuICAgKlxuICAgKiBgYGB0eXBlc2NyaXB0XG4gICAqIGNvbnN0IGF1dGggPSB7IGFwcElkLCBwcml2YXRlS2V5IH07XG4gICAqIGNvbnN0IGluc3RhbGxhdGlvbkF1dGggPSB7IGFwcElkLCBwcml2YXRlS2V5LCBpbnN0YWxsYXRpb25JZCB9O1xuICAgKiBgYGBcbiAgICpcbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vb2N0b2tpdC9hdXRoZW50aWNhdGlvbi1zdHJhdGVnaWVzLmpzLyNnaXRodWItYXBwLW9yLWluc3RhbGxhdGlvbi1hdXRoZW50aWNhdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgYXV0aE9wdGlvbnM6IElBdXRoT3B0aW9ucztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBHaXRodWJDdXN0b21SZXNvdXJjZVByb3BzIGV4dGVuZHMgR2l0aHViQ3VzdG9tUmVzb3VyY2VPcHRpb25zIHtcbiAgLyoqXG4gICAqIENsb3VkZm9ybWF0aW9uIFJlc291cmNlIHR5cGUuXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZVR5cGU/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBUaGUgR2l0SHViIEFwaSBjYWxsIHRvIG1ha2Ugd2hlbiB0aGUgcmVzb3VyY2UgaXMgY3JlYXRlZC5cbiAgICovXG4gIHJlYWRvbmx5IG9uQ3JlYXRlPzogR2l0aHViQXBpQ2FsbDtcbiAgLyoqXG4gICAqIFRoZSBHaXRIdWIgQXBpIGNhbGwgdG8gbWFrZSB3aGVuIHRoZSByZXNvdXJjZSBpcyB1cGRhdGVkLlxuICAgKi9cbiAgcmVhZG9ubHkgb25VcGRhdGU/OiBHaXRodWJBcGlDYWxsO1xuICAvKipcbiAgICogVGhlIEdpdEh1YiBBcGkgY2FsbCB0byBtYWtlIHdoZW4gdGhlIHJlc291cmNlIGlzIGRlbGV0ZWQuXG4gICAqL1xuICByZWFkb25seSBvbkRlbGV0ZT86IEdpdGh1YkFwaUNhbGw7XG59XG5cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBHaXRodWJDdXN0b21SZXNvdXJjZUJhc2UgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBhYnN0cmFjdCByZWFkb25seSBfcmVzb3VyY2U6IEN1c3RvbVJlc291cmNlO1xuICAvKipcbiAgICogVGhlIHBoeXNpY2FsIG5hbWUgb2YgdGhpcyBjdXN0b20gcmVzb3VyY2UuXG4gICAqL1xuICBnZXQgcmVmKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIHRoaXMuX3Jlc291cmNlLnJlZjtcbiAgfVxuICAvKipcbiAgICogUmV0dXJucyB0aGUgdmFsdWUgb2YgYW4gYXR0cmlidXRlIG9mIHRoZSBjdXN0b20gcmVzb3VyY2Ugb2YgYW4gYXJiaXRyYXJ5XG4gICAqIHR5cGUuIEF0dHJpYnV0ZXMgYXJlIHJldHVybmVkIGZyb20gdGhlIGN1c3RvbSByZXNvdXJjZSBwcm92aWRlciB0aHJvdWdoIHRoZVxuICAgKiBgRGF0YWAgbWFwIHdoZXJlIHRoZSBrZXkgaXMgdGhlIGF0dHJpYnV0ZSBuYW1lLlxuICAgKlxuICAgKiBAcGFyYW0gYXR0cmlidXRlTmFtZSB0aGUgbmFtZSBvZiB0aGUgYXR0cmlidXRlXG4gICAqIEByZXR1cm5zIGEgdG9rZW4gZm9yIGBGbjo6R2V0QXR0YC4gVXNlIGBUb2tlbi5hc1h4eGAgdG8gZW5jb2RlIHRoZSByZXR1cm5lZCBgUmVmZXJlbmNlYCBhcyBhIHNwZWNpZmljIHR5cGUgb3JcbiAgICogdXNlIHRoZSBjb252ZW5pZW5jZSBgZ2V0QXR0U3RyaW5nYCBmb3Igc3RyaW5nIGF0dHJpYnV0ZXMuXG4gICAqL1xuICBnZXRBdHQoYXR0cmlidXRlTmFtZTogc3RyaW5nKTogUmVmZXJlbmNlIHtcbiAgICByZXR1cm4gdGhpcy5fcmVzb3VyY2UuZ2V0QXR0KGF0dHJpYnV0ZU5hbWUpO1xuICB9XG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSB2YWx1ZSBvZiBhbiBhdHRyaWJ1dGUgb2YgdGhlIGN1c3RvbSByZXNvdXJjZSBvZiB0eXBlIHN0cmluZy5cbiAgICogQXR0cmlidXRlcyBhcmUgcmV0dXJuZWQgZnJvbSB0aGUgY3VzdG9tIHJlc291cmNlIHByb3ZpZGVyIHRocm91Z2ggdGhlXG4gICAqIGBEYXRhYCBtYXAgd2hlcmUgdGhlIGtleSBpcyB0aGUgYXR0cmlidXRlIG5hbWUuXG4gICAqXG4gICAqIEBwYXJhbSBhdHRyaWJ1dGVOYW1lIHRoZSBuYW1lIG9mIHRoZSBhdHRyaWJ1dGVcbiAgICogQHJldHVybnMgYSB0b2tlbiBmb3IgYEZuOjpHZXRBdHRgIGVuY29kZWQgYXMgYSBzdHJpbmcuXG4gICAqL1xuICBnZXRBdHRTdHJpbmcoYXR0cmlidXRlTmFtZTogc3RyaW5nKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5fcmVzb3VyY2UuZ2V0QXR0U3RyaW5nKGF0dHJpYnV0ZU5hbWUpO1xuICB9XG59XG5cbi8qKlxuICogYGBgdHlwZXNjcmlwdFxuICogY29uc3QgYXV0aCA9IHNlY3JldHNfbWFuYWdlci5TZWNyZXQuZnJvbVNlY3JldE5hbWVWMihzY29wZSwgXCJBdXRoXCIsIFwiY2RrLWdpdGh1Yi9naXRodWItdG9rZW5cIik7XG4gKlxuICogbmV3IEdpdGh1YkN1c3RvbVJlc291cmNlKHNjb3BlLCBcIkdpdGh1YlJlcG9cIiwge1xuICogICBvbkNyZWF0ZToge1xuICogICAgIC8vIGh0dHBzOi8vb2N0b2tpdC5naXRodWIuaW8vcmVzdC5qcy92MTkvI3JlcG9zLWNyZWF0ZS1pbi1vcmdcbiAqICAgICBlbmRwb2ludDogXCJyZXBvc1wiLFxuICogICAgIG1ldGhvZDogXCJjcmVhdGVJbk9yZ1wiLFxuICogICAgIHBhcmFtZXRlcnM6IHtcbiAqICAgICAgIG9yZzogXCJwZXBwZXJpemVcIixcbiAqICAgICAgIG5hbWU6IFwiY2RrLWdpdGh1YlwiLFxuICogICAgIH0sXG4gKiAgICAgb3V0cHV0UGF0aHM6IFtcImlkXCIsIFwiZnVsbF9uYW1lXCJdLFxuICogICAgIHBoeXNpY2FsUmVzb3VyY2VJZDogY3VzdG9tX3Jlc291cmNlcy5QaHlzaWNhbFJlc291cmNlSWQuZnJvbVJlc3BvbnNlKFwiZnVsbF9uYW1lXCIpLFxuICogICAgIGlnbm9yZUVycm9yQ29kZXNNYXRjaGluZzogXCJuYW1lIGFscmVhZHkgZXhpc3RzIG9uIHRoaXMgYWNjb3VudFwiLFxuICogICB9LFxuICogICBvblVwZGF0ZToge1xuICogICAgIC8vIGh0dHBzOi8vb2N0b2tpdC5naXRodWIuaW8vcmVzdC5qcy92MTkjcmVwb3MtZ2V0XG4gKiAgICAgZW5kcG9pbnQ6IFwicmVwb3NcIixcbiAqICAgICBtZXRob2Q6IFwiZ2V0XCIsXG4gKiAgICAgcGFyYW1ldGVyczoge1xuICogICAgICAgb3duZXI6IFwicGVwcGVyaXplXCIsXG4gKiAgICAgICByZXBvOiBcImNkay1naXRodWJcIixcbiAqICAgICB9LFxuICogICAgIG91dHB1dFBhdGhzOiBbXCJpZFwiLCBcImZ1bGxfbmFtZVwiXSxcbiAqICAgICBwaHlzaWNhbFJlc291cmNlSWQ6IGN1c3RvbV9yZXNvdXJjZXMuUGh5c2ljYWxSZXNvdXJjZUlkLmZyb21SZXNwb25zZShcImZ1bGxfbmFtZVwiKSxcbiAqICAgfSxcbiAqICAgb25EZWxldGU6IHtcbiAqICAgICAvLyBodHRwczovL29jdG9raXQuZ2l0aHViLmlvL3Jlc3QuanMvdjE5I3JlcG9zLWRlbGV0ZVxuICogICAgIGVuZHBvaW50OiBcInJlcG9zXCIsXG4gKiAgICAgbWV0aG9kOiBcImRlbGV0ZVwiLFxuICogICAgIHBhcmFtZXRlcnM6IHtcbiAqICAgICAgIG93bmVyOiBcInBlcHBlcml6ZVwiLFxuICogICAgICAgcmVwbzogXCJjZGstZ2l0aHViXCIsXG4gKiAgICAgfSxcbiAqICAgICBvdXRwdXRQYXRoczogW10sXG4gKiAgIH0sXG4gKiAgIGF1dGhPcHRpb25zOiBBdXRoT3B0aW9ucy5hcHBBdXRoKGF1dGgpLFxuICogfSk7XG4gKiBgYGBcbiAqL1xuZXhwb3J0IGNsYXNzIEdpdGh1YkN1c3RvbVJlc291cmNlIGV4dGVuZHMgR2l0aHViQ3VzdG9tUmVzb3VyY2VCYXNlIHtcbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcmVhZG9ubHkgX3Jlc291cmNlOiBDdXN0b21SZXNvdXJjZTtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEdpdGh1YkN1c3RvbVJlc291cmNlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgcHJvdmlkZXIgPSBHaXRodWJDdXN0b21SZXNvdXJjZVByb3ZpZGVyLmdldE9yQ3JlYXRlKHRoaXMpO1xuICAgIGNvbnN0IGF1dGhPcHRpb25zID0gcHJvcHMuYXV0aE9wdGlvbnM7XG4gICAgYXV0aE9wdGlvbnMuX2dyYW50UmVhZChwcm92aWRlcik7XG5cbiAgICB0aGlzLl9yZXNvdXJjZSA9IG5ldyBDdXN0b21SZXNvdXJjZSh0aGlzLCBcIlJlc291cmNlXCIsIHtcbiAgICAgIHNlcnZpY2VUb2tlbjogcHJvdmlkZXIuc2VydmljZVRva2VuLFxuICAgICAgcmVzb3VyY2VUeXBlOiBwcm9wcy5yZXNvdXJjZVR5cGUsXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIENyZWF0ZTogcHJvcHMub25DcmVhdGUgJiYgTGF6eS51bmNhY2hlZFN0cmluZyh7IHByb2R1Y2U6ICgpID0+IFN0YWNrLm9mKHRoaXMpLnRvSnNvblN0cmluZyhwcm9wcy5vbkNyZWF0ZSkgfSksXG4gICAgICAgIFVwZGF0ZTogcHJvcHMub25VcGRhdGUgJiYgTGF6eS51bmNhY2hlZFN0cmluZyh7IHByb2R1Y2U6ICgpID0+IFN0YWNrLm9mKHRoaXMpLnRvSnNvblN0cmluZyhwcm9wcy5vblVwZGF0ZSkgfSksXG4gICAgICAgIERlbGV0ZTogcHJvcHMub25EZWxldGUgJiYgTGF6eS51bmNhY2hlZFN0cmluZyh7IHByb2R1Y2U6ICgpID0+IFN0YWNrLm9mKHRoaXMpLnRvSnNvblN0cmluZyhwcm9wcy5vbkRlbGV0ZSkgfSksXG4gICAgICAgIEF1dGg6IHByb3BzLmF1dGhPcHRpb25zLl9hdXRoLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuIl19