import io
import math
from collections.abc import Callable
from typing import Any

import cli
import pytest

from persistent_cache import cache, deep_learning, speedup_deep_learning

caches = [cache, deep_learning.cache, speedup_deep_learning.cache]


def calculate(*args: Any, **kwargs: Any) -> None:
    cli.console.print("calculation started")
    cli.console.print(args, kwargs)


def verify_cached_function(function: Callable[..., Any]) -> None:
    with io.BytesIO() as fp:
        function(fp, lambda x: x, math, {})


@pytest.mark.parametrize("cache_decorator", caches)
def test_cache_with_argument_combination(cache_decorator: Callable[..., Any]) -> None:
    cached_function = cache_decorator(calculate)
    verify_cached_function(cached_function)


@pytest.mark.parametrize("cache_decorator", caches)
def test_cache_as_function(cache_decorator: Callable[..., Any]) -> None:
    cached_function = cache_decorator()(calculate)
    verify_cached_function(cached_function)
