/******************************************************************************
 *
 * Copyright (c) 2017, the Perspective Authors.
 *
 * This file is part of the Perspective library, distributed under the terms of
 * the Apache License 2.0.  The full license can be found in the LICENSE file.
 *
 */

#ifdef __linux__
#include <perspective/first.h>
#include <perspective/base.h>
#include <perspective/raii.h>
#include <sys/mman.h>

namespace perspective {

t_file_handle::~t_file_handle() {
    if (valid()) {
        t_index rcode = close(m_value);
        PSP_VERBOSE_ASSERT(rcode == 0, "Error closing file.");
    }
}

bool
t_file_handle::valid() const {
    return m_value >= 0;
}

void
t_file_handle::release() {
    m_value = -1;
}

t_mmap_handle::~t_mmap_handle() {
    if (valid()) {
        t_index rcode = munmap(m_value, m_len);
        PSP_VERBOSE_ASSERT(rcode == 0, "munmap failed.");
    }
}

bool
t_mmap_handle::valid() {
    return m_value != MAP_FAILED;
}

} // end namespace perspective

#endif