#  ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
#  ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
#  ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
#  ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
#  ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
#  ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
#  ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
#  ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
#  ┃ This file is part of the Perspective library, distributed under the terms ┃
#  ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
#  ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

import pandas as pd
from unittest.mock import patch
from perspective import PerspectiveWidget, Plugin, PerspectiveError


class TestLayout:
    def test_layout_invalid_plugin(self):
        with patch("IPython.display.display"):
            df = pd.DataFrame([1, 2], columns=["1"])
            PerspectiveWidget(df, plugin=Plugin.YBAR)
            PerspectiveWidget(df, plugin="Y Line")
            try:
                PerspectiveWidget(df, plugin="test")
                assert False
            except PerspectiveError:
                pass

            try:
                PerspectiveWidget(df, plugin=5)
                assert False
            except PerspectiveError:
                pass

    def test_layout_invalid_columns(self):
        with patch("IPython.display.display"):
            df = pd.DataFrame([1, 2], columns=["1"])
            PerspectiveWidget(df, plugin=Plugin.YBAR, columns=["1"])
            try:
                PerspectiveWidget(df, plugin=Plugin.YBAR, columns=5)
                assert False
            except PerspectiveError:
                pass
