// This file is @generated by prost-build.
/// Recoverable, user-readable error reporting from the engine.
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerError {
    #[prost(string, tag = "1")]
    pub message: ::prost::alloc::string::String,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Schema {
    #[prost(message, repeated, tag = "1")]
    pub schema: ::prost::alloc::vec::Vec<schema::KeyTypePair>,
}
/// Nested message and enum types in `Schema`.
pub mod schema {
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct KeyTypePair {
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        #[prost(enumeration = "super::ColumnType", tag = "2")]
        pub r#type: i32,
    }
}
/// The data type constructors Perspective supports.
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MakeTableData {
    #[prost(oneof = "make_table_data::Data", tags = "1, 2, 3, 4, 5, 6")]
    pub data: ::core::option::Option<make_table_data::Data>,
}
/// Nested message and enum types in `MakeTableData`.
pub mod make_table_data {
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Data {
        #[prost(message, tag = "1")]
        FromSchema(super::Schema),
        #[prost(string, tag = "2")]
        FromCsv(::prost::alloc::string::String),
        #[prost(bytes, tag = "3")]
        #[serde(skip)]
        FromArrow(::prost::alloc::vec::Vec<u8>),
        #[prost(string, tag = "4")]
        FromRows(::prost::alloc::string::String),
        #[prost(string, tag = "5")]
        FromCols(::prost::alloc::string::String),
        #[prost(string, tag = "6")]
        FromView(::prost::alloc::string::String),
    }
}
/// View type scalars
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Scalar {
    #[prost(oneof = "scalar::Scalar", tags = "1, 2, 3, 4, 5, 6, 7")]
    pub scalar: ::core::option::Option<scalar::Scalar>,
}
/// Nested message and enum types in `Scalar`.
pub mod scalar {
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Scalar {
        #[prost(bool, tag = "1")]
        Bool(bool),
        /// TODO these are the wrong type
        #[prost(int64, tag = "2")]
        Date(i64),
        #[prost(int64, tag = "3")]
        Datetime(i64),
        #[prost(double, tag = "4")]
        Float(f64),
        #[prost(int32, tag = "5")]
        Int(i32),
        #[prost(string, tag = "6")]
        String(::prost::alloc::string::String),
        #[prost(enumeration = "::prost_types::NullValue", tag = "7")]
        Null(i32),
    }
}
/// Options for requresting a slice of data, starting with the rectangular
/// viewport.
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewPort {
    #[prost(uint32, optional, tag = "1")]
    pub start_row: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "2")]
    pub start_col: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "3")]
    pub end_row: ::core::option::Option<u32>,
    ///    optional bool id = 5;
    ///    optional bool index = 3;
    ///    optional bool formatted = 6;
    ///    optional bool leaves_only = 7;
    ///    optional bool compression = 3;
    #[prost(uint32, optional, tag = "4")]
    pub end_col: ::core::option::Option<u32>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Request {
    #[prost(uint32, tag = "1")]
    pub msg_id: u32,
    #[prost(string, tag = "2")]
    pub entity_id: ::prost::alloc::string::String,
    #[prost(
        oneof = "request::ClientReq",
        tags = "3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35"
    )]
    pub client_req: ::core::option::Option<request::ClientReq>,
}
/// Nested message and enum types in `Request`.
pub mod request {
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ClientReq {
        /// Minimum Virtual API (theoretical).
        #[prost(message, tag = "3")]
        GetFeaturesReq(super::GetFeaturesReq),
        #[prost(message, tag = "4")]
        GetHostedTablesReq(super::GetHostedTablesReq),
        #[prost(message, tag = "5")]
        TableMakePortReq(super::TableMakePortReq),
        #[prost(message, tag = "6")]
        TableMakeViewReq(super::TableMakeViewReq),
        #[prost(message, tag = "7")]
        TableSchemaReq(super::TableSchemaReq),
        #[prost(message, tag = "8")]
        TableSizeReq(super::TableSizeReq),
        #[prost(message, tag = "9")]
        TableValidateExprReq(super::TableValidateExprReq),
        #[prost(message, tag = "10")]
        ViewColumnPathsReq(super::ViewColumnPathsReq),
        #[prost(message, tag = "11")]
        ViewDeleteReq(super::ViewDeleteReq),
        #[prost(message, tag = "12")]
        ViewDimensionsReq(super::ViewDimensionsReq),
        #[prost(message, tag = "13")]
        ViewExpressionSchemaReq(super::ViewExpressionSchemaReq),
        #[prost(message, tag = "14")]
        ViewGetConfigReq(super::ViewGetConfigReq),
        #[prost(message, tag = "15")]
        ViewSchemaReq(super::ViewSchemaReq),
        #[prost(message, tag = "16")]
        ViewToArrowReq(super::ViewToArrowReq),
        /// Optional (we can enable real-time/autocomplete/etc with these, but
        /// not required).
        #[prost(message, tag = "17")]
        ServerSystemInfoReq(super::ServerSystemInfoReq),
        #[prost(message, tag = "18")]
        ViewCollapseReq(super::ViewCollapseReq),
        #[prost(message, tag = "19")]
        ViewExpandReq(super::ViewExpandReq),
        #[prost(message, tag = "20")]
        ViewGetMinMaxReq(super::ViewGetMinMaxReq),
        #[prost(message, tag = "21")]
        ViewOnUpdateReq(super::ViewOnUpdateReq),
        #[prost(message, tag = "22")]
        ViewRemoveOnUpdateReq(super::ViewRemoveOnUpdateReq),
        #[prost(message, tag = "23")]
        ViewSetDepthReq(super::ViewSetDepthReq),
        #[prost(message, tag = "24")]
        ViewToColumnsStringReq(super::ViewToColumnsStringReq),
        #[prost(message, tag = "25")]
        ViewToCsvReq(super::ViewToCsvReq),
        #[prost(message, tag = "26")]
        ViewToRowsStringReq(super::ViewToRowsStringReq),
        /// External (we don't need these for viewer, but the developer may).
        #[prost(message, tag = "27")]
        MakeTableReq(super::MakeTableReq),
        #[prost(message, tag = "28")]
        TableDeleteReq(super::TableDeleteReq),
        #[prost(message, tag = "29")]
        TableOnDeleteReq(super::TableOnDeleteReq),
        #[prost(message, tag = "30")]
        TableRemoveDeleteReq(super::TableRemoveDeleteReq),
        #[prost(message, tag = "31")]
        TableRemoveReq(super::TableRemoveReq),
        #[prost(message, tag = "32")]
        TableReplaceReq(super::TableReplaceReq),
        #[prost(message, tag = "33")]
        TableUpdateReq(super::TableUpdateReq),
        #[prost(message, tag = "34")]
        ViewOnDeleteReq(super::ViewOnDeleteReq),
        #[prost(message, tag = "35")]
        ViewRemoveDeleteReq(super::ViewRemoveDeleteReq),
    }
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Response {
    #[prost(uint32, tag = "1")]
    pub msg_id: u32,
    #[prost(string, tag = "2")]
    pub entity_id: ::prost::alloc::string::String,
    #[prost(
        oneof = "response::ClientResp",
        tags = "3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 50"
    )]
    pub client_resp: ::core::option::Option<response::ClientResp>,
}
/// Nested message and enum types in `Response`.
pub mod response {
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ClientResp {
        #[prost(message, tag = "3")]
        GetFeaturesResp(super::GetFeaturesResp),
        #[prost(message, tag = "4")]
        GetHostedTablesResp(super::GetHostedTablesResp),
        #[prost(message, tag = "5")]
        TableMakePortResp(super::TableMakePortResp),
        #[prost(message, tag = "6")]
        TableMakeViewResp(super::TableMakeViewResp),
        #[prost(message, tag = "7")]
        TableSchemaResp(super::TableSchemaResp),
        #[prost(message, tag = "8")]
        TableSizeResp(super::TableSizeResp),
        #[prost(message, tag = "9")]
        TableValidateExprResp(super::TableValidateExprResp),
        #[prost(message, tag = "10")]
        ViewColumnPathsResp(super::ViewColumnPathsResp),
        #[prost(message, tag = "11")]
        ViewDeleteResp(super::ViewDeleteResp),
        #[prost(message, tag = "12")]
        ViewDimensionsResp(super::ViewDimensionsResp),
        #[prost(message, tag = "13")]
        ViewExpressionSchemaResp(super::ViewExpressionSchemaResp),
        #[prost(message, tag = "14")]
        ViewGetConfigResp(super::ViewGetConfigResp),
        #[prost(message, tag = "15")]
        ViewSchemaResp(super::ViewSchemaResp),
        #[prost(message, tag = "16")]
        ViewToArrowResp(super::ViewToArrowResp),
        #[prost(message, tag = "17")]
        ServerSystemInfoResp(super::ServerSystemInfoResp),
        #[prost(message, tag = "18")]
        ViewCollapseResp(super::ViewCollapseResp),
        #[prost(message, tag = "19")]
        ViewExpandResp(super::ViewExpandResp),
        #[prost(message, tag = "20")]
        ViewGetMinMaxResp(super::ViewGetMinMaxResp),
        #[prost(message, tag = "21")]
        ViewOnUpdateResp(super::ViewOnUpdateResp),
        #[prost(message, tag = "22")]
        ViewRemoveOnUpdateResp(super::ViewRemoveOnUpdateResp),
        #[prost(message, tag = "23")]
        ViewSetDepthResp(super::ViewSetDepthResp),
        #[prost(message, tag = "24")]
        ViewToColumnsStringResp(super::ViewToColumnsStringResp),
        #[prost(message, tag = "25")]
        ViewToCsvResp(super::ViewToCsvResp),
        #[prost(message, tag = "26")]
        ViewToRowsStringResp(super::ViewToRowsStringResp),
        #[prost(message, tag = "27")]
        MakeTableResp(super::MakeTableResp),
        #[prost(message, tag = "28")]
        TableDeleteResp(super::TableDeleteResp),
        #[prost(message, tag = "29")]
        TableOnDeleteResp(super::TableOnDeleteResp),
        #[prost(message, tag = "30")]
        TableRemoveDeleteResp(super::TableRemoveDeleteResp),
        #[prost(message, tag = "31")]
        TableRemoveResp(super::TableRemoveResp),
        #[prost(message, tag = "32")]
        TableReplaceResp(super::TableReplaceResp),
        #[prost(message, tag = "33")]
        TableUpdateResp(super::TableUpdateResp),
        #[prost(message, tag = "34")]
        ViewOnDeleteResp(super::ViewOnDeleteResp),
        #[prost(message, tag = "35")]
        ViewRemoveDeleteResp(super::ViewRemoveDeleteResp),
        #[prost(message, tag = "50")]
        ServerError(super::ServerError),
    }
}
/// Informs the client of the feature set, e.g. what to expect in the
/// `ViewConfig` message.
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetFeaturesReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetFeaturesResp {
    #[prost(bool, tag = "1")]
    pub group_by: bool,
    #[prost(bool, tag = "2")]
    pub split_by: bool,
    #[prost(bool, tag = "3")]
    pub expressions: bool,
    #[prost(map = "uint32, message", tag = "4")]
    pub filter_ops: ::std::collections::HashMap<
        u32,
        get_features_resp::ColumnTypeOptions,
    >,
}
/// Nested message and enum types in `GetFeaturesResp`.
pub mod get_features_resp {
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ColumnTypeOptions {
        #[prost(string, repeated, tag = "1")]
        pub options: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
}
/// `Client::get_hosted_tables`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetHostedTablesReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetHostedTablesResp {
    #[prost(message, repeated, tag = "1")]
    pub table_infos: ::prost::alloc::vec::Vec<HostedTable>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HostedTable {
    #[prost(string, tag = "1")]
    pub entity_id: ::prost::alloc::string::String,
    #[prost(string, optional, tag = "2")]
    pub index: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(uint32, optional, tag = "3")]
    pub limit: ::core::option::Option<u32>,
}
/// `Table::size`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableSizeReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableSizeResp {
    #[prost(uint32, tag = "2")]
    pub size: u32,
}
/// `Table::schema`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableSchemaReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableSchemaResp {
    #[prost(message, optional, tag = "1")]
    pub schema: ::core::option::Option<Schema>,
}
/// `Table::validate_expressions`
/// TODO: This should be just `validate()`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableValidateExprReq {
    #[prost(map = "string, string", tag = "1")]
    pub column_to_expr: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
#[derive(serde::Serialize)]
#[derive(serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableValidateExprResp {
    #[prost(map = "string, enumeration(ColumnType)", tag = "1")]
    pub expression_schema: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        i32,
    >,
    #[prost(map = "string, message", tag = "2")]
    pub errors: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        table_validate_expr_resp::ExprValidationError,
    >,
    #[prost(map = "string, string", tag = "3")]
    pub expression_alias: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
/// Nested message and enum types in `TableValidateExprResp`.
pub mod table_validate_expr_resp {
    #[derive(serde::Serialize)]
    #[derive(serde::Deserialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ExprValidationError {
        #[prost(string, tag = "1")]
        pub error_message: ::prost::alloc::string::String,
        #[prost(uint32, tag = "2")]
        pub line: u32,
        #[prost(uint32, tag = "3")]
        pub column: u32,
    }
}
/// `Table::view`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableMakeViewReq {
    #[prost(string, tag = "1")]
    pub view_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub config: ::core::option::Option<ViewConfig>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableMakeViewResp {
    #[prost(string, tag = "1")]
    pub view_id: ::prost::alloc::string::String,
}
/// `View::schema`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewSchemaReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewSchemaResp {
    #[prost(map = "string, enumeration(ColumnType)", tag = "1")]
    pub schema: ::std::collections::HashMap<::prost::alloc::string::String, i32>,
}
/// `View::dimensions`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewDimensionsReq {}
#[derive(serde::Serialize)]
#[derive(serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewDimensionsResp {
    #[prost(uint32, tag = "1")]
    pub num_table_rows: u32,
    #[prost(uint32, tag = "2")]
    pub num_table_columns: u32,
    #[prost(uint32, tag = "3")]
    pub num_view_rows: u32,
    #[prost(uint32, tag = "4")]
    pub num_view_columns: u32,
}
/// `View::get_config`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewGetConfigReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewGetConfigResp {
    #[prost(message, optional, tag = "1")]
    pub config: ::core::option::Option<ViewConfig>,
}
/// `Client::table`.
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MakeTableReq {
    #[prost(message, optional, tag = "1")]
    pub data: ::core::option::Option<MakeTableData>,
    #[prost(message, optional, tag = "2")]
    pub options: ::core::option::Option<make_table_req::MakeTableOptions>,
}
/// Nested message and enum types in `MakeTableReq`.
pub mod make_table_req {
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct MakeTableOptions {
        #[prost(oneof = "make_table_options::MakeTableType", tags = "1, 2")]
        pub make_table_type: ::core::option::Option<make_table_options::MakeTableType>,
    }
    /// Nested message and enum types in `MakeTableOptions`.
    pub mod make_table_options {
        #[derive(serde::Serialize)]
        #[allow(clippy::derive_partial_eq_without_eq)]
        #[derive(Clone, PartialEq, ::prost::Oneof)]
        pub enum MakeTableType {
            #[prost(string, tag = "1")]
            MakeIndexTable(::prost::alloc::string::String),
            #[prost(uint32, tag = "2")]
            MakeLimitTable(u32),
        }
    }
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MakeTableResp {}
/// `Table::delete`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableDeleteReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableDeleteResp {}
/// `Table::on_delete`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableOnDeleteReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableOnDeleteResp {}
/// `Table::make_port`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableMakePortReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableMakePortResp {
    #[prost(uint32, tag = "1")]
    pub port_id: u32,
}
/// `Table::remove_delete`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableRemoveDeleteReq {
    #[prost(uint32, tag = "1")]
    pub id: u32,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableRemoveDeleteResp {}
/// `Table::update`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableUpdateReq {
    #[prost(message, optional, tag = "1")]
    pub data: ::core::option::Option<MakeTableData>,
    #[prost(uint32, tag = "2")]
    pub port_id: u32,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableUpdateResp {}
/// `Table::replace`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableReplaceReq {
    #[prost(message, optional, tag = "1")]
    pub data: ::core::option::Option<MakeTableData>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableReplaceResp {}
/// `Table::remove`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableRemoveReq {
    #[prost(message, optional, tag = "1")]
    pub data: ::core::option::Option<MakeTableData>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableRemoveResp {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewOnUpdateReq {
    #[prost(enumeration = "view_on_update_req::Mode", optional, tag = "1")]
    pub mode: ::core::option::Option<i32>,
}
/// Nested message and enum types in `ViewOnUpdateReq`.
pub mod view_on_update_req {
    #[derive(serde::Serialize)]
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Mode {
        Row = 0,
    }
    impl Mode {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Mode::Row => "ROW",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "ROW" => Some(Self::Row),
                _ => None,
            }
        }
    }
}
#[derive(ts_rs::TS)]
#[ts(as = "Vec::<u8>")]
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewOnUpdateResp {
    #[prost(bytes = "vec", optional, tag = "1")]
    #[serde(with = "serde_bytes")]
    pub delta: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    #[prost(uint32, tag = "2")]
    pub port_id: u32,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewOnDeleteReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewOnDeleteResp {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewRemoveDeleteReq {
    #[prost(uint32, tag = "1")]
    pub id: u32,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewRemoveDeleteResp {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewToColumnsStringReq {
    #[prost(message, optional, tag = "1")]
    pub viewport: ::core::option::Option<ViewPort>,
    #[prost(bool, optional, tag = "2")]
    pub id: ::core::option::Option<bool>,
    #[prost(bool, optional, tag = "3")]
    pub index: ::core::option::Option<bool>,
    #[prost(bool, optional, tag = "4")]
    pub formatted: ::core::option::Option<bool>,
    #[prost(bool, optional, tag = "5")]
    pub leaves_only: ::core::option::Option<bool>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewToColumnsStringResp {
    #[prost(string, tag = "1")]
    pub json_string: ::prost::alloc::string::String,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewToRowsStringReq {
    #[prost(message, optional, tag = "1")]
    pub viewport: ::core::option::Option<ViewPort>,
    #[prost(bool, optional, tag = "2")]
    pub id: ::core::option::Option<bool>,
    #[prost(bool, optional, tag = "3")]
    pub index: ::core::option::Option<bool>,
    #[prost(bool, optional, tag = "4")]
    pub formatted: ::core::option::Option<bool>,
    #[prost(bool, optional, tag = "5")]
    pub leaves_only: ::core::option::Option<bool>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewToRowsStringResp {
    #[prost(string, tag = "1")]
    pub json_string: ::prost::alloc::string::String,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewToArrowReq {
    #[prost(message, optional, tag = "1")]
    pub viewport: ::core::option::Option<ViewPort>,
    #[prost(string, optional, tag = "2")]
    pub compression: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewToArrowResp {
    #[prost(bytes = "vec", tag = "1")]
    #[serde(skip)]
    pub arrow: ::prost::alloc::vec::Vec<u8>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewColumnPathsReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewColumnPathsResp {
    /// repeated ColumnPath paths = 1;
    #[prost(string, repeated, tag = "1")]
    pub paths: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewDeleteReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewDeleteResp {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewGetMinMaxReq {
    #[prost(string, tag = "1")]
    pub column_name: ::prost::alloc::string::String,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewGetMinMaxResp {
    #[prost(string, tag = "1")]
    pub min: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub max: ::prost::alloc::string::String,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewExpressionSchemaReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewExpressionSchemaResp {
    #[prost(map = "string, enumeration(ColumnType)", tag = "1")]
    pub schema: ::std::collections::HashMap<::prost::alloc::string::String, i32>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewToCsvReq {
    #[prost(message, optional, tag = "1")]
    pub viewport: ::core::option::Option<ViewPort>,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewToCsvResp {
    #[prost(string, tag = "1")]
    pub csv: ::prost::alloc::string::String,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewRemoveOnUpdateReq {
    #[prost(uint32, tag = "1")]
    pub id: u32,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewRemoveOnUpdateResp {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewCollapseReq {
    #[prost(uint32, tag = "1")]
    pub row_index: u32,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewCollapseResp {
    #[prost(uint32, tag = "1")]
    pub num_changed: u32,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewExpandReq {
    #[prost(uint32, tag = "1")]
    pub row_index: u32,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewExpandResp {
    #[prost(uint32, tag = "1")]
    pub num_changed: u32,
}
/// `View::set_depth`
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewSetDepthReq {
    #[prost(uint32, tag = "1")]
    pub depth: u32,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewSetDepthResp {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerSystemInfoReq {}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerSystemInfoResp {
    #[prost(double, tag = "1")]
    pub heap_size: f64,
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewConfig {
    #[prost(string, repeated, tag = "1")]
    pub group_by: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, repeated, tag = "2")]
    pub split_by: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "3")]
    pub columns: ::core::option::Option<ColumnsUpdate>,
    #[prost(message, repeated, tag = "4")]
    pub filter: ::prost::alloc::vec::Vec<view_config::Filter>,
    #[prost(message, repeated, tag = "5")]
    pub sort: ::prost::alloc::vec::Vec<view_config::Sort>,
    #[prost(map = "string, string", tag = "6")]
    pub expressions: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(map = "string, message", tag = "7")]
    pub aggregates: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        view_config::AggList,
    >,
    #[prost(enumeration = "view_config::FilterReducer", tag = "8")]
    pub filter_op: i32,
    #[prost(uint32, optional, tag = "9")]
    pub group_by_depth: ::core::option::Option<u32>,
}
/// Nested message and enum types in `ViewConfig`.
pub mod view_config {
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct AggList {
        #[prost(string, repeated, tag = "1")]
        pub aggregations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Sort {
        #[prost(string, tag = "1")]
        pub column: ::prost::alloc::string::String,
        #[prost(enumeration = "super::SortOp", tag = "2")]
        pub op: i32,
    }
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Filter {
        #[prost(string, tag = "1")]
        pub column: ::prost::alloc::string::String,
        #[prost(string, tag = "2")]
        pub op: ::prost::alloc::string::String,
        #[prost(message, repeated, tag = "3")]
        pub value: ::prost::alloc::vec::Vec<super::Scalar>,
    }
    #[derive(serde::Serialize)]
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum FilterReducer {
        And = 0,
        Or = 1,
    }
    impl FilterReducer {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                FilterReducer::And => "AND",
                FilterReducer::Or => "OR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "AND" => Some(Self::And),
                "OR" => Some(Self::Or),
                _ => None,
            }
        }
    }
}
#[derive(serde::Serialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ColumnsUpdate {
    #[prost(oneof = "columns_update::OptColumns", tags = "1, 2")]
    pub opt_columns: ::core::option::Option<columns_update::OptColumns>,
}
/// Nested message and enum types in `ColumnsUpdate`.
pub mod columns_update {
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Columns {
        #[prost(string, repeated, tag = "1")]
        pub columns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(serde::Serialize)]
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum OptColumns {
        #[prost(enumeration = "::prost_types::NullValue", tag = "1")]
        DefaultColumns(i32),
        #[prost(message, tag = "2")]
        Columns(Columns),
    }
}
/// View types
#[derive(serde::Serialize)]
#[derive(serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum ColumnType {
    String = 0,
    Date = 1,
    Datetime = 2,
    Integer = 3,
    Float = 4,
    Boolean = 5,
}
impl ColumnType {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            ColumnType::String => "STRING",
            ColumnType::Date => "DATE",
            ColumnType::Datetime => "DATETIME",
            ColumnType::Integer => "INTEGER",
            ColumnType::Float => "FLOAT",
            ColumnType::Boolean => "BOOLEAN",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "STRING" => Some(Self::String),
            "DATE" => Some(Self::Date),
            "DATETIME" => Some(Self::Datetime),
            "INTEGER" => Some(Self::Integer),
            "FLOAT" => Some(Self::Float),
            "BOOLEAN" => Some(Self::Boolean),
            _ => None,
        }
    }
}
/// TODO This belongs in features
#[derive(serde::Serialize)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum SortOp {
    SortNone = 0,
    SortAsc = 1,
    SortDesc = 2,
    SortColAsc = 3,
    SortColDesc = 4,
    SortAscAbs = 5,
    SortDescAbs = 6,
    SortColAscAbs = 7,
    SortColDescAbs = 8,
}
impl SortOp {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            SortOp::SortNone => "SORT_NONE",
            SortOp::SortAsc => "SORT_ASC",
            SortOp::SortDesc => "SORT_DESC",
            SortOp::SortColAsc => "SORT_COL_ASC",
            SortOp::SortColDesc => "SORT_COL_DESC",
            SortOp::SortAscAbs => "SORT_ASC_ABS",
            SortOp::SortDescAbs => "SORT_DESC_ABS",
            SortOp::SortColAscAbs => "SORT_COL_ASC_ABS",
            SortOp::SortColDescAbs => "SORT_COL_DESC_ABS",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "SORT_NONE" => Some(Self::SortNone),
            "SORT_ASC" => Some(Self::SortAsc),
            "SORT_DESC" => Some(Self::SortDesc),
            "SORT_COL_ASC" => Some(Self::SortColAsc),
            "SORT_COL_DESC" => Some(Self::SortColDesc),
            "SORT_ASC_ABS" => Some(Self::SortAscAbs),
            "SORT_DESC_ABS" => Some(Self::SortDescAbs),
            "SORT_COL_ASC_ABS" => Some(Self::SortColAscAbs),
            "SORT_COL_DESC_ABS" => Some(Self::SortColDescAbs),
            _ => None,
        }
    }
}
