/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Jul  7 12:22:47 PDT 2015 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle_c.native -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -n 64 -name t2bv_64 -include t2b.h -sign 1 */

/*
 * This function contains 519 FP additions, 384 FP multiplications,
 * (or, 261 additions, 126 multiplications, 258 fused multiply/add),
 * 187 stack variables, 15 constants, and 128 memory accesses
 */
#include "t2b.h"

static void t2bv_64(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DVK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DVK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DVK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  R *x;
	  x = ii;
	  for (m = mb, W = W + (mb * ((TWVL / VL) * 126)); m < me; m = m + VL, x = x + (VL * ms), W = W + (TWVL * 126), MAKE_VOLATILE_STRIDE(64, rs)) {
	       V T6L, T6M, T6O, T6P, T75, T6V, T5A, T6A, T72, T6K, T6t, T6D, T6w, T6B, T6h;
	       V T6E;
	       {
		    V Ta, T3U, T3V, T37, T7a, T58, T7B, T6l, T1v, T24, T5Q, T7o, T5F, T7l, T43;
		    V T4F, T2i, T2R, T6b, T7v, T60, T7s, T4a, T4I, T5u, T7h, T5x, T7g, T1i, T3b;
		    V T4m, T4C, T7e, T5l, T7d, T5o, T3a, TV, T4B, T4j, T3X, T3Y, T6o, T7b, T5f;
		    V T7C, Tx, T38, T2p, T61, T2n, T65, T2D, T7p, T5M, T7m, T5T, T4G, T46, T25;
		    V T1S, T2q, T2u, T2w;
		    {
			 V T5q, T10, T5v, T15, T1b, T5s, T1c, T1e;
			 {
			      V T1V, T1p, T5B, T5O, T1u, T1X, T20, T21;
			      {
				   V T1, T2, T7, T5, T32, T34, T2X, T2Z;
				   T1 = LD(&(x[0]), ms, &(x[0]));
				   T2 = LD(&(x[WS(rs, 32)]), ms, &(x[0]));
				   T7 = LD(&(x[WS(rs, 48)]), ms, &(x[0]));
				   T5 = LD(&(x[WS(rs, 16)]), ms, &(x[0]));
				   T32 = LD(&(x[WS(rs, 56)]), ms, &(x[0]));
				   T34 = LD(&(x[WS(rs, 24)]), ms, &(x[0]));
				   T2X = LD(&(x[WS(rs, 8)]), ms, &(x[0]));
				   T2Z = LD(&(x[WS(rs, 40)]), ms, &(x[0]));
				   {
					V T1m, T54, T6j, T36, T56, T31, T55, T1n, T1q, T1s, T4, T9;
					{
					     V T3, T8, T6, T33, T35, T2Y, T30, T1l;
					     T1l = LD(&(x[WS(rs, 1)]), ms, &(x[WS(rs, 1)]));
					     T3 = BYTW(&(W[TWVL * 62]), T2);
					     T8 = BYTW(&(W[TWVL * 94]), T7);
					     T6 = BYTW(&(W[TWVL * 30]), T5);
					     T33 = BYTW(&(W[TWVL * 110]), T32);
					     T35 = BYTW(&(W[TWVL * 46]), T34);
					     T2Y = BYTW(&(W[TWVL * 14]), T2X);
					     T30 = BYTW(&(W[TWVL * 78]), T2Z);
					     T1m = BYTW(&(W[0]), T1l);
					     T54 = VSUB(T1, T3);
					     T4 = VADD(T1, T3);
					     T6j = VSUB(T6, T8);
					     T9 = VADD(T6, T8);
					     T36 = VADD(T33, T35);
					     T56 = VSUB(T33, T35);
					     T31 = VADD(T2Y, T30);
					     T55 = VSUB(T2Y, T30);
					     T1n = LD(&(x[WS(rs, 33)]), ms, &(x[WS(rs, 1)]));
					}
					T1q = LD(&(x[WS(rs, 17)]), ms, &(x[WS(rs, 1)]));
					T1s = LD(&(x[WS(rs, 49)]), ms, &(x[WS(rs, 1)]));
					Ta = VSUB(T4, T9);
					T3U = VADD(T4, T9);
					{
					     V T57, T6k, T1o, T1r, T1t, T1W, T1U, T1Z;
					     T1U = LD(&(x[WS(rs, 9)]), ms, &(x[WS(rs, 1)]));
					     T3V = VADD(T31, T36);
					     T37 = VSUB(T31, T36);
					     T57 = VADD(T55, T56);
					     T6k = VSUB(T55, T56);
					     T1o = BYTW(&(W[TWVL * 64]), T1n);
					     T1r = BYTW(&(W[TWVL * 32]), T1q);
					     T1t = BYTW(&(W[TWVL * 96]), T1s);
					     T1V = BYTW(&(W[TWVL * 16]), T1U);
					     T1W = LD(&(x[WS(rs, 41)]), ms, &(x[WS(rs, 1)]));
					     T1Z = LD(&(x[WS(rs, 57)]), ms, &(x[WS(rs, 1)]));
					     T7a = VFNMS(LDK(KP707106781), T57, T54);
					     T58 = VFMA(LDK(KP707106781), T57, T54);
					     T7B = VFNMS(LDK(KP707106781), T6k, T6j);
					     T6l = VFMA(LDK(KP707106781), T6k, T6j);
					     T1p = VADD(T1m, T1o);
					     T5B = VSUB(T1m, T1o);
					     T5O = VSUB(T1r, T1t);
					     T1u = VADD(T1r, T1t);
					     T1X = BYTW(&(W[TWVL * 80]), T1W);
					     T20 = BYTW(&(W[TWVL * 112]), T1Z);
					     T21 = LD(&(x[WS(rs, 25)]), ms, &(x[WS(rs, 1)]));
					}
				   }
			      }
			      {
				   V T5W, T2N, T69, T2L, T5Y, T2P, T48, T2c, T2h;
				   {
					V T41, T1Y, T5C, T22, T2d, T29, T2b, T2f, T28, T2a, T2H, T2J;
					T28 = LD(&(x[WS(rs, 63)]), ms, &(x[WS(rs, 1)]));
					T2a = LD(&(x[WS(rs, 31)]), ms, &(x[WS(rs, 1)]));
					T1v = VSUB(T1p, T1u);
					T41 = VADD(T1p, T1u);
					T1Y = VADD(T1V, T1X);
					T5C = VSUB(T1V, T1X);
					T22 = BYTW(&(W[TWVL * 48]), T21);
					T2d = LD(&(x[WS(rs, 15)]), ms, &(x[WS(rs, 1)]));
					T29 = BYTW(&(W[TWVL * 124]), T28);
					T2b = BYTW(&(W[TWVL * 60]), T2a);
					T2f = LD(&(x[WS(rs, 47)]), ms, &(x[WS(rs, 1)]));
					T2H = LD(&(x[WS(rs, 55)]), ms, &(x[WS(rs, 1)]));
					T2J = LD(&(x[WS(rs, 23)]), ms, &(x[WS(rs, 1)]));
					{
					     V T23, T5D, T2e, T2g, T2I, T2K, T2M;
					     T2M = LD(&(x[WS(rs, 7)]), ms, &(x[WS(rs, 1)]));
					     T23 = VADD(T20, T22);
					     T5D = VSUB(T20, T22);
					     T2e = BYTW(&(W[TWVL * 28]), T2d);
					     T2c = VADD(T29, T2b);
					     T5W = VSUB(T29, T2b);
					     T2g = BYTW(&(W[TWVL * 92]), T2f);
					     T2I = BYTW(&(W[TWVL * 108]), T2H);
					     T2K = BYTW(&(W[TWVL * 44]), T2J);
					     T2N = BYTW(&(W[TWVL * 12]), T2M);
					     {
						  V T5E, T5P, T42, T2O;
						  T5E = VADD(T5C, T5D);
						  T5P = VSUB(T5C, T5D);
						  T24 = VSUB(T1Y, T23);
						  T42 = VADD(T1Y, T23);
						  T69 = VSUB(T2g, T2e);
						  T2h = VADD(T2e, T2g);
						  T2O = LD(&(x[WS(rs, 39)]), ms, &(x[WS(rs, 1)]));
						  T2L = VADD(T2I, T2K);
						  T5Y = VSUB(T2I, T2K);
						  T5Q = VFMA(LDK(KP707106781), T5P, T5O);
						  T7o = VFNMS(LDK(KP707106781), T5P, T5O);
						  T5F = VFMA(LDK(KP707106781), T5E, T5B);
						  T7l = VFNMS(LDK(KP707106781), T5E, T5B);
						  T43 = VADD(T41, T42);
						  T4F = VSUB(T41, T42);
						  T2P = BYTW(&(W[TWVL * 76]), T2O);
					     }
					}
				   }
				   T2i = VSUB(T2c, T2h);
				   T48 = VADD(T2c, T2h);
				   {
					V TW, TY, T11, T2Q, T5X, T13;
					TW = LD(&(x[WS(rs, 62)]), ms, &(x[0]));
					TY = LD(&(x[WS(rs, 30)]), ms, &(x[0]));
					T11 = LD(&(x[WS(rs, 14)]), ms, &(x[0]));
					T2Q = VADD(T2N, T2P);
					T5X = VSUB(T2N, T2P);
					T13 = LD(&(x[WS(rs, 46)]), ms, &(x[0]));
					{
					     V T12, T5Z, T6a, T49, T14, T18, T1a;
					     {
						  V T17, T19, TX, TZ;
						  T17 = LD(&(x[WS(rs, 54)]), ms, &(x[0]));
						  T19 = LD(&(x[WS(rs, 22)]), ms, &(x[0]));
						  TX = BYTW(&(W[TWVL * 122]), TW);
						  TZ = BYTW(&(W[TWVL * 58]), TY);
						  T12 = BYTW(&(W[TWVL * 26]), T11);
						  T5Z = VADD(T5X, T5Y);
						  T6a = VSUB(T5Y, T5X);
						  T2R = VSUB(T2L, T2Q);
						  T49 = VADD(T2Q, T2L);
						  T14 = BYTW(&(W[TWVL * 90]), T13);
						  T18 = BYTW(&(W[TWVL * 106]), T17);
						  T5q = VSUB(TX, TZ);
						  T10 = VADD(TX, TZ);
						  T1a = BYTW(&(W[TWVL * 42]), T19);
					     }
					     T6b = VFMA(LDK(KP707106781), T6a, T69);
					     T7v = VFNMS(LDK(KP707106781), T6a, T69);
					     T60 = VFMA(LDK(KP707106781), T5Z, T5W);
					     T7s = VFNMS(LDK(KP707106781), T5Z, T5W);
					     T4a = VADD(T48, T49);
					     T4I = VSUB(T48, T49);
					     T5v = VSUB(T14, T12);
					     T15 = VADD(T12, T14);
					     T1b = VADD(T18, T1a);
					     T5s = VSUB(T18, T1a);
					}
					T1c = LD(&(x[WS(rs, 6)]), ms, &(x[0]));
					T1e = LD(&(x[WS(rs, 38)]), ms, &(x[0]));
				   }
			      }
			 }
			 {
			      V Th, T59, Tf, Tv, T5d, Tj, Tm, To;
			      {
				   V T5h, TQ, T5m, T5i, TO, TS, TJ, T4h, TD, TI;
				   {
					V T4k, T16, TB, T1d, T1f, TE, TG, TA, Tz, TK, TM, TC;
					Tz = LD(&(x[WS(rs, 2)]), ms, &(x[0]));
					T4k = VADD(T10, T15);
					T16 = VSUB(T10, T15);
					TB = LD(&(x[WS(rs, 34)]), ms, &(x[0]));
					T1d = BYTW(&(W[TWVL * 10]), T1c);
					T1f = BYTW(&(W[TWVL * 74]), T1e);
					TE = LD(&(x[WS(rs, 18)]), ms, &(x[0]));
					TG = LD(&(x[WS(rs, 50)]), ms, &(x[0]));
					TA = BYTW(&(W[TWVL * 2]), Tz);
					TK = LD(&(x[WS(rs, 10)]), ms, &(x[0]));
					TM = LD(&(x[WS(rs, 42)]), ms, &(x[0]));
					TC = BYTW(&(W[TWVL * 66]), TB);
					{
					     V T1g, T5r, TF, TH, TL, TN, TP;
					     TP = LD(&(x[WS(rs, 58)]), ms, &(x[0]));
					     T1g = VADD(T1d, T1f);
					     T5r = VSUB(T1d, T1f);
					     TF = BYTW(&(W[TWVL * 34]), TE);
					     TH = BYTW(&(W[TWVL * 98]), TG);
					     TL = BYTW(&(W[TWVL * 18]), TK);
					     TN = BYTW(&(W[TWVL * 82]), TM);
					     T5h = VSUB(TA, TC);
					     TD = VADD(TA, TC);
					     TQ = BYTW(&(W[TWVL * 114]), TP);
					     {
						  V T5w, T5t, T4l, T1h, TR;
						  T5w = VSUB(T5s, T5r);
						  T5t = VADD(T5r, T5s);
						  T4l = VADD(T1g, T1b);
						  T1h = VSUB(T1b, T1g);
						  T5m = VSUB(TF, TH);
						  TI = VADD(TF, TH);
						  T5i = VSUB(TL, TN);
						  TO = VADD(TL, TN);
						  TR = LD(&(x[WS(rs, 26)]), ms, &(x[0]));
						  T5u = VFMA(LDK(KP707106781), T5t, T5q);
						  T7h = VFNMS(LDK(KP707106781), T5t, T5q);
						  T5x = VFMA(LDK(KP707106781), T5w, T5v);
						  T7g = VFNMS(LDK(KP707106781), T5w, T5v);
						  T1i = VFNMS(LDK(KP414213562), T1h, T16);
						  T3b = VFMA(LDK(KP414213562), T16, T1h);
						  T4m = VADD(T4k, T4l);
						  T4C = VSUB(T4k, T4l);
						  TS = BYTW(&(W[TWVL * 50]), TR);
					     }
					}
				   }
				   TJ = VSUB(TD, TI);
				   T4h = VADD(TD, TI);
				   {
					V Tb, Td, Tr, T5j, TT, Tt, Tg;
					Tb = LD(&(x[WS(rs, 4)]), ms, &(x[0]));
					Td = LD(&(x[WS(rs, 36)]), ms, &(x[0]));
					Tr = LD(&(x[WS(rs, 12)]), ms, &(x[0]));
					T5j = VSUB(TQ, TS);
					TT = VADD(TQ, TS);
					Tt = LD(&(x[WS(rs, 44)]), ms, &(x[0]));
					Tg = LD(&(x[WS(rs, 20)]), ms, &(x[0]));
					{
					     V Ti, Tc, Te, Ts;
					     Ti = LD(&(x[WS(rs, 52)]), ms, &(x[0]));
					     Tc = BYTW(&(W[TWVL * 6]), Tb);
					     Te = BYTW(&(W[TWVL * 70]), Td);
					     Ts = BYTW(&(W[TWVL * 22]), Tr);
					     {
						  V T5k, T5n, TU, T4i, Tu;
						  T5k = VADD(T5i, T5j);
						  T5n = VSUB(T5i, T5j);
						  TU = VSUB(TO, TT);
						  T4i = VADD(TO, TT);
						  Tu = BYTW(&(W[TWVL * 86]), Tt);
						  Th = BYTW(&(W[TWVL * 38]), Tg);
						  T59 = VSUB(Tc, Te);
						  Tf = VADD(Tc, Te);
						  T7e = VFNMS(LDK(KP707106781), T5k, T5h);
						  T5l = VFMA(LDK(KP707106781), T5k, T5h);
						  T7d = VFNMS(LDK(KP707106781), T5n, T5m);
						  T5o = VFMA(LDK(KP707106781), T5n, T5m);
						  T3a = VFMA(LDK(KP414213562), TJ, TU);
						  TV = VFNMS(LDK(KP414213562), TU, TJ);
						  T4B = VSUB(T4h, T4i);
						  T4j = VADD(T4h, T4i);
						  Tv = VADD(Ts, Tu);
						  T5d = VSUB(Tu, Ts);
						  Tj = BYTW(&(W[TWVL * 102]), Ti);
					     }
					}
					Tm = LD(&(x[WS(rs, 60)]), ms, &(x[0]));
					To = LD(&(x[WS(rs, 28)]), ms, &(x[0]));
				   }
			      }
			      {
				   V T5b, T6m, Tl, T1A, T5G, T1Q, T5K, T1C, T1D, T5e, T6n, Tw, T1H, T1J;
				   {
					V T1w, T1y, T1M, T1O, Tq, T5c, T1B;
					T1w = LD(&(x[WS(rs, 5)]), ms, &(x[WS(rs, 1)]));
					T1y = LD(&(x[WS(rs, 37)]), ms, &(x[WS(rs, 1)]));
					T1M = LD(&(x[WS(rs, 13)]), ms, &(x[WS(rs, 1)]));
					T1O = LD(&(x[WS(rs, 45)]), ms, &(x[WS(rs, 1)]));
					T1B = LD(&(x[WS(rs, 21)]), ms, &(x[WS(rs, 1)]));
					{
					     V Tk, T5a, Tn, Tp;
					     Tk = VADD(Th, Tj);
					     T5a = VSUB(Th, Tj);
					     Tn = BYTW(&(W[TWVL * 118]), Tm);
					     Tp = BYTW(&(W[TWVL * 54]), To);
					     {
						  V T1x, T1z, T1N, T1P;
						  T1x = BYTW(&(W[TWVL * 8]), T1w);
						  T1z = BYTW(&(W[TWVL * 72]), T1y);
						  T1N = BYTW(&(W[TWVL * 24]), T1M);
						  T1P = BYTW(&(W[TWVL * 88]), T1O);
						  T5b = VFNMS(LDK(KP414213562), T5a, T59);
						  T6m = VFMA(LDK(KP414213562), T59, T5a);
						  T3X = VADD(Tf, Tk);
						  Tl = VSUB(Tf, Tk);
						  Tq = VADD(Tn, Tp);
						  T5c = VSUB(Tn, Tp);
						  T1A = VADD(T1x, T1z);
						  T5G = VSUB(T1x, T1z);
						  T1Q = VADD(T1N, T1P);
						  T5K = VSUB(T1N, T1P);
						  T1C = BYTW(&(W[TWVL * 40]), T1B);
					     }
					}
					T1D = LD(&(x[WS(rs, 53)]), ms, &(x[WS(rs, 1)]));
					T5e = VFNMS(LDK(KP414213562), T5d, T5c);
					T6n = VFMA(LDK(KP414213562), T5c, T5d);
					T3Y = VADD(Tq, Tv);
					Tw = VSUB(Tq, Tv);
					T1H = LD(&(x[WS(rs, 61)]), ms, &(x[WS(rs, 1)]));
					T1J = LD(&(x[WS(rs, 29)]), ms, &(x[WS(rs, 1)]));
				   }
				   {
					V T1I, T1K, T1F, T5H, T2k, T2l, T2z, T2B, T2j, T1E;
					T2j = LD(&(x[WS(rs, 3)]), ms, &(x[WS(rs, 1)]));
					T1E = BYTW(&(W[TWVL * 104]), T1D);
					T6o = VSUB(T6m, T6n);
					T7b = VADD(T6m, T6n);
					T5f = VADD(T5b, T5e);
					T7C = VSUB(T5b, T5e);
					Tx = VADD(Tl, Tw);
					T38 = VSUB(Tl, Tw);
					T1I = BYTW(&(W[TWVL * 120]), T1H);
					T1K = BYTW(&(W[TWVL * 56]), T1J);
					T1F = VADD(T1C, T1E);
					T5H = VSUB(T1C, T1E);
					T2k = BYTW(&(W[TWVL * 4]), T2j);
					T2l = LD(&(x[WS(rs, 35)]), ms, &(x[WS(rs, 1)]));
					T2z = LD(&(x[WS(rs, 11)]), ms, &(x[WS(rs, 1)]));
					T2B = LD(&(x[WS(rs, 43)]), ms, &(x[WS(rs, 1)]));
					{
					     V T5I, T5R, T44, T1G, T2m, T2A, T2C, T5S, T5L, T1R, T45, T2o, T5J, T1L;
					     T2o = LD(&(x[WS(rs, 19)]), ms, &(x[WS(rs, 1)]));
					     T5J = VSUB(T1I, T1K);
					     T1L = VADD(T1I, T1K);
					     T5I = VFNMS(LDK(KP414213562), T5H, T5G);
					     T5R = VFMA(LDK(KP414213562), T5G, T5H);
					     T44 = VADD(T1A, T1F);
					     T1G = VSUB(T1A, T1F);
					     T2m = BYTW(&(W[TWVL * 68]), T2l);
					     T2A = BYTW(&(W[TWVL * 20]), T2z);
					     T2C = BYTW(&(W[TWVL * 84]), T2B);
					     T5S = VFNMS(LDK(KP414213562), T5J, T5K);
					     T5L = VFMA(LDK(KP414213562), T5K, T5J);
					     T1R = VSUB(T1L, T1Q);
					     T45 = VADD(T1L, T1Q);
					     T2p = BYTW(&(W[TWVL * 36]), T2o);
					     T61 = VSUB(T2k, T2m);
					     T2n = VADD(T2k, T2m);
					     T65 = VSUB(T2C, T2A);
					     T2D = VADD(T2A, T2C);
					     T7p = VSUB(T5I, T5L);
					     T5M = VADD(T5I, T5L);
					     T7m = VSUB(T5R, T5S);
					     T5T = VADD(T5R, T5S);
					     T4G = VSUB(T44, T45);
					     T46 = VADD(T44, T45);
					     T25 = VSUB(T1G, T1R);
					     T1S = VADD(T1G, T1R);
					     T2q = LD(&(x[WS(rs, 51)]), ms, &(x[WS(rs, 1)]));
					}
					T2u = LD(&(x[WS(rs, 59)]), ms, &(x[WS(rs, 1)]));
					T2w = LD(&(x[WS(rs, 27)]), ms, &(x[WS(rs, 1)]));
				   }
			      }
			 }
		    }
		    {
			 V T67, T7w, T6e, T7t, T3s, T3E, T39, T3D, T1k, T3k, T3t, T3c, T1T, T3v, T3w;
			 V T26, T2G, T3y, T3z, T2T;
			 {
			      V T4A, T4N, T47, T4v, T2r, T2v, T2x, T4s, T40, T3W, T3Z;
			      T4A = VSUB(T3U, T3V);
			      T3W = VADD(T3U, T3V);
			      T3Z = VADD(T3X, T3Y);
			      T4N = VSUB(T3X, T3Y);
			      T47 = VSUB(T43, T46);
			      T4v = VADD(T43, T46);
			      T2r = BYTW(&(W[TWVL * 100]), T2q);
			      T2v = BYTW(&(W[TWVL * 116]), T2u);
			      T2x = BYTW(&(W[TWVL * 52]), T2w);
			      T4s = VADD(T3W, T3Z);
			      T40 = VSUB(T3W, T3Z);
			      {
				   V T4O, T4n, T4Q, T4H, T4E, T4W, T4u, T4y, T4d, T4J, T2F, T2S;
				   {
					V T6c, T63, T2t, T4b, T6d, T66, T2E, T4c;
					{
					     V T4D, T62, T2s, T64, T2y, T4t;
					     T4O = VSUB(T4B, T4C);
					     T4D = VADD(T4B, T4C);
					     T62 = VSUB(T2r, T2p);
					     T2s = VADD(T2p, T2r);
					     T64 = VSUB(T2v, T2x);
					     T2y = VADD(T2v, T2x);
					     T4t = VADD(T4j, T4m);
					     T4n = VSUB(T4j, T4m);
					     T4Q = VFMA(LDK(KP414213562), T4F, T4G);
					     T4H = VFNMS(LDK(KP414213562), T4G, T4F);
					     T4E = VFMA(LDK(KP707106781), T4D, T4A);
					     T4W = VFNMS(LDK(KP707106781), T4D, T4A);
					     T6c = VFNMS(LDK(KP414213562), T61, T62);
					     T63 = VFMA(LDK(KP414213562), T62, T61);
					     T2t = VSUB(T2n, T2s);
					     T4b = VADD(T2n, T2s);
					     T6d = VFMA(LDK(KP414213562), T64, T65);
					     T66 = VFNMS(LDK(KP414213562), T65, T64);
					     T2E = VSUB(T2y, T2D);
					     T4c = VADD(T2y, T2D);
					     T4u = VSUB(T4s, T4t);
					     T4y = VADD(T4s, T4t);
					}
					T67 = VADD(T63, T66);
					T7w = VSUB(T66, T63);
					T6e = VADD(T6c, T6d);
					T7t = VSUB(T6d, T6c);
					T4d = VADD(T4b, T4c);
					T4J = VSUB(T4c, T4b);
					T2F = VADD(T2t, T2E);
					T2S = VSUB(T2E, T2t);
				   }
				   {
					V Ty, T1j, T4R, T4K;
					Ty = VFMA(LDK(KP707106781), Tx, Ta);
					T3s = VFNMS(LDK(KP707106781), Tx, Ta);
					T3E = VSUB(TV, T1i);
					T1j = VADD(TV, T1i);
					T39 = VFMA(LDK(KP707106781), T38, T37);
					T3D = VFNMS(LDK(KP707106781), T38, T37);
					T4R = VFMA(LDK(KP414213562), T4I, T4J);
					T4K = VFNMS(LDK(KP414213562), T4J, T4I);
					{
					     V T4w, T4e, T4P, T4Z;
					     T4w = VADD(T4a, T4d);
					     T4e = VSUB(T4a, T4d);
					     T4P = VFMA(LDK(KP707106781), T4O, T4N);
					     T4Z = VFNMS(LDK(KP707106781), T4O, T4N);
					     T1k = VFMA(LDK(KP923879532), T1j, Ty);
					     T3k = VFNMS(LDK(KP923879532), T1j, Ty);
					     {
						  V T4L, T50, T4S, T4X;
						  T4L = VADD(T4H, T4K);
						  T50 = VSUB(T4H, T4K);
						  T4S = VSUB(T4Q, T4R);
						  T4X = VADD(T4Q, T4R);
						  {
						       V T4f, T4o, T4x, T4z;
						       T4f = VADD(T47, T4e);
						       T4o = VSUB(T47, T4e);
						       T4x = VSUB(T4v, T4w);
						       T4z = VADD(T4v, T4w);
						       {
							    V T53, T51, T4M, T4U;
							    T53 = VFNMS(LDK(KP923879532), T50, T4Z);
							    T51 = VFMA(LDK(KP923879532), T50, T4Z);
							    T4M = VFNMS(LDK(KP923879532), T4L, T4E);
							    T4U = VFMA(LDK(KP923879532), T4L, T4E);
							    {
								 V T52, T4Y, T4T, T4V;
								 T52 = VFMA(LDK(KP923879532), T4X, T4W);
								 T4Y = VFNMS(LDK(KP923879532), T4X, T4W);
								 T4T = VFNMS(LDK(KP923879532), T4S, T4P);
								 T4V = VFMA(LDK(KP923879532), T4S, T4P);
								 {
								      V T4p, T4r, T4g, T4q;
								      T4p = VFNMS(LDK(KP707106781), T4o, T4n);
								      T4r = VFMA(LDK(KP707106781), T4o, T4n);
								      T4g = VFNMS(LDK(KP707106781), T4f, T40);
								      T4q = VFMA(LDK(KP707106781), T4f, T40);
								      ST(&(x[0]), VADD(T4y, T4z), ms, &(x[0]));
								      ST(&(x[WS(rs, 32)]), VSUB(T4y, T4z), ms, &(x[0]));
								      ST(&(x[WS(rs, 16)]), VFMAI(T4x, T4u), ms, &(x[0]));
								      ST(&(x[WS(rs, 48)]), VFNMSI(T4x, T4u), ms, &(x[0]));
								      ST(&(x[WS(rs, 44)]), VFNMSI(T51, T4Y), ms, &(x[0]));
								      ST(&(x[WS(rs, 20)]), VFMAI(T51, T4Y), ms, &(x[0]));
								      ST(&(x[WS(rs, 52)]), VFMAI(T53, T52), ms, &(x[0]));
								      ST(&(x[WS(rs, 12)]), VFNMSI(T53, T52), ms, &(x[0]));
								      ST(&(x[WS(rs, 4)]), VFMAI(T4V, T4U), ms, &(x[0]));
								      ST(&(x[WS(rs, 60)]), VFNMSI(T4V, T4U), ms, &(x[0]));
								      ST(&(x[WS(rs, 36)]), VFMAI(T4T, T4M), ms, &(x[0]));
								      ST(&(x[WS(rs, 28)]), VFNMSI(T4T, T4M), ms, &(x[0]));
								      ST(&(x[WS(rs, 56)]), VFNMSI(T4r, T4q), ms, &(x[0]));
								      ST(&(x[WS(rs, 8)]), VFMAI(T4r, T4q), ms, &(x[0]));
								      ST(&(x[WS(rs, 40)]), VFMAI(T4p, T4g), ms, &(x[0]));
								      ST(&(x[WS(rs, 24)]), VFNMSI(T4p, T4g), ms, &(x[0]));
								      T3t = VADD(T3a, T3b);
								      T3c = VSUB(T3a, T3b);
								 }
							    }
						       }
						  }
					     }
					}
					T1T = VFMA(LDK(KP707106781), T1S, T1v);
					T3v = VFNMS(LDK(KP707106781), T1S, T1v);
					T3w = VFNMS(LDK(KP707106781), T25, T24);
					T26 = VFMA(LDK(KP707106781), T25, T24);
					T2G = VFMA(LDK(KP707106781), T2F, T2i);
					T3y = VFNMS(LDK(KP707106781), T2F, T2i);
					T3z = VFNMS(LDK(KP707106781), T2S, T2R);
					T2T = VFMA(LDK(KP707106781), T2S, T2R);
				   }
			      }
			 }
			 {
			      V T3u, T3M, T3F, T3P, T3x, T3G, T3q, T3m, T3h, T3j, T3r, T3p, T2W, T3i;
			      {
				   V T3d, T3n, T27, T3e, T2U, T3f;
				   T3d = VFMA(LDK(KP923879532), T3c, T39);
				   T3n = VFNMS(LDK(KP923879532), T3c, T39);
				   T27 = VFNMS(LDK(KP198912367), T26, T1T);
				   T3e = VFMA(LDK(KP198912367), T1T, T26);
				   T2U = VFNMS(LDK(KP198912367), T2T, T2G);
				   T3f = VFMA(LDK(KP198912367), T2G, T2T);
				   T3u = VFMA(LDK(KP923879532), T3t, T3s);
				   T3M = VFNMS(LDK(KP923879532), T3t, T3s);
				   {
					V T3g, T3l, T2V, T3o;
					T3g = VSUB(T3e, T3f);
					T3l = VADD(T3e, T3f);
					T2V = VADD(T27, T2U);
					T3o = VSUB(T27, T2U);
					T3F = VFNMS(LDK(KP923879532), T3E, T3D);
					T3P = VFMA(LDK(KP923879532), T3E, T3D);
					T3x = VFMA(LDK(KP668178637), T3w, T3v);
					T3G = VFNMS(LDK(KP668178637), T3v, T3w);
					T3q = VFMA(LDK(KP980785280), T3l, T3k);
					T3m = VFNMS(LDK(KP980785280), T3l, T3k);
					T3h = VFNMS(LDK(KP980785280), T3g, T3d);
					T3j = VFMA(LDK(KP980785280), T3g, T3d);
					T3r = VFNMS(LDK(KP980785280), T3o, T3n);
					T3p = VFMA(LDK(KP980785280), T3o, T3n);
					T2W = VFNMS(LDK(KP980785280), T2V, T1k);
					T3i = VFMA(LDK(KP980785280), T2V, T1k);
				   }
			      }
			      {
				   V T7n, T7Z, T8j, T89, T7k, T7O, T8g, T7Y, T7H, T7R, T80, T7q, T7u, T82, T83;
				   V T7x;
				   {
					V T7c, T7W, T7D, T87, T7f, T7E, T3A, T3H, T7F, T7i;
					T7c = VFNMS(LDK(KP923879532), T7b, T7a);
					T7W = VFMA(LDK(KP923879532), T7b, T7a);
					T7D = VFMA(LDK(KP923879532), T7C, T7B);
					T87 = VFNMS(LDK(KP923879532), T7C, T7B);
					T7f = VFNMS(LDK(KP668178637), T7e, T7d);
					T7E = VFMA(LDK(KP668178637), T7d, T7e);
					ST(&(x[WS(rs, 46)]), VFNMSI(T3p, T3m), ms, &(x[0]));
					ST(&(x[WS(rs, 18)]), VFMAI(T3p, T3m), ms, &(x[0]));
					ST(&(x[WS(rs, 50)]), VFMAI(T3r, T3q), ms, &(x[0]));
					ST(&(x[WS(rs, 14)]), VFNMSI(T3r, T3q), ms, &(x[0]));
					ST(&(x[WS(rs, 2)]), VFMAI(T3j, T3i), ms, &(x[0]));
					ST(&(x[WS(rs, 62)]), VFNMSI(T3j, T3i), ms, &(x[0]));
					ST(&(x[WS(rs, 34)]), VFMAI(T3h, T2W), ms, &(x[0]));
					ST(&(x[WS(rs, 30)]), VFNMSI(T3h, T2W), ms, &(x[0]));
					T3A = VFMA(LDK(KP668178637), T3z, T3y);
					T3H = VFNMS(LDK(KP668178637), T3y, T3z);
					T7F = VFMA(LDK(KP668178637), T7g, T7h);
					T7i = VFNMS(LDK(KP668178637), T7h, T7g);
					T7n = VFNMS(LDK(KP923879532), T7m, T7l);
					T7Z = VFMA(LDK(KP923879532), T7m, T7l);
					{
					     V T3I, T3N, T3B, T3Q;
					     T3I = VSUB(T3G, T3H);
					     T3N = VADD(T3G, T3H);
					     T3B = VADD(T3x, T3A);
					     T3Q = VSUB(T3x, T3A);
					     {
						  V T7j, T88, T7G, T7X;
						  T7j = VADD(T7f, T7i);
						  T88 = VSUB(T7f, T7i);
						  T7G = VSUB(T7E, T7F);
						  T7X = VADD(T7E, T7F);
						  {
						       V T3S, T3O, T3J, T3L;
						       T3S = VFNMS(LDK(KP831469612), T3N, T3M);
						       T3O = VFMA(LDK(KP831469612), T3N, T3M);
						       T3J = VFNMS(LDK(KP831469612), T3I, T3F);
						       T3L = VFMA(LDK(KP831469612), T3I, T3F);
						       {
							    V T3T, T3R, T3C, T3K;
							    T3T = VFMA(LDK(KP831469612), T3Q, T3P);
							    T3R = VFNMS(LDK(KP831469612), T3Q, T3P);
							    T3C = VFNMS(LDK(KP831469612), T3B, T3u);
							    T3K = VFMA(LDK(KP831469612), T3B, T3u);
							    T8j = VFNMS(LDK(KP831469612), T88, T87);
							    T89 = VFMA(LDK(KP831469612), T88, T87);
							    T7k = VFNMS(LDK(KP831469612), T7j, T7c);
							    T7O = VFMA(LDK(KP831469612), T7j, T7c);
							    T8g = VFNMS(LDK(KP831469612), T7X, T7W);
							    T7Y = VFMA(LDK(KP831469612), T7X, T7W);
							    T7H = VFMA(LDK(KP831469612), T7G, T7D);
							    T7R = VFNMS(LDK(KP831469612), T7G, T7D);
							    ST(&(x[WS(rs, 42)]), VFMAI(T3R, T3O), ms, &(x[0]));
							    ST(&(x[WS(rs, 22)]), VFNMSI(T3R, T3O), ms, &(x[0]));
							    ST(&(x[WS(rs, 54)]), VFNMSI(T3T, T3S), ms, &(x[0]));
							    ST(&(x[WS(rs, 10)]), VFMAI(T3T, T3S), ms, &(x[0]));
							    ST(&(x[WS(rs, 58)]), VFMAI(T3L, T3K), ms, &(x[0]));
							    ST(&(x[WS(rs, 6)]), VFNMSI(T3L, T3K), ms, &(x[0]));
							    ST(&(x[WS(rs, 26)]), VFMAI(T3J, T3C), ms, &(x[0]));
							    ST(&(x[WS(rs, 38)]), VFNMSI(T3J, T3C), ms, &(x[0]));
							    T80 = VFNMS(LDK(KP923879532), T7p, T7o);
							    T7q = VFMA(LDK(KP923879532), T7p, T7o);
						       }
						  }
					     }
					}
					T7u = VFNMS(LDK(KP923879532), T7t, T7s);
					T82 = VFMA(LDK(KP923879532), T7t, T7s);
					T83 = VFNMS(LDK(KP923879532), T7w, T7v);
					T7x = VFMA(LDK(KP923879532), T7w, T7v);
				   }
				   {
					V T5g, T6I, T6p, T6T, T5p, T6q, T6r, T5y;
					T5g = VFMA(LDK(KP923879532), T5f, T58);
					T6I = VFNMS(LDK(KP923879532), T5f, T58);
					{
					     V T7r, T7I, T7y, T7J;
					     T7r = VFNMS(LDK(KP534511135), T7q, T7n);
					     T7I = VFMA(LDK(KP534511135), T7n, T7q);
					     T7y = VFNMS(LDK(KP534511135), T7x, T7u);
					     T7J = VFMA(LDK(KP534511135), T7u, T7x);
					     {
						  V T81, T8a, T84, T8b;
						  T81 = VFMA(LDK(KP303346683), T80, T7Z);
						  T8a = VFNMS(LDK(KP303346683), T7Z, T80);
						  T84 = VFMA(LDK(KP303346683), T83, T82);
						  T8b = VFNMS(LDK(KP303346683), T82, T83);
						  T6p = VFMA(LDK(KP923879532), T6o, T6l);
						  T6T = VFNMS(LDK(KP923879532), T6o, T6l);
						  T5p = VFNMS(LDK(KP198912367), T5o, T5l);
						  T6q = VFMA(LDK(KP198912367), T5l, T5o);
						  {
						       V T7K, T7P, T7z, T7S;
						       T7K = VSUB(T7I, T7J);
						       T7P = VADD(T7I, T7J);
						       T7z = VADD(T7r, T7y);
						       T7S = VSUB(T7r, T7y);
						       {
							    V T8c, T8h, T85, T8k;
							    T8c = VSUB(T8a, T8b);
							    T8h = VADD(T8a, T8b);
							    T85 = VADD(T81, T84);
							    T8k = VSUB(T81, T84);
							    {
								 V T7Q, T7U, T7L, T7N;
								 T7Q = VFNMS(LDK(KP881921264), T7P, T7O);
								 T7U = VFMA(LDK(KP881921264), T7P, T7O);
								 T7L = VFNMS(LDK(KP881921264), T7K, T7H);
								 T7N = VFMA(LDK(KP881921264), T7K, T7H);
								 {
								      V T7T, T7V, T7A, T7M;
								      T7T = VFMA(LDK(KP881921264), T7S, T7R);
								      T7V = VFNMS(LDK(KP881921264), T7S, T7R);
								      T7A = VFNMS(LDK(KP881921264), T7z, T7k);
								      T7M = VFMA(LDK(KP881921264), T7z, T7k);
								      {
									   V T8i, T8m, T8d, T8f;
									   T8i = VFMA(LDK(KP956940335), T8h, T8g);
									   T8m = VFNMS(LDK(KP956940335), T8h, T8g);
									   T8d = VFNMS(LDK(KP956940335), T8c, T89);
									   T8f = VFMA(LDK(KP956940335), T8c, T89);
									   {
										V T8l, T8n, T86, T8e;
										T8l = VFNMS(LDK(KP956940335), T8k, T8j);
										T8n = VFMA(LDK(KP956940335), T8k, T8j);
										T86 = VFNMS(LDK(KP956940335), T85, T7Y);
										T8e = VFMA(LDK(KP956940335), T85, T7Y);
										ST(&(x[WS(rs, 53)]), VFMAI(T7V, T7U), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 11)]), VFNMSI(T7V, T7U), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 43)]), VFNMSI(T7T, T7Q), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 21)]), VFMAI(T7T, T7Q), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 5)]), VFMAI(T7N, T7M), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 59)]), VFNMSI(T7N, T7M), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 37)]), VFMAI(T7L, T7A), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 27)]), VFNMSI(T7L, T7A), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 51)]), VFNMSI(T8n, T8m), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 13)]), VFMAI(T8n, T8m), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 45)]), VFMAI(T8l, T8i), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 19)]), VFNMSI(T8l, T8i), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 61)]), VFMAI(T8f, T8e), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 3)]), VFNMSI(T8f, T8e), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 29)]), VFMAI(T8d, T86), ms, &(x[WS(rs, 1)]));
										ST(&(x[WS(rs, 35)]), VFNMSI(T8d, T86), ms, &(x[WS(rs, 1)]));
										T6r = VFMA(LDK(KP198912367), T5u, T5x);
										T5y = VFNMS(LDK(KP198912367), T5x, T5u);
									   }
								      }
								 }
							    }
						       }
						  }
					     }
					}
					{
					     V T5N, T5U, T68, T5z, T6U, T6f;
					     T5N = VFMA(LDK(KP923879532), T5M, T5F);
					     T6L = VFNMS(LDK(KP923879532), T5M, T5F);
					     T6M = VFNMS(LDK(KP923879532), T5T, T5Q);
					     T5U = VFMA(LDK(KP923879532), T5T, T5Q);
					     T68 = VFMA(LDK(KP923879532), T67, T60);
					     T6O = VFNMS(LDK(KP923879532), T67, T60);
					     T5z = VADD(T5p, T5y);
					     T6U = VSUB(T5p, T5y);
					     T6P = VFNMS(LDK(KP923879532), T6e, T6b);
					     T6f = VFMA(LDK(KP923879532), T6e, T6b);
					     {
						  V T5V, T6u, T6g, T6v, T6s, T6J;
						  T6s = VSUB(T6q, T6r);
						  T6J = VADD(T6q, T6r);
						  T5V = VFNMS(LDK(KP098491403), T5U, T5N);
						  T6u = VFMA(LDK(KP098491403), T5N, T5U);
						  T75 = VFMA(LDK(KP980785280), T6U, T6T);
						  T6V = VFNMS(LDK(KP980785280), T6U, T6T);
						  T5A = VFMA(LDK(KP980785280), T5z, T5g);
						  T6A = VFNMS(LDK(KP980785280), T5z, T5g);
						  T6g = VFNMS(LDK(KP098491403), T6f, T68);
						  T6v = VFMA(LDK(KP098491403), T68, T6f);
						  T72 = VFNMS(LDK(KP980785280), T6J, T6I);
						  T6K = VFMA(LDK(KP980785280), T6J, T6I);
						  T6t = VFMA(LDK(KP980785280), T6s, T6p);
						  T6D = VFNMS(LDK(KP980785280), T6s, T6p);
						  T6w = VSUB(T6u, T6v);
						  T6B = VADD(T6u, T6v);
						  T6h = VADD(T5V, T6g);
						  T6E = VSUB(T5V, T6g);
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       {
		    V T6W, T6N, T6G, T6C, T6z, T6x, T6H, T6F, T6y, T6i, T6X, T6Q;
		    T6W = VFNMS(LDK(KP820678790), T6L, T6M);
		    T6N = VFMA(LDK(KP820678790), T6M, T6L);
		    T6G = VFMA(LDK(KP995184726), T6B, T6A);
		    T6C = VFNMS(LDK(KP995184726), T6B, T6A);
		    T6z = VFMA(LDK(KP995184726), T6w, T6t);
		    T6x = VFNMS(LDK(KP995184726), T6w, T6t);
		    T6H = VFNMS(LDK(KP995184726), T6E, T6D);
		    T6F = VFMA(LDK(KP995184726), T6E, T6D);
		    T6y = VFMA(LDK(KP995184726), T6h, T5A);
		    T6i = VFNMS(LDK(KP995184726), T6h, T5A);
		    T6X = VFNMS(LDK(KP820678790), T6O, T6P);
		    T6Q = VFMA(LDK(KP820678790), T6P, T6O);
		    {
			 V T73, T6Y, T76, T6R;
			 ST(&(x[WS(rs, 49)]), VFMAI(T6H, T6G), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 15)]), VFNMSI(T6H, T6G), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 47)]), VFNMSI(T6F, T6C), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 17)]), VFMAI(T6F, T6C), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 1)]), VFMAI(T6z, T6y), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 63)]), VFNMSI(T6z, T6y), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 33)]), VFMAI(T6x, T6i), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 31)]), VFNMSI(T6x, T6i), ms, &(x[WS(rs, 1)]));
			 T73 = VADD(T6W, T6X);
			 T6Y = VSUB(T6W, T6X);
			 T76 = VSUB(T6N, T6Q);
			 T6R = VADD(T6N, T6Q);
			 {
			      V T78, T74, T71, T6Z, T79, T77, T70, T6S;
			      T78 = VFNMS(LDK(KP773010453), T73, T72);
			      T74 = VFMA(LDK(KP773010453), T73, T72);
			      T71 = VFMA(LDK(KP773010453), T6Y, T6V);
			      T6Z = VFNMS(LDK(KP773010453), T6Y, T6V);
			      T79 = VFMA(LDK(KP773010453), T76, T75);
			      T77 = VFNMS(LDK(KP773010453), T76, T75);
			      T70 = VFMA(LDK(KP773010453), T6R, T6K);
			      T6S = VFNMS(LDK(KP773010453), T6R, T6K);
			      ST(&(x[WS(rs, 55)]), VFNMSI(T79, T78), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 9)]), VFMAI(T79, T78), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 41)]), VFMAI(T77, T74), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 23)]), VFNMSI(T77, T74), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 57)]), VFMAI(T71, T70), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 7)]), VFNMSI(T71, T70), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 25)]), VFMAI(T6Z, T6S), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 39)]), VFNMSI(T6Z, T6S), ms, &(x[WS(rs, 1)]));
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 2),
     VTW(0, 3),
     VTW(0, 4),
     VTW(0, 5),
     VTW(0, 6),
     VTW(0, 7),
     VTW(0, 8),
     VTW(0, 9),
     VTW(0, 10),
     VTW(0, 11),
     VTW(0, 12),
     VTW(0, 13),
     VTW(0, 14),
     VTW(0, 15),
     VTW(0, 16),
     VTW(0, 17),
     VTW(0, 18),
     VTW(0, 19),
     VTW(0, 20),
     VTW(0, 21),
     VTW(0, 22),
     VTW(0, 23),
     VTW(0, 24),
     VTW(0, 25),
     VTW(0, 26),
     VTW(0, 27),
     VTW(0, 28),
     VTW(0, 29),
     VTW(0, 30),
     VTW(0, 31),
     VTW(0, 32),
     VTW(0, 33),
     VTW(0, 34),
     VTW(0, 35),
     VTW(0, 36),
     VTW(0, 37),
     VTW(0, 38),
     VTW(0, 39),
     VTW(0, 40),
     VTW(0, 41),
     VTW(0, 42),
     VTW(0, 43),
     VTW(0, 44),
     VTW(0, 45),
     VTW(0, 46),
     VTW(0, 47),
     VTW(0, 48),
     VTW(0, 49),
     VTW(0, 50),
     VTW(0, 51),
     VTW(0, 52),
     VTW(0, 53),
     VTW(0, 54),
     VTW(0, 55),
     VTW(0, 56),
     VTW(0, 57),
     VTW(0, 58),
     VTW(0, 59),
     VTW(0, 60),
     VTW(0, 61),
     VTW(0, 62),
     VTW(0, 63),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 64, XSIMD_STRING("t2bv_64"), twinstr, &GENUS, {261, 126, 258, 0}, 0, 0, 0 };

void XSIMD(codelet_t2bv_64) (planner *p) {
     X(kdft_dit_register) (p, t2bv_64, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle_c.native -simd -compact -variables 4 -pipeline-latency 8 -n 64 -name t2bv_64 -include t2b.h -sign 1 */

/*
 * This function contains 519 FP additions, 250 FP multiplications,
 * (or, 467 additions, 198 multiplications, 52 fused multiply/add),
 * 107 stack variables, 15 constants, and 128 memory accesses
 */
#include "t2b.h"

static void t2bv_64(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  R *x;
	  x = ii;
	  for (m = mb, W = W + (mb * ((TWVL / VL) * 126)); m < me; m = m + VL, x = x + (VL * ms), W = W + (TWVL * 126), MAKE_VOLATILE_STRIDE(64, rs)) {
	       V Tg, T4B, T6v, T7G, T3r, T4w, T5q, T7F, T5Y, T62, T28, T4d, T2g, T4a, T7g;
	       V T7Y, T6f, T6j, T2Z, T4k, T37, T4h, T7n, T81, T7w, T7x, T7y, T5M, T6q, T1k;
	       V T4s, T1r, T4t, T7t, T7u, T7v, T5F, T6p, TV, T4p, T12, T4q, T7A, T7B, TD;
	       V T4x, T3k, T4C, T5x, T6s, T1R, T4b, T7j, T7Z, T2j, T4e, T5V, T63, T2I, T4i;
	       V T7q, T82, T3a, T4l, T6c, T6k;
	       {
		    V T1, T3, T3p, T3n, Tb, Td, Te, T6, T8, T9, T2, T3o, T3m;
		    T1 = LD(&(x[0]), ms, &(x[0]));
		    T2 = LD(&(x[WS(rs, 32)]), ms, &(x[0]));
		    T3 = BYTW(&(W[TWVL * 62]), T2);
		    T3o = LD(&(x[WS(rs, 48)]), ms, &(x[0]));
		    T3p = BYTW(&(W[TWVL * 94]), T3o);
		    T3m = LD(&(x[WS(rs, 16)]), ms, &(x[0]));
		    T3n = BYTW(&(W[TWVL * 30]), T3m);
		    {
			 V Ta, Tc, T5, T7;
			 Ta = LD(&(x[WS(rs, 56)]), ms, &(x[0]));
			 Tb = BYTW(&(W[TWVL * 110]), Ta);
			 Tc = LD(&(x[WS(rs, 24)]), ms, &(x[0]));
			 Td = BYTW(&(W[TWVL * 46]), Tc);
			 Te = VSUB(Tb, Td);
			 T5 = LD(&(x[WS(rs, 8)]), ms, &(x[0]));
			 T6 = BYTW(&(W[TWVL * 14]), T5);
			 T7 = LD(&(x[WS(rs, 40)]), ms, &(x[0]));
			 T8 = BYTW(&(W[TWVL * 78]), T7);
			 T9 = VSUB(T6, T8);
		    }
		    {
			 V T4, Tf, T6t, T6u;
			 T4 = VSUB(T1, T3);
			 Tf = VMUL(LDK(KP707106781), VADD(T9, Te));
			 Tg = VSUB(T4, Tf);
			 T4B = VADD(T4, Tf);
			 T6t = VADD(T6, T8);
			 T6u = VADD(Tb, Td);
			 T6v = VSUB(T6t, T6u);
			 T7G = VADD(T6t, T6u);
		    }
		    {
			 V T3l, T3q, T5o, T5p;
			 T3l = VMUL(LDK(KP707106781), VSUB(T9, Te));
			 T3q = VSUB(T3n, T3p);
			 T3r = VSUB(T3l, T3q);
			 T4w = VADD(T3q, T3l);
			 T5o = VADD(T1, T3);
			 T5p = VADD(T3n, T3p);
			 T5q = VSUB(T5o, T5p);
			 T7F = VADD(T5o, T5p);
		    }
	       }
	       {
		    V T24, T26, T61, T2b, T2d, T60, T1W, T5W, T21, T5X, T22, T27;
		    {
			 V T23, T25, T2a, T2c;
			 T23 = LD(&(x[WS(rs, 17)]), ms, &(x[WS(rs, 1)]));
			 T24 = BYTW(&(W[TWVL * 32]), T23);
			 T25 = LD(&(x[WS(rs, 49)]), ms, &(x[WS(rs, 1)]));
			 T26 = BYTW(&(W[TWVL * 96]), T25);
			 T61 = VADD(T24, T26);
			 T2a = LD(&(x[WS(rs, 1)]), ms, &(x[WS(rs, 1)]));
			 T2b = BYTW(&(W[0]), T2a);
			 T2c = LD(&(x[WS(rs, 33)]), ms, &(x[WS(rs, 1)]));
			 T2d = BYTW(&(W[TWVL * 64]), T2c);
			 T60 = VADD(T2b, T2d);
		    }
		    {
			 V T1T, T1V, T1S, T1U;
			 T1S = LD(&(x[WS(rs, 9)]), ms, &(x[WS(rs, 1)]));
			 T1T = BYTW(&(W[TWVL * 16]), T1S);
			 T1U = LD(&(x[WS(rs, 41)]), ms, &(x[WS(rs, 1)]));
			 T1V = BYTW(&(W[TWVL * 80]), T1U);
			 T1W = VSUB(T1T, T1V);
			 T5W = VADD(T1T, T1V);
		    }
		    {
			 V T1Y, T20, T1X, T1Z;
			 T1X = LD(&(x[WS(rs, 57)]), ms, &(x[WS(rs, 1)]));
			 T1Y = BYTW(&(W[TWVL * 112]), T1X);
			 T1Z = LD(&(x[WS(rs, 25)]), ms, &(x[WS(rs, 1)]));
			 T20 = BYTW(&(W[TWVL * 48]), T1Z);
			 T21 = VSUB(T1Y, T20);
			 T5X = VADD(T1Y, T20);
		    }
		    T5Y = VSUB(T5W, T5X);
		    T62 = VSUB(T60, T61);
		    T22 = VMUL(LDK(KP707106781), VSUB(T1W, T21));
		    T27 = VSUB(T24, T26);
		    T28 = VSUB(T22, T27);
		    T4d = VADD(T27, T22);
		    {
			 V T2e, T2f, T7e, T7f;
			 T2e = VSUB(T2b, T2d);
			 T2f = VMUL(LDK(KP707106781), VADD(T1W, T21));
			 T2g = VSUB(T2e, T2f);
			 T4a = VADD(T2e, T2f);
			 T7e = VADD(T60, T61);
			 T7f = VADD(T5W, T5X);
			 T7g = VSUB(T7e, T7f);
			 T7Y = VADD(T7e, T7f);
		    }
	       }
	       {
		    V T2V, T2X, T6i, T32, T34, T6h, T2N, T6d, T2S, T6e, T2T, T2Y;
		    {
			 V T2U, T2W, T31, T33;
			 T2U = LD(&(x[WS(rs, 15)]), ms, &(x[WS(rs, 1)]));
			 T2V = BYTW(&(W[TWVL * 28]), T2U);
			 T2W = LD(&(x[WS(rs, 47)]), ms, &(x[WS(rs, 1)]));
			 T2X = BYTW(&(W[TWVL * 92]), T2W);
			 T6i = VADD(T2V, T2X);
			 T31 = LD(&(x[WS(rs, 63)]), ms, &(x[WS(rs, 1)]));
			 T32 = BYTW(&(W[TWVL * 124]), T31);
			 T33 = LD(&(x[WS(rs, 31)]), ms, &(x[WS(rs, 1)]));
			 T34 = BYTW(&(W[TWVL * 60]), T33);
			 T6h = VADD(T32, T34);
		    }
		    {
			 V T2K, T2M, T2J, T2L;
			 T2J = LD(&(x[WS(rs, 7)]), ms, &(x[WS(rs, 1)]));
			 T2K = BYTW(&(W[TWVL * 12]), T2J);
			 T2L = LD(&(x[WS(rs, 39)]), ms, &(x[WS(rs, 1)]));
			 T2M = BYTW(&(W[TWVL * 76]), T2L);
			 T2N = VSUB(T2K, T2M);
			 T6d = VADD(T2K, T2M);
		    }
		    {
			 V T2P, T2R, T2O, T2Q;
			 T2O = LD(&(x[WS(rs, 55)]), ms, &(x[WS(rs, 1)]));
			 T2P = BYTW(&(W[TWVL * 108]), T2O);
			 T2Q = LD(&(x[WS(rs, 23)]), ms, &(x[WS(rs, 1)]));
			 T2R = BYTW(&(W[TWVL * 44]), T2Q);
			 T2S = VSUB(T2P, T2R);
			 T6e = VADD(T2P, T2R);
		    }
		    T6f = VSUB(T6d, T6e);
		    T6j = VSUB(T6h, T6i);
		    T2T = VMUL(LDK(KP707106781), VSUB(T2N, T2S));
		    T2Y = VSUB(T2V, T2X);
		    T2Z = VSUB(T2T, T2Y);
		    T4k = VADD(T2Y, T2T);
		    {
			 V T35, T36, T7l, T7m;
			 T35 = VSUB(T32, T34);
			 T36 = VMUL(LDK(KP707106781), VADD(T2N, T2S));
			 T37 = VSUB(T35, T36);
			 T4h = VADD(T35, T36);
			 T7l = VADD(T6h, T6i);
			 T7m = VADD(T6d, T6e);
			 T7n = VSUB(T7l, T7m);
			 T81 = VADD(T7l, T7m);
		    }
	       }
	       {
		    V T1g, T1i, T5K, T1m, T1o, T5J, T18, T5G, T1d, T5H, T5I, T5L;
		    {
			 V T1f, T1h, T1l, T1n;
			 T1f = LD(&(x[WS(rs, 14)]), ms, &(x[0]));
			 T1g = BYTW(&(W[TWVL * 26]), T1f);
			 T1h = LD(&(x[WS(rs, 46)]), ms, &(x[0]));
			 T1i = BYTW(&(W[TWVL * 90]), T1h);
			 T5K = VADD(T1g, T1i);
			 T1l = LD(&(x[WS(rs, 62)]), ms, &(x[0]));
			 T1m = BYTW(&(W[TWVL * 122]), T1l);
			 T1n = LD(&(x[WS(rs, 30)]), ms, &(x[0]));
			 T1o = BYTW(&(W[TWVL * 58]), T1n);
			 T5J = VADD(T1m, T1o);
		    }
		    {
			 V T15, T17, T14, T16;
			 T14 = LD(&(x[WS(rs, 6)]), ms, &(x[0]));
			 T15 = BYTW(&(W[TWVL * 10]), T14);
			 T16 = LD(&(x[WS(rs, 38)]), ms, &(x[0]));
			 T17 = BYTW(&(W[TWVL * 74]), T16);
			 T18 = VSUB(T15, T17);
			 T5G = VADD(T15, T17);
		    }
		    {
			 V T1a, T1c, T19, T1b;
			 T19 = LD(&(x[WS(rs, 54)]), ms, &(x[0]));
			 T1a = BYTW(&(W[TWVL * 106]), T19);
			 T1b = LD(&(x[WS(rs, 22)]), ms, &(x[0]));
			 T1c = BYTW(&(W[TWVL * 42]), T1b);
			 T1d = VSUB(T1a, T1c);
			 T5H = VADD(T1a, T1c);
		    }
		    T7w = VADD(T5J, T5K);
		    T7x = VADD(T5G, T5H);
		    T7y = VSUB(T7w, T7x);
		    T5I = VSUB(T5G, T5H);
		    T5L = VSUB(T5J, T5K);
		    T5M = VFNMS(LDK(KP382683432), T5L, VMUL(LDK(KP923879532), T5I));
		    T6q = VFMA(LDK(KP923879532), T5L, VMUL(LDK(KP382683432), T5I));
		    {
			 V T1e, T1j, T1p, T1q;
			 T1e = VMUL(LDK(KP707106781), VSUB(T18, T1d));
			 T1j = VSUB(T1g, T1i);
			 T1k = VSUB(T1e, T1j);
			 T4s = VADD(T1j, T1e);
			 T1p = VSUB(T1m, T1o);
			 T1q = VMUL(LDK(KP707106781), VADD(T18, T1d));
			 T1r = VSUB(T1p, T1q);
			 T4t = VADD(T1p, T1q);
		    }
	       }
	       {
		    V TR, TT, T5A, TX, TZ, T5z, TJ, T5C, TO, T5D, T5B, T5E;
		    {
			 V TQ, TS, TW, TY;
			 TQ = LD(&(x[WS(rs, 18)]), ms, &(x[0]));
			 TR = BYTW(&(W[TWVL * 34]), TQ);
			 TS = LD(&(x[WS(rs, 50)]), ms, &(x[0]));
			 TT = BYTW(&(W[TWVL * 98]), TS);
			 T5A = VADD(TR, TT);
			 TW = LD(&(x[WS(rs, 2)]), ms, &(x[0]));
			 TX = BYTW(&(W[TWVL * 2]), TW);
			 TY = LD(&(x[WS(rs, 34)]), ms, &(x[0]));
			 TZ = BYTW(&(W[TWVL * 66]), TY);
			 T5z = VADD(TX, TZ);
		    }
		    {
			 V TG, TI, TF, TH;
			 TF = LD(&(x[WS(rs, 10)]), ms, &(x[0]));
			 TG = BYTW(&(W[TWVL * 18]), TF);
			 TH = LD(&(x[WS(rs, 42)]), ms, &(x[0]));
			 TI = BYTW(&(W[TWVL * 82]), TH);
			 TJ = VSUB(TG, TI);
			 T5C = VADD(TG, TI);
		    }
		    {
			 V TL, TN, TK, TM;
			 TK = LD(&(x[WS(rs, 58)]), ms, &(x[0]));
			 TL = BYTW(&(W[TWVL * 114]), TK);
			 TM = LD(&(x[WS(rs, 26)]), ms, &(x[0]));
			 TN = BYTW(&(W[TWVL * 50]), TM);
			 TO = VSUB(TL, TN);
			 T5D = VADD(TL, TN);
		    }
		    T7t = VADD(T5z, T5A);
		    T7u = VADD(T5C, T5D);
		    T7v = VSUB(T7t, T7u);
		    T5B = VSUB(T5z, T5A);
		    T5E = VSUB(T5C, T5D);
		    T5F = VFMA(LDK(KP382683432), T5B, VMUL(LDK(KP923879532), T5E));
		    T6p = VFNMS(LDK(KP382683432), T5E, VMUL(LDK(KP923879532), T5B));
		    {
			 V TP, TU, T10, T11;
			 TP = VMUL(LDK(KP707106781), VSUB(TJ, TO));
			 TU = VSUB(TR, TT);
			 TV = VSUB(TP, TU);
			 T4p = VADD(TU, TP);
			 T10 = VSUB(TX, TZ);
			 T11 = VMUL(LDK(KP707106781), VADD(TJ, TO));
			 T12 = VSUB(T10, T11);
			 T4q = VADD(T10, T11);
		    }
	       }
	       {
		    V Tl, T5r, TB, T5u, Tq, T5s, Tw, T5v, Tr, TC;
		    {
			 V Ti, Tk, Th, Tj;
			 Th = LD(&(x[WS(rs, 4)]), ms, &(x[0]));
			 Ti = BYTW(&(W[TWVL * 6]), Th);
			 Tj = LD(&(x[WS(rs, 36)]), ms, &(x[0]));
			 Tk = BYTW(&(W[TWVL * 70]), Tj);
			 Tl = VSUB(Ti, Tk);
			 T5r = VADD(Ti, Tk);
		    }
		    {
			 V Ty, TA, Tx, Tz;
			 Tx = LD(&(x[WS(rs, 60)]), ms, &(x[0]));
			 Ty = BYTW(&(W[TWVL * 118]), Tx);
			 Tz = LD(&(x[WS(rs, 28)]), ms, &(x[0]));
			 TA = BYTW(&(W[TWVL * 54]), Tz);
			 TB = VSUB(Ty, TA);
			 T5u = VADD(Ty, TA);
		    }
		    {
			 V Tn, Tp, Tm, To;
			 Tm = LD(&(x[WS(rs, 20)]), ms, &(x[0]));
			 Tn = BYTW(&(W[TWVL * 38]), Tm);
			 To = LD(&(x[WS(rs, 52)]), ms, &(x[0]));
			 Tp = BYTW(&(W[TWVL * 102]), To);
			 Tq = VSUB(Tn, Tp);
			 T5s = VADD(Tn, Tp);
		    }
		    {
			 V Tt, Tv, Ts, Tu;
			 Ts = LD(&(x[WS(rs, 12)]), ms, &(x[0]));
			 Tt = BYTW(&(W[TWVL * 22]), Ts);
			 Tu = LD(&(x[WS(rs, 44)]), ms, &(x[0]));
			 Tv = BYTW(&(W[TWVL * 86]), Tu);
			 Tw = VSUB(Tt, Tv);
			 T5v = VADD(Tt, Tv);
		    }
		    T7A = VADD(T5r, T5s);
		    T7B = VADD(T5u, T5v);
		    Tr = VFMA(LDK(KP382683432), Tl, VMUL(LDK(KP923879532), Tq));
		    TC = VFNMS(LDK(KP382683432), TB, VMUL(LDK(KP923879532), Tw));
		    TD = VSUB(Tr, TC);
		    T4x = VADD(Tr, TC);
		    {
			 V T3i, T3j, T5t, T5w;
			 T3i = VFNMS(LDK(KP382683432), Tq, VMUL(LDK(KP923879532), Tl));
			 T3j = VFMA(LDK(KP923879532), TB, VMUL(LDK(KP382683432), Tw));
			 T3k = VSUB(T3i, T3j);
			 T4C = VADD(T3i, T3j);
			 T5t = VSUB(T5r, T5s);
			 T5w = VSUB(T5u, T5v);
			 T5x = VMUL(LDK(KP707106781), VADD(T5t, T5w));
			 T6s = VMUL(LDK(KP707106781), VSUB(T5t, T5w));
		    }
	       }
	       {
		    V T1z, T5P, T1P, T5T, T1E, T5Q, T1K, T5S;
		    {
			 V T1w, T1y, T1v, T1x;
			 T1v = LD(&(x[WS(rs, 5)]), ms, &(x[WS(rs, 1)]));
			 T1w = BYTW(&(W[TWVL * 8]), T1v);
			 T1x = LD(&(x[WS(rs, 37)]), ms, &(x[WS(rs, 1)]));
			 T1y = BYTW(&(W[TWVL * 72]), T1x);
			 T1z = VSUB(T1w, T1y);
			 T5P = VADD(T1w, T1y);
		    }
		    {
			 V T1M, T1O, T1L, T1N;
			 T1L = LD(&(x[WS(rs, 13)]), ms, &(x[WS(rs, 1)]));
			 T1M = BYTW(&(W[TWVL * 24]), T1L);
			 T1N = LD(&(x[WS(rs, 45)]), ms, &(x[WS(rs, 1)]));
			 T1O = BYTW(&(W[TWVL * 88]), T1N);
			 T1P = VSUB(T1M, T1O);
			 T5T = VADD(T1M, T1O);
		    }
		    {
			 V T1B, T1D, T1A, T1C;
			 T1A = LD(&(x[WS(rs, 21)]), ms, &(x[WS(rs, 1)]));
			 T1B = BYTW(&(W[TWVL * 40]), T1A);
			 T1C = LD(&(x[WS(rs, 53)]), ms, &(x[WS(rs, 1)]));
			 T1D = BYTW(&(W[TWVL * 104]), T1C);
			 T1E = VSUB(T1B, T1D);
			 T5Q = VADD(T1B, T1D);
		    }
		    {
			 V T1H, T1J, T1G, T1I;
			 T1G = LD(&(x[WS(rs, 61)]), ms, &(x[WS(rs, 1)]));
			 T1H = BYTW(&(W[TWVL * 120]), T1G);
			 T1I = LD(&(x[WS(rs, 29)]), ms, &(x[WS(rs, 1)]));
			 T1J = BYTW(&(W[TWVL * 56]), T1I);
			 T1K = VSUB(T1H, T1J);
			 T5S = VADD(T1H, T1J);
		    }
		    {
			 V T1F, T1Q, T7h, T7i;
			 T1F = VFNMS(LDK(KP382683432), T1E, VMUL(LDK(KP923879532), T1z));
			 T1Q = VFMA(LDK(KP923879532), T1K, VMUL(LDK(KP382683432), T1P));
			 T1R = VSUB(T1F, T1Q);
			 T4b = VADD(T1F, T1Q);
			 T7h = VADD(T5P, T5Q);
			 T7i = VADD(T5S, T5T);
			 T7j = VSUB(T7h, T7i);
			 T7Z = VADD(T7h, T7i);
		    }
		    {
			 V T2h, T2i, T5R, T5U;
			 T2h = VFMA(LDK(KP382683432), T1z, VMUL(LDK(KP923879532), T1E));
			 T2i = VFNMS(LDK(KP382683432), T1K, VMUL(LDK(KP923879532), T1P));
			 T2j = VSUB(T2h, T2i);
			 T4e = VADD(T2h, T2i);
			 T5R = VSUB(T5P, T5Q);
			 T5U = VSUB(T5S, T5T);
			 T5V = VMUL(LDK(KP707106781), VSUB(T5R, T5U));
			 T63 = VMUL(LDK(KP707106781), VADD(T5R, T5U));
		    }
	       }
	       {
		    V T2q, T66, T2G, T6a, T2v, T67, T2B, T69;
		    {
			 V T2n, T2p, T2m, T2o;
			 T2m = LD(&(x[WS(rs, 3)]), ms, &(x[WS(rs, 1)]));
			 T2n = BYTW(&(W[TWVL * 4]), T2m);
			 T2o = LD(&(x[WS(rs, 35)]), ms, &(x[WS(rs, 1)]));
			 T2p = BYTW(&(W[TWVL * 68]), T2o);
			 T2q = VSUB(T2n, T2p);
			 T66 = VADD(T2n, T2p);
		    }
		    {
			 V T2D, T2F, T2C, T2E;
			 T2C = LD(&(x[WS(rs, 11)]), ms, &(x[WS(rs, 1)]));
			 T2D = BYTW(&(W[TWVL * 20]), T2C);
			 T2E = LD(&(x[WS(rs, 43)]), ms, &(x[WS(rs, 1)]));
			 T2F = BYTW(&(W[TWVL * 84]), T2E);
			 T2G = VSUB(T2D, T2F);
			 T6a = VADD(T2D, T2F);
		    }
		    {
			 V T2s, T2u, T2r, T2t;
			 T2r = LD(&(x[WS(rs, 19)]), ms, &(x[WS(rs, 1)]));
			 T2s = BYTW(&(W[TWVL * 36]), T2r);
			 T2t = LD(&(x[WS(rs, 51)]), ms, &(x[WS(rs, 1)]));
			 T2u = BYTW(&(W[TWVL * 100]), T2t);
			 T2v = VSUB(T2s, T2u);
			 T67 = VADD(T2s, T2u);
		    }
		    {
			 V T2y, T2A, T2x, T2z;
			 T2x = LD(&(x[WS(rs, 59)]), ms, &(x[WS(rs, 1)]));
			 T2y = BYTW(&(W[TWVL * 116]), T2x);
			 T2z = LD(&(x[WS(rs, 27)]), ms, &(x[WS(rs, 1)]));
			 T2A = BYTW(&(W[TWVL * 52]), T2z);
			 T2B = VSUB(T2y, T2A);
			 T69 = VADD(T2y, T2A);
		    }
		    {
			 V T2w, T2H, T7o, T7p;
			 T2w = VFNMS(LDK(KP382683432), T2v, VMUL(LDK(KP923879532), T2q));
			 T2H = VFMA(LDK(KP923879532), T2B, VMUL(LDK(KP382683432), T2G));
			 T2I = VSUB(T2w, T2H);
			 T4i = VADD(T2w, T2H);
			 T7o = VADD(T66, T67);
			 T7p = VADD(T69, T6a);
			 T7q = VSUB(T7o, T7p);
			 T82 = VADD(T7o, T7p);
		    }
		    {
			 V T38, T39, T68, T6b;
			 T38 = VFMA(LDK(KP382683432), T2q, VMUL(LDK(KP923879532), T2v));
			 T39 = VFNMS(LDK(KP382683432), T2B, VMUL(LDK(KP923879532), T2G));
			 T3a = VSUB(T38, T39);
			 T4l = VADD(T38, T39);
			 T68 = VSUB(T66, T67);
			 T6b = VSUB(T69, T6a);
			 T6c = VMUL(LDK(KP707106781), VSUB(T68, T6b));
			 T6k = VMUL(LDK(KP707106781), VADD(T68, T6b));
		    }
	       }
	       {
		    V T7s, T7R, T7M, T7U, T7D, T7T, T7J, T7Q;
		    {
			 V T7k, T7r, T7K, T7L;
			 T7k = VFNMS(LDK(KP382683432), T7j, VMUL(LDK(KP923879532), T7g));
			 T7r = VFMA(LDK(KP923879532), T7n, VMUL(LDK(KP382683432), T7q));
			 T7s = VSUB(T7k, T7r);
			 T7R = VADD(T7k, T7r);
			 T7K = VFMA(LDK(KP382683432), T7g, VMUL(LDK(KP923879532), T7j));
			 T7L = VFNMS(LDK(KP382683432), T7n, VMUL(LDK(KP923879532), T7q));
			 T7M = VSUB(T7K, T7L);
			 T7U = VADD(T7K, T7L);
		    }
		    {
			 V T7z, T7C, T7H, T7I;
			 T7z = VMUL(LDK(KP707106781), VSUB(T7v, T7y));
			 T7C = VSUB(T7A, T7B);
			 T7D = VSUB(T7z, T7C);
			 T7T = VADD(T7C, T7z);
			 T7H = VSUB(T7F, T7G);
			 T7I = VMUL(LDK(KP707106781), VADD(T7v, T7y));
			 T7J = VSUB(T7H, T7I);
			 T7Q = VADD(T7H, T7I);
		    }
		    {
			 V T7E, T7N, T7W, T7X;
			 T7E = VBYI(VSUB(T7s, T7D));
			 T7N = VSUB(T7J, T7M);
			 ST(&(x[WS(rs, 20)]), VADD(T7E, T7N), ms, &(x[0]));
			 ST(&(x[WS(rs, 44)]), VSUB(T7N, T7E), ms, &(x[0]));
			 T7W = VSUB(T7Q, T7R);
			 T7X = VBYI(VSUB(T7U, T7T));
			 ST(&(x[WS(rs, 36)]), VSUB(T7W, T7X), ms, &(x[0]));
			 ST(&(x[WS(rs, 28)]), VADD(T7W, T7X), ms, &(x[0]));
		    }
		    {
			 V T7O, T7P, T7S, T7V;
			 T7O = VBYI(VADD(T7D, T7s));
			 T7P = VADD(T7J, T7M);
			 ST(&(x[WS(rs, 12)]), VADD(T7O, T7P), ms, &(x[0]));
			 ST(&(x[WS(rs, 52)]), VSUB(T7P, T7O), ms, &(x[0]));
			 T7S = VADD(T7Q, T7R);
			 T7V = VBYI(VADD(T7T, T7U));
			 ST(&(x[WS(rs, 60)]), VSUB(T7S, T7V), ms, &(x[0]));
			 ST(&(x[WS(rs, 4)]), VADD(T7S, T7V), ms, &(x[0]));
		    }
	       }
	       {
		    V T84, T8c, T8l, T8n, T87, T8h, T8b, T8g, T8i, T8m;
		    {
			 V T80, T83, T8j, T8k;
			 T80 = VSUB(T7Y, T7Z);
			 T83 = VSUB(T81, T82);
			 T84 = VMUL(LDK(KP707106781), VSUB(T80, T83));
			 T8c = VMUL(LDK(KP707106781), VADD(T80, T83));
			 T8j = VADD(T7Y, T7Z);
			 T8k = VADD(T81, T82);
			 T8l = VBYI(VSUB(T8j, T8k));
			 T8n = VADD(T8j, T8k);
		    }
		    {
			 V T85, T86, T89, T8a;
			 T85 = VADD(T7t, T7u);
			 T86 = VADD(T7w, T7x);
			 T87 = VSUB(T85, T86);
			 T8h = VADD(T85, T86);
			 T89 = VADD(T7F, T7G);
			 T8a = VADD(T7A, T7B);
			 T8b = VSUB(T89, T8a);
			 T8g = VADD(T89, T8a);
		    }
		    T8i = VSUB(T8g, T8h);
		    ST(&(x[WS(rs, 48)]), VSUB(T8i, T8l), ms, &(x[0]));
		    ST(&(x[WS(rs, 16)]), VADD(T8i, T8l), ms, &(x[0]));
		    T8m = VADD(T8g, T8h);
		    ST(&(x[WS(rs, 32)]), VSUB(T8m, T8n), ms, &(x[0]));
		    ST(&(x[0]), VADD(T8m, T8n), ms, &(x[0]));
		    {
			 V T88, T8d, T8e, T8f;
			 T88 = VBYI(VSUB(T84, T87));
			 T8d = VSUB(T8b, T8c);
			 ST(&(x[WS(rs, 24)]), VADD(T88, T8d), ms, &(x[0]));
			 ST(&(x[WS(rs, 40)]), VSUB(T8d, T88), ms, &(x[0]));
			 T8e = VBYI(VADD(T87, T84));
			 T8f = VADD(T8b, T8c);
			 ST(&(x[WS(rs, 8)]), VADD(T8e, T8f), ms, &(x[0]));
			 ST(&(x[WS(rs, 56)]), VSUB(T8f, T8e), ms, &(x[0]));
		    }
	       }
	       {
		    V T5O, T6H, T6x, T6F, T6n, T6I, T6A, T6E;
		    {
			 V T5y, T5N, T6r, T6w;
			 T5y = VSUB(T5q, T5x);
			 T5N = VSUB(T5F, T5M);
			 T5O = VSUB(T5y, T5N);
			 T6H = VADD(T5y, T5N);
			 T6r = VSUB(T6p, T6q);
			 T6w = VSUB(T6s, T6v);
			 T6x = VSUB(T6r, T6w);
			 T6F = VADD(T6w, T6r);
			 {
			      V T65, T6y, T6m, T6z;
			      {
				   V T5Z, T64, T6g, T6l;
				   T5Z = VSUB(T5V, T5Y);
				   T64 = VSUB(T62, T63);
				   T65 = VFMA(LDK(KP831469612), T5Z, VMUL(LDK(KP555570233), T64));
				   T6y = VFNMS(LDK(KP555570233), T5Z, VMUL(LDK(KP831469612), T64));
				   T6g = VSUB(T6c, T6f);
				   T6l = VSUB(T6j, T6k);
				   T6m = VFNMS(LDK(KP555570233), T6l, VMUL(LDK(KP831469612), T6g));
				   T6z = VFMA(LDK(KP555570233), T6g, VMUL(LDK(KP831469612), T6l));
			      }
			      T6n = VSUB(T65, T6m);
			      T6I = VADD(T6y, T6z);
			      T6A = VSUB(T6y, T6z);
			      T6E = VADD(T65, T6m);
			 }
		    }
		    {
			 V T6o, T6B, T6K, T6L;
			 T6o = VADD(T5O, T6n);
			 T6B = VBYI(VADD(T6x, T6A));
			 ST(&(x[WS(rs, 54)]), VSUB(T6o, T6B), ms, &(x[0]));
			 ST(&(x[WS(rs, 10)]), VADD(T6o, T6B), ms, &(x[0]));
			 T6K = VBYI(VADD(T6F, T6E));
			 T6L = VADD(T6H, T6I);
			 ST(&(x[WS(rs, 6)]), VADD(T6K, T6L), ms, &(x[0]));
			 ST(&(x[WS(rs, 58)]), VSUB(T6L, T6K), ms, &(x[0]));
		    }
		    {
			 V T6C, T6D, T6G, T6J;
			 T6C = VSUB(T5O, T6n);
			 T6D = VBYI(VSUB(T6A, T6x));
			 ST(&(x[WS(rs, 42)]), VSUB(T6C, T6D), ms, &(x[0]));
			 ST(&(x[WS(rs, 22)]), VADD(T6C, T6D), ms, &(x[0]));
			 T6G = VBYI(VSUB(T6E, T6F));
			 T6J = VSUB(T6H, T6I);
			 ST(&(x[WS(rs, 26)]), VADD(T6G, T6J), ms, &(x[0]));
			 ST(&(x[WS(rs, 38)]), VSUB(T6J, T6G), ms, &(x[0]));
		    }
	       }
	       {
		    V T6O, T79, T6Z, T77, T6V, T7a, T72, T76;
		    {
			 V T6M, T6N, T6X, T6Y;
			 T6M = VADD(T5q, T5x);
			 T6N = VADD(T6p, T6q);
			 T6O = VSUB(T6M, T6N);
			 T79 = VADD(T6M, T6N);
			 T6X = VADD(T5F, T5M);
			 T6Y = VADD(T6v, T6s);
			 T6Z = VSUB(T6X, T6Y);
			 T77 = VADD(T6Y, T6X);
			 {
			      V T6R, T70, T6U, T71;
			      {
				   V T6P, T6Q, T6S, T6T;
				   T6P = VADD(T5Y, T5V);
				   T6Q = VADD(T62, T63);
				   T6R = VFMA(LDK(KP980785280), T6P, VMUL(LDK(KP195090322), T6Q));
				   T70 = VFNMS(LDK(KP195090322), T6P, VMUL(LDK(KP980785280), T6Q));
				   T6S = VADD(T6f, T6c);
				   T6T = VADD(T6j, T6k);
				   T6U = VFNMS(LDK(KP195090322), T6T, VMUL(LDK(KP980785280), T6S));
				   T71 = VFMA(LDK(KP195090322), T6S, VMUL(LDK(KP980785280), T6T));
			      }
			      T6V = VSUB(T6R, T6U);
			      T7a = VADD(T70, T71);
			      T72 = VSUB(T70, T71);
			      T76 = VADD(T6R, T6U);
			 }
		    }
		    {
			 V T6W, T73, T7c, T7d;
			 T6W = VADD(T6O, T6V);
			 T73 = VBYI(VADD(T6Z, T72));
			 ST(&(x[WS(rs, 50)]), VSUB(T6W, T73), ms, &(x[0]));
			 ST(&(x[WS(rs, 14)]), VADD(T6W, T73), ms, &(x[0]));
			 T7c = VBYI(VADD(T77, T76));
			 T7d = VADD(T79, T7a);
			 ST(&(x[WS(rs, 2)]), VADD(T7c, T7d), ms, &(x[0]));
			 ST(&(x[WS(rs, 62)]), VSUB(T7d, T7c), ms, &(x[0]));
		    }
		    {
			 V T74, T75, T78, T7b;
			 T74 = VSUB(T6O, T6V);
			 T75 = VBYI(VSUB(T72, T6Z));
			 ST(&(x[WS(rs, 46)]), VSUB(T74, T75), ms, &(x[0]));
			 ST(&(x[WS(rs, 18)]), VADD(T74, T75), ms, &(x[0]));
			 T78 = VBYI(VSUB(T76, T77));
			 T7b = VSUB(T79, T7a);
			 ST(&(x[WS(rs, 30)]), VADD(T78, T7b), ms, &(x[0]));
			 ST(&(x[WS(rs, 34)]), VSUB(T7b, T78), ms, &(x[0]));
		    }
	       }
	       {
		    V T4z, T5g, T4R, T59, T4H, T5j, T4O, T55, T4o, T4S, T4K, T4P, T52, T5k, T5c;
		    V T5h;
		    {
			 V T4y, T57, T4v, T58, T4r, T4u;
			 T4y = VADD(T4w, T4x);
			 T57 = VSUB(T4B, T4C);
			 T4r = VFMA(LDK(KP980785280), T4p, VMUL(LDK(KP195090322), T4q));
			 T4u = VFNMS(LDK(KP195090322), T4t, VMUL(LDK(KP980785280), T4s));
			 T4v = VADD(T4r, T4u);
			 T58 = VSUB(T4r, T4u);
			 T4z = VSUB(T4v, T4y);
			 T5g = VADD(T57, T58);
			 T4R = VADD(T4y, T4v);
			 T59 = VSUB(T57, T58);
		    }
		    {
			 V T4D, T54, T4G, T53, T4E, T4F;
			 T4D = VADD(T4B, T4C);
			 T54 = VSUB(T4x, T4w);
			 T4E = VFNMS(LDK(KP195090322), T4p, VMUL(LDK(KP980785280), T4q));
			 T4F = VFMA(LDK(KP195090322), T4s, VMUL(LDK(KP980785280), T4t));
			 T4G = VADD(T4E, T4F);
			 T53 = VSUB(T4E, T4F);
			 T4H = VSUB(T4D, T4G);
			 T5j = VADD(T54, T53);
			 T4O = VADD(T4D, T4G);
			 T55 = VSUB(T53, T54);
		    }
		    {
			 V T4g, T4I, T4n, T4J;
			 {
			      V T4c, T4f, T4j, T4m;
			      T4c = VADD(T4a, T4b);
			      T4f = VADD(T4d, T4e);
			      T4g = VFNMS(LDK(KP098017140), T4f, VMUL(LDK(KP995184726), T4c));
			      T4I = VFMA(LDK(KP098017140), T4c, VMUL(LDK(KP995184726), T4f));
			      T4j = VADD(T4h, T4i);
			      T4m = VADD(T4k, T4l);
			      T4n = VFMA(LDK(KP995184726), T4j, VMUL(LDK(KP098017140), T4m));
			      T4J = VFNMS(LDK(KP098017140), T4j, VMUL(LDK(KP995184726), T4m));
			 }
			 T4o = VSUB(T4g, T4n);
			 T4S = VADD(T4I, T4J);
			 T4K = VSUB(T4I, T4J);
			 T4P = VADD(T4g, T4n);
		    }
		    {
			 V T4Y, T5a, T51, T5b;
			 {
			      V T4W, T4X, T4Z, T50;
			      T4W = VSUB(T4a, T4b);
			      T4X = VSUB(T4e, T4d);
			      T4Y = VFNMS(LDK(KP634393284), T4X, VMUL(LDK(KP773010453), T4W));
			      T5a = VFMA(LDK(KP634393284), T4W, VMUL(LDK(KP773010453), T4X));
			      T4Z = VSUB(T4h, T4i);
			      T50 = VSUB(T4l, T4k);
			      T51 = VFMA(LDK(KP773010453), T4Z, VMUL(LDK(KP634393284), T50));
			      T5b = VFNMS(LDK(KP634393284), T4Z, VMUL(LDK(KP773010453), T50));
			 }
			 T52 = VSUB(T4Y, T51);
			 T5k = VADD(T5a, T5b);
			 T5c = VSUB(T5a, T5b);
			 T5h = VADD(T4Y, T51);
		    }
		    {
			 V T4A, T4L, T5i, T5l;
			 T4A = VBYI(VSUB(T4o, T4z));
			 T4L = VSUB(T4H, T4K);
			 ST(&(x[WS(rs, 17)]), VADD(T4A, T4L), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 47)]), VSUB(T4L, T4A), ms, &(x[WS(rs, 1)]));
			 T5i = VADD(T5g, T5h);
			 T5l = VBYI(VADD(T5j, T5k));
			 ST(&(x[WS(rs, 57)]), VSUB(T5i, T5l), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 7)]), VADD(T5i, T5l), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T5m, T5n, T4M, T4N;
			 T5m = VSUB(T5g, T5h);
			 T5n = VBYI(VSUB(T5k, T5j));
			 ST(&(x[WS(rs, 39)]), VSUB(T5m, T5n), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 25)]), VADD(T5m, T5n), ms, &(x[WS(rs, 1)]));
			 T4M = VBYI(VADD(T4z, T4o));
			 T4N = VADD(T4H, T4K);
			 ST(&(x[WS(rs, 15)]), VADD(T4M, T4N), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 49)]), VSUB(T4N, T4M), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T4Q, T4T, T56, T5d;
			 T4Q = VADD(T4O, T4P);
			 T4T = VBYI(VADD(T4R, T4S));
			 ST(&(x[WS(rs, 63)]), VSUB(T4Q, T4T), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 1)]), VADD(T4Q, T4T), ms, &(x[WS(rs, 1)]));
			 T56 = VBYI(VSUB(T52, T55));
			 T5d = VSUB(T59, T5c);
			 ST(&(x[WS(rs, 23)]), VADD(T56, T5d), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 41)]), VSUB(T5d, T56), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T5e, T5f, T4U, T4V;
			 T5e = VBYI(VADD(T55, T52));
			 T5f = VADD(T59, T5c);
			 ST(&(x[WS(rs, 9)]), VADD(T5e, T5f), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 55)]), VSUB(T5f, T5e), ms, &(x[WS(rs, 1)]));
			 T4U = VSUB(T4O, T4P);
			 T4V = VBYI(VSUB(T4S, T4R));
			 ST(&(x[WS(rs, 33)]), VSUB(T4U, T4V), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 31)]), VADD(T4U, T4V), ms, &(x[WS(rs, 1)]));
		    }
	       }
	       {
		    V T1u, T43, T3D, T3V, T3t, T45, T3B, T3K, T3d, T3E, T3w, T3A, T3R, T46, T3Y;
		    V T42;
		    {
			 V TE, T3U, T1t, T3T, T13, T1s;
			 TE = VSUB(Tg, TD);
			 T3U = VADD(T3r, T3k);
			 T13 = VFMA(LDK(KP831469612), TV, VMUL(LDK(KP555570233), T12));
			 T1s = VFNMS(LDK(KP555570233), T1r, VMUL(LDK(KP831469612), T1k));
			 T1t = VSUB(T13, T1s);
			 T3T = VADD(T13, T1s);
			 T1u = VSUB(TE, T1t);
			 T43 = VADD(T3U, T3T);
			 T3D = VADD(TE, T1t);
			 T3V = VSUB(T3T, T3U);
		    }
		    {
			 V T3s, T3I, T3h, T3J, T3f, T3g;
			 T3s = VSUB(T3k, T3r);
			 T3I = VADD(Tg, TD);
			 T3f = VFNMS(LDK(KP555570233), TV, VMUL(LDK(KP831469612), T12));
			 T3g = VFMA(LDK(KP555570233), T1k, VMUL(LDK(KP831469612), T1r));
			 T3h = VSUB(T3f, T3g);
			 T3J = VADD(T3f, T3g);
			 T3t = VSUB(T3h, T3s);
			 T45 = VADD(T3I, T3J);
			 T3B = VADD(T3s, T3h);
			 T3K = VSUB(T3I, T3J);
		    }
		    {
			 V T2l, T3u, T3c, T3v;
			 {
			      V T29, T2k, T30, T3b;
			      T29 = VSUB(T1R, T28);
			      T2k = VSUB(T2g, T2j);
			      T2l = VFMA(LDK(KP881921264), T29, VMUL(LDK(KP471396736), T2k));
			      T3u = VFNMS(LDK(KP471396736), T29, VMUL(LDK(KP881921264), T2k));
			      T30 = VSUB(T2I, T2Z);
			      T3b = VSUB(T37, T3a);
			      T3c = VFNMS(LDK(KP471396736), T3b, VMUL(LDK(KP881921264), T30));
			      T3v = VFMA(LDK(KP471396736), T30, VMUL(LDK(KP881921264), T3b));
			 }
			 T3d = VSUB(T2l, T3c);
			 T3E = VADD(T3u, T3v);
			 T3w = VSUB(T3u, T3v);
			 T3A = VADD(T2l, T3c);
		    }
		    {
			 V T3N, T3W, T3Q, T3X;
			 {
			      V T3L, T3M, T3O, T3P;
			      T3L = VADD(T28, T1R);
			      T3M = VADD(T2g, T2j);
			      T3N = VFMA(LDK(KP956940335), T3L, VMUL(LDK(KP290284677), T3M));
			      T3W = VFNMS(LDK(KP290284677), T3L, VMUL(LDK(KP956940335), T3M));
			      T3O = VADD(T2Z, T2I);
			      T3P = VADD(T37, T3a);
			      T3Q = VFNMS(LDK(KP290284677), T3P, VMUL(LDK(KP956940335), T3O));
			      T3X = VFMA(LDK(KP290284677), T3O, VMUL(LDK(KP956940335), T3P));
			 }
			 T3R = VSUB(T3N, T3Q);
			 T46 = VADD(T3W, T3X);
			 T3Y = VSUB(T3W, T3X);
			 T42 = VADD(T3N, T3Q);
		    }
		    {
			 V T3e, T3x, T44, T47;
			 T3e = VADD(T1u, T3d);
			 T3x = VBYI(VADD(T3t, T3w));
			 ST(&(x[WS(rs, 53)]), VSUB(T3e, T3x), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 11)]), VADD(T3e, T3x), ms, &(x[WS(rs, 1)]));
			 T44 = VBYI(VSUB(T42, T43));
			 T47 = VSUB(T45, T46);
			 ST(&(x[WS(rs, 29)]), VADD(T44, T47), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 35)]), VSUB(T47, T44), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T48, T49, T3y, T3z;
			 T48 = VBYI(VADD(T43, T42));
			 T49 = VADD(T45, T46);
			 ST(&(x[WS(rs, 3)]), VADD(T48, T49), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 61)]), VSUB(T49, T48), ms, &(x[WS(rs, 1)]));
			 T3y = VSUB(T1u, T3d);
			 T3z = VBYI(VSUB(T3w, T3t));
			 ST(&(x[WS(rs, 43)]), VSUB(T3y, T3z), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 21)]), VADD(T3y, T3z), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T3C, T3F, T3S, T3Z;
			 T3C = VBYI(VSUB(T3A, T3B));
			 T3F = VSUB(T3D, T3E);
			 ST(&(x[WS(rs, 27)]), VADD(T3C, T3F), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 37)]), VSUB(T3F, T3C), ms, &(x[WS(rs, 1)]));
			 T3S = VADD(T3K, T3R);
			 T3Z = VBYI(VADD(T3V, T3Y));
			 ST(&(x[WS(rs, 51)]), VSUB(T3S, T3Z), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 13)]), VADD(T3S, T3Z), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T40, T41, T3G, T3H;
			 T40 = VSUB(T3K, T3R);
			 T41 = VBYI(VSUB(T3Y, T3V));
			 ST(&(x[WS(rs, 45)]), VSUB(T40, T41), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 19)]), VADD(T40, T41), ms, &(x[WS(rs, 1)]));
			 T3G = VBYI(VADD(T3B, T3A));
			 T3H = VADD(T3D, T3E);
			 ST(&(x[WS(rs, 5)]), VADD(T3G, T3H), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 59)]), VSUB(T3H, T3G), ms, &(x[WS(rs, 1)]));
		    }
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 2),
     VTW(0, 3),
     VTW(0, 4),
     VTW(0, 5),
     VTW(0, 6),
     VTW(0, 7),
     VTW(0, 8),
     VTW(0, 9),
     VTW(0, 10),
     VTW(0, 11),
     VTW(0, 12),
     VTW(0, 13),
     VTW(0, 14),
     VTW(0, 15),
     VTW(0, 16),
     VTW(0, 17),
     VTW(0, 18),
     VTW(0, 19),
     VTW(0, 20),
     VTW(0, 21),
     VTW(0, 22),
     VTW(0, 23),
     VTW(0, 24),
     VTW(0, 25),
     VTW(0, 26),
     VTW(0, 27),
     VTW(0, 28),
     VTW(0, 29),
     VTW(0, 30),
     VTW(0, 31),
     VTW(0, 32),
     VTW(0, 33),
     VTW(0, 34),
     VTW(0, 35),
     VTW(0, 36),
     VTW(0, 37),
     VTW(0, 38),
     VTW(0, 39),
     VTW(0, 40),
     VTW(0, 41),
     VTW(0, 42),
     VTW(0, 43),
     VTW(0, 44),
     VTW(0, 45),
     VTW(0, 46),
     VTW(0, 47),
     VTW(0, 48),
     VTW(0, 49),
     VTW(0, 50),
     VTW(0, 51),
     VTW(0, 52),
     VTW(0, 53),
     VTW(0, 54),
     VTW(0, 55),
     VTW(0, 56),
     VTW(0, 57),
     VTW(0, 58),
     VTW(0, 59),
     VTW(0, 60),
     VTW(0, 61),
     VTW(0, 62),
     VTW(0, 63),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 64, XSIMD_STRING("t2bv_64"), twinstr, &GENUS, {467, 198, 52, 0}, 0, 0, 0 };

void XSIMD(codelet_t2bv_64) (planner *p) {
     X(kdft_dit_register) (p, t2bv_64, &desc);
}
#endif				/* HAVE_FMA */
