/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Jul  7 12:24:06 PDT 2015 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -twiddle-log3 -precompute-twiddles -n 25 -dif -name hb2_25 -include hb.h */

/*
 * This function contains 440 FP additions, 434 FP multiplications,
 * (or, 84 additions, 78 multiplications, 356 fused multiply/add),
 * 234 stack variables, 47 constants, and 100 memory accesses
 */
#include "hb.h"

static void hb2_25(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP833417178, +0.833417178328688677408962550243238843138996060);
     DK(KP921177326, +0.921177326965143320250447435415066029359282231);
     DK(KP541454447, +0.541454447536312777046285590082819509052033189);
     DK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DK(KP242145790, +0.242145790282157779872542093866183953459003101);
     DK(KP904730450, +0.904730450839922351881287709692877908104763647);
     DK(KP803003575, +0.803003575438660414833440593570376004635464850);
     DK(KP554608978, +0.554608978404018097464974850792216217022558774);
     DK(KP683113946, +0.683113946453479238701949862233725244439656928);
     DK(KP559154169, +0.559154169276087864842202529084232643714075927);
     DK(KP248028675, +0.248028675328619457762448260696444630363259177);
     DK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DK(KP831864738, +0.831864738706457140726048799369896829771167132);
     DK(KP871714437, +0.871714437527667770979999223229522602943903653);
     DK(KP851038619, +0.851038619207379630836264138867114231259902550);
     DK(KP943557151, +0.943557151597354104399655195398983005179443399);
     DK(KP726211448, +0.726211448929902658173535992263577167607493062);
     DK(KP525970792, +0.525970792408939708442463226536226366643874659);
     DK(KP912018591, +0.912018591466481957908415381764119056233607330);
     DK(KP912575812, +0.912575812670962425556968549836277086778922727);
     DK(KP994076283, +0.994076283785401014123185814696322018529298887);
     DK(KP614372930, +0.614372930789563808870829930444362096004872855);
     DK(KP621716863, +0.621716863012209892444754556304102309693593202);
     DK(KP860541664, +0.860541664367944677098261680920518816412804187);
     DK(KP949179823, +0.949179823508441261575555465843363271711583843);
     DK(KP557913902, +0.557913902031834264187699648465567037992437152);
     DK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DK(KP249506682, +0.249506682107067890488084201715862638334226305);
     DK(KP772036680, +0.772036680810363904029489473607579825330539880);
     DK(KP906616052, +0.906616052148196230441134447086066874408359177);
     DK(KP734762448, +0.734762448793050413546343770063151342619912334);
     DK(KP560319534, +0.560319534973832390111614715371676131169633784);
     DK(KP681693190, +0.681693190061530575150324149145440022633095390);
     DK(KP845997307, +0.845997307939530944175097360758058292389769300);
     DK(KP968479752, +0.968479752739016373193524836781420152702090879);
     DK(KP062914667, +0.062914667253649757225485955897349402364686947);
     DK(KP827271945, +0.827271945972475634034355757144307982555673741);
     DK(KP470564281, +0.470564281212251493087595091036643380879947982);
     DK(KP126329378, +0.126329378446108174786050455341811215027378105);
     DK(KP256756360, +0.256756360367726783319498520922669048172391148);
     DK(KP634619297, +0.634619297544148100711287640319130485732531031);
     DK(KP549754652, +0.549754652192770074288023275540779861653779767);
     DK(KP939062505, +0.939062505817492352556001843133229685779824606);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP618033988, +0.618033988749894848204586834365638117720309180);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 8, MAKE_VOLATILE_STRIDE(50, rs)) {
	       E TN, TQ, T4e, T2y, T4i, T3U, T4u, T4o, T4G, T4C, T2F, T41, T3Q, T4q, T3a;
	       E T3F, T4a, T4w, T46, T44;
	       {
		    E TT, TO, TR, T23, T2d, T2x, TP, TV, T2p, T85, T4d, T25, TX;
		    TN = W[0];
		    TT = W[4];
		    TO = W[2];
		    TR = W[3];
		    T23 = W[6];
		    T2d = TN * TT;
		    T2x = TO * TT;
		    TP = TN * TO;
		    TV = TN * TR;
		    T2p = TT * T23;
		    T85 = TN * T23;
		    T4d = TO * T23;
		    T25 = W[7];
		    TQ = W[1];
		    TX = W[5];
		    {
			 E T86, T4n, TW, T4l, TS, T71, T2q, T4z, T2e, T8a, T2u, T76, T2k, T4B, T6E;
			 E T6U, T6Y, T5T, T8i, T1I, T2a, T26, TY, T8d, T8s, T8o, T5C, T5w, T7g, T7c;
			 E T5M, T5I, T9, T40, T1R, T3X, T6H, T7F, T5W, T7n, T4N, T68, T1S, T1k, T1T;
			 E T1D, T1Y, T1Z, T10, TM, T7K, T7A, T6p, T6w, T4X, T56, T3K, T2U, T7x, T7J;
			 E T6v, T6i, T50, T57, T3L, T39, T4Q, T59, T3O, T3E, T67, T7t, T7H, T6y, T63;
			 E T4T, T5a, T3N, T3p, T66, T7o;
			 {
			      E T2A, T2z, T6G, T2E, T5V, T6F;
			      {
				   E T1, T1J, T3Y, T3Z, T8, T2C, T1M, T1P, T2D, T4h, T89, T2t, T3W, T1Q, T3V;
				   T1 = cr[0];
				   T4e = FMA(TR, T25, T4d);
				   T4h = TO * T25;
				   T89 = TN * T25;
				   T2t = TT * T25;
				   T86 = FMA(TQ, T25, T85);
				   T4n = FNMS(TQ, TO, TV);
				   TW = FMA(TQ, TO, TV);
				   T4l = FMA(TQ, TR, TP);
				   TS = FNMS(TQ, TR, TP);
				   T71 = FNMS(TR, TX, T2x);
				   T2y = FMA(TR, TX, T2x);
				   T2q = FMA(TX, T25, T2p);
				   T4z = FMA(TQ, TX, T2d);
				   T2e = FNMS(TQ, TX, T2d);
				   {
					E T3T, T2j, T4t, T6T;
					T3T = TO * TX;
					T2j = TN * TX;
					T4i = FNMS(TR, T23, T4h);
					T8a = FNMS(TQ, T23, T89);
					T2u = FNMS(TX, T23, T2t);
					T4t = T4l * TX;
					T6T = T4l * T23;
					{
					     E T6X, T4m, T1H, T29;
					     T6X = T4l * T25;
					     T4m = T4l * TT;
					     T1H = TS * TX;
					     T29 = TS * T25;
					     {
						  E T24, TU, T4F, T4A;
						  T24 = TS * T23;
						  TU = TS * TT;
						  T4F = T4z * T25;
						  T4A = T4z * T23;
						  {
						       E T8r, T8n, T5B, T5v;
						       T8r = T2y * T25;
						       T8n = T2y * T23;
						       T5B = T2e * T25;
						       T5v = T2e * T23;
						       T3U = FNMS(TR, TT, T3T);
						       T76 = FMA(TR, TT, T3T);
						       T2k = FMA(TQ, TT, T2j);
						       T4B = FNMS(TQ, TT, T2j);
						       T4u = FMA(T4n, TT, T4t);
						       T6E = FNMS(T4n, TT, T4t);
						       T6U = FMA(T4n, T25, T6T);
						       T6Y = FNMS(T4n, T23, T6X);
						       T5T = FMA(T4n, TX, T4m);
						       T4o = FNMS(T4n, TX, T4m);
						       T8i = FMA(TW, TT, T1H);
						       T1I = FNMS(TW, TT, T1H);
						       T2a = FNMS(TW, T23, T29);
						       T26 = FMA(TW, T25, T24);
						       TY = FMA(TW, TX, TU);
						       T8d = FNMS(TW, TX, TU);
						       T8s = FNMS(T3U, T23, T8r);
						       T8o = FMA(T3U, T25, T8n);
						       T5C = FNMS(T2k, T23, T5B);
						       T5w = FMA(T2k, T25, T5v);
						       T4G = FNMS(T4B, T23, T4F);
						       T4C = FMA(T4B, T25, T4A);
						       {
							    E T7f, T7b, T5L, T5H;
							    T7f = T5T * T25;
							    T7b = T5T * T23;
							    T5L = TY * T25;
							    T5H = TY * T23;
							    T7g = FNMS(T6E, T23, T7f);
							    T7c = FMA(T6E, T25, T7b);
							    T5M = FNMS(T1I, T23, T5L);
							    T5I = FMA(T1I, T25, T5H);
							    T1J = ci[WS(rs, 24)];
						       }
						  }
					     }
					}
				   }
				   {
					E T2, T3, T5, T6;
					T2 = cr[WS(rs, 5)];
					T3 = ci[WS(rs, 4)];
					T5 = cr[WS(rs, 10)];
					T6 = ci[WS(rs, 9)];
					{
					     E T1K, T4, T7, T1L, T1N, T1O;
					     T1K = ci[WS(rs, 19)];
					     T3Y = T2 - T3;
					     T4 = T2 + T3;
					     T3Z = T5 - T6;
					     T7 = T5 + T6;
					     T1L = cr[WS(rs, 20)];
					     T1N = ci[WS(rs, 14)];
					     T1O = cr[WS(rs, 15)];
					     T8 = T4 + T7;
					     T2A = T4 - T7;
					     T2C = T1K + T1L;
					     T1M = T1K - T1L;
					     T1P = T1N - T1O;
					     T2D = T1N + T1O;
					}
				   }
				   T2z = FNMS(KP250000000, T8, T1);
				   T9 = T1 + T8;
				   T3W = T1M - T1P;
				   T1Q = T1M + T1P;
				   T40 = FMA(KP618033988, T3Z, T3Y);
				   T6G = FNMS(KP618033988, T3Y, T3Z);
				   T2E = FMA(KP618033988, T2D, T2C);
				   T5V = FNMS(KP618033988, T2C, T2D);
				   T1R = T1J + T1Q;
				   T3V = FNMS(KP250000000, T1Q, T1J);
				   T6F = FNMS(KP559016994, T3W, T3V);
				   T3X = FMA(KP559016994, T3W, T3V);
			      }
			      {
				   E T2S, T6n, T2H, T2G, Ti, T5Y, T3C, T3r, TK, T3q, T30, T6d, T33, Tr, T32;
				   E T3v, T61, T3y, T1C, T3x, T2L, T6k, T2O, T1a, T2N, T6g, T37, T2W, Tt, T1j;
				   E T2V, Tx, T3g, T3j, Tw, T3l, T1t, T3i, Ty;
				   {
					E T1u, T1v, T1A, T3u, T1w;
					{
					     E TC, TI, T3B, TD, TE;
					     {
						  E Ta, Te, Tf, Tb, Tc, T5U, T2B, T2R, Tg;
						  Ta = cr[WS(rs, 1)];
						  T5U = FNMS(KP559016994, T2A, T2z);
						  T2B = FMA(KP559016994, T2A, T2z);
						  T6H = FNMS(KP951056516, T6G, T6F);
						  T7F = FMA(KP951056516, T6G, T6F);
						  Te = cr[WS(rs, 11)];
						  T5W = FMA(KP951056516, T5V, T5U);
						  T7n = FNMS(KP951056516, T5V, T5U);
						  T4N = FMA(KP951056516, T2E, T2B);
						  T2F = FNMS(KP951056516, T2E, T2B);
						  Tf = ci[WS(rs, 8)];
						  Tb = cr[WS(rs, 6)];
						  Tc = ci[WS(rs, 3)];
						  TC = cr[WS(rs, 3)];
						  T2R = Tf - Te;
						  Tg = Te + Tf;
						  {
						       E T2Q, Td, Th, TG, TH;
						       T2Q = Tb - Tc;
						       Td = Tb + Tc;
						       TG = ci[WS(rs, 11)];
						       TH = ci[WS(rs, 6)];
						       T2S = FNMS(KP618033988, T2R, T2Q);
						       T6n = FMA(KP618033988, T2Q, T2R);
						       Th = Td + Tg;
						       T2H = Td - Tg;
						       TI = TG + TH;
						       T3B = TG - TH;
						       T2G = FNMS(KP250000000, Th, Ta);
						       Ti = Ta + Th;
						       TD = cr[WS(rs, 8)];
						       TE = ci[WS(rs, 1)];
						  }
					     }
					     {
						  E Tj, Tk, Tp, T2Z, TJ, Tl;
						  Tj = cr[WS(rs, 4)];
						  {
						       E Tn, To, T3A, TF;
						       Tn = ci[WS(rs, 10)];
						       To = ci[WS(rs, 5)];
						       T3A = TD - TE;
						       TF = TD + TE;
						       Tk = cr[WS(rs, 9)];
						       Tp = Tn + To;
						       T2Z = To - Tn;
						       T5Y = FNMS(KP618033988, T3A, T3B);
						       T3C = FMA(KP618033988, T3B, T3A);
						       T3r = TI - TF;
						       TJ = TF + TI;
						       Tl = ci[0];
						  }
						  T1u = ci[WS(rs, 21)];
						  TK = TC + TJ;
						  T3q = FNMS(KP250000000, TJ, TC);
						  {
						       E T1y, Tm, T2Y, T1z, Tq;
						       T1y = cr[WS(rs, 13)];
						       Tm = Tk + Tl;
						       T2Y = Tl - Tk;
						       T1z = cr[WS(rs, 18)];
						       T1v = ci[WS(rs, 16)];
						       T30 = FMA(KP618033988, T2Z, T2Y);
						       T6d = FNMS(KP618033988, T2Y, T2Z);
						       T33 = Tm - Tp;
						       Tq = Tm + Tp;
						       T1A = T1y + T1z;
						       T3u = T1z - T1y;
						       Tr = Tj + Tq;
						       T32 = FMS(KP250000000, Tq, Tj);
						       T1w = cr[WS(rs, 23)];
						  }
					     }
					}
					{
					     E T1b, T1c, T1h, T36, T1d;
					     {
						  E T12, T13, T18, T2K, T1B, T14;
						  T12 = ci[WS(rs, 23)];
						  {
						       E T16, T17, T3t, T1x;
						       T16 = ci[WS(rs, 13)];
						       T17 = cr[WS(rs, 16)];
						       T3t = T1v + T1w;
						       T1x = T1v - T1w;
						       T13 = ci[WS(rs, 18)];
						       T18 = T16 - T17;
						       T2K = T16 + T17;
						       T3v = FMA(KP618033988, T3u, T3t);
						       T61 = FNMS(KP618033988, T3t, T3u);
						       T3y = T1x + T1A;
						       T1B = T1x - T1A;
						       T14 = cr[WS(rs, 21)];
						  }
						  T1b = ci[WS(rs, 20)];
						  T1C = T1u + T1B;
						  T3x = FMS(KP250000000, T1B, T1u);
						  {
						       E T1f, T15, T2J, T1g, T19;
						       T1f = cr[WS(rs, 14)];
						       T15 = T13 - T14;
						       T2J = T13 + T14;
						       T1g = cr[WS(rs, 19)];
						       T1c = ci[WS(rs, 15)];
						       T2L = FMA(KP618033988, T2K, T2J);
						       T6k = FNMS(KP618033988, T2J, T2K);
						       T2O = T15 - T18;
						       T19 = T15 + T18;
						       T1h = T1f + T1g;
						       T36 = T1g - T1f;
						       T1a = T12 + T19;
						       T2N = FNMS(KP250000000, T19, T12);
						       T1d = cr[WS(rs, 24)];
						  }
					     }
					     {
						  E T1l, T1p, T1o, T3e, T1i, T1q;
						  T1l = ci[WS(rs, 22)];
						  {
						       E T1m, T1n, T35, T1e;
						       T1m = ci[WS(rs, 17)];
						       T1n = cr[WS(rs, 22)];
						       T35 = T1c + T1d;
						       T1e = T1c - T1d;
						       T1p = ci[WS(rs, 12)];
						       T1o = T1m - T1n;
						       T3e = T1m + T1n;
						       T6g = FNMS(KP618033988, T35, T36);
						       T37 = FMA(KP618033988, T36, T35);
						       T2W = T1e + T1h;
						       T1i = T1e - T1h;
						       T1q = cr[WS(rs, 17)];
						  }
						  Tt = cr[WS(rs, 2)];
						  T1j = T1b + T1i;
						  T2V = FMS(KP250000000, T1i, T1b);
						  {
						       E Tu, T1r, T3f, Tv, T1s;
						       Tu = cr[WS(rs, 7)];
						       T1r = T1p - T1q;
						       T3f = T1p + T1q;
						       Tv = ci[WS(rs, 2)];
						       Tx = cr[WS(rs, 12)];
						       T3g = FMA(KP618033988, T3f, T3e);
						       T68 = FNMS(KP618033988, T3e, T3f);
						       T3j = T1o - T1r;
						       T1s = T1o + T1r;
						       Tw = Tu + Tv;
						       T3l = Tu - Tv;
						       T1t = T1l + T1s;
						       T3i = FMS(KP250000000, T1s, T1l);
						       Ty = ci[WS(rs, 7)];
						  }
					     }
					}
				   }
				   {
					E T3n, T65, T3c, T3b, T2P, T2M, T4W;
					{
					     E TA, T3m, Tz, TB, Ts;
					     T3m = Ty - Tx;
					     Tz = Tx + Ty;
					     T1S = T1a + T1j;
					     T1k = T1a - T1j;
					     T3n = FNMS(KP618033988, T3m, T3l);
					     T65 = FMA(KP618033988, T3l, T3m);
					     TA = Tw + Tz;
					     T3c = Tz - Tw;
					     T3b = FNMS(KP250000000, TA, Tt);
					     TB = Tt + TA;
					     T1T = T1t + T1C;
					     T1D = T1t - T1C;
					     T1Y = Ti - Tr;
					     Ts = Ti + Tr;
					     {
						  E T2I, T6j, T6m, TL;
						  T2I = FMA(KP559016994, T2H, T2G);
						  T6j = FNMS(KP559016994, T2H, T2G);
						  T6m = FNMS(KP559016994, T2O, T2N);
						  T2P = FMA(KP559016994, T2O, T2N);
						  TL = TB + TK;
						  T1Z = TB - TK;
						  {
						       E T6l, T7y, T6o, T7z;
						       T6l = FMA(KP951056516, T6k, T6j);
						       T7y = FNMS(KP951056516, T6k, T6j);
						       T6o = FMA(KP951056516, T6n, T6m);
						       T7z = FNMS(KP951056516, T6n, T6m);
						       T10 = Ts - TL;
						       TM = Ts + TL;
						       T2M = FNMS(KP951056516, T2L, T2I);
						       T4W = FMA(KP951056516, T2L, T2I);
						       T7K = FMA(KP939062505, T7y, T7z);
						       T7A = FNMS(KP939062505, T7z, T7y);
						       T6p = FNMS(KP549754652, T6o, T6l);
						       T6w = FMA(KP549754652, T6l, T6o);
						  }
					     }
					}
					{
					     E T34, T31, T4Y, T60, T3s, T3z, T5X;
					     {
						  E T2X, T6c, T6f, T4V, T2T;
						  T2X = FNMS(KP559016994, T2W, T2V);
						  T6c = FMA(KP559016994, T2W, T2V);
						  T6f = FMA(KP559016994, T33, T32);
						  T34 = FNMS(KP559016994, T33, T32);
						  T4V = FNMS(KP951056516, T2S, T2P);
						  T2T = FMA(KP951056516, T2S, T2P);
						  {
						       E T7w, T6e, T7v, T6h;
						       T7w = FMA(KP951056516, T6d, T6c);
						       T6e = FNMS(KP951056516, T6d, T6c);
						       T7v = FMA(KP951056516, T6g, T6f);
						       T6h = FNMS(KP951056516, T6g, T6f);
						       T4X = FNMS(KP634619297, T4W, T4V);
						       T56 = FMA(KP634619297, T4V, T4W);
						       T3K = FMA(KP256756360, T2M, T2T);
						       T2U = FNMS(KP256756360, T2T, T2M);
						       T7x = FMA(KP126329378, T7w, T7v);
						       T7J = FNMS(KP126329378, T7v, T7w);
						       T6v = FNMS(KP470564281, T6e, T6h);
						       T6i = FMA(KP470564281, T6h, T6e);
						       T31 = FMA(KP951056516, T30, T2X);
						       T4Y = FNMS(KP951056516, T30, T2X);
						  }
						  T60 = FMA(KP559016994, T3r, T3q);
						  T3s = FNMS(KP559016994, T3r, T3q);
						  T3z = FNMS(KP559016994, T3y, T3x);
						  T5X = FMA(KP559016994, T3y, T3x);
					     }
					     {
						  E T5Z, T7r, T4Z, T38;
						  T4Z = FNMS(KP951056516, T37, T34);
						  T38 = FMA(KP951056516, T37, T34);
						  {
						       E T4O, T3w, T4P, T3D;
						       T4O = FMA(KP951056516, T3v, T3s);
						       T3w = FNMS(KP951056516, T3v, T3s);
						       T4P = FMA(KP951056516, T3C, T3z);
						       T3D = FNMS(KP951056516, T3C, T3z);
						       T50 = FNMS(KP827271945, T4Z, T4Y);
						       T57 = FMA(KP827271945, T4Y, T4Z);
						       T3L = FMA(KP634619297, T31, T38);
						       T39 = FNMS(KP634619297, T38, T31);
						       T4Q = FNMS(KP126329378, T4P, T4O);
						       T59 = FMA(KP126329378, T4O, T4P);
						       T3O = FNMS(KP939062505, T3w, T3D);
						       T3E = FMA(KP939062505, T3D, T3w);
						       T5Z = FMA(KP951056516, T5Y, T5X);
						       T7r = FNMS(KP951056516, T5Y, T5X);
						  }
						  {
						       E T3d, T3k, T64, T7s, T62;
						       T67 = FMA(KP559016994, T3c, T3b);
						       T3d = FNMS(KP559016994, T3c, T3b);
						       T3k = FNMS(KP559016994, T3j, T3i);
						       T64 = FMA(KP559016994, T3j, T3i);
						       T7s = FNMS(KP951056516, T61, T60);
						       T62 = FMA(KP951056516, T61, T60);
						       {
							    E T4S, T3h, T4R, T3o;
							    T4S = FMA(KP951056516, T3g, T3d);
							    T3h = FNMS(KP951056516, T3g, T3d);
							    T4R = FMA(KP951056516, T3n, T3k);
							    T3o = FNMS(KP951056516, T3n, T3k);
							    T7t = FNMS(KP827271945, T7s, T7r);
							    T7H = FMA(KP827271945, T7r, T7s);
							    T6y = FNMS(KP062914667, T5Z, T62);
							    T63 = FMA(KP062914667, T62, T5Z);
							    T4T = FNMS(KP470564281, T4S, T4R);
							    T5a = FMA(KP470564281, T4R, T4S);
							    T3N = FNMS(KP549754652, T3h, T3o);
							    T3p = FMA(KP549754652, T3o, T3h);
							    T66 = FNMS(KP951056516, T65, T64);
							    T7o = FMA(KP951056516, T65, T64);
						       }
						  }
					     }
					}
				   }
			      }
			 }
			 {
			      E T7q, T7G, T6J, T6I, T6q, T6b, T6B, T73, T6Q, T78, T6z, T6a;
			      cr[0] = T9 + TM;
			      {
				   E T1U, T2l, T1X, T2g, T1E, TZ, T2m, T20, T2v, T2n;
				   {
					E T1W, T7p, T69, T1V;
					T1W = T1S - T1T;
					T1U = T1S + T1T;
					T7p = FNMS(KP951056516, T68, T67);
					T69 = FMA(KP951056516, T68, T67);
					T1V = FNMS(KP250000000, T1U, T1R);
					T7q = FMA(KP062914667, T7p, T7o);
					T7G = FNMS(KP062914667, T7o, T7p);
					T6z = FNMS(KP634619297, T66, T69);
					T6a = FMA(KP634619297, T69, T66);
					T2l = FNMS(KP559016994, T1W, T1V);
					T1X = FMA(KP559016994, T1W, T1V);
					T2g = FNMS(KP618033988, T1k, T1D);
					T1E = FMA(KP618033988, T1D, T1k);
					TZ = FNMS(KP250000000, TM, T9);
					T2m = FNMS(KP618033988, T1Y, T1Z);
					T20 = FMA(KP618033988, T1Z, T1Y);
				   }
				   ci[0] = T1R + T1U;
				   T2v = FMA(KP951056516, T2m, T2l);
				   T2n = FNMS(KP951056516, T2m, T2l);
				   {
					E T2b, T21, T2f, T11;
					T2b = FNMS(KP951056516, T20, T1X);
					T21 = FMA(KP951056516, T20, T1X);
					T2f = FNMS(KP559016994, T10, TZ);
					T11 = FMA(KP559016994, T10, TZ);
					{
					     E T2h, T2r, T27, T1F;
					     T2h = FMA(KP951056516, T2g, T2f);
					     T2r = FNMS(KP951056516, T2g, T2f);
					     T27 = FMA(KP951056516, T1E, T11);
					     T1F = FNMS(KP951056516, T1E, T11);
					     {
						  E T2o, T2i, T2w, T2s;
						  T2o = T2k * T2h;
						  T2i = T2e * T2h;
						  T2w = T2u * T2r;
						  T2s = T2q * T2r;
						  {
						       E T2c, T28, T22, T1G;
						       T2c = T2a * T27;
						       T28 = T26 * T27;
						       T22 = T1I * T1F;
						       T1G = TY * T1F;
						       ci[WS(rs, 15)] = FMA(T2q, T2v, T2w);
						       cr[WS(rs, 15)] = FNMS(T2u, T2v, T2s);
						       ci[WS(rs, 20)] = FMA(T26, T2b, T2c);
						       cr[WS(rs, 20)] = FNMS(T2a, T2b, T28);
						       ci[WS(rs, 5)] = FMA(TY, T21, T22);
						       cr[WS(rs, 5)] = FNMS(T1I, T21, T1G);
						       cr[WS(rs, 10)] = FNMS(T2k, T2n, T2i);
						       ci[WS(rs, 10)] = FMA(T2e, T2n, T2o);
						  }
					     }
					}
				   }
			      }
			      {
				   E T6x, T6A, T6O, T6P;
				   T6x = FMA(KP968479752, T6w, T6v);
				   T6J = FNMS(KP968479752, T6w, T6v);
				   T6I = FMA(KP845997307, T6z, T6y);
				   T6A = FNMS(KP845997307, T6z, T6y);
				   T6O = FNMS(KP968479752, T6p, T6i);
				   T6q = FMA(KP968479752, T6p, T6i);
				   T6b = FMA(KP845997307, T6a, T63);
				   T6P = FNMS(KP845997307, T6a, T63);
				   T6B = FNMS(KP681693190, T6A, T6x);
				   T73 = FMA(KP560319534, T6x, T6A);
				   T6Q = FMA(KP681693190, T6P, T6O);
				   T78 = FNMS(KP560319534, T6O, T6P);
			      }
			      {
				   E T7U, T8f, T7B, T7u, T82, T8k, T7Y, T7M;
				   {
					E T7L, T7I, T80, T81;
					{
					     E T7S, T6r, T6t, T6K, T6M, T7T, T6s, T7j;
					     T7S = FNMS(KP734762448, T7K, T7J);
					     T7L = FMA(KP734762448, T7K, T7J);
					     T6r = FMA(KP906616052, T6q, T6b);
					     T6t = FNMS(KP906616052, T6q, T6b);
					     T6K = FNMS(KP906616052, T6J, T6I);
					     T6M = FMA(KP906616052, T6J, T6I);
					     T7I = FMA(KP772036680, T7H, T7G);
					     T7T = FNMS(KP772036680, T7H, T7G);
					     T6s = FNMS(KP249506682, T6r, T5W);
					     T7j = FMA(KP998026728, T6r, T5W);
					     {
						  E T6L, T7l, T72, T6u;
						  T6L = FNMS(KP249506682, T6K, T6H);
						  T7l = FMA(KP998026728, T6K, T6H);
						  T72 = FMA(KP557913902, T6t, T6s);
						  T6u = FNMS(KP557913902, T6t, T6s);
						  {
						       E T7k, T6N, T77, T7m;
						       T7k = T4l * T7j;
						       T6N = FNMS(KP557913902, T6M, T6L);
						       T77 = FMA(KP557913902, T6M, T6L);
						       T7m = T4l * T7l;
						       {
							    E T74, T7d, T6V, T6C;
							    T74 = FNMS(KP949179823, T73, T72);
							    T7d = FMA(KP949179823, T73, T72);
							    T6V = FMA(KP860541664, T6B, T6u);
							    T6C = FNMS(KP860541664, T6B, T6u);
							    cr[WS(rs, 2)] = FNMS(T4n, T7l, T7k);
							    {
								 E T7h, T79, T6R, T6Z;
								 T7h = FNMS(KP949179823, T78, T77);
								 T79 = FMA(KP949179823, T78, T77);
								 T6R = FNMS(KP860541664, T6Q, T6N);
								 T6Z = FMA(KP860541664, T6Q, T6N);
								 ci[WS(rs, 2)] = FMA(T4n, T7j, T7m);
								 {
								      E T75, T7e, T6W, T6D;
								      T75 = T71 * T74;
								      T7e = T7c * T7d;
								      T6W = T6U * T6V;
								      T6D = T5T * T6C;
								      {
									   E T7a, T7i, T70, T6S;
									   T7a = T71 * T79;
									   T7i = T7c * T7h;
									   T70 = T6U * T6Z;
									   T6S = T5T * T6R;
									   cr[WS(rs, 12)] = FNMS(T76, T79, T75);
									   cr[WS(rs, 17)] = FNMS(T7g, T7h, T7e);
									   cr[WS(rs, 22)] = FNMS(T6Y, T6Z, T6W);
									   cr[WS(rs, 7)] = FNMS(T6E, T6R, T6D);
									   ci[WS(rs, 12)] = FMA(T76, T74, T7a);
									   ci[WS(rs, 17)] = FMA(T7g, T7d, T7i);
									   ci[WS(rs, 22)] = FMA(T6Y, T6V, T70);
									   ci[WS(rs, 7)] = FMA(T6E, T6C, T6S);
									   T7U = FNMS(KP621716863, T7T, T7S);
									   T8f = FMA(KP614372930, T7S, T7T);
								      }
								 }
							    }
						       }
						  }
					     }
					}
					T80 = FNMS(KP734762448, T7A, T7x);
					T7B = FMA(KP734762448, T7A, T7x);
					T7u = FMA(KP772036680, T7t, T7q);
					T81 = FNMS(KP772036680, T7t, T7q);
					T82 = FNMS(KP621716863, T81, T80);
					T8k = FMA(KP614372930, T80, T81);
					T7Y = FNMS(KP994076283, T7L, T7I);
					T7M = FMA(KP994076283, T7L, T7I);
				   }
				   {
					E T5y, T5c, T51, T4U, T5f, T5E, T5o, T5i, T5k;
					{
					     E T5h, T5g, T5m, T5n, T58, T5b;
					     T5h = FMA(KP912575812, T57, T56);
					     T58 = FNMS(KP912575812, T57, T56);
					     T5b = FNMS(KP912018591, T5a, T59);
					     T5g = FMA(KP912018591, T5a, T59);
					     {
						  E T7X, T7N, T7C, T7Q;
						  T7X = FNMS(KP249506682, T7M, T7F);
						  T7N = FMA(KP998026728, T7M, T7F);
						  T7C = FMA(KP994076283, T7B, T7u);
						  T7Q = FNMS(KP994076283, T7B, T7u);
						  T5y = FMA(KP525970792, T58, T5b);
						  T5c = FNMS(KP726211448, T5b, T58);
						  {
						       E T7Z, T8j, T7P, T7D;
						       T7Z = FNMS(KP557913902, T7Y, T7X);
						       T8j = FMA(KP557913902, T7Y, T7X);
						       T7P = FNMS(KP249506682, T7C, T7n);
						       T7D = FMA(KP998026728, T7C, T7n);
						       {
							    E T8b, T83, T8t, T8l;
							    T8b = FMA(KP943557151, T82, T7Z);
							    T83 = FNMS(KP943557151, T82, T7Z);
							    T8t = FMA(KP949179823, T8k, T8j);
							    T8l = FNMS(KP949179823, T8k, T8j);
							    {
								 E T8e, T7R, T7O, T7E;
								 T8e = FMA(KP557913902, T7Q, T7P);
								 T7R = FNMS(KP557913902, T7Q, T7P);
								 T7O = TR * T7D;
								 T7E = TO * T7D;
								 {
								      E T8g, T8p, T7V, T87;
								      T8g = FMA(KP949179823, T8f, T8e);
								      T8p = FNMS(KP949179823, T8f, T8e);
								      T7V = FMA(KP943557151, T7U, T7R);
								      T87 = FNMS(KP943557151, T7U, T7R);
								      ci[WS(rs, 3)] = FMA(TO, T7N, T7O);
								      cr[WS(rs, 3)] = FNMS(TR, T7N, T7E);
								      {
									   E T8m, T8h, T8u, T8q;
									   T8m = T8i * T8g;
									   T8h = T8d * T8g;
									   T8u = T8s * T8p;
									   T8q = T8o * T8p;
									   {
										E T84, T7W, T8c, T88;
										T84 = T4B * T7V;
										T7W = T4z * T7V;
										T8c = T8a * T87;
										T88 = T86 * T87;
										ci[WS(rs, 13)] = FMA(T8d, T8l, T8m);
										cr[WS(rs, 13)] = FNMS(T8i, T8l, T8h);
										ci[WS(rs, 18)] = FMA(T8o, T8t, T8u);
										cr[WS(rs, 18)] = FNMS(T8s, T8t, T8q);
										ci[WS(rs, 8)] = FMA(T4z, T83, T84);
										cr[WS(rs, 8)] = FNMS(T4B, T83, T7W);
										ci[WS(rs, 23)] = FMA(T86, T8b, T8c);
										cr[WS(rs, 23)] = FNMS(T8a, T8b, T88);
									   }
								      }
								 }
							    }
						       }
						  }
					     }
					     T51 = FMA(KP912575812, T50, T4X);
					     T5m = FNMS(KP912575812, T50, T4X);
					     T5n = FMA(KP912018591, T4T, T4Q);
					     T4U = FNMS(KP912018591, T4T, T4Q);
					     T41 = FMA(KP951056516, T40, T3X);
					     T5f = FNMS(KP951056516, T40, T3X);
					     T5E = FMA(KP525970792, T5m, T5n);
					     T5o = FNMS(KP726211448, T5n, T5m);
					     T5i = FMA(KP851038619, T5h, T5g);
					     T5k = FNMS(KP851038619, T5h, T5g);
					}
					{
					     E T42, T43, T48, T49, T3M, T3P;
					     T3M = FMA(KP871714437, T3L, T3K);
					     T42 = FNMS(KP871714437, T3L, T3K);
					     T43 = FMA(KP831864738, T3O, T3N);
					     T3P = FNMS(KP831864738, T3O, T3N);
					     {
						  E T5R, T5j, T54, T52;
						  T5R = FMA(KP992114701, T5i, T5f);
						  T5j = FNMS(KP248028675, T5i, T5f);
						  T54 = FNMS(KP851038619, T51, T4U);
						  T52 = FMA(KP851038619, T51, T4U);
						  T3Q = FNMS(KP559154169, T3P, T3M);
						  T4q = FMA(KP683113946, T3M, T3P);
						  {
						       E T5D, T5l, T5P, T53;
						       T5D = FMA(KP554608978, T5k, T5j);
						       T5l = FNMS(KP554608978, T5k, T5j);
						       T5P = FNMS(KP992114701, T52, T4N);
						       T53 = FMA(KP248028675, T52, T4N);
						       {
							    E T5p, T5t, T5F, T5N;
							    T5p = FNMS(KP803003575, T5o, T5l);
							    T5t = FMA(KP803003575, T5o, T5l);
							    T5F = FNMS(KP943557151, T5E, T5D);
							    T5N = FMA(KP943557151, T5E, T5D);
							    {
								 E T55, T5x, T5S, T5Q;
								 T55 = FMA(KP554608978, T54, T53);
								 T5x = FNMS(KP554608978, T54, T53);
								 T5S = TW * T5P;
								 T5Q = TS * T5P;
								 {
								      E T5J, T5z, T5r, T5d;
								      T5J = FMA(KP943557151, T5y, T5x);
								      T5z = FNMS(KP943557151, T5y, T5x);
								      T5r = FMA(KP803003575, T5c, T55);
								      T5d = FNMS(KP803003575, T5c, T55);
								      ci[WS(rs, 4)] = FMA(TS, T5R, T5S);
								      cr[WS(rs, 4)] = FNMS(TW, T5R, T5Q);
								      {
									   E T5G, T5A, T5O, T5K;
									   T5G = T5C * T5z;
									   T5A = T5w * T5z;
									   T5O = T5M * T5J;
									   T5K = T5I * T5J;
									   {
										E T5q, T5e, T5u, T5s;
										T5q = TX * T5d;
										T5e = TT * T5d;
										T5u = T25 * T5r;
										T5s = T23 * T5r;
										ci[WS(rs, 14)] = FMA(T5w, T5F, T5G);
										cr[WS(rs, 14)] = FNMS(T5C, T5F, T5A);
										ci[WS(rs, 19)] = FMA(T5I, T5N, T5O);
										cr[WS(rs, 19)] = FNMS(T5M, T5N, T5K);
										ci[WS(rs, 9)] = FMA(TT, T5p, T5q);
										cr[WS(rs, 9)] = FNMS(TX, T5p, T5e);
										ci[WS(rs, 24)] = FMA(T23, T5t, T5u);
										cr[WS(rs, 24)] = FNMS(T25, T5t, T5s);
									   }
								      }
								 }
							    }
						       }
						  }
					     }
					     T48 = FNMS(KP871714437, T39, T2U);
					     T3a = FMA(KP871714437, T39, T2U);
					     T3F = FMA(KP831864738, T3E, T3p);
					     T49 = FNMS(KP831864738, T3E, T3p);
					     T4a = FMA(KP559154169, T49, T48);
					     T4w = FNMS(KP683113946, T48, T49);
					     T46 = FMA(KP904730450, T43, T42);
					     T44 = FNMS(KP904730450, T43, T42);
					}
				   }
			      }
			 }
		    }
	       }
	       {
		    E T45, T4L, T3G, T3I;
		    T45 = FNMS(KP242145790, T44, T41);
		    T4L = FMA(KP968583161, T44, T41);
		    T3G = FMA(KP904730450, T3F, T3a);
		    T3I = FNMS(KP904730450, T3F, T3a);
		    {
			 E T4v, T47, T4J, T3H;
			 T4v = FNMS(KP541454447, T46, T45);
			 T47 = FMA(KP541454447, T46, T45);
			 T4J = FMA(KP968583161, T3G, T2F);
			 T3H = FNMS(KP242145790, T3G, T2F);
			 {
			      E T4b, T4j, T4x, T4H;
			      T4b = FMA(KP921177326, T4a, T47);
			      T4j = FNMS(KP921177326, T4a, T47);
			      T4x = FNMS(KP833417178, T4w, T4v);
			      T4H = FMA(KP833417178, T4w, T4v);
			      {
				   E T3J, T4p, T4M, T4K;
				   T3J = FMA(KP541454447, T3I, T3H);
				   T4p = FNMS(KP541454447, T3I, T3H);
				   T4M = TQ * T4J;
				   T4K = TN * T4J;
				   {
					E T4D, T4r, T4f, T3R;
					T4D = FMA(KP833417178, T4q, T4p);
					T4r = FNMS(KP833417178, T4q, T4p);
					T4f = FMA(KP921177326, T3Q, T3J);
					T3R = FNMS(KP921177326, T3Q, T3J);
					ci[WS(rs, 1)] = FMA(TN, T4L, T4M);
					cr[WS(rs, 1)] = FNMS(TQ, T4L, T4K);
					{
					     E T4y, T4s, T4I, T4E;
					     T4y = T4u * T4r;
					     T4s = T4o * T4r;
					     T4I = T4G * T4D;
					     T4E = T4C * T4D;
					     {
						  E T4c, T3S, T4k, T4g;
						  T4c = T3U * T3R;
						  T3S = T2y * T3R;
						  T4k = T4i * T4f;
						  T4g = T4e * T4f;
						  ci[WS(rs, 11)] = FMA(T4o, T4x, T4y);
						  cr[WS(rs, 11)] = FNMS(T4u, T4x, T4s);
						  ci[WS(rs, 16)] = FMA(T4C, T4H, T4I);
						  cr[WS(rs, 16)] = FNMS(T4G, T4H, T4E);
						  ci[WS(rs, 6)] = FMA(T2y, T4b, T4c);
						  cr[WS(rs, 6)] = FNMS(T3U, T4b, T3S);
						  ci[WS(rs, 21)] = FMA(T4e, T4j, T4k);
						  cr[WS(rs, 21)] = FNMS(T4i, T4j, T4g);
					     }
					}
				   }
			      }
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 24},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 25, "hb2_25", twinstr, &GENUS, {84, 78, 356, 0} };

void X(codelet_hb2_25) (planner *p) {
     X(khc2hc_register) (p, hb2_25, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -sign 1 -twiddle-log3 -precompute-twiddles -n 25 -dif -name hb2_25 -include hb.h */

/*
 * This function contains 440 FP additions, 340 FP multiplications,
 * (or, 280 additions, 180 multiplications, 160 fused multiply/add),
 * 155 stack variables, 20 constants, and 100 memory accesses
 */
#include "hb.h"

static void hb2_25(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DK(KP062790519, +0.062790519529313376076178224565631133122484832);
     DK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DK(KP125333233, +0.125333233564304245373118759816508793942918247);
     DK(KP425779291, +0.425779291565072648862502445744251703979973042);
     DK(KP904827052, +0.904827052466019527713668647932697593970413911);
     DK(KP248689887, +0.248689887164854788242283746006447968417567406);
     DK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DK(KP770513242, +0.770513242775789230803009636396177847271667672);
     DK(KP637423989, +0.637423989748689710176712811676016195434917298);
     DK(KP844327925, +0.844327925502015078548558063966681505381659241);
     DK(KP535826794, +0.535826794978996618271308767867639978063575346);
     DK(KP684547105, +0.684547105928688673732283357621209269889519233);
     DK(KP728968627, +0.728968627421411523146730319055259111372571664);
     DK(KP481753674, +0.481753674101715274987191502872129653528542010);
     DK(KP876306680, +0.876306680043863587308115903922062583399064238);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 8, MAKE_VOLATILE_STRIDE(50, rs)) {
	       E TN, TQ, TO, TR, TT, TY, T2t, T2r, TZ, TU, T4f, T4l, T2d, T4v, T5m;
	       E T2j, T5l, T4X, T2v, T11, T3R, T1L, T5d, T6x, T5h, T6t, T25, T26, T27, T29;
	       E T6D, T7v, T49, T7l, T7p, T7t, T2p, T2n, T4b, T4p, T5n, T6B, T5b, T5p, T6p;
	       E T6r, T59, T4r;
	       {
		    E T2c, T4j, T2h, T4e, T2b, T4k, T2i, T4d;
		    {
			 E TP, TX, TS, TW;
			 TN = W[0];
			 TQ = W[1];
			 TO = W[2];
			 TR = W[3];
			 TP = TN * TO;
			 TX = TQ * TO;
			 TS = TQ * TR;
			 TW = TN * TR;
			 TT = TP - TS;
			 TY = TW + TX;
			 T2t = TW - TX;
			 T2r = TP + TS;
			 TZ = W[5];
			 T2c = TQ * TZ;
			 T4j = TO * TZ;
			 T2h = TN * TZ;
			 T4e = TR * TZ;
			 TU = W[4];
			 T2b = TN * TU;
			 T4k = TR * TU;
			 T2i = TQ * TU;
			 T4d = TO * TU;
		    }
		    T4f = T4d - T4e;
		    T4l = T4j + T4k;
		    {
			 E T2s, T2u, TV, T10, T3P, T3Q, T1J, T1K;
			 T2d = T2b - T2c;
			 T4v = T2b + T2c;
			 T5m = T4j - T4k;
			 T2j = T2h + T2i;
			 T5l = T4d + T4e;
			 T4X = T2h - T2i;
			 T2s = T2r * TU;
			 T2u = T2t * TZ;
			 T2v = T2s + T2u;
			 TV = TT * TU;
			 T10 = TY * TZ;
			 T11 = TV + T10;
			 T3P = T2r * TZ;
			 T3Q = T2t * TU;
			 T3R = T3P - T3Q;
			 T1J = TT * TZ;
			 T1K = TY * TU;
			 T1L = T1J - T1K;
			 T5d = TV - T10;
			 T6x = T3P + T3Q;
			 T5h = T1J + T1K;
			 T6t = T2s - T2u;
			 T25 = W[6];
			 T26 = W[7];
			 T27 = FMA(TT, T25, TY * T26);
			 T29 = FNMS(TY, T25, TT * T26);
			 T6D = FNMS(T4X, T25, T4v * T26);
			 T7v = FNMS(T1L, T25, T11 * T26);
			 T49 = FMA(T2r, T25, T2t * T26);
			 T7l = FMA(T2d, T25, T2j * T26);
			 T7p = FNMS(T2j, T25, T2d * T26);
			 T7t = FMA(T11, T25, T1L * T26);
			 T2p = FNMS(TZ, T25, TU * T26);
			 T2n = FMA(TU, T25, TZ * T26);
			 T4b = FNMS(T2t, T25, T2r * T26);
			 T4p = FMA(T2v, T25, T3R * T26);
			 T5n = FMA(T5l, T25, T5m * T26);
			 T6B = FMA(T4v, T25, T4X * T26);
			 T5b = FNMS(TQ, T25, TN * T26);
			 T5p = FNMS(T5m, T25, T5l * T26);
			 T6p = FMA(TO, T25, TR * T26);
			 T6r = FNMS(TR, T25, TO * T26);
			 T59 = FMA(TN, T25, TQ * T26);
			 T4r = FNMS(T3R, T25, T2v * T26);
		    }
	       }
	       {
		    E T9, T6i, T40, T3z, T5Y, Ti, Tr, Ts, T1d, T1m, T1P, T2K, T4P, T3H, T4y;
		    E T5G, T71, T65, T6N, T5z, T70, T64, T6K, T2Z, T4Q, T3I, T4B, T20, T5Z, T3C;
		    E T43, T6j, TB, TK, TL, T1w, T1F, T1Q, T3f, T4S, T3K, T4F, T5V, T74, T68;
		    E T6U, T5O, T73, T67, T6R, T3u, T4T, T3L, T4I;
		    {
			 E T1, T4, T7, T8, T3Z, T3Y, T3x, T3y;
			 T1 = cr[0];
			 {
			      E T2, T3, T5, T6;
			      T2 = cr[WS(rs, 5)];
			      T3 = ci[WS(rs, 4)];
			      T4 = T2 + T3;
			      T5 = cr[WS(rs, 10)];
			      T6 = ci[WS(rs, 9)];
			      T7 = T5 + T6;
			      T8 = T4 + T7;
			      T3Z = T5 - T6;
			      T3Y = T2 - T3;
			 }
			 T9 = T1 + T8;
			 T6i = FMA(KP951056516, T3Y, KP587785252 * T3Z);
			 T40 = FNMS(KP951056516, T3Z, KP587785252 * T3Y);
			 T3x = FNMS(KP250000000, T8, T1);
			 T3y = KP559016994 * (T4 - T7);
			 T3z = T3x - T3y;
			 T5Y = T3y + T3x;
		    }
		    {
			 E Ta, T2x, T5w, T2F, Th, T2w, T1e, T2P, T5B, T2X, T1l, T2O, Tj, T2N, T5D;
			 E T2T, Tq, T2S, T15, T2B, T5u, T2H, T1c, T2G;
			 {
			      E Tg, T2E, Td, T2D;
			      Ta = cr[WS(rs, 1)];
			      {
				   E Te, Tf, Tb, Tc;
				   Te = cr[WS(rs, 11)];
				   Tf = ci[WS(rs, 8)];
				   Tg = Te + Tf;
				   T2E = Te - Tf;
				   Tb = cr[WS(rs, 6)];
				   Tc = ci[WS(rs, 3)];
				   Td = Tb + Tc;
				   T2D = Tb - Tc;
			      }
			      T2x = KP559016994 * (Td - Tg);
			      T5w = FMA(KP951056516, T2D, KP587785252 * T2E);
			      T2F = FNMS(KP951056516, T2E, KP587785252 * T2D);
			      Th = Td + Tg;
			      T2w = FNMS(KP250000000, Th, Ta);
			 }
			 {
			      E T1k, T2W, T1h, T2V;
			      T1e = ci[WS(rs, 20)];
			      {
				   E T1i, T1j, T1f, T1g;
				   T1i = cr[WS(rs, 14)];
				   T1j = cr[WS(rs, 19)];
				   T1k = T1i + T1j;
				   T2W = T1j - T1i;
				   T1f = ci[WS(rs, 15)];
				   T1g = cr[WS(rs, 24)];
				   T1h = T1f - T1g;
				   T2V = T1f + T1g;
			      }
			      T2P = KP559016994 * (T1h + T1k);
			      T5B = FMA(KP951056516, T2V, KP587785252 * T2W);
			      T2X = FNMS(KP951056516, T2W, KP587785252 * T2V);
			      T1l = T1h - T1k;
			      T2O = FNMS(KP250000000, T1l, T1e);
			 }
			 {
			      E Tp, T2M, Tm, T2L;
			      Tj = cr[WS(rs, 4)];
			      {
				   E Tn, To, Tk, Tl;
				   Tn = ci[WS(rs, 10)];
				   To = ci[WS(rs, 5)];
				   Tp = Tn + To;
				   T2M = Tn - To;
				   Tk = cr[WS(rs, 9)];
				   Tl = ci[0];
				   Tm = Tk + Tl;
				   T2L = Tk - Tl;
			      }
			      T2N = FNMS(KP951056516, T2M, KP587785252 * T2L);
			      T5D = FMA(KP951056516, T2L, KP587785252 * T2M);
			      T2T = KP559016994 * (Tm - Tp);
			      Tq = Tm + Tp;
			      T2S = FNMS(KP250000000, Tq, Tj);
			 }
			 {
			      E T1b, T2A, T18, T2z;
			      T15 = ci[WS(rs, 23)];
			      {
				   E T19, T1a, T16, T17;
				   T19 = ci[WS(rs, 13)];
				   T1a = cr[WS(rs, 16)];
				   T1b = T19 - T1a;
				   T2A = T19 + T1a;
				   T16 = ci[WS(rs, 18)];
				   T17 = cr[WS(rs, 21)];
				   T18 = T16 - T17;
				   T2z = T16 + T17;
			      }
			      T2B = FNMS(KP951056516, T2A, KP587785252 * T2z);
			      T5u = FMA(KP951056516, T2z, KP587785252 * T2A);
			      T2H = KP559016994 * (T18 - T1b);
			      T1c = T18 + T1b;
			      T2G = FNMS(KP250000000, T1c, T15);
			 }
			 Ti = Ta + Th;
			 Tr = Tj + Tq;
			 Ts = Ti + Tr;
			 T1d = T15 + T1c;
			 T1m = T1e + T1l;
			 T1P = T1d + T1m;
			 {
			      E T2C, T4w, T2J, T4x, T2y, T2I;
			      T2y = T2w - T2x;
			      T2C = T2y - T2B;
			      T4w = T2y + T2B;
			      T2I = T2G - T2H;
			      T2J = T2F + T2I;
			      T4x = T2I - T2F;
			      T2K = FNMS(KP481753674, T2J, KP876306680 * T2C);
			      T4P = FMA(KP728968627, T4x, KP684547105 * T4w);
			      T3H = FMA(KP876306680, T2J, KP481753674 * T2C);
			      T4y = FNMS(KP684547105, T4x, KP728968627 * T4w);
			 }
			 {
			      E T5C, T6M, T5F, T6L, T5A, T5E;
			      T5A = T2T + T2S;
			      T5C = T5A - T5B;
			      T6M = T5A + T5B;
			      T5E = T2O + T2P;
			      T5F = T5D + T5E;
			      T6L = T5E - T5D;
			      T5G = FNMS(KP844327925, T5F, KP535826794 * T5C);
			      T71 = FMA(KP637423989, T6L, KP770513242 * T6M);
			      T65 = FMA(KP535826794, T5F, KP844327925 * T5C);
			      T6N = FNMS(KP637423989, T6M, KP770513242 * T6L);
			 }
			 {
			      E T5v, T6I, T5y, T6J, T5t, T5x;
			      T5t = T2x + T2w;
			      T5v = T5t - T5u;
			      T6I = T5t + T5u;
			      T5x = T2H + T2G;
			      T5y = T5w + T5x;
			      T6J = T5x - T5w;
			      T5z = FNMS(KP248689887, T5y, KP968583161 * T5v);
			      T70 = FMA(KP535826794, T6J, KP844327925 * T6I);
			      T64 = FMA(KP968583161, T5y, KP248689887 * T5v);
			      T6K = FNMS(KP844327925, T6J, KP535826794 * T6I);
			 }
			 {
			      E T2R, T4z, T2Y, T4A, T2Q, T2U;
			      T2Q = T2O - T2P;
			      T2R = T2N + T2Q;
			      T4z = T2Q - T2N;
			      T2U = T2S - T2T;
			      T2Y = T2U - T2X;
			      T4A = T2U + T2X;
			      T2Z = FMA(KP904827052, T2R, KP425779291 * T2Y);
			      T4Q = FNMS(KP992114701, T4z, KP125333233 * T4A);
			      T3I = FNMS(KP425779291, T2R, KP904827052 * T2Y);
			      T4B = FMA(KP125333233, T4z, KP992114701 * T4A);
			 }
		    }
		    {
			 E T1S, T1V, T1Y, T1Z, T3B, T3A, T41, T42;
			 T1S = ci[WS(rs, 24)];
			 {
			      E T1T, T1U, T1W, T1X;
			      T1T = ci[WS(rs, 19)];
			      T1U = cr[WS(rs, 20)];
			      T1V = T1T - T1U;
			      T1W = ci[WS(rs, 14)];
			      T1X = cr[WS(rs, 15)];
			      T1Y = T1W - T1X;
			      T1Z = T1V + T1Y;
			      T3B = T1W + T1X;
			      T3A = T1T + T1U;
			 }
			 T20 = T1S + T1Z;
			 T5Z = FMA(KP951056516, T3A, KP587785252 * T3B);
			 T3C = FNMS(KP951056516, T3B, KP587785252 * T3A);
			 T41 = FNMS(KP250000000, T1Z, T1S);
			 T42 = KP559016994 * (T1V - T1Y);
			 T43 = T41 - T42;
			 T6j = T42 + T41;
		    }
		    {
			 E Tt, T32, T5L, T3a, TA, T31, T1o, T36, T5J, T3c, T1v, T3b, TC, T3h, T5S;
			 E T3p, TJ, T3g, T1x, T3l, T5Q, T3r, T1E, T3q;
			 {
			      E Tw, T38, Tz, T39;
			      Tt = cr[WS(rs, 2)];
			      {
				   E Tu, Tv, Tx, Ty;
				   Tu = cr[WS(rs, 7)];
				   Tv = ci[WS(rs, 2)];
				   Tw = Tu + Tv;
				   T38 = Tu - Tv;
				   Tx = cr[WS(rs, 12)];
				   Ty = ci[WS(rs, 7)];
				   Tz = Tx + Ty;
				   T39 = Tx - Ty;
			      }
			      T32 = KP559016994 * (Tw - Tz);
			      T5L = FMA(KP951056516, T38, KP587785252 * T39);
			      T3a = FNMS(KP951056516, T39, KP587785252 * T38);
			      TA = Tw + Tz;
			      T31 = FNMS(KP250000000, TA, Tt);
			 }
			 {
			      E T1r, T34, T1u, T35;
			      T1o = ci[WS(rs, 22)];
			      {
				   E T1p, T1q, T1s, T1t;
				   T1p = ci[WS(rs, 17)];
				   T1q = cr[WS(rs, 22)];
				   T1r = T1p - T1q;
				   T34 = T1p + T1q;
				   T1s = ci[WS(rs, 12)];
				   T1t = cr[WS(rs, 17)];
				   T1u = T1s - T1t;
				   T35 = T1s + T1t;
			      }
			      T36 = FNMS(KP951056516, T35, KP587785252 * T34);
			      T5J = FMA(KP951056516, T34, KP587785252 * T35);
			      T3c = KP559016994 * (T1r - T1u);
			      T1v = T1r + T1u;
			      T3b = FNMS(KP250000000, T1v, T1o);
			 }
			 {
			      E TI, T3o, TF, T3n;
			      TC = cr[WS(rs, 3)];
			      {
				   E TG, TH, TD, TE;
				   TG = ci[WS(rs, 11)];
				   TH = ci[WS(rs, 6)];
				   TI = TG + TH;
				   T3o = TG - TH;
				   TD = cr[WS(rs, 8)];
				   TE = ci[WS(rs, 1)];
				   TF = TD + TE;
				   T3n = TD - TE;
			      }
			      T3h = KP559016994 * (TF - TI);
			      T5S = FMA(KP951056516, T3n, KP587785252 * T3o);
			      T3p = FNMS(KP951056516, T3o, KP587785252 * T3n);
			      TJ = TF + TI;
			      T3g = FNMS(KP250000000, TJ, TC);
			 }
			 {
			      E T1D, T3k, T1A, T3j;
			      T1x = ci[WS(rs, 21)];
			      {
				   E T1B, T1C, T1y, T1z;
				   T1B = cr[WS(rs, 13)];
				   T1C = cr[WS(rs, 18)];
				   T1D = T1B + T1C;
				   T3k = T1C - T1B;
				   T1y = ci[WS(rs, 16)];
				   T1z = cr[WS(rs, 23)];
				   T1A = T1y - T1z;
				   T3j = T1y + T1z;
			      }
			      T3l = FNMS(KP951056516, T3k, KP587785252 * T3j);
			      T5Q = FMA(KP951056516, T3j, KP587785252 * T3k);
			      T3r = KP559016994 * (T1A + T1D);
			      T1E = T1A - T1D;
			      T3q = FNMS(KP250000000, T1E, T1x);
			 }
			 TB = Tt + TA;
			 TK = TC + TJ;
			 TL = TB + TK;
			 T1w = T1o + T1v;
			 T1F = T1x + T1E;
			 T1Q = T1w + T1F;
			 {
			      E T37, T4D, T3e, T4E, T33, T3d;
			      T33 = T31 - T32;
			      T37 = T33 - T36;
			      T4D = T33 + T36;
			      T3d = T3b - T3c;
			      T3e = T3a + T3d;
			      T4E = T3d - T3a;
			      T3f = FNMS(KP844327925, T3e, KP535826794 * T37);
			      T4S = FMA(KP062790519, T4E, KP998026728 * T4D);
			      T3K = FMA(KP535826794, T3e, KP844327925 * T37);
			      T4F = FNMS(KP998026728, T4E, KP062790519 * T4D);
			 }
			 {
			      E T5R, T6T, T5U, T6S, T5P, T5T;
			      T5P = T3h + T3g;
			      T5R = T5P - T5Q;
			      T6T = T5P + T5Q;
			      T5T = T3q + T3r;
			      T5U = T5S + T5T;
			      T6S = T5T - T5S;
			      T5V = FNMS(KP684547105, T5U, KP728968627 * T5R);
			      T74 = FNMS(KP992114701, T6S, KP125333233 * T6T);
			      T68 = FMA(KP728968627, T5U, KP684547105 * T5R);
			      T6U = FMA(KP125333233, T6S, KP992114701 * T6T);
			 }
			 {
			      E T5K, T6Q, T5N, T6P, T5I, T5M;
			      T5I = T32 + T31;
			      T5K = T5I - T5J;
			      T6Q = T5I + T5J;
			      T5M = T3c + T3b;
			      T5N = T5L + T5M;
			      T6P = T5M - T5L;
			      T5O = FNMS(KP481753674, T5N, KP876306680 * T5K);
			      T73 = FNMS(KP425779291, T6P, KP904827052 * T6Q);
			      T67 = FMA(KP876306680, T5N, KP481753674 * T5K);
			      T6R = FMA(KP904827052, T6P, KP425779291 * T6Q);
			 }
			 {
			      E T3m, T4H, T3t, T4G, T3i, T3s;
			      T3i = T3g - T3h;
			      T3m = T3i - T3l;
			      T4H = T3i + T3l;
			      T3s = T3q - T3r;
			      T3t = T3p + T3s;
			      T4G = T3s - T3p;
			      T3u = FNMS(KP998026728, T3t, KP062790519 * T3m);
			      T4T = FNMS(KP637423989, T4G, KP770513242 * T4H);
			      T3L = FMA(KP062790519, T3t, KP998026728 * T3m);
			      T4I = FMA(KP770513242, T4G, KP637423989 * T4H);
			 }
		    }
		    {
			 E TM, T14, T2e, T21, T23, T2l, T1H, T2f, T1O, T2k;
			 {
			      E T12, T13, T1R, T22;
			      T12 = KP559016994 * (Ts - TL);
			      TM = Ts + TL;
			      T13 = FNMS(KP250000000, TM, T9);
			      T14 = T12 + T13;
			      T2e = T13 - T12;
			      T1R = KP559016994 * (T1P - T1Q);
			      T21 = T1P + T1Q;
			      T22 = FNMS(KP250000000, T21, T20);
			      T23 = T1R + T22;
			      T2l = T22 - T1R;
			 }
			 {
			      E T1n, T1G, T1M, T1N;
			      T1n = T1d - T1m;
			      T1G = T1w - T1F;
			      T1H = FMA(KP951056516, T1n, KP587785252 * T1G);
			      T2f = FNMS(KP951056516, T1G, KP587785252 * T1n);
			      T1M = Ti - Tr;
			      T1N = TB - TK;
			      T1O = FMA(KP951056516, T1M, KP587785252 * T1N);
			      T2k = FNMS(KP951056516, T1N, KP587785252 * T1M);
			 }
			 {
			      E T1I, T24, T2o, T2q;
			      cr[0] = T9 + TM;
			      ci[0] = T20 + T21;
			      T1I = T14 - T1H;
			      T24 = T1O + T23;
			      cr[WS(rs, 5)] = FNMS(T1L, T24, T11 * T1I);
			      ci[WS(rs, 5)] = FMA(T1L, T1I, T11 * T24);
			      T2o = T2e + T2f;
			      T2q = T2l - T2k;
			      cr[WS(rs, 15)] = FNMS(T2p, T2q, T2n * T2o);
			      ci[WS(rs, 15)] = FMA(T2p, T2o, T2n * T2q);
			      {
				   E T2g, T2m, T28, T2a;
				   T2g = T2e - T2f;
				   T2m = T2k + T2l;
				   cr[WS(rs, 10)] = FNMS(T2j, T2m, T2d * T2g);
				   ci[WS(rs, 10)] = FMA(T2j, T2g, T2d * T2m);
				   T28 = T14 + T1H;
				   T2a = T23 - T1O;
				   cr[WS(rs, 20)] = FNMS(T29, T2a, T27 * T28);
				   ci[WS(rs, 20)] = FMA(T29, T28, T27 * T2a);
			      }
			 }
		    }
		    {
			 E T76, T7n, T7a, T7q, T6H, T6W, T6X, T6Y, T7e, T7f, T7d, T7g, T7x, T7y;
			 {
			      E T72, T75, T78, T79;
			      T72 = T70 + T71;
			      T75 = T73 - T74;
			      T76 = FMA(KP951056516, T72, KP587785252 * T75);
			      T7n = FNMS(KP951056516, T75, KP587785252 * T72);
			      T78 = T6K - T6N;
			      T79 = T6U - T6R;
			      T7a = FMA(KP951056516, T78, KP587785252 * T79);
			      T7q = FNMS(KP951056516, T79, KP587785252 * T78);
			 }
			 {
			      E T6O, T6V, T7b, T7c;
			      T6H = T5Y + T5Z;
			      T6O = T6K + T6N;
			      T6V = T6R + T6U;
			      T6W = T6O - T6V;
			      T6X = FNMS(KP250000000, T6W, T6H);
			      T6Y = KP559016994 * (T6O + T6V);
			      T7e = T6j - T6i;
			      T7b = T70 - T71;
			      T7c = T73 + T74;
			      T7f = T7b + T7c;
			      T7d = KP559016994 * (T7b - T7c);
			      T7g = FNMS(KP250000000, T7f, T7e);
			 }
			 T7x = T6H + T6W;
			 T7y = T7e + T7f;
			 cr[WS(rs, 4)] = FNMS(TY, T7y, TT * T7x);
			 ci[WS(rs, 4)] = FMA(TY, T7x, TT * T7y);
			 {
			      E T7o, T7u, T7s, T7w, T7m, T7r;
			      T7m = T6X - T6Y;
			      T7o = T7m - T7n;
			      T7u = T7m + T7n;
			      T7r = T7g - T7d;
			      T7s = T7q + T7r;
			      T7w = T7r - T7q;
			      cr[WS(rs, 14)] = FNMS(T7p, T7s, T7l * T7o);
			      ci[WS(rs, 14)] = FMA(T7p, T7o, T7l * T7s);
			      cr[WS(rs, 19)] = FNMS(T7v, T7w, T7t * T7u);
			      ci[WS(rs, 19)] = FMA(T7v, T7u, T7t * T7w);
			 }
			 {
			      E T77, T7j, T7i, T7k, T6Z, T7h;
			      T6Z = T6X + T6Y;
			      T77 = T6Z - T76;
			      T7j = T6Z + T76;
			      T7h = T7d + T7g;
			      T7i = T7a + T7h;
			      T7k = T7h - T7a;
			      cr[WS(rs, 9)] = FNMS(TZ, T7i, TU * T77);
			      ci[WS(rs, 9)] = FMA(TZ, T77, TU * T7i);
			      cr[WS(rs, 24)] = FNMS(T26, T7k, T25 * T7j);
			      ci[WS(rs, 24)] = FMA(T26, T7j, T25 * T7k);
			 }
		    }
		    {
			 E T3N, T4h, T3U, T4m, T3D, T3E, T3w, T3F, T44, T45, T3X, T46, T4t, T4u;
			 {
			      E T3J, T3M, T3S, T3T;
			      T3J = T3H - T3I;
			      T3M = T3K - T3L;
			      T3N = FMA(KP951056516, T3J, KP587785252 * T3M);
			      T4h = FNMS(KP951056516, T3M, KP587785252 * T3J);
			      T3S = T2K + T2Z;
			      T3T = T3f - T3u;
			      T3U = FMA(KP951056516, T3S, KP587785252 * T3T);
			      T4m = FNMS(KP951056516, T3T, KP587785252 * T3S);
			 }
			 {
			      E T30, T3v, T3V, T3W;
			      T3D = T3z - T3C;
			      T30 = T2K - T2Z;
			      T3v = T3f + T3u;
			      T3E = T30 + T3v;
			      T3w = KP559016994 * (T30 - T3v);
			      T3F = FNMS(KP250000000, T3E, T3D);
			      T44 = T40 + T43;
			      T3V = T3H + T3I;
			      T3W = T3K + T3L;
			      T45 = T3V + T3W;
			      T3X = KP559016994 * (T3V - T3W);
			      T46 = FNMS(KP250000000, T45, T44);
			 }
			 T4t = T3D + T3E;
			 T4u = T44 + T45;
			 cr[WS(rs, 2)] = FNMS(T2t, T4u, T2r * T4t);
			 ci[WS(rs, 2)] = FMA(T2t, T4t, T2r * T4u);
			 {
			      E T4i, T4q, T4o, T4s, T4g, T4n;
			      T4g = T3F - T3w;
			      T4i = T4g - T4h;
			      T4q = T4g + T4h;
			      T4n = T46 - T3X;
			      T4o = T4m + T4n;
			      T4s = T4n - T4m;
			      cr[WS(rs, 12)] = FNMS(T4l, T4o, T4f * T4i);
			      ci[WS(rs, 12)] = FMA(T4l, T4i, T4f * T4o);
			      cr[WS(rs, 17)] = FNMS(T4r, T4s, T4p * T4q);
			      ci[WS(rs, 17)] = FMA(T4r, T4q, T4p * T4s);
			 }
			 {
			      E T3O, T4a, T48, T4c, T3G, T47;
			      T3G = T3w + T3F;
			      T3O = T3G - T3N;
			      T4a = T3G + T3N;
			      T47 = T3X + T46;
			      T48 = T3U + T47;
			      T4c = T47 - T3U;
			      cr[WS(rs, 7)] = FNMS(T3R, T48, T2v * T3O);
			      ci[WS(rs, 7)] = FMA(T3R, T3O, T2v * T48);
			      cr[WS(rs, 22)] = FNMS(T4b, T4c, T49 * T4a);
			      ci[WS(rs, 22)] = FMA(T4b, T4a, T49 * T4c);
			 }
		    }
		    {
			 E T4V, T5f, T50, T5i, T4L, T4M, T4K, T4N, T54, T55, T53, T56, T5r, T5s;
			 {
			      E T4R, T4U, T4Y, T4Z;
			      T4R = T4P - T4Q;
			      T4U = T4S - T4T;
			      T4V = FMA(KP951056516, T4R, KP587785252 * T4U);
			      T5f = FNMS(KP951056516, T4U, KP587785252 * T4R);
			      T4Y = T4y + T4B;
			      T4Z = T4F + T4I;
			      T50 = FMA(KP951056516, T4Y, KP587785252 * T4Z);
			      T5i = FNMS(KP951056516, T4Z, KP587785252 * T4Y);
			 }
			 {
			      E T4C, T4J, T51, T52;
			      T4L = T3z + T3C;
			      T4C = T4y - T4B;
			      T4J = T4F - T4I;
			      T4M = T4C + T4J;
			      T4K = KP559016994 * (T4C - T4J);
			      T4N = FNMS(KP250000000, T4M, T4L);
			      T54 = T43 - T40;
			      T51 = T4P + T4Q;
			      T52 = T4S + T4T;
			      T55 = T51 + T52;
			      T53 = KP559016994 * (T51 - T52);
			      T56 = FNMS(KP250000000, T55, T54);
			 }
			 T5r = T4L + T4M;
			 T5s = T54 + T55;
			 cr[WS(rs, 3)] = FNMS(TR, T5s, TO * T5r);
			 ci[WS(rs, 3)] = FMA(TR, T5r, TO * T5s);
			 {
			      E T5g, T5o, T5k, T5q, T5e, T5j;
			      T5e = T4N - T4K;
			      T5g = T5e - T5f;
			      T5o = T5e + T5f;
			      T5j = T56 - T53;
			      T5k = T5i + T5j;
			      T5q = T5j - T5i;
			      cr[WS(rs, 13)] = FNMS(T5h, T5k, T5d * T5g);
			      ci[WS(rs, 13)] = FMA(T5h, T5g, T5d * T5k);
			      cr[WS(rs, 18)] = FNMS(T5p, T5q, T5n * T5o);
			      ci[WS(rs, 18)] = FMA(T5p, T5o, T5n * T5q);
			 }
			 {
			      E T4W, T5a, T58, T5c, T4O, T57;
			      T4O = T4K + T4N;
			      T4W = T4O - T4V;
			      T5a = T4O + T4V;
			      T57 = T53 + T56;
			      T58 = T50 + T57;
			      T5c = T57 - T50;
			      cr[WS(rs, 8)] = FNMS(T4X, T58, T4v * T4W);
			      ci[WS(rs, 8)] = FMA(T4X, T4W, T4v * T58);
			      cr[WS(rs, 23)] = FNMS(T5b, T5c, T59 * T5a);
			      ci[WS(rs, 23)] = FMA(T5b, T5a, T59 * T5c);
			 }
		    }
		    {
			 E T6a, T6v, T6e, T6y, T60, T61, T5X, T62, T6k, T6l, T6h, T6m, T6F, T6G;
			 {
			      E T66, T69, T6c, T6d;
			      T66 = T64 - T65;
			      T69 = T67 - T68;
			      T6a = FMA(KP951056516, T66, KP587785252 * T69);
			      T6v = FNMS(KP951056516, T69, KP587785252 * T66);
			      T6c = T5z - T5G;
			      T6d = T5O - T5V;
			      T6e = FMA(KP951056516, T6c, KP587785252 * T6d);
			      T6y = FNMS(KP951056516, T6d, KP587785252 * T6c);
			 }
			 {
			      E T5H, T5W, T6f, T6g;
			      T60 = T5Y - T5Z;
			      T5H = T5z + T5G;
			      T5W = T5O + T5V;
			      T61 = T5H + T5W;
			      T5X = KP559016994 * (T5H - T5W);
			      T62 = FNMS(KP250000000, T61, T60);
			      T6k = T6i + T6j;
			      T6f = T64 + T65;
			      T6g = T67 + T68;
			      T6l = T6f + T6g;
			      T6h = KP559016994 * (T6f - T6g);
			      T6m = FNMS(KP250000000, T6l, T6k);
			 }
			 T6F = T60 + T61;
			 T6G = T6k + T6l;
			 cr[WS(rs, 1)] = FNMS(TQ, T6G, TN * T6F);
			 ci[WS(rs, 1)] = FMA(TQ, T6F, TN * T6G);
			 {
			      E T6w, T6C, T6A, T6E, T6u, T6z;
			      T6u = T62 - T5X;
			      T6w = T6u - T6v;
			      T6C = T6u + T6v;
			      T6z = T6m - T6h;
			      T6A = T6y + T6z;
			      T6E = T6z - T6y;
			      cr[WS(rs, 11)] = FNMS(T6x, T6A, T6t * T6w);
			      ci[WS(rs, 11)] = FMA(T6x, T6w, T6t * T6A);
			      cr[WS(rs, 16)] = FNMS(T6D, T6E, T6B * T6C);
			      ci[WS(rs, 16)] = FMA(T6D, T6C, T6B * T6E);
			 }
			 {
			      E T6b, T6q, T6o, T6s, T63, T6n;
			      T63 = T5X + T62;
			      T6b = T63 - T6a;
			      T6q = T63 + T6a;
			      T6n = T6h + T6m;
			      T6o = T6e + T6n;
			      T6s = T6n - T6e;
			      cr[WS(rs, 6)] = FNMS(T5m, T6o, T5l * T6b);
			      ci[WS(rs, 6)] = FMA(T5m, T6b, T5l * T6o);
			      cr[WS(rs, 21)] = FNMS(T6r, T6s, T6p * T6q);
			      ci[WS(rs, 21)] = FMA(T6r, T6q, T6p * T6s);
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 24},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 25, "hb2_25", twinstr, &GENUS, {280, 180, 160, 0} };

void X(codelet_hb2_25) (planner *p) {
     X(khc2hc_register) (p, hb2_25, &desc);
}
#endif				/* HAVE_FMA */
