import argparse

from .main import DDLConverter


def run():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        "--input",
        required=True,
        help="Path to PgRouting SQL file generated by osm2po",
    )
    parser.add_argument("--output", default=None, help="Output file")
    parser.add_argument(
        "--format", default="csv", help="Output format: JSON (default), CSV or Avro"
    )
    args = parser.parse_args()

    input_file = args.input
    output_file = args.output
    output_format = args.format
    if not args.output:
        filename, _, ext = input_file.rpartition(".")
        output_file = filename + "." + output_format.lower()

    converter = DDLConverter(input_file, output_file, output_format)
    converter.convert()
