# Changelog

## [integrations/pgvector-v1.1.0] - 2024-11-21

### 🚀 Features

- Add filter_policy to pgvector integration (#820)
- Add schema support to pgvector document store. (#1095)
- Pgvector - recreate the connection if it is no longer valid (#1202)

### 🐛 Bug Fixes

- `PgVector` - Fallback to default filter policy when deserializing retrievers without the init parameter (#900)

### 📚 Documentation

- Explain different connection string formats in the docstring (#1132)

### 🧪 Testing

- Do not retry tests in `hatch run test` command (#954)

### ⚙️ CI

- Retry tests to reduce flakyness (#836)
- Adopt uv as installer (#1142)

### 🧹 Chores

- Update ruff invocation to include check parameter (#853)
- PgVector - remove legacy filter support (#1068)
- Update changelog after removing legacy filters (#1083)
- Update ruff linting scripts and settings (#1105)

### 🌀 Miscellaneous

- Ci: install `pytest-rerunfailures` where needed; add retry config to `test-cov` script (#845)
- Chore: Minor retriever pydoc fix (#884)
- Chore: Update pgvector test for the new `apply_filter_policy` usage (#970)
- Chore: pgvector ruff update, don't ruff tests (#984)

## [integrations/pgvector-v0.4.0] - 2024-06-20

### 🚀 Features

- Defer the database connection to when it's needed (#773)
- Add customizable index names for pgvector (#818)

### 🌀 Miscellaneous

- Docs: add missing api references (#728)
- [deepset-ai/haystack-core-integrations#727] (#738)

## [integrations/pgvector-v0.2.0] - 2024-05-08

### 🚀 Features

- `MongoDBAtlasEmbeddingRetriever` (#427)
- Implement keyword retrieval for pgvector integration (#644)

### 🐛 Bug Fixes

- Fix order of API docs (#447)

### 📚 Documentation

- Update category slug (#442)
- Disable-class-def (#556)

### 🌀 Miscellaneous

- Pgvector - review docstrings and API reference (#502)
- Refactor tests (#574)
- Remove references to Python 3.7 (#601)
- Make Document Stores initially skip `SparseEmbedding` (#606)
- Chore: add license classifiers (#680)
- Type hints in pgvector document store updated for 3.8 compability (#704)
- Chore: change the pydoc renderer class (#718)

## [integrations/pgvector-v0.1.0] - 2024-02-14

### 🐛 Bug Fixes

- Pgvector: fix linting (#328)

### 🌀 Miscellaneous

- Pgvector Document Store - minimal implementation (#239)
- Pgvector - filters (#257)
- Pgvector - embedding retrieval (#298)
- Pgvector - Embedding Retriever (#320)
- Pgvector: generate API docs (#325)
- Pgvector: add an example (#334)
- Adopt `Secret` to pgvector (#402)

<!-- generated by git-cliff -->
