# PhrameAPI
Phrame API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.2
- Package version: 1.0.4.dev
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import PhrameAPI
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import PhrameAPI
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import PhrameAPI
from PhrameAPI.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/PhrameServer
# See configuration.py for a list of all supported configuration parameters.
configuration = PhrameAPI.Configuration(
    host = "http://localhost/PhrameServer"
)



# Enter a context with an instance of the API client
with PhrameAPI.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = PhrameAPI.PhrameApi(api_client)
    component_name = 'component_name_example' # str | Name of component
    version_id = 'version_id_example' # str | ID of component (optional)

    try:
        # DELETE Component
        api_instance.minio_delete_ui_component(component_name, version_id=version_id)
    except ApiException as e:
        print("Exception when calling PhrameApi->minio_delete_ui_component: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/PhrameServer*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PhrameApi* | [**minio_delete_ui_component**](docs/PhrameApi.md#minio_delete_ui_component) | **DELETE** /components | DELETE Component
*PhrameApi* | [**minio_delete_ui_config**](docs/PhrameApi.md#minio_delete_ui_config) | **DELETE** /config | DELETE config
*PhrameApi* | [**minio_get_all_component_names**](docs/PhrameApi.md#minio_get_all_component_names) | **GET** /components/all | Get all components
*PhrameApi* | [**minio_get_all_config_names**](docs/PhrameApi.md#minio_get_all_config_names) | **GET** /config/all | GET all configs
*PhrameApi* | [**minio_get_ui_component**](docs/PhrameApi.md#minio_get_ui_component) | **GET** /components | GET Components
*PhrameApi* | [**minio_get_ui_config**](docs/PhrameApi.md#minio_get_ui_config) | **GET** /config | GET config
*PhrameApi* | [**minio_post_ui_component**](docs/PhrameApi.md#minio_post_ui_component) | **POST** /components | POST component
*PhrameApi* | [**minio_post_ui_config**](docs/PhrameApi.md#minio_post_ui_config) | **POST** /config | POST config


## Documentation For Models

 - [DbPhrameJSONStore](docs/DbPhrameJSONStore.md)
 - [DbPhrameUIConfiguration](docs/DbPhrameUIConfiguration.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author

david@3adesign.co.uk


