# coding: utf-8

"""
    PhrameAPI

    Phrame API  # noqa: E501

    The version of the OpenAPI document: 1.0.2
    Contact: david@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from PhrameAPI.api_client import ApiClient
from PhrameAPI.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PhrameApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def minio_delete_ui_component(self, component_name, **kwargs):  # noqa: E501
        """DELETE Component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_delete_ui_component(component_name, async_req=True)
        >>> result = thread.get()

        :param component_name: Name of component (required)
        :type component_name: str
        :param version_id: ID of component
        :type version_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.minio_delete_ui_component_with_http_info(component_name, **kwargs)  # noqa: E501

    def minio_delete_ui_component_with_http_info(self, component_name, **kwargs):  # noqa: E501
        """DELETE Component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_delete_ui_component_with_http_info(component_name, async_req=True)
        >>> result = thread.get()

        :param component_name: Name of component (required)
        :type component_name: str
        :param version_id: ID of component
        :type version_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'component_name',
            'version_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method minio_delete_ui_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'component_name' is set
        if self.api_client.client_side_validation and local_var_params.get('component_name') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `component_name` when calling `minio_delete_ui_component`")  # noqa: E501

        if self.api_client.client_side_validation and ('component_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['component_name']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `component_name` when calling `minio_delete_ui_component`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('component_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['component_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `component_name` when calling `minio_delete_ui_component`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('component_name') is not None:  # noqa: E501
            query_params.append(('component_name', local_var_params['component_name']))  # noqa: E501
        if local_var_params.get('version_id') is not None:  # noqa: E501
            query_params.append(('version_id', local_var_params['version_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/components', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def minio_delete_ui_config(self, config_name, **kwargs):  # noqa: E501
        """DELETE config  # noqa: E501

         DELETE the UI config for a provided config name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_delete_ui_config(config_name, async_req=True)
        >>> result = thread.get()

        :param config_name: Name of Configuration (required)
        :type config_name: str
        :param version_id: Version ID of obj
        :type version_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.minio_delete_ui_config_with_http_info(config_name, **kwargs)  # noqa: E501

    def minio_delete_ui_config_with_http_info(self, config_name, **kwargs):  # noqa: E501
        """DELETE config  # noqa: E501

         DELETE the UI config for a provided config name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_delete_ui_config_with_http_info(config_name, async_req=True)
        >>> result = thread.get()

        :param config_name: Name of Configuration (required)
        :type config_name: str
        :param version_id: Version ID of obj
        :type version_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'config_name',
            'version_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method minio_delete_ui_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'config_name' is set
        if self.api_client.client_side_validation and local_var_params.get('config_name') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_name` when calling `minio_delete_ui_config`")  # noqa: E501

        if self.api_client.client_side_validation and ('config_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['config_name']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `config_name` when calling `minio_delete_ui_config`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('config_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['config_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `config_name` when calling `minio_delete_ui_config`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('version_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['version_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `minio_delete_ui_config`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('version_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['version_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `minio_delete_ui_config`, length must be greater than or equal to `36`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('config_name') is not None:  # noqa: E501
            query_params.append(('config_name', local_var_params['config_name']))  # noqa: E501
        if local_var_params.get('version_id') is not None:  # noqa: E501
            query_params.append(('version_id', local_var_params['version_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/config', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def minio_get_all_component_names(self, **kwargs):  # noqa: E501
        """Get all components  # noqa: E501

         GET all the available UI components  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_get_all_component_names(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.minio_get_all_component_names_with_http_info(**kwargs)  # noqa: E501

    def minio_get_all_component_names_with_http_info(self, **kwargs):  # noqa: E501
        """Get all components  # noqa: E501

         GET all the available UI components  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_get_all_component_names_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method minio_get_all_component_names" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/components/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def minio_get_all_config_names(self, **kwargs):  # noqa: E501
        """GET all configs  # noqa: E501

         GET all the available UI configs    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_get_all_config_names(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.minio_get_all_config_names_with_http_info(**kwargs)  # noqa: E501

    def minio_get_all_config_names_with_http_info(self, **kwargs):  # noqa: E501
        """GET all configs  # noqa: E501

         GET all the available UI configs    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_get_all_config_names_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method minio_get_all_config_names" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
            501: None,
        }

        return self.api_client.call_api(
            '/config/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def minio_get_ui_component(self, component_name, **kwargs):  # noqa: E501
        """GET Components  # noqa: E501

         GET the UI component for a provided name   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_get_ui_component(component_name, async_req=True)
        >>> result = thread.get()

        :param component_name: Name of component (required)
        :type component_name: str
        :param version_id: ID of component
        :type version_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.minio_get_ui_component_with_http_info(component_name, **kwargs)  # noqa: E501

    def minio_get_ui_component_with_http_info(self, component_name, **kwargs):  # noqa: E501
        """GET Components  # noqa: E501

         GET the UI component for a provided name   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_get_ui_component_with_http_info(component_name, async_req=True)
        >>> result = thread.get()

        :param component_name: Name of component (required)
        :type component_name: str
        :param version_id: ID of component
        :type version_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'component_name',
            'version_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method minio_get_ui_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'component_name' is set
        if self.api_client.client_side_validation and local_var_params.get('component_name') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `component_name` when calling `minio_get_ui_component`")  # noqa: E501

        if self.api_client.client_side_validation and ('component_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['component_name']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `component_name` when calling `minio_get_ui_component`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('component_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['component_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `component_name` when calling `minio_get_ui_component`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'component_name' in local_var_params and not re.search(r'^[^\s]+$', local_var_params['component_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `component_name` when calling `minio_get_ui_component`, must conform to the pattern `/^[^\s]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('component_name') is not None:  # noqa: E501
            query_params.append(('component_name', local_var_params['component_name']))  # noqa: E501
        if local_var_params.get('version_id') is not None:  # noqa: E501
            query_params.append(('version_id', local_var_params['version_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            201: None,
            202: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/components', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def minio_get_ui_config(self, config_name, **kwargs):  # noqa: E501
        """GET config  # noqa: E501

         GET the UI config for a provided config name   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_get_ui_config(config_name, async_req=True)
        >>> result = thread.get()

        :param config_name: Name of Configuration (required)
        :type config_name: str
        :param version_id: Version ID of obj (optional)
        :type version_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.minio_get_ui_config_with_http_info(config_name, **kwargs)  # noqa: E501

    def minio_get_ui_config_with_http_info(self, config_name, **kwargs):  # noqa: E501
        """GET config  # noqa: E501

         GET the UI config for a provided config name   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_get_ui_config_with_http_info(config_name, async_req=True)
        >>> result = thread.get()

        :param config_name: Name of Configuration (required)
        :type config_name: str
        :param version_id: Version ID of obj (optional)
        :type version_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'config_name',
            'version_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method minio_get_ui_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'config_name' is set
        if self.api_client.client_side_validation and local_var_params.get('config_name') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_name` when calling `minio_get_ui_config`")  # noqa: E501

        if self.api_client.client_side_validation and ('config_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['config_name']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `config_name` when calling `minio_get_ui_config`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('config_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['config_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `config_name` when calling `minio_get_ui_config`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'config_name' in local_var_params and not re.search(r'^[^\s]+$', local_var_params['config_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `config_name` when calling `minio_get_ui_config`, must conform to the pattern `/^[^\s]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('config_name') is not None:  # noqa: E501
            query_params.append(('config_name', local_var_params['config_name']))  # noqa: E501
        if local_var_params.get('version_id') is not None:  # noqa: E501
            query_params.append(('version_id', local_var_params['version_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            202: None,
            203: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
            501: None,
        }

        return self.api_client.call_api(
            '/config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def minio_post_ui_component(self, component_name, **kwargs):  # noqa: E501
        """POST component  # noqa: E501

         POST the UI component for a provided config name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_post_ui_component(component_name, async_req=True)
        >>> result = thread.get()

        :param component_name: Name of component (required)
        :type component_name: str
        :param body:
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.minio_post_ui_component_with_http_info(component_name, **kwargs)  # noqa: E501

    def minio_post_ui_component_with_http_info(self, component_name, **kwargs):  # noqa: E501
        """POST component  # noqa: E501

         POST the UI component for a provided config name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_post_ui_component_with_http_info(component_name, async_req=True)
        >>> result = thread.get()

        :param component_name: Name of component (required)
        :type component_name: str
        :param body:
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'component_name',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method minio_post_ui_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'component_name' is set
        if self.api_client.client_side_validation and local_var_params.get('component_name') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `component_name` when calling `minio_post_ui_component`")  # noqa: E501

        if self.api_client.client_side_validation and ('component_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['component_name']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `component_name` when calling `minio_post_ui_component`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('component_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['component_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `component_name` when calling `minio_post_ui_component`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('component_name') is not None:  # noqa: E501
            query_params.append(('component_name', local_var_params['component_name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/components', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def minio_post_ui_config(self, config_name, **kwargs):  # noqa: E501
        """POST config  # noqa: E501

         POST the UI config for a provided config name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_post_ui_config(config_name, async_req=True)
        >>> result = thread.get()

        :param config_name: Name of config file (required)
        :type config_name: str
        :param body:
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.minio_post_ui_config_with_http_info(config_name, **kwargs)  # noqa: E501

    def minio_post_ui_config_with_http_info(self, config_name, **kwargs):  # noqa: E501
        """POST config  # noqa: E501

         POST the UI config for a provided config name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.minio_post_ui_config_with_http_info(config_name, async_req=True)
        >>> result = thread.get()

        :param config_name: Name of config file (required)
        :type config_name: str
        :param body:
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'config_name',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method minio_post_ui_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'config_name' is set
        if self.api_client.client_side_validation and local_var_params.get('config_name') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_name` when calling `minio_post_ui_config`")  # noqa: E501

        if self.api_client.client_side_validation and ('config_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['config_name']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `config_name` when calling `minio_post_ui_config`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('config_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['config_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `config_name` when calling `minio_post_ui_config`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('config_name') is not None:  # noqa: E501
            query_params.append(('config_name', local_var_params['config_name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/config', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
