# physplotlib

The physplotlib library allows one to load data from text files, to make simple treatments and to plot data in a fast and efficient way. It is usefull when handling with output files from numerical simulations in a quick way or if one wants to make a quick plot from text files to watch the content. 


## Table of contents

1. [Instalation](#instalation)
2. [Introduction](#introduction)
3. [treatfile class](#treatfile)
    * [filter](#treatfile-filter)
    * [compute](#treatfile-compute)
    * [save to file](#treatfile-savefile)
4. [statplot class](#statplot)
    * [load file](#statplot-loadfile)
    * [load data](#statplot-loaddata)
    * [reset](#statplot-reset)
    * [vertical plot](#statplot-verticalplot)
    * [horizontal plot](#statplot-horizontalplot)
    * [operation](#statplot-operation)
5. [dyplot class](#dyplot)
    * [vertical plot](#dyplot-verticalplot)
    * [horizontal plot](#dyplot-horizontalplot)


## 1. Instalation <a name="instalation"></a>

This package requires the following packages: numpy, matplotlib, matplotlib.pyplot and matplotlib.animation. Be sure to have all this packages installed, otherwise some functionalities may not work out. 

To install the package simply past the command:

```bash
git clone https://github.com/numpy/numpy.git
```

All files to be used by the package must be located inside the physplotlib directory.

To import the module simply type:

```python
import physplotlib as pp
```

From this point on use the prefix pp. before any object creation

## 2. Introduction <a name="introduction"></a>

The physplotlib library contains classes to load data from csv (or txt) files, make operations between columns or lines, and plot the respective treated data. It uses the library matplotlib and is intended to be used by engineers and scientists, who need to make plots quickly after obtaiing data. In particular, it is intended for people handling with output files from numerical simulations. This package was created for the vizualization of the output data that is generated by the heatrapy package. The module relies on 3 classes:

**treatfile**

This class loads and treats the data with filters and operations. This classe is builts to extract relevant information from log files, which can be afterwards stored in a file or used by statplot class to plot the resulting information.

**statplot**

This class loads data from csv (or txt) files or from previously treated data, e.g. with the treatfile class, and plots quickly the data in a personalized manner. This class is inteded to be used in logbooks, such as jupyter notebook.

**dyplot**

This class loads data from a file constantly and makes dynamic and personalized plots. This class is intended to be used during a simulation, or during data aquizition. 


## 3. treatfile class <a name="treatfile"></a>

The treatfile submodule can be used to make simple operation with csv (or txt) files before plotting or converting into other csv (or txt) files. It loads data from txt files, filter the values that comes after a given string and makes some operations, before exporting the data back or plotting with staticplot class. To initialize the object type

```python
object = pp.treatfile(<file_name>, <filter>)
```

where `<file_name>` is the url of the text file to be treated, and `<filter>` is a list. Each entry is a 2 string list where the first element correcponds to the string before the value to filter and the second element corresponds to the string after the value to filter. The default value for the second string is '\n' and thus can be neglected. This initialization will load the data into `object.data`, which will have a dimension of `len(<filter>)`. Each element of `òbject.data` will be a list of filtered data. This initialization also loads the file_name into `object.file_name`, and the header into `object.header`, that is a list of the string labels of `object.data`. 

##### filter <a name="treatfile-filter"></a>

To filter the data from `object.data`, use the filter method:

```python
object.filter(<column>, <values>)
```

where `<values>` is a list of values used for the filter, and `<column>` is the column to be filtered for the values in the `<values>` list.

##### compute <a name="treatfile-compute"></a>

To compute the entries of the `object.data` use the calculate method:

```python
 object.calculate(<column>, <operation>, add_info='default')
```

where `<column>` is the integer referring to the column to operate. `<operation>` is a string that identifies the operation, and can have the following values:

* `'H:M:S to sec'` converts the entries with format H:M:S to a float number in seconds
* `'error'` calculates the error of a column with respect to column goven in the input variable `add_info`.

##### save to file <a name="treatfile-savefile"></a>

To save the data into a file use the saveFile method:

```python
object.saveFile(<file_name>, delim=',')
```

where `<file_name>` is the url of the text file to be saved, and `delim` is a string with the delimitation between columns. The default value is ','.


## 4. statplot class <a name="statplot"></a>

The statplot submodule can be used to make static plots of data stored in csv (or txt) files. It loads data, makes simple treatment and plots the data in a fast and efficient way, without refreshing constantly while the source file is being changed. To initialize the object type

```python
object = pp.statplot()
```

This initialization creates the `object.data` variable, which is a list of books, where each entry correponds to different loaded data, created the `object.header` variable, which is a list of headers corresponding to each book, and `object.file_name`, which is a list correponding to the origin of data (loaded file or loaded values). 


##### load file <a name="statplot-loadfile"></a>

To load data from a file type

```python
object.loadFile(<file_name>, header=True, delim=',')
```

where `<file_name>` is the url of the text file to be loaded, `header` is a boolean that tells if the file has a header, and `delim` is a string that indicates the separation of the column. Note that loading a file never removes existing data but appends the data to the existing data.


##### load data <a name="statplot-loaddata"></a>

To load the whole data from python variables type

```python
object.loadFile(<header>, <data>, <dataName>)
```
where `<header>` is a list the `object.header` value, `<data>` is the value for `object.data`, and `<dataName>` is the value for `object.file_name` (equivalent of file names).

##### reset <a name="statplot-reset"></a>

To reset all the data type

```python
object.reset()
```


##### vertical plot <a name="statplot-verticalplot"></a>

To plot each entry of a column from a book type

```python
object.verticalPlot(<data_index_list>, <list_x_Column>, <list_y_Column_list>,
                    xtype='lin', ytype='lin', symbol='default', title=None,
                    legenda='default', x_title=None, y_title=None,
                    legend_position='upper right', legend_size=10,
                    x_limits='default', y_limits='default', grid=False,
                    area='default', line='default')
```

This command will plot the data using matplotlib.pyplot, with the input variables that are listed below:

* `<data_index_list>`: list of the books to be plotted
* `<list_x_Column>`: list of X Columns (for each book)
* `<list_y_Column>`: list of Y Columns (for each book)
* `xtype`: x scale mode of the plot
* `ytype`: y scale mode of the plot
* `symbol`: list of symbols used in the plot for each book
* `title`: plot title
* `legenda`: list of legend with respect to the plotted data
* `x_title`: x axis title
* `y_title`: y axis title
* `legend_position`: position of the legend (given by pyplot)
* `legend_size`: size of the legend
* `grid`: set if there is a grid
* `area`: if not 'default' fills an area of the plot [xmin,xmax,ymin,ymax,alpha,color]
* `line`: if not 'default' creates a line [xmin,xmax,ymin,ymax,symbol]
* `x_limits`: list of 2 element: the first the minimum x value and the second the maximum x value to be plotted
* `y_limits`: list of 2 element: the first the minimum y value and the second the maximum y value to be plotted


##### horizontal plot <a name="statplot-horizontalplot"></a>

To plot each entry of a row from a book type

```python
object.horizontalPlot(<data_index_list>, <x_line_list, columns_list>,
                      x_line_value='default', x_column='default',
                      symbol='o-', limits='default',
                      xlabel='file column index', ylabel='value',
                      x_shift='default', x_length='default',
                      title='default', legend_position='upper right',
                      legend_size=10, xtype='lin', ytype='lin')
```

This method will plot the data using matplotlib.pyplot, with the input variables that are listed below:

* `<data_index_list>`: list of the books to be plotted
* `<x_line_list>`: list of lists of the lines to be ploted (for each book). If x_line_value is True, x_line_list is the value of the x_column.
* `columns_list`: indicates the range of indexes to be ploted (for each data index)
* `xtype`: x scale mode of the plot
* `ytype`: y scale mode of the plot
* `x_column`: list of columns for the x values (for each book)
* `symbol`: list of symbols used in the plot for each book
* `title`: plot title
* `legend_position`: position of the legend (given by pyplot)
* `legend_size`: size of the legend
* `limits`: list of 2 element: the first the minimum y value and the second the maximum y value to be plotted
* `xlabel`: name of the x axis
* `ylabel`: name of the y axis
* `x_shift`: list of the index correction
* `x_length`: list of the space step. If default the x axis will only show the indexes. If a float number, the x axis will show the length accordingly


##### operation <a name="statplot-operation"></a>

To realize operations between columns of any book stored in `object.data` type

```python
object.operation(<operation>, <data_to_operate>, add_info='default',
                 data_index_list='default'):
```

This method will compute that data according to the input variables listed below:

* `<operation>`: string that indicates the operation 
  * 'error': calculates the relative error of data_to_operate with respect to add_info (other column).
* `<data_to_operate>`: columns to be operated.
  * 'error': [[book index x, column index x], [book index y, column index y]]
* `add_info`: additional information needed for the operation
  * 'error': reference x and y columns [[book index x, column index x], [book index y, column index y]]
* `data_index_list`: book index where the result is stored



## 5. dyplot class <a name="dyplot"></a>

The dyplot module can be used to plot the data from csv (or txt) files, refreshing the plot constantly while the source file is being changed, i.e. plot dynamically.

To initialize the object type

```python
object = pp.dyplot(<fileName>, header=True, delim=',')
```

where `<fileName>` is the url of the file to be loaded. ,`header:` is a boolean that tells if the file has a header, and `delim` is a string that indicates the separation of the column.


##### vertical plot <a name="dyplot-verticalplot"></a>

To plot columns type

```python
object.verticalPlot(<xColumn>, <yColumnsList>, timeInterval=1000)
```

where `<xColumn>` is column index of the x data, `<yColumnList>` is column index list of the y data, and `timeInterval` is the refresh time in milliseconds. This method plots each entry of the input list yColumnList as a function of the input list xColumn.


##### horizontal plot <a name="dyplot-horizontalplot"></a>

To plot rows type

```python
object.horizontalPlot(<columns>, xColumn='default', limits='default',
                      xShift=0, xLength='default', xlabel='file column index',
                      ylabel='value', timeInterval=1000, symbol='o-')
```
This method plots the values of the last line of the file as a function of column index, with the followinf input variables.

* `<columns>`: list that indicates the range of indexes to be plotted
* `timeInterval`: refresh time in milliseconds
* `symbol`: matplotlib symbol of the plot
* `xlabel`: name of the x axis
* `ylabel`: name of the y axis
* `limits`: list of length = 2 that indicates the limits of the y scale
* `xShift`: int value that indicates the correction of the index
* `xLength`: space step. If equal to 'default' the x axis will only show the indexes. If a float number, the x axis will show the length accordingly