# pipe2codeblock

Pipe text into a code block in a markdown file.

Originally designed for putting a terminal command's `--help` text into a `README.md`.

## Usage

Put a fenced codeblock in your target file with the info string `help`.

The fenced codeblock is defined as it is by [CommonMark](https://spec.commonmark.org/0.29/#fenced-code-blocks),
with the exception that it cannot be indented (to prevent spaces being lstripped inside the block).

Then do 

```bash
your_awesome_tool --help | p2c README.md
```

to pipe the text in, or

```bash
p2c README.md input_file.txt
```

to read from a file.

The `--tgt` option allows you to choose which info string to target (instead of `"help"`).
Only the first instance will be used.


## Usage

```help
usage: p2c [-h] [--tgt TGT] outfile [infile]

Pipe text into a code block in a markdown file.

positional arguments:
  outfile
  infile

optional arguments:
  -h, --help  show this help message and exit
  --tgt TGT   Target a code block with a different info string (default
              'help')
```

Generated by dogfooding: `p2c --help | p2c README.md`
