# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
import os
import sys
import json

from typing import List

from alibabacloud_polardb20170801.client import Client as polardb20170801Client
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_polardb20170801 import models as polardb_20170801_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_tea_util.client import Client as UtilClient


class PolarDBUtils:
    def __init__(self, region_id: str, access_key_id: str, access_key_secret: str):
        """
        description:
            初始化PolarDB工具类
        parameters:
            region_id(str): 阿里云区域ID
            access_key_id(str): 阿里云访问密钥ID
            access_key_secret(str): 阿里云访问密钥Secret
        """
        self.region_id = region_id
        self.access_key_id = access_key_id
        self.access_key_secret = access_key_secret
        self.client = self._create_client()

    def _create_client(self) -> polardb20170801Client:
        """
        description:
            创建PolarDB客户端
        return:
            polardb20170801Client: PolarDB客户端实例
        """
        config = open_api_models.Config(
            access_key_id=self.access_key_id,
            access_key_secret=self.access_key_secret,
            region_id=self.region_id,
        )
        config.endpoint = f"polardb.aliyuncs.com"
        return polardb20170801Client(config)

    def list_clusters(
        self,
    ) -> tuple[dict, bool]:
        describe_dbclusters_request = polardb_20170801_models.DescribeDBClustersRequest(
            region_id=self.region_id
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = self.client.describe_dbclusters_with_options(
                describe_dbclusters_request, runtime
            )
            return resp.body.to_map(), True
        except Exception as error:
            return {}, False

    def list_cluster_ids(
        self,
    ) -> tuple[list, bool]:
        """
        description:
            列出PolarDB集群ID
        return:
            cluster_ids: 集群ID列表
            success: 操作是否成功
        """
        try:
            resp, success = self.list_clusters()
            if not success:
                return [], False

            clusters = resp.get("Items", {}).get("DBCluster", [])
            return [cluster["DBClusterId"] for cluster in clusters], True
        except Exception as error:
            return [], False

    async def list_clusters_async(
        self,
    ) -> tuple[dict, bool]:
        describe_dbclusters_request = polardb_20170801_models.DescribeDBClustersRequest(
            region_id=self.region_id
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = await self.client.describe_dbclusters_with_options_async(
                describe_dbclusters_request, runtime
            )
            return resp.body.to_map(), True
        except Exception as error:
            return {}, False

    async def list_cluster_ids_async(
        self,
    ) -> tuple[list, bool]:
        """
        description:
            列出PolarDB集群ID
        return:
            cluster_ids: 集群ID列表
            success: 操作是否成功
        """
        try:
            resp, success = await self.list_clusters_async()
            if not success:
                return [], False
            clusters = resp.get("Items", {}).get("DBCluster", [])
            return [cluster["DBClusterId"] for cluster in clusters], True
        except Exception as error:
            return [], False

    def list_character_set_names(
        self,
        cluster_id: str,
    ) -> tuple[list, bool]:
        """
        description:
            列出PolarDB字符集名称
        parameters:
            cluster_id(str): 集群ID
        return:
            character_set_names: 字符集名称列表
            success: 操作是否成功
        """
        describe_character_set_name_request = (
            polardb_20170801_models.DescribeCharacterSetNameRequest(
                region_id=self.region_id, dbcluster_id=cluster_id
            )
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = self.client.describe_character_set_name_with_options(
                describe_character_set_name_request, runtime
            )
            return (
                resp.body.to_map()
                .get("CharacterSetNameItems", {})
                .get("CharacterSetName", []),
                True,
            )
        except Exception as error:
            return [], False

    async def list_character_set_names_async(
        self,
        cluster_id: str,
    ) -> tuple[list, bool]:
        """
        description:
            异步列出PolarDB字符集名称
        parameters:
            cluster_id(str): 集群ID
        return:
            character_set_names: 字符集名称列表
            success: 操作是否成功
        """
        describe_character_set_name_request = (
            polardb_20170801_models.DescribeCharacterSetNameRequest(
                region_id=self.region_id, dbcluster_id=cluster_id
            )
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = await self.client.describe_character_set_name_with_options_async(
                describe_character_set_name_request, runtime
            )
            return (
                resp.body.to_map()
                .get("CharacterSetNameItems", {})
                .get("CharacterSetName", []),
                True,
            )
        except Exception as error:
            return [], False

    def create_database(
        self,
        cluster_id: str,
        database_name: str,
        character_set_name: str = "utf8mb4",
    ) -> bool:
        """
        description:
            创建PolarDB数据库
        parameters:
            cluster_id(str): 集群ID
            database_name(str): 数据库名称
            character_set_name(str): 字符集名称
        return:
            bool: 创建结果
        """
        create_database_request = polardb_20170801_models.CreateDatabaseRequest(
            character_set_name=character_set_name,
            dbcluster_id=cluster_id,
            dbname=database_name,
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = self.client.create_database_with_options(
                create_database_request, runtime
            )
            return True if resp.body.to_map().get("RequestId") else False
        except Exception as error:
            return False

    async def create_database_async(
        self,
        cluster_id: str,
        database_name: str,
        character_set_name: str = "utf8mb4",
    ) -> bool:
        """
        description:
            异步创建PolarDB数据库
        parameters:
            cluster_id(str): 集群ID
            database_name(str): 数据库名称
            character_set_name(str): 字符集名称
        return:
            bool: 创建结果
        """
        create_database_request = polardb_20170801_models.CreateDatabaseRequest(
            character_set_name=character_set_name,
            dbcluster_id=cluster_id,
            dbname=database_name,
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = await self.client.create_database_with_options_async(
                create_database_request, runtime
            )
            return True if resp.body.to_map().get("RequestId") else False
        except Exception as error:
            return False

    def delete_database(
        self,
        cluster_id: str,
        database_name: str,
    ) -> bool:
        """
        description:
            删除PolarDB数据库
        parameters:
            cluster_id(str): 集群ID
            database_name(str): 数据库名称
        return:
            bool: 删除结果
        """
        delete_database_request = polardb_20170801_models.DeleteDatabaseRequest(
            dbcluster_id=cluster_id,
            dbname=database_name,
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = self.client.delete_database_with_options(
                delete_database_request, runtime
            )
            return True if resp.body.to_map().get("RequestId") else False
        except Exception as error:
            return False

    async def delete_database_async(
        self,
        cluster_id: str,
        database_name: str,
    ) -> bool:
        """
        description:
            异步删除PolarDB数据库
        parameters:
            cluster_id(str): 集群ID
            database_name(str): 数据库名称
        return:
            bool: 删除结果
        """
        delete_database_request = polardb_20170801_models.DeleteDatabaseRequest(
            dbcluster_id=cluster_id,
            dbname=database_name,
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = await self.client.delete_database_with_options_async(
                delete_database_request, runtime
            )
            return True if resp.body.to_map().get("RequestId") else False
        except Exception as error:
            return False

    def list_databases(
        self,
        cluster_id: str,
    ) -> tuple[list, bool]:
        """
        description:
            列出PolarDB数据库
        parameters:
            cluster_id(str): 集群ID
        return:
            databases: 数据库列表
            success: 操作是否成功
        """
        describe_databases_request = polardb_20170801_models.DescribeDatabasesRequest(
            dbcluster_id=cluster_id
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = self.client.describe_databases_with_options(
                describe_databases_request, runtime
            )
            return resp.body.to_map(), True
        except Exception as error:
            return [], False

    async def list_databases_async(
        self,
        cluster_id: str,
    ) -> tuple[list, bool]:
        """
        description:
            异步列出PolarDB数据库
        parameters:
            cluster_id(str): 集群ID
        return:
            databases: 数据库列表
            success: 操作是否成功
        """
        describe_databases_request = polardb_20170801_models.DescribeDatabasesRequest(
            dbcluster_id=cluster_id
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = await self.client.describe_databases_with_options_async(
                describe_databases_request, runtime
            )
            return resp.body.to_map(), True
        except Exception as error:
            return [], False

    def list_database_names(
        self,
        cluster_id: str,
    ) -> tuple[list, bool]:
        """
        description:
            列出PolarDB数据库名称
        parameters:
            cluster_id(str): 集群ID
        return:
            database_names: 数据库名称列表
            success: 操作是否成功
        """
        try:
            resp, success = self.list_databases(cluster_id)
            if not success:
                return [], False

            return [
                database["DBName"]
                for database in resp.get("Databases", {}).get("Database", [])
            ], True
        except Exception as error:
            return [], False

    async def list_database_names_async(
        self,
        cluster_id: str,
    ) -> tuple[list, bool]:
        """
        description:
            异步列出PolarDB数据库名称
        parameters:
            cluster_id(str): 集群ID
        return:
            database_names: 数据库名称列表
            success: 操作是否成功
        """
        try:
            resp, success = await self.list_databases_async(cluster_id)
            if not success:
                return [], False

            return [
                database["DBName"]
                for database in resp.get("Databases", {}).get("Database", [])
            ], True
        except Exception as error:
            return [], False
