# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .observations_v_2_meta import ObservationsV2Meta


class ObservationsV2Response(pydantic_v1.BaseModel):
    """
    Response containing observations with field-group-based filtering and cursor-based pagination.

    The `data` array contains observation objects with only the requested field groups included.
    Use the `cursor` in `meta` to retrieve the next page of results.
    """

    data: typing.List[typing.Dict[str, typing.Any]] = pydantic_v1.Field()
    """
    Array of observation objects. Fields included depend on the `fields` parameter in the request.
    """

    meta: ObservationsV2Meta

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
