# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .pricing_tier_operator import PricingTierOperator


class PricingTierCondition(pydantic_v1.BaseModel):
    """
    Condition for matching a pricing tier based on usage details. Used to implement tiered pricing models where costs vary based on usage thresholds.

    How it works:
    1. The regex pattern matches against usage detail keys (e.g., "input_tokens", "input_cached")
    2. Values of all matching keys are summed together
    3. The sum is compared against the threshold value using the specified operator
    4. All conditions in a tier must be met (AND logic) for the tier to match

    Common use cases:
    - Threshold-based pricing: Match when accumulated usage exceeds a certain amount
    - Usage-type-specific pricing: Different rates for cached vs non-cached tokens, or input vs output
    - Volume-based pricing: Different rates based on total request or token count
    """

    usage_detail_pattern: str = pydantic_v1.Field(alias="usageDetailPattern")
    """
    Regex pattern to match against usage detail keys. All matching keys' values are summed for threshold comparison.
    
    Examples:
    - "^input" matches "input", "input_tokens", "input_cached", etc.
    - "^(input|prompt)" matches both "input_tokens" and "prompt_tokens"
    - "_cache$" matches "input_cache", "output_cache", etc.
    
    The pattern is case-insensitive by default. If no keys match, the sum is treated as zero.
    """

    operator: PricingTierOperator = pydantic_v1.Field()
    """
    Comparison operator to apply between the summed value and the threshold.
    
    - gt: greater than (sum > threshold)
    - gte: greater than or equal (sum >= threshold)
    - lt: less than (sum < threshold)
    - lte: less than or equal (sum <= threshold)
    - eq: equal (sum == threshold)
    - neq: not equal (sum != threshold)
    """

    value: float = pydantic_v1.Field()
    """
    Threshold value for comparison. For token-based pricing, this is typically the token count threshold (e.g., 200000 for a 200K token threshold).
    """

    case_sensitive: bool = pydantic_v1.Field(alias="caseSensitive")
    """
    Whether the regex pattern matching is case-sensitive. Default is false (case-insensitive matching).
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
