# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pydantic_utilities import pydantic_v1
from ...core.request_options import RequestOptions
from ..commons.errors.access_denied_error import AccessDeniedError
from ..commons.errors.error import Error
from ..commons.errors.method_not_allowed_error import MethodNotAllowedError
from ..commons.errors.not_found_error import NotFoundError
from ..commons.errors.unauthorized_error import UnauthorizedError
from .types.otel_resource_span import OtelResourceSpan
from .types.otel_trace_response import OtelTraceResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OpentelemetryClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def export_traces(
        self,
        *,
        resource_spans: typing.Sequence[OtelResourceSpan],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OtelTraceResponse:
        """
        **OpenTelemetry Traces Ingestion Endpoint**

        This endpoint implements the OTLP/HTTP specification for trace ingestion, providing native OpenTelemetry integration for Langfuse Observability.

        **Supported Formats:**
        - Binary Protobuf: `Content-Type: application/x-protobuf`
        - JSON Protobuf: `Content-Type: application/json`
        - Supports gzip compression via `Content-Encoding: gzip` header

        **Specification Compliance:**
        - Conforms to [OTLP/HTTP Trace Export](https://opentelemetry.io/docs/specs/otlp/#otlphttp)
        - Implements `ExportTraceServiceRequest` message format

        **Documentation:**
        - Integration guide: https://langfuse.com/integrations/native/opentelemetry
        - Data model: https://langfuse.com/docs/observability/data-model

        Parameters
        ----------
        resource_spans : typing.Sequence[OtelResourceSpan]
            Array of resource spans containing trace data as defined in the OTLP specification

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OtelTraceResponse

        Examples
        --------
        from langfuse import (
            OtelAttribute,
            OtelAttributeValue,
            OtelResource,
            OtelResourceSpan,
            OtelScope,
            OtelScopeSpan,
            OtelSpan,
        )
        from langfuse.client import FernLangfuse

        client = FernLangfuse(
            x_langfuse_sdk_name="YOUR_X_LANGFUSE_SDK_NAME",
            x_langfuse_sdk_version="YOUR_X_LANGFUSE_SDK_VERSION",
            x_langfuse_public_key="YOUR_X_LANGFUSE_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )
        client.opentelemetry.export_traces(
            resource_spans=[
                OtelResourceSpan(
                    resource=OtelResource(
                        attributes=[
                            OtelAttribute(
                                key="service.name",
                                value=OtelAttributeValue(
                                    string_value="my-service",
                                ),
                            ),
                            OtelAttribute(
                                key="service.version",
                                value=OtelAttributeValue(
                                    string_value="1.0.0",
                                ),
                            ),
                        ],
                    ),
                    scope_spans=[
                        OtelScopeSpan(
                            scope=OtelScope(
                                name="langfuse-sdk",
                                version="2.60.3",
                            ),
                            spans=[
                                OtelSpan(
                                    trace_id="0123456789abcdef0123456789abcdef",
                                    span_id="0123456789abcdef",
                                    name="my-operation",
                                    kind=1,
                                    start_time_unix_nano="1747872000000000000",
                                    end_time_unix_nano="1747872001000000000",
                                    attributes=[
                                        OtelAttribute(
                                            key="langfuse.observation.type",
                                            value=OtelAttributeValue(
                                                string_value="generation",
                                            ),
                                        )
                                    ],
                                    status={},
                                )
                            ],
                        )
                    ],
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/public/otel/v1/traces",
            method="POST",
            json={"resourceSpans": resource_spans},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(OtelTraceResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncOpentelemetryClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def export_traces(
        self,
        *,
        resource_spans: typing.Sequence[OtelResourceSpan],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OtelTraceResponse:
        """
        **OpenTelemetry Traces Ingestion Endpoint**

        This endpoint implements the OTLP/HTTP specification for trace ingestion, providing native OpenTelemetry integration for Langfuse Observability.

        **Supported Formats:**
        - Binary Protobuf: `Content-Type: application/x-protobuf`
        - JSON Protobuf: `Content-Type: application/json`
        - Supports gzip compression via `Content-Encoding: gzip` header

        **Specification Compliance:**
        - Conforms to [OTLP/HTTP Trace Export](https://opentelemetry.io/docs/specs/otlp/#otlphttp)
        - Implements `ExportTraceServiceRequest` message format

        **Documentation:**
        - Integration guide: https://langfuse.com/integrations/native/opentelemetry
        - Data model: https://langfuse.com/docs/observability/data-model

        Parameters
        ----------
        resource_spans : typing.Sequence[OtelResourceSpan]
            Array of resource spans containing trace data as defined in the OTLP specification

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OtelTraceResponse

        Examples
        --------
        import asyncio

        from langfuse import (
            OtelAttribute,
            OtelAttributeValue,
            OtelResource,
            OtelResourceSpan,
            OtelScope,
            OtelScopeSpan,
            OtelSpan,
        )
        from langfuse.client import AsyncFernLangfuse

        client = AsyncFernLangfuse(
            x_langfuse_sdk_name="YOUR_X_LANGFUSE_SDK_NAME",
            x_langfuse_sdk_version="YOUR_X_LANGFUSE_SDK_VERSION",
            x_langfuse_public_key="YOUR_X_LANGFUSE_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.opentelemetry.export_traces(
                resource_spans=[
                    OtelResourceSpan(
                        resource=OtelResource(
                            attributes=[
                                OtelAttribute(
                                    key="service.name",
                                    value=OtelAttributeValue(
                                        string_value="my-service",
                                    ),
                                ),
                                OtelAttribute(
                                    key="service.version",
                                    value=OtelAttributeValue(
                                        string_value="1.0.0",
                                    ),
                                ),
                            ],
                        ),
                        scope_spans=[
                            OtelScopeSpan(
                                scope=OtelScope(
                                    name="langfuse-sdk",
                                    version="2.60.3",
                                ),
                                spans=[
                                    OtelSpan(
                                        trace_id="0123456789abcdef0123456789abcdef",
                                        span_id="0123456789abcdef",
                                        name="my-operation",
                                        kind=1,
                                        start_time_unix_nano="1747872000000000000",
                                        end_time_unix_nano="1747872001000000000",
                                        attributes=[
                                            OtelAttribute(
                                                key="langfuse.observation.type",
                                                value=OtelAttributeValue(
                                                    string_value="generation",
                                                ),
                                            )
                                        ],
                                        status={},
                                    )
                                ],
                            )
                        ],
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/public/otel/v1/traces",
            method="POST",
            json={"resourceSpans": resource_spans},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(OtelTraceResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
