# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .pricing_tier_condition import PricingTierCondition


class PricingTier(pydantic_v1.BaseModel):
    """
    Pricing tier definition with conditional pricing based on usage thresholds.

    Pricing tiers enable accurate cost tracking for LLM providers that charge different rates based on usage patterns.
    For example, some providers charge higher rates when context size exceeds certain thresholds.

    How tier matching works:
    1. Tiers are evaluated in ascending priority order (priority 1 before priority 2, etc.)
    2. The first tier where ALL conditions match is selected
    3. If no conditional tiers match, the default tier is used as a fallback
    4. The default tier has priority 0 and no conditions

    Why priorities matter:
    - Lower priority numbers are evaluated first, allowing you to define specific cases before general ones
    - Example: Priority 1 for "high usage" (>200K tokens), Priority 2 for "medium usage" (>100K tokens), Priority 0 for default
    - Without proper ordering, a less specific condition might match before a more specific one

    Every model must have exactly one default tier to ensure cost calculation always succeeds.
    """

    id: str = pydantic_v1.Field()
    """
    Unique identifier for the pricing tier
    """

    name: str = pydantic_v1.Field()
    """
    Name of the pricing tier for display and identification purposes.
    
    Examples: "Standard", "High Volume Tier", "Large Context", "Extended Context Tier"
    """

    is_default: bool = pydantic_v1.Field(alias="isDefault")
    """
    Whether this is the default tier. Every model must have exactly one default tier with priority 0 and no conditions.
    
    The default tier serves as a fallback when no conditional tiers match, ensuring cost calculation always succeeds.
    It typically represents the base pricing for standard usage patterns.
    """

    priority: int = pydantic_v1.Field()
    """
    Priority for tier matching evaluation. Lower numbers = higher priority (evaluated first).
    
    The default tier must always have priority 0. Conditional tiers should have priority 1, 2, 3, etc.
    
    Example ordering:
    - Priority 0: Default tier (no conditions, always matches as fallback)
    - Priority 1: High usage tier (e.g., >200K tokens)
    - Priority 2: Medium usage tier (e.g., >100K tokens)
    
    This ensures more specific conditions are checked before general ones.
    """

    conditions: typing.List[PricingTierCondition] = pydantic_v1.Field()
    """
    Array of conditions that must ALL be met for this tier to match (AND logic).
    
    The default tier must have an empty conditions array. Conditional tiers should have one or more conditions
    that define when this tier's pricing applies.
    
    Multiple conditions enable complex matching scenarios (e.g., "high input tokens AND low output tokens").
    """

    prices: typing.Dict[str, float] = pydantic_v1.Field()
    """
    Prices (USD) by usage type for this tier.
    
    Common usage types: "input", "output", "total", "request", "image"
    Prices are specified in USD per unit (e.g., per token, per request, per second).
    
    Example: {"input": 0.000003, "output": 0.000015} means $3 per million input tokens and $15 per million output tokens.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
