# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1


class LlmConnection(pydantic_v1.BaseModel):
    """
    LLM API connection configuration (secrets excluded)
    """

    id: str
    provider: str = pydantic_v1.Field()
    """
    Provider name (e.g., 'openai', 'my-gateway'). Must be unique in project, used for upserting.
    """

    adapter: str = pydantic_v1.Field()
    """
    The adapter used to interface with the LLM
    """

    display_secret_key: str = pydantic_v1.Field(alias="displaySecretKey")
    """
    Masked version of the secret key for display purposes
    """

    base_url: typing.Optional[str] = pydantic_v1.Field(alias="baseURL", default=None)
    """
    Custom base URL for the LLM API
    """

    custom_models: typing.List[str] = pydantic_v1.Field(alias="customModels")
    """
    List of custom model names available for this connection
    """

    with_default_models: bool = pydantic_v1.Field(alias="withDefaultModels")
    """
    Whether to include default models for this adapter
    """

    extra_header_keys: typing.List[str] = pydantic_v1.Field(alias="extraHeaderKeys")
    """
    Keys of extra headers sent with requests (values excluded for security)
    """

    config: typing.Optional[typing.Dict[str, typing.Any]] = pydantic_v1.Field(
        default=None
    )
    """
    Adapter-specific configuration. Required for Bedrock (`{"region":"us-east-1"}`), optional for VertexAI (`{"location":"us-central1"}`), not used by other adapters.
    """

    created_at: dt.datetime = pydantic_v1.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic_v1.Field(alias="updatedAt")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
