# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .pricing_tier_condition import PricingTierCondition


class PricingTierInput(pydantic_v1.BaseModel):
    """
    Input schema for creating a pricing tier. The tier ID will be automatically generated server-side.

    When creating a model with pricing tiers:
    - Exactly one tier must have isDefault=true (the fallback tier)
    - The default tier must have priority=0 and conditions=[]
    - All tier names and priorities must be unique within the model
    - Each tier must define at least one price

    See PricingTier for detailed information about how tiers work and why they're useful.
    """

    name: str = pydantic_v1.Field()
    """
    Name of the pricing tier for display and identification purposes.
    
    Must be unique within the model. Common patterns: "Standard", "High Volume Tier", "Extended Context"
    """

    is_default: bool = pydantic_v1.Field(alias="isDefault")
    """
    Whether this is the default tier. Exactly one tier per model must be marked as default.
    
    Requirements for default tier:
    - Must have isDefault=true
    - Must have priority=0
    - Must have empty conditions array (conditions=[])
    
    The default tier acts as a fallback when no conditional tiers match.
    """

    priority: int = pydantic_v1.Field()
    """
    Priority for tier matching evaluation. Lower numbers = higher priority (evaluated first).
    
    Must be unique within the model. The default tier must have priority=0.
    Conditional tiers should use priority 1, 2, 3, etc. based on their specificity.
    """

    conditions: typing.List[PricingTierCondition] = pydantic_v1.Field()
    """
    Array of conditions that must ALL be met for this tier to match (AND logic).
    
    The default tier must have an empty array (conditions=[]).
    Conditional tiers should define one or more conditions that specify when this tier's pricing applies.
    
    Each condition specifies a regex pattern, operator, and threshold value for matching against usage details.
    """

    prices: typing.Dict[str, float] = pydantic_v1.Field()
    """
    Prices (USD) by usage type for this tier. At least one price must be defined.
    
    Common usage types: "input", "output", "total", "request", "image"
    Prices are in USD per unit (e.g., per token).
    
    Example: {"input": 0.000003, "output": 0.000015} represents $3 per million input tokens and $15 per million output tokens.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
