# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class MediaContentType(str, enum.Enum):
    """
    The MIME type of the media record
    """

    IMAGE_PNG = "image/png"
    IMAGE_JPEG = "image/jpeg"
    IMAGE_JPG = "image/jpg"
    IMAGE_WEBP = "image/webp"
    IMAGE_GIF = "image/gif"
    IMAGE_SVG_XML = "image/svg+xml"
    IMAGE_TIFF = "image/tiff"
    IMAGE_BMP = "image/bmp"
    IMAGE_AVIF = "image/avif"
    IMAGE_HEIC = "image/heic"
    AUDIO_MPEG = "audio/mpeg"
    AUDIO_MP_3 = "audio/mp3"
    AUDIO_WAV = "audio/wav"
    AUDIO_OGG = "audio/ogg"
    AUDIO_OGA = "audio/oga"
    AUDIO_AAC = "audio/aac"
    AUDIO_MP_4 = "audio/mp4"
    AUDIO_FLAC = "audio/flac"
    AUDIO_OPUS = "audio/opus"
    AUDIO_WEBM = "audio/webm"
    VIDEO_MP_4 = "video/mp4"
    VIDEO_WEBM = "video/webm"
    VIDEO_OGG = "video/ogg"
    VIDEO_MPEG = "video/mpeg"
    VIDEO_QUICKTIME = "video/quicktime"
    VIDEO_X_MSVIDEO = "video/x-msvideo"
    VIDEO_X_MATROSKA = "video/x-matroska"
    TEXT_PLAIN = "text/plain"
    TEXT_HTML = "text/html"
    TEXT_CSS = "text/css"
    TEXT_CSV = "text/csv"
    TEXT_MARKDOWN = "text/markdown"
    TEXT_X_PYTHON = "text/x-python"
    APPLICATION_JAVASCRIPT = "application/javascript"
    TEXT_X_TYPESCRIPT = "text/x-typescript"
    APPLICATION_X_YAML = "application/x-yaml"
    APPLICATION_PDF = "application/pdf"
    APPLICATION_MSWORD = "application/msword"
    APPLICATION_MS_EXCEL = "application/vnd.ms-excel"
    APPLICATION_OPENXML_SPREADSHEET = (
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    )
    APPLICATION_ZIP = "application/zip"
    APPLICATION_JSON = "application/json"
    APPLICATION_XML = "application/xml"
    APPLICATION_OCTET_STREAM = "application/octet-stream"
    APPLICATION_OPENXML_WORD = (
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document"
    )
    APPLICATION_OPENXML_PRESENTATION = (
        "application/vnd.openxmlformats-officedocument.presentationml.presentation"
    )
    APPLICATION_RTF = "application/rtf"
    APPLICATION_X_NDJSON = "application/x-ndjson"
    APPLICATION_PARQUET = "application/vnd.apache.parquet"
    APPLICATION_GZIP = "application/gzip"
    APPLICATION_X_TAR = "application/x-tar"
    APPLICATION_X_7_Z_COMPRESSED = "application/x-7z-compressed"

    def visit(
        self,
        image_png: typing.Callable[[], T_Result],
        image_jpeg: typing.Callable[[], T_Result],
        image_jpg: typing.Callable[[], T_Result],
        image_webp: typing.Callable[[], T_Result],
        image_gif: typing.Callable[[], T_Result],
        image_svg_xml: typing.Callable[[], T_Result],
        image_tiff: typing.Callable[[], T_Result],
        image_bmp: typing.Callable[[], T_Result],
        image_avif: typing.Callable[[], T_Result],
        image_heic: typing.Callable[[], T_Result],
        audio_mpeg: typing.Callable[[], T_Result],
        audio_mp_3: typing.Callable[[], T_Result],
        audio_wav: typing.Callable[[], T_Result],
        audio_ogg: typing.Callable[[], T_Result],
        audio_oga: typing.Callable[[], T_Result],
        audio_aac: typing.Callable[[], T_Result],
        audio_mp_4: typing.Callable[[], T_Result],
        audio_flac: typing.Callable[[], T_Result],
        audio_opus: typing.Callable[[], T_Result],
        audio_webm: typing.Callable[[], T_Result],
        video_mp_4: typing.Callable[[], T_Result],
        video_webm: typing.Callable[[], T_Result],
        video_ogg: typing.Callable[[], T_Result],
        video_mpeg: typing.Callable[[], T_Result],
        video_quicktime: typing.Callable[[], T_Result],
        video_x_msvideo: typing.Callable[[], T_Result],
        video_x_matroska: typing.Callable[[], T_Result],
        text_plain: typing.Callable[[], T_Result],
        text_html: typing.Callable[[], T_Result],
        text_css: typing.Callable[[], T_Result],
        text_csv: typing.Callable[[], T_Result],
        text_markdown: typing.Callable[[], T_Result],
        text_x_python: typing.Callable[[], T_Result],
        application_javascript: typing.Callable[[], T_Result],
        text_x_typescript: typing.Callable[[], T_Result],
        application_x_yaml: typing.Callable[[], T_Result],
        application_pdf: typing.Callable[[], T_Result],
        application_msword: typing.Callable[[], T_Result],
        application_ms_excel: typing.Callable[[], T_Result],
        application_openxml_spreadsheet: typing.Callable[[], T_Result],
        application_zip: typing.Callable[[], T_Result],
        application_json: typing.Callable[[], T_Result],
        application_xml: typing.Callable[[], T_Result],
        application_octet_stream: typing.Callable[[], T_Result],
        application_openxml_word: typing.Callable[[], T_Result],
        application_openxml_presentation: typing.Callable[[], T_Result],
        application_rtf: typing.Callable[[], T_Result],
        application_x_ndjson: typing.Callable[[], T_Result],
        application_parquet: typing.Callable[[], T_Result],
        application_gzip: typing.Callable[[], T_Result],
        application_x_tar: typing.Callable[[], T_Result],
        application_x_7_z_compressed: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is MediaContentType.IMAGE_PNG:
            return image_png()
        if self is MediaContentType.IMAGE_JPEG:
            return image_jpeg()
        if self is MediaContentType.IMAGE_JPG:
            return image_jpg()
        if self is MediaContentType.IMAGE_WEBP:
            return image_webp()
        if self is MediaContentType.IMAGE_GIF:
            return image_gif()
        if self is MediaContentType.IMAGE_SVG_XML:
            return image_svg_xml()
        if self is MediaContentType.IMAGE_TIFF:
            return image_tiff()
        if self is MediaContentType.IMAGE_BMP:
            return image_bmp()
        if self is MediaContentType.IMAGE_AVIF:
            return image_avif()
        if self is MediaContentType.IMAGE_HEIC:
            return image_heic()
        if self is MediaContentType.AUDIO_MPEG:
            return audio_mpeg()
        if self is MediaContentType.AUDIO_MP_3:
            return audio_mp_3()
        if self is MediaContentType.AUDIO_WAV:
            return audio_wav()
        if self is MediaContentType.AUDIO_OGG:
            return audio_ogg()
        if self is MediaContentType.AUDIO_OGA:
            return audio_oga()
        if self is MediaContentType.AUDIO_AAC:
            return audio_aac()
        if self is MediaContentType.AUDIO_MP_4:
            return audio_mp_4()
        if self is MediaContentType.AUDIO_FLAC:
            return audio_flac()
        if self is MediaContentType.AUDIO_OPUS:
            return audio_opus()
        if self is MediaContentType.AUDIO_WEBM:
            return audio_webm()
        if self is MediaContentType.VIDEO_MP_4:
            return video_mp_4()
        if self is MediaContentType.VIDEO_WEBM:
            return video_webm()
        if self is MediaContentType.VIDEO_OGG:
            return video_ogg()
        if self is MediaContentType.VIDEO_MPEG:
            return video_mpeg()
        if self is MediaContentType.VIDEO_QUICKTIME:
            return video_quicktime()
        if self is MediaContentType.VIDEO_X_MSVIDEO:
            return video_x_msvideo()
        if self is MediaContentType.VIDEO_X_MATROSKA:
            return video_x_matroska()
        if self is MediaContentType.TEXT_PLAIN:
            return text_plain()
        if self is MediaContentType.TEXT_HTML:
            return text_html()
        if self is MediaContentType.TEXT_CSS:
            return text_css()
        if self is MediaContentType.TEXT_CSV:
            return text_csv()
        if self is MediaContentType.TEXT_MARKDOWN:
            return text_markdown()
        if self is MediaContentType.TEXT_X_PYTHON:
            return text_x_python()
        if self is MediaContentType.APPLICATION_JAVASCRIPT:
            return application_javascript()
        if self is MediaContentType.TEXT_X_TYPESCRIPT:
            return text_x_typescript()
        if self is MediaContentType.APPLICATION_X_YAML:
            return application_x_yaml()
        if self is MediaContentType.APPLICATION_PDF:
            return application_pdf()
        if self is MediaContentType.APPLICATION_MSWORD:
            return application_msword()
        if self is MediaContentType.APPLICATION_MS_EXCEL:
            return application_ms_excel()
        if self is MediaContentType.APPLICATION_OPENXML_SPREADSHEET:
            return application_openxml_spreadsheet()
        if self is MediaContentType.APPLICATION_ZIP:
            return application_zip()
        if self is MediaContentType.APPLICATION_JSON:
            return application_json()
        if self is MediaContentType.APPLICATION_XML:
            return application_xml()
        if self is MediaContentType.APPLICATION_OCTET_STREAM:
            return application_octet_stream()
        if self is MediaContentType.APPLICATION_OPENXML_WORD:
            return application_openxml_word()
        if self is MediaContentType.APPLICATION_OPENXML_PRESENTATION:
            return application_openxml_presentation()
        if self is MediaContentType.APPLICATION_RTF:
            return application_rtf()
        if self is MediaContentType.APPLICATION_X_NDJSON:
            return application_x_ndjson()
        if self is MediaContentType.APPLICATION_PARQUET:
            return application_parquet()
        if self is MediaContentType.APPLICATION_GZIP:
            return application_gzip()
        if self is MediaContentType.APPLICATION_X_TAR:
            return application_x_tar()
        if self is MediaContentType.APPLICATION_X_7_Z_COMPRESSED:
            return application_x_7_z_compressed()
