# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .otel_attribute import OtelAttribute


class OtelSpan(pydantic_v1.BaseModel):
    """
    Individual span representing a unit of work or operation
    """

    trace_id: typing.Optional[typing.Any] = pydantic_v1.Field(
        alias="traceId", default=None
    )
    """
    Trace ID (16 bytes, hex-encoded string in JSON or Buffer in binary)
    """

    span_id: typing.Optional[typing.Any] = pydantic_v1.Field(
        alias="spanId", default=None
    )
    """
    Span ID (8 bytes, hex-encoded string in JSON or Buffer in binary)
    """

    parent_span_id: typing.Optional[typing.Any] = pydantic_v1.Field(
        alias="parentSpanId", default=None
    )
    """
    Parent span ID if this is a child span
    """

    name: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Span name describing the operation
    """

    kind: typing.Optional[int] = pydantic_v1.Field(default=None)
    """
    Span kind (1=INTERNAL, 2=SERVER, 3=CLIENT, 4=PRODUCER, 5=CONSUMER)
    """

    start_time_unix_nano: typing.Optional[typing.Any] = pydantic_v1.Field(
        alias="startTimeUnixNano", default=None
    )
    """
    Start time in nanoseconds since Unix epoch
    """

    end_time_unix_nano: typing.Optional[typing.Any] = pydantic_v1.Field(
        alias="endTimeUnixNano", default=None
    )
    """
    End time in nanoseconds since Unix epoch
    """

    attributes: typing.Optional[typing.List[OtelAttribute]] = pydantic_v1.Field(
        default=None
    )
    """
    Span attributes including Langfuse-specific attributes (langfuse.observation.*)
    """

    status: typing.Optional[typing.Any] = pydantic_v1.Field(default=None)
    """
    Span status object
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
