# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .model_price import ModelPrice
from .model_usage_unit import ModelUsageUnit
from .pricing_tier import PricingTier


class Model(pydantic_v1.BaseModel):
    """
    Model definition used for transforming usage into USD cost and/or tokenization.

    Models can have either simple flat pricing or tiered pricing:
    - Flat pricing: Single price per usage type (legacy, but still supported)
    - Tiered pricing: Multiple pricing tiers with conditional matching based on usage patterns

    The pricing tiers approach is recommended for models with usage-based pricing variations.
    When using tiered pricing, the flat price fields (inputPrice, outputPrice, prices) are populated
    from the default tier for backward compatibility.
    """

    id: str
    model_name: str = pydantic_v1.Field(alias="modelName")
    """
    Name of the model definition. If multiple with the same name exist, they are applied in the following order: (1) custom over built-in, (2) newest according to startTime where model.startTime<observation.startTime
    """

    match_pattern: str = pydantic_v1.Field(alias="matchPattern")
    """
    Regex pattern which matches this model definition to generation.model. Useful in case of fine-tuned models. If you want to exact match, use `(?i)^modelname$`
    """

    start_date: typing.Optional[dt.datetime] = pydantic_v1.Field(
        alias="startDate", default=None
    )
    """
    Apply only to generations which are newer than this ISO date.
    """

    unit: typing.Optional[ModelUsageUnit] = pydantic_v1.Field(default=None)
    """
    Unit used by this model.
    """

    input_price: typing.Optional[float] = pydantic_v1.Field(
        alias="inputPrice", default=None
    )
    """
    Deprecated. See 'prices' instead. Price (USD) per input unit
    """

    output_price: typing.Optional[float] = pydantic_v1.Field(
        alias="outputPrice", default=None
    )
    """
    Deprecated. See 'prices' instead. Price (USD) per output unit
    """

    total_price: typing.Optional[float] = pydantic_v1.Field(
        alias="totalPrice", default=None
    )
    """
    Deprecated. See 'prices' instead. Price (USD) per total unit. Cannot be set if input or output price is set.
    """

    tokenizer_id: typing.Optional[str] = pydantic_v1.Field(
        alias="tokenizerId", default=None
    )
    """
    Optional. Tokenizer to be applied to observations which match to this model. See docs for more details.
    """

    tokenizer_config: typing.Optional[typing.Any] = pydantic_v1.Field(
        alias="tokenizerConfig", default=None
    )
    """
    Optional. Configuration for the selected tokenizer. Needs to be JSON. See docs for more details.
    """

    is_langfuse_managed: bool = pydantic_v1.Field(alias="isLangfuseManaged")
    created_at: dt.datetime = pydantic_v1.Field(alias="createdAt")
    """
    Timestamp when the model was created
    """

    prices: typing.Dict[str, ModelPrice] = pydantic_v1.Field()
    """
    Deprecated. Use 'pricingTiers' instead for models with usage-based pricing variations.
    
    This field shows prices by usage type from the default pricing tier. Maintained for backward compatibility.
    If the model uses tiered pricing, this field will be populated from the default tier's prices.
    """

    pricing_tiers: typing.List[PricingTier] = pydantic_v1.Field(alias="pricingTiers")
    """
    Array of pricing tiers with conditional pricing based on usage thresholds.
    
    Pricing tiers enable accurate cost tracking for models that charge different rates based on usage patterns
    (e.g., different rates for high-volume usage, large context windows, or cached tokens).
    
    Each model must have exactly one default tier (isDefault=true, priority=0) that serves as a fallback.
    Additional conditional tiers can be defined with specific matching criteria.
    
    If this array is empty, the model uses legacy flat pricing from the inputPrice/outputPrice/totalPrice fields.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
