# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .blob_storage_export_frequency import BlobStorageExportFrequency
from .blob_storage_export_mode import BlobStorageExportMode
from .blob_storage_integration_file_type import BlobStorageIntegrationFileType
from .blob_storage_integration_type import BlobStorageIntegrationType


class BlobStorageIntegrationResponse(pydantic_v1.BaseModel):
    id: str
    project_id: str = pydantic_v1.Field(alias="projectId")
    type: BlobStorageIntegrationType
    bucket_name: str = pydantic_v1.Field(alias="bucketName")
    endpoint: typing.Optional[str] = None
    region: str
    access_key_id: typing.Optional[str] = pydantic_v1.Field(
        alias="accessKeyId", default=None
    )
    prefix: str
    export_frequency: BlobStorageExportFrequency = pydantic_v1.Field(
        alias="exportFrequency"
    )
    enabled: bool
    force_path_style: bool = pydantic_v1.Field(alias="forcePathStyle")
    file_type: BlobStorageIntegrationFileType = pydantic_v1.Field(alias="fileType")
    export_mode: BlobStorageExportMode = pydantic_v1.Field(alias="exportMode")
    export_start_date: typing.Optional[dt.datetime] = pydantic_v1.Field(
        alias="exportStartDate", default=None
    )
    next_sync_at: typing.Optional[dt.datetime] = pydantic_v1.Field(
        alias="nextSyncAt", default=None
    )
    last_sync_at: typing.Optional[dt.datetime] = pydantic_v1.Field(
        alias="lastSyncAt", default=None
    )
    created_at: dt.datetime = pydantic_v1.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic_v1.Field(alias="updatedAt")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
